/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred.gridmix;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.UtilsForTests;
import org.apache.hadoop.mapred.gridmix.ClusterSummarizer;
import org.apache.hadoop.mapred.gridmix.CompressionEmulationUtil;
import org.apache.hadoop.mapred.gridmix.ExecutionSummarizer;
import org.apache.hadoop.mapred.gridmix.GenerateData;
import org.apache.hadoop.mapred.gridmix.GridmixJobSubmissionPolicy;
import org.apache.hadoop.mapred.gridmix.JobFactory;
import org.apache.hadoop.mapred.gridmix.RoundRobinUserResolver;
import org.apache.hadoop.mapred.gridmix.Statistics;
import org.apache.hadoop.mapred.gridmix.TestGridmixSummary;
import org.apache.hadoop.mapred.gridmix.UserResolver;
import org.apache.hadoop.mapreduce.Job;
import org.junit.Assert;
import org.junit.Test;

/*
 * Exception performing whole class analysis ignored.
 */
public class TestGridmixSummary {
    @Test
    public void testDataStatistics() throws Exception {
        GenerateData.DataStatistics stats = new GenerateData.DataStatistics(10L, 2L, true);
        Assert.assertEquals((String)"Data size mismatch", (long)10L, (long)stats.getDataSize());
        Assert.assertEquals((String)"Num files mismatch", (long)2L, (long)stats.getNumFiles());
        Assert.assertTrue((String)"Compression configuration mismatch", (boolean)stats.isDataCompressed());
        stats = new GenerateData.DataStatistics(100L, 5L, false);
        Assert.assertEquals((String)"Data size mismatch", (long)100L, (long)stats.getDataSize());
        Assert.assertEquals((String)"Num files mismatch", (long)5L, (long)stats.getNumFiles());
        Assert.assertFalse((String)"Compression configuration mismatch", (boolean)stats.isDataCompressed());
        Configuration conf = new Configuration();
        Path rootTempDir = new Path(System.getProperty("test.build.data", "/tmp"));
        Path testDir = new Path(rootTempDir, "testDataStatistics");
        FileSystem fs = testDir.getFileSystem(conf);
        fs.delete(testDir, true);
        Path testInputDir = new Path(testDir, "test");
        fs.mkdirs(testInputDir);
        CompressionEmulationUtil.setCompressionEmulationEnabled((Configuration)conf, (boolean)true);
        Boolean failed = null;
        try {
            GenerateData.publishDataStatistics((Path)testInputDir, (long)1024L, (Configuration)conf);
            failed = false;
        }
        catch (RuntimeException e) {
            failed = true;
        }
        Assert.assertNotNull((String)"Expected failure!", (Object)failed);
        Assert.assertTrue((String)"Compression data publishing error", (boolean)failed);
        CompressionEmulationUtil.setCompressionEmulationEnabled((Configuration)conf, (boolean)false);
        stats = GenerateData.publishDataStatistics((Path)testInputDir, (long)1024L, (Configuration)conf);
        Assert.assertEquals((String)"Data size mismatch", (long)0L, (long)stats.getDataSize());
        Assert.assertEquals((String)"Num files mismatch", (long)0L, (long)stats.getNumFiles());
        Assert.assertFalse((String)"Compression configuration mismatch", (boolean)stats.isDataCompressed());
        CompressionEmulationUtil.setCompressionEmulationEnabled((Configuration)conf, (boolean)false);
        Path inputDataFile = new Path(testInputDir, "test");
        long size = UtilsForTests.createTmpFileDFS((FileSystem)fs, (Path)inputDataFile, (FsPermission)FsPermission.createImmutable((short)777), (String)"hi hello bye").size();
        stats = GenerateData.publishDataStatistics((Path)testInputDir, (long)-1L, (Configuration)conf);
        Assert.assertEquals((String)"Data size mismatch", (long)size, (long)stats.getDataSize());
        Assert.assertEquals((String)"Num files mismatch", (long)1L, (long)stats.getNumFiles());
        Assert.assertFalse((String)"Compression configuration mismatch", (boolean)stats.isDataCompressed());
        CompressionEmulationUtil.setCompressionEmulationEnabled((Configuration)conf, (boolean)true);
        failed = null;
        try {
            GenerateData.publishDataStatistics((Path)testInputDir, (long)1234L, (Configuration)conf);
            failed = false;
        }
        catch (RuntimeException e) {
            failed = true;
        }
        Assert.assertNotNull((String)"Expected failure!", (Object)failed);
        Assert.assertTrue((String)"Compression data publishing error", (boolean)failed);
        CompressionEmulationUtil.setCompressionEmulationEnabled((Configuration)conf, (boolean)false);
        fs.delete(inputDataFile, false);
        inputDataFile = new Path(testInputDir, "test.gz");
        size = UtilsForTests.createTmpFileDFS((FileSystem)fs, (Path)inputDataFile, (FsPermission)FsPermission.createImmutable((short)777), (String)"hi hello").size();
        stats = GenerateData.publishDataStatistics((Path)testInputDir, (long)1234L, (Configuration)conf);
        Assert.assertEquals((String)"Data size mismatch", (long)size, (long)stats.getDataSize());
        Assert.assertEquals((String)"Num files mismatch", (long)1L, (long)stats.getNumFiles());
        Assert.assertFalse((String)"Compression configuration mismatch", (boolean)stats.isDataCompressed());
        CompressionEmulationUtil.setCompressionEmulationEnabled((Configuration)conf, (boolean)true);
        stats = GenerateData.publishDataStatistics((Path)testInputDir, (long)1234L, (Configuration)conf);
        Assert.assertEquals((String)"Data size mismatch", (long)size, (long)stats.getDataSize());
        Assert.assertEquals((String)"Num files mismatch", (long)1L, (long)stats.getNumFiles());
        Assert.assertTrue((String)"Compression configuration mismatch", (boolean)stats.isDataCompressed());
    }

    @Test
    public void testExecutionSummarizer() throws IOException {
        Configuration conf = new Configuration();
        ExecutionSummarizer es = new ExecutionSummarizer();
        Assert.assertEquals((String)"ExecutionSummarizer init failed", (Object)"N/A", (Object)es.getCommandLineArgsString());
        long startTime = System.currentTimeMillis();
        String[] initArgs = new String[]{"-Xmx20m", "-Dtest.args='test'"};
        es = new ExecutionSummarizer(initArgs);
        Assert.assertEquals((String)"ExecutionSummarizer init failed", (Object)"-Xmx20m -Dtest.args='test'", (Object)es.getCommandLineArgsString());
        Assert.assertTrue((String)"Start time mismatch", (es.getStartTime() >= startTime ? 1 : 0) != 0);
        Assert.assertTrue((String)"Start time mismatch", (es.getStartTime() <= System.currentTimeMillis() ? 1 : 0) != 0);
        es.update(null);
        Assert.assertEquals((String)"ExecutionSummarizer init failed", (long)0L, (long)es.getSimulationStartTime());
        TestGridmixSummary.testExecutionSummarizer((int)0, (int)0, (int)0, (int)0, (int)0, (int)0, (ExecutionSummarizer)es);
        long simStartTime = System.currentTimeMillis();
        es.start(null);
        Assert.assertTrue((String)"Simulation start time mismatch", (es.getSimulationStartTime() >= simStartTime ? 1 : 0) != 0);
        Assert.assertTrue((String)"Simulation start time mismatch", (es.getSimulationStartTime() <= System.currentTimeMillis() ? 1 : 0) != 0);
        Statistics.JobStats stats = TestGridmixSummary.generateFakeJobStats((int)1, (int)10, (boolean)true);
        es.update(stats);
        TestGridmixSummary.testExecutionSummarizer((int)1, (int)10, (int)0, (int)1, (int)1, (int)0, (ExecutionSummarizer)es);
        stats = TestGridmixSummary.generateFakeJobStats((int)5, (int)1, (boolean)false);
        es.update(stats);
        TestGridmixSummary.testExecutionSummarizer((int)6, (int)11, (int)0, (int)2, (int)1, (int)1, (ExecutionSummarizer)es);
        FakeJobFactory factory = new FakeJobFactory(conf);
        factory.numJobsInTrace = 3;
        Path rootTempDir = new Path(System.getProperty("test.build.data", "/tmp"));
        Path testDir = new Path(rootTempDir, "testGridmixSummary");
        Path testTraceFile = new Path(testDir, "test-trace.json");
        LocalFileSystem fs = FileSystem.getLocal((Configuration)conf);
        fs.create(testTraceFile).close();
        RoundRobinUserResolver resolver = new RoundRobinUserResolver();
        GenerateData.DataStatistics dataStats = new GenerateData.DataStatistics(100L, 2L, true);
        String policy = GridmixJobSubmissionPolicy.REPLAY.name();
        conf.set("gridmix.job-submission.policy", policy);
        es.finalize((JobFactory)factory, testTraceFile.toString(), 1024L, (UserResolver)resolver, dataStats, conf);
        Assert.assertEquals((String)"Mismtach in num jobs in trace", (long)3L, (long)es.getNumJobsInTrace());
        String tid = ExecutionSummarizer.getTraceSignature((String)testTraceFile.toString());
        Assert.assertEquals((String)"Mismatch in trace signature", (Object)tid, (Object)es.getInputTraceSignature());
        Path qPath = fs.makeQualified(testTraceFile);
        Assert.assertEquals((String)"Mismatch in trace filename", (Object)qPath.toString(), (Object)es.getInputTraceLocation());
        Assert.assertEquals((String)"Mismatch in expected data size", (Object)"1 K", (Object)es.getExpectedDataSize());
        Assert.assertEquals((String)"Mismatch in input data statistics", (Object)ExecutionSummarizer.stringifyDataStatistics((GenerateData.DataStatistics)dataStats), (Object)es.getInputDataStatistics());
        Assert.assertEquals((String)"Mismatch in user resolver", (Object)resolver.getClass().getName(), (Object)es.getUserResolver());
        Assert.assertEquals((String)"Mismatch in policy", (Object)policy, (Object)es.getJobSubmissionPolicy());
        es.finalize((JobFactory)factory, testTraceFile.toString(), 0x280000000L, (UserResolver)resolver, dataStats, conf);
        Assert.assertEquals((String)"Mismatch in expected data size", (Object)"10 G", (Object)es.getExpectedDataSize());
        fs.delete(testTraceFile, false);
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException ie) {
            // empty catch block
        }
        fs.create(testTraceFile).close();
        es.finalize((JobFactory)factory, testTraceFile.toString(), 0L, (UserResolver)resolver, dataStats, conf);
        Assert.assertEquals((String)"Mismatch in trace data size", (Object)"N/A", (Object)es.getExpectedDataSize());
        Assert.assertFalse((String)"Mismatch in trace signature", (boolean)tid.equals(es.getInputTraceSignature()));
        tid = ExecutionSummarizer.getTraceSignature((String)testTraceFile.toString());
        Assert.assertEquals((String)"Mismatch in trace signature", (Object)tid, (Object)es.getInputTraceSignature());
        testTraceFile = new Path(testDir, "test-trace2.json");
        fs.create(testTraceFile).close();
        es.finalize((JobFactory)factory, testTraceFile.toString(), 0L, (UserResolver)resolver, dataStats, conf);
        Assert.assertFalse((String)"Mismatch in trace signature", (boolean)tid.equals(es.getInputTraceSignature()));
        tid = ExecutionSummarizer.getTraceSignature((String)testTraceFile.toString());
        Assert.assertEquals((String)"Mismatch in trace signature", (Object)tid, (Object)es.getInputTraceSignature());
        es.finalize((JobFactory)factory, "-", 0L, (UserResolver)resolver, dataStats, conf);
        Assert.assertEquals((String)"Mismatch in trace signature", (Object)"N/A", (Object)es.getInputTraceSignature());
        Assert.assertEquals((String)"Mismatch in trace file location", (Object)"N/A", (Object)es.getInputTraceLocation());
    }

    private static void testExecutionSummarizer(int numMaps, int numReds, int totalJobsInTrace, int totalJobSubmitted, int numSuccessfulJob, int numFailedJobs, ExecutionSummarizer es) {
        Assert.assertEquals((String)"ExecutionSummarizer test failed [num-maps]", (long)numMaps, (long)es.getNumMapTasksLaunched());
        Assert.assertEquals((String)"ExecutionSummarizer test failed [num-reducers]", (long)numReds, (long)es.getNumReduceTasksLaunched());
        Assert.assertEquals((String)"ExecutionSummarizer test failed [num-jobs-in-trace]", (long)totalJobsInTrace, (long)es.getNumJobsInTrace());
        Assert.assertEquals((String)"ExecutionSummarizer test failed [num-submitted jobs]", (long)totalJobSubmitted, (long)es.getNumSubmittedJobs());
        Assert.assertEquals((String)"ExecutionSummarizer test failed [num-successful-jobs]", (long)numSuccessfulJob, (long)es.getNumSuccessfulJobs());
        Assert.assertEquals((String)"ExecutionSummarizer test failed [num-failed jobs]", (long)numFailedJobs, (long)es.getNumFailedJobs());
    }

    private static Statistics.JobStats generateFakeJobStats(int numMaps, int numReds, boolean isSuccessful) throws IOException {
        1 fakeJob = new /* Unavailable Anonymous Inner Class!! */;
        return new Statistics.JobStats(numMaps, numReds, (Job)fakeJob);
    }

    @Test
    public void testClusterSummarizer() throws IOException {
        ClusterSummarizer cs = new ClusterSummarizer();
        Configuration conf = new Configuration();
        String jt = "test-jt:1234";
        String nn = "test-nn:5678";
        conf.set("mapreduce.jobtracker.address", jt);
        conf.set("fs.defaultFS", nn);
        cs.start(conf);
        Assert.assertEquals((String)"JT name mismatch", (Object)jt, (Object)cs.getJobTrackerInfo());
        Assert.assertEquals((String)"NN name mismatch", (Object)nn, (Object)cs.getNamenodeInfo());
        Statistics.ClusterStats cstats = Statistics.ClusterStats.getClusterStats();
        conf.set("mapreduce.jobtracker.address", "local");
        conf.set("fs.defaultFS", "local");
        JobClient jc = new JobClient(conf);
        cstats.setClusterMetric(jc.getClusterStatus());
        cs.update(cstats);
        Assert.assertEquals((String)"Cluster summary test failed!", (long)1L, (long)cs.getMaxMapTasks());
        Assert.assertEquals((String)"Cluster summary test failed!", (long)1L, (long)cs.getMaxReduceTasks());
        Assert.assertEquals((String)"Cluster summary test failed!", (long)1L, (long)cs.getNumActiveTrackers());
        Assert.assertEquals((String)"Cluster summary test failed!", (long)0L, (long)cs.getNumBlacklistedTrackers());
    }
}

