/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred.gridmix;

import java.io.IOException;
import java.io.InputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.mapred.gridmix.CompressionEmulationUtil;
import org.apache.hadoop.mapreduce.lib.input.CombineFileSplit;

class FileQueue
extends InputStream {
    private int idx = -1;
    private long curlen = -1L;
    private InputStream input;
    private final byte[] z = new byte[1];
    private final Path[] paths;
    private final long[] lengths;
    private final long[] startoffset;
    private final Configuration conf;

    public FileQueue(CombineFileSplit split, Configuration conf) throws IOException {
        this.conf = conf;
        this.paths = split.getPaths();
        this.startoffset = split.getStartOffsets();
        this.lengths = split.getLengths();
        this.nextSource();
    }

    protected void nextSource() throws IOException {
        if (0 == this.paths.length) {
            return;
        }
        if (this.input != null) {
            this.input.close();
        }
        this.idx = (this.idx + 1) % this.paths.length;
        this.curlen = this.lengths[this.idx];
        Path file = this.paths[this.idx];
        this.input = CompressionEmulationUtil.getPossiblyDecompressedInputStream((Path)file, (Configuration)this.conf, (long)this.startoffset[this.idx]);
    }

    @Override
    public int read() throws IOException {
        int tmp = this.read(this.z);
        return tmp == -1 ? -1 : 0xFF & this.z[0];
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int kvread = 0;
        while (kvread < len) {
            if (this.curlen <= 0L) {
                this.nextSource();
                continue;
            }
            int srcRead = (int)Math.min((long)(len - kvread), this.curlen);
            IOUtils.readFully((InputStream)this.input, (byte[])b, (int)kvread, (int)srcRead);
            this.curlen -= (long)srcRead;
            kvread += srcRead;
        }
        return kvread;
    }

    @Override
    public void close() throws IOException {
        this.input.close();
    }
}

