/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred.gridmix;

import org.apache.commons.lang.time.FastDateFormat;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.gridmix.StatListener;
import org.apache.hadoop.mapred.gridmix.Statistics;

class ClusterSummarizer
implements StatListener<Statistics.ClusterStats> {
    static final Log LOG = LogFactory.getLog(ClusterSummarizer.class);
    private int numBlacklistedTrackers;
    private int numActiveTrackers;
    private int maxMapTasks;
    private int maxReduceTasks;
    private String jobTrackerInfo = "N/A";
    private String namenodeInfo = "N/A";

    ClusterSummarizer() {
    }

    public void update(Statistics.ClusterStats item) {
        try {
            this.numBlacklistedTrackers = item.getStatus().getBlacklistedTrackers();
            this.numActiveTrackers = item.getStatus().getTaskTrackers();
            this.maxMapTasks = item.getStatus().getMaxMapTasks();
            this.maxReduceTasks = item.getStatus().getMaxReduceTasks();
        }
        catch (Exception e) {
            long time = System.currentTimeMillis();
            LOG.info((Object)("Error in processing cluster status at " + FastDateFormat.getInstance().format(time)));
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Cluster Summary:-");
        builder.append("\nJobTracker: ").append(this.getJobTrackerInfo());
        builder.append("\nFileSystem: ").append(this.getNamenodeInfo());
        builder.append("\nNumber of blacklisted trackers: ").append(this.getNumBlacklistedTrackers());
        builder.append("\nNumber of active trackers: ").append(this.getNumActiveTrackers());
        builder.append("\nMax map task capacity: ").append(this.getMaxMapTasks());
        builder.append("\nMax reduce task capacity: ").append(this.getMaxReduceTasks());
        builder.append("\n\n");
        return builder.toString();
    }

    void start(Configuration conf) {
        this.jobTrackerInfo = conf.get("mapreduce.jobtracker.address");
        this.namenodeInfo = conf.get("fs.defaultFS");
    }

    protected int getNumBlacklistedTrackers() {
        return this.numBlacklistedTrackers;
    }

    protected int getNumActiveTrackers() {
        return this.numActiveTrackers;
    }

    protected int getMaxMapTasks() {
        return this.maxMapTasks;
    }

    protected int getMaxReduceTasks() {
        return this.maxReduceTasks;
    }

    protected String getJobTrackerInfo() {
        return this.jobTrackerInfo;
    }

    protected String getNamenodeInfo() {
        return this.namenodeInfo;
    }
}

