/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred.gridmix;

import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.gridmix.DebugJobFactory;
import org.apache.hadoop.mapred.gridmix.GridmixJobSubmissionPolicy;
import org.apache.hadoop.mapred.gridmix.JobFactory;
import org.apache.hadoop.mapred.gridmix.JobSubmitter;
import org.apache.hadoop.mapred.gridmix.UserResolver;

public class DebugJobFactory {
    public static JobFactory<?> getFactory(JobSubmitter submitter, Path scratch, int numJobs, Configuration conf, CountDownLatch startFlag, UserResolver resolver) throws IOException {
        GridmixJobSubmissionPolicy policy = GridmixJobSubmissionPolicy.getPolicy((Configuration)conf, (GridmixJobSubmissionPolicy)GridmixJobSubmissionPolicy.STRESS);
        if (policy == GridmixJobSubmissionPolicy.REPLAY) {
            return new DebugReplayJobFactory(submitter, scratch, numJobs, conf, startFlag, resolver);
        }
        if (policy == GridmixJobSubmissionPolicy.STRESS) {
            return new DebugStressJobFactory(submitter, scratch, numJobs, conf, startFlag, resolver);
        }
        if (policy == GridmixJobSubmissionPolicy.SERIAL) {
            return new DebugSerialJobFactory(submitter, scratch, numJobs, conf, startFlag, resolver);
        }
        return null;
    }
}

