/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred.gridmix;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.IOException;
import java.util.Arrays;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.mapred.gridmix.CompressionEmulationUtil;
import org.apache.hadoop.mapred.gridmix.RandomTextDataGenerator;

/*
 * Exception performing whole class analysis ignored.
 */
class GridmixRecord
implements WritableComparable<GridmixRecord> {
    private static final int FIXED_BYTES = 1;
    private int size = -1;
    private long seed;
    private final DataInputBuffer dib = new DataInputBuffer();
    private final DataOutputBuffer dob = new DataOutputBuffer(8);
    private byte[] literal = this.dob.getData();
    private boolean compressible = false;
    private float compressionRatio = 0.5f;
    private RandomTextDataGenerator rtg = null;

    GridmixRecord() {
        this(1, 0L);
    }

    GridmixRecord(int size, long seed) {
        this.seed = seed;
        this.setSizeInternal(size);
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.setSizeInternal(size);
    }

    void setCompressibility(boolean compressible, float ratio) {
        this.compressible = compressible;
        this.compressionRatio = ratio;
        if (compressible) {
            this.rtg = CompressionEmulationUtil.getRandomTextDataGenerator((float)ratio, (long)0L);
        }
    }

    private void setSizeInternal(int size) {
        this.size = Math.max(1, size);
        try {
            this.seed = GridmixRecord.maskSeed((long)this.seed, (int)this.size);
            this.dob.reset();
            this.dob.writeLong(this.seed);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public final void setSeed(long seed) {
        this.seed = seed;
    }

    long nextRand(long x) {
        x ^= x << 13;
        x ^= x >>> 7;
        x ^= x << 17;
        return x;
    }

    private void writeRandomText(DataOutput out, int size) throws IOException {
        long tmp = this.seed;
        out.writeLong(tmp);
        int i = size - 8;
        String randomWord = this.rtg.getRandomWord();
        byte[] bytes = randomWord.getBytes("UTF-8");
        long randomWordSize = bytes.length;
        while ((long)i >= randomWordSize) {
            out.write(bytes);
            i = (int)((long)i - randomWordSize);
            randomWord = this.rtg.getRandomWord();
            bytes = randomWord.getBytes("UTF-8");
            randomWordSize = bytes.length;
        }
        if (i > 0) {
            out.write(bytes, 0, i);
        }
    }

    public void writeRandom(DataOutput out, int size) throws IOException {
        int i;
        long tmp = this.seed;
        out.writeLong(tmp);
        for (i = size - 8; i > 7; i -= 8) {
            tmp = this.nextRand(tmp);
            out.writeLong(tmp);
        }
        tmp = this.nextRand(tmp);
        while (i > 0) {
            out.writeByte((int)(tmp & 0xFFL));
            tmp >>>= 8;
            --i;
        }
    }

    public void readFields(DataInput in) throws IOException {
        this.size = WritableUtils.readVInt((DataInput)in);
        int payload = this.size - WritableUtils.getVIntSize((long)this.size);
        if (payload > 8) {
            this.seed = in.readLong();
            payload -= 8;
        } else {
            Arrays.fill(this.literal, (byte)0);
            in.readFully(this.literal, 0, payload);
            this.dib.reset(this.literal, 0, this.literal.length);
            this.seed = this.dib.readLong();
            payload = 0;
        }
        int vBytes = in.skipBytes(payload);
        if (vBytes != payload) {
            throw new EOFException("Expected " + payload + ", read " + vBytes);
        }
    }

    public void write(DataOutput out) throws IOException {
        WritableUtils.writeVInt((DataOutput)out, (int)this.size);
        int payload = this.size - WritableUtils.getVIntSize((long)this.size);
        if (payload > 8) {
            if (this.compressible) {
                this.writeRandomText(out, payload);
            } else {
                this.writeRandom(out, payload);
            }
        } else if (payload > 0) {
            out.write(this.literal, 0, payload);
        }
    }

    public int compareTo(GridmixRecord other) {
        return this.compareSeed(other.seed, Math.max(0, other.getSize() - other.fixedBytes()));
    }

    int fixedBytes() {
        return 1;
    }

    private static long maskSeed(long sd, int sz) {
        if (sz <= 1) {
            sd = 0L;
        } else if (sz < 9) {
            int tmp = sz - 1;
            long mask = (1L << 8 * tmp) - 1L;
            sd &= mask << 8 * (8 - tmp);
        }
        return sd;
    }

    int compareSeed(long jSeed, int jSize) {
        int iSize = Math.max(0, this.getSize() - this.fixedBytes());
        int seedLen = Math.min(iSize, jSize) + 1;
        jSeed = GridmixRecord.maskSeed((long)jSeed, (int)seedLen);
        long iSeed = GridmixRecord.maskSeed((long)this.seed, (int)seedLen);
        int cmplen = Math.min(iSize, jSize);
        for (int i = 0; i < cmplen; i += 8) {
            int k = cmplen - i;
            for (long j = 56L; j >= (long)(Math.max(0, 8 - k) * 8); j -= 8L) {
                int xi = (int)(iSeed >>> (int)j & 0xFFL);
                int xj = (int)(jSeed >>> (int)j & 0xFFL);
                if (xi == xj) continue;
                return xi - xj;
            }
            iSeed = this.nextRand(iSeed);
            jSeed = this.nextRand(jSeed);
        }
        return iSize - jSize;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other != null && other.getClass() == this.getClass()) {
            GridmixRecord o = (GridmixRecord)other;
            return this.getSize() == o.getSize() && this.seed == o.seed;
        }
        return false;
    }

    public int hashCode() {
        return (int)(this.seed * (long)this.getSize());
    }
}

