/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred.gridmix;

import java.io.DataOutput;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.mapred.gridmix.AvgRecordFactory;
import org.apache.hadoop.mapred.gridmix.GridmixKey;
import org.apache.hadoop.mapred.gridmix.GridmixRecord;
import org.junit.Assert;
import org.junit.Test;

/*
 * Exception performing whole class analysis ignored.
 */
public class TestRecordFactory {
    private static final Log LOG = LogFactory.getLog(TestRecordFactory.class);

    public static void testFactory(long targetBytes, long targetRecs) throws Exception {
        Configuration conf = new Configuration();
        GridmixKey key = new GridmixKey();
        GridmixRecord val = new GridmixRecord();
        LOG.info((Object)("Target bytes/records: " + targetBytes + "/" + targetRecs));
        AvgRecordFactory f = new AvgRecordFactory(targetBytes, targetRecs, conf);
        targetRecs = targetRecs <= 0L && targetBytes >= 0L ? Math.max(1L, targetBytes / (long)conf.getInt("gridmix.missing.rec.size", 65536)) : targetRecs;
        long records = 0L;
        DataOutputBuffer out = new DataOutputBuffer();
        while (f.next(key, val)) {
            ++records;
            key.write((DataOutput)out);
            val.write((DataOutput)out);
        }
        Assert.assertEquals((long)targetRecs, (long)records);
        Assert.assertEquals((long)targetBytes, (long)out.getLength());
    }

    @Test
    public void testRandom() throws Exception {
        Random r = new Random();
        long targetBytes = r.nextInt(0x100000) + 49152;
        long targetRecs = r.nextInt(16384);
        TestRecordFactory.testFactory((long)targetBytes, (long)targetRecs);
    }

    @Test
    public void testAvg() throws Exception {
        Random r = new Random();
        long avgsize = r.nextInt(1024) + 1;
        long targetRecs = r.nextInt(16384);
        TestRecordFactory.testFactory((long)(targetRecs * avgsize), (long)targetRecs);
    }

    @Test
    public void testZero() throws Exception {
        Random r = new Random();
        long targetBytes = r.nextInt(0x100000);
        TestRecordFactory.testFactory((long)targetBytes, (long)0L);
    }
}

