/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred.gridmix;

import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.io.RawComparator;
import org.apache.hadoop.io.WritableComparator;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.mapred.gridmix.CompressionEmulationUtil;
import org.apache.hadoop.mapred.gridmix.FilePool;
import org.apache.hadoop.mapred.gridmix.GridmixKey;
import org.apache.hadoop.mapred.gridmix.GridmixRecord;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.Partitioner;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.tools.rumen.JobStory;
import org.apache.hadoop.tools.rumen.datatypes.util.MapReduceJobPropertiesParser;

abstract class GridmixJob
implements Callable<Job>,
Delayed {
    public static final String JOB_NAME_PREFIX = "GRIDMIX";
    public static final Log LOG = LogFactory.getLog(GridmixJob.class);
    private static final ThreadLocal<Formatter> nameFormat = new ThreadLocal<Formatter>(){

        @Override
        protected Formatter initialValue() {
            StringBuilder sb = new StringBuilder(GridmixJob.JOB_NAME_PREFIX.length() + 6);
            sb.append(GridmixJob.JOB_NAME_PREFIX);
            return new Formatter(sb);
        }
    };
    private boolean submitted;
    protected final int seq;
    protected final Path outdir;
    protected final Job job;
    protected final JobStory jobdesc;
    protected final UserGroupInformation ugi;
    protected final long submissionTimeNanos;
    private static final ConcurrentHashMap<Integer, List<InputSplit>> descCache = new ConcurrentHashMap();
    protected static final String GRIDMIX_JOB_SEQ = "gridmix.job.seq";
    protected static final String GRIDMIX_USE_QUEUE_IN_TRACE = "gridmix.job-submission.use-queue-in-trace";
    protected static final String GRIDMIX_DEFAULT_QUEUE = "gridmix.job-submission.default-queue";
    static final String GRIDMIX_HIGHRAM_EMULATION_ENABLE = "gridmix.highram-emulation.enable";
    static final String GRIDMIX_TASK_JVM_OPTIONS_ENABLE = "gridmix.task.jvm-options.enable";

    private static void setJobQueue(Job job, String queue) {
        if (queue != null) {
            job.getConfiguration().set("mapreduce.job.queuename", queue);
        }
    }

    public GridmixJob(final Configuration conf, long submissionMillis, final JobStory jobdesc, Path outRoot, UserGroupInformation ugi, final int seq) throws IOException {
        this.ugi = ugi;
        this.jobdesc = jobdesc;
        this.seq = seq;
        ((StringBuilder)nameFormat.get().out()).setLength(JOB_NAME_PREFIX.length());
        try {
            this.job = (Job)this.ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Job>(){

                @Override
                public Job run() throws IOException {
                    String jobId = null == jobdesc.getJobID() ? "<unknown>" : jobdesc.getJobID().toString();
                    Job ret = new Job(conf, ((Formatter)nameFormat.get()).format("%06d", seq).toString());
                    ret.getConfiguration().setInt(GridmixJob.GRIDMIX_JOB_SEQ, seq);
                    ret.getConfiguration().set("gridmix.job.original-job-id", jobId);
                    ret.getConfiguration().set("gridmix.job.original-job-name", jobdesc.getName());
                    if (conf.getBoolean(GridmixJob.GRIDMIX_USE_QUEUE_IN_TRACE, false)) {
                        GridmixJob.setJobQueue(ret, jobdesc.getQueueName());
                    } else {
                        GridmixJob.setJobQueue(ret, conf.get(GridmixJob.GRIDMIX_DEFAULT_QUEUE));
                    }
                    if (GridmixJob.this.canEmulateCompression() && CompressionEmulationUtil.isCompressionEmulationEnabled(conf)) {
                        CompressionEmulationUtil.configureCompressionEmulation((Configuration)jobdesc.getJobConf(), ret.getConfiguration());
                    }
                    if (conf.getBoolean(GridmixJob.GRIDMIX_HIGHRAM_EMULATION_ENABLE, true)) {
                        GridmixJob.configureHighRamProperties((Configuration)jobdesc.getJobConf(), ret.getConfiguration());
                    }
                    if (conf.getBoolean(GridmixJob.GRIDMIX_TASK_JVM_OPTIONS_ENABLE, true)) {
                        GridmixJob.configureTaskJVMOptions((Configuration)jobdesc.getJobConf(), ret.getConfiguration());
                    }
                    return ret;
                }
            });
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
        this.submissionTimeNanos = TimeUnit.NANOSECONDS.convert(submissionMillis, TimeUnit.MILLISECONDS);
        this.outdir = new Path(outRoot, "" + seq);
    }

    protected static void configureTaskJVMOptions(Configuration originalJobConf, Configuration simulatedJobConf) {
        GridmixJob.configureTaskJVMMaxHeapOptions(originalJobConf, simulatedJobConf, "mapred.child.java.opts");
        GridmixJob.configureTaskJVMMaxHeapOptions(originalJobConf, simulatedJobConf, "mapreduce.map.java.opts");
        GridmixJob.configureTaskJVMMaxHeapOptions(originalJobConf, simulatedJobConf, "mapreduce.reduce.java.opts");
    }

    private static void configureTaskJVMMaxHeapOptions(Configuration srcConf, Configuration destConf, String key) {
        String srcHeapOpts = srcConf.get(key);
        if (srcHeapOpts != null) {
            ArrayList srcMaxOptsList = new ArrayList();
            MapReduceJobPropertiesParser.extractMaxHeapOpts((String)srcHeapOpts, srcMaxOptsList, new ArrayList());
            if (srcMaxOptsList.size() > 0) {
                ArrayList destOtherOptsList = new ArrayList();
                String destHeapOpts = destConf.get(key);
                if (destHeapOpts != null) {
                    MapReduceJobPropertiesParser.extractMaxHeapOpts((String)destHeapOpts, new ArrayList(), destOtherOptsList);
                }
                StringBuilder newHeapOpts = new StringBuilder();
                for (String otherOpt : destOtherOptsList) {
                    newHeapOpts.append(otherOpt).append(" ");
                }
                for (String opts : srcMaxOptsList) {
                    newHeapOpts.append(opts).append(" ");
                }
                destConf.set(key, newHeapOpts.toString().trim());
            }
        }
    }

    private static void scaleConfigParameter(Configuration sourceConf, Configuration destConf, String clusterValueKey, String jobValueKey, long defaultValue) {
        long simulatedClusterDefaultValue = destConf.getLong(clusterValueKey, defaultValue);
        long originalClusterDefaultValue = sourceConf.getLong(clusterValueKey, defaultValue);
        long originalJobValue = sourceConf.getLong(jobValueKey, defaultValue);
        double scaleFactor = (double)originalJobValue / (double)originalClusterDefaultValue;
        long simulatedJobValue = (long)(scaleFactor * (double)simulatedClusterDefaultValue);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("For the job configuration parameter '" + jobValueKey + "' and the cluster configuration parameter '" + clusterValueKey + "', the original job's configuration value" + " is scaled from '" + originalJobValue + "' to '" + simulatedJobValue + "' using the default (unit) value of " + "'" + originalClusterDefaultValue + "' for the original " + " cluster and '" + simulatedClusterDefaultValue + "' for the" + " simulated cluster."));
        }
        destConf.setLong(jobValueKey, simulatedJobValue);
    }

    private static boolean checkMemoryUpperLimits(String jobKey, String limitKey, Configuration conf, boolean convertLimitToMB) {
        long limit;
        if (conf.get(limitKey) != null && (limit = conf.getLong(limitKey, -1L)) >= 0L) {
            long scaledConfigValue;
            if (convertLimitToMB) {
                limit /= 0x100000L;
            }
            if ((scaledConfigValue = conf.getLong(jobKey, -1L)) > limit) {
                throw new RuntimeException("Simulated job's configuration parameter '" + jobKey + "' got scaled to a value '" + scaledConfigValue + "' which exceeds the upper limit of '" + limit + "' defined for the simulated cluster by the key '" + limitKey + "'. To disable High-Ram feature emulation, set '" + GRIDMIX_HIGHRAM_EMULATION_ENABLE + "' to 'false'.");
            }
            return true;
        }
        return false;
    }

    private static void validateTaskMemoryLimits(Configuration conf, String jobKey, String clusterMaxKey) {
        if (!GridmixJob.checkMemoryUpperLimits(jobKey, "mapred.task.limit.maxvmem", conf, true)) {
            GridmixJob.checkMemoryUpperLimits(jobKey, clusterMaxKey, conf, false);
        }
    }

    static void configureHighRamProperties(Configuration sourceConf, Configuration destConf) {
        GridmixJob.scaleConfigParameter(sourceConf, destConf, "mapreduce.cluster.mapmemory.mb", "mapreduce.map.memory.mb", 1024L);
        GridmixJob.validateTaskMemoryLimits(destConf, "mapreduce.map.memory.mb", "mapreduce.jobtracker.maxmapmemory.mb");
        GridmixJob.scaleConfigParameter(sourceConf, destConf, "mapreduce.cluster.reducememory.mb", "mapreduce.reduce.memory.mb", 1024L);
        GridmixJob.validateTaskMemoryLimits(destConf, "mapreduce.reduce.memory.mb", "mapreduce.jobtracker.maxreducememory.mb");
    }

    protected abstract boolean canEmulateCompression();

    protected GridmixJob(final Configuration conf, long submissionMillis, final String name) throws IOException {
        this.submissionTimeNanos = TimeUnit.NANOSECONDS.convert(submissionMillis, TimeUnit.MILLISECONDS);
        this.jobdesc = null;
        this.outdir = null;
        this.seq = -1;
        this.ugi = UserGroupInformation.getCurrentUser();
        try {
            this.job = (Job)this.ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Job>(){

                @Override
                public Job run() throws IOException {
                    Job ret = new Job(conf, name);
                    ret.getConfiguration().setInt(GridmixJob.GRIDMIX_JOB_SEQ, GridmixJob.this.seq);
                    GridmixJob.setJobQueue(ret, conf.get(GridmixJob.GRIDMIX_DEFAULT_QUEUE));
                    return ret;
                }
            });
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }

    public UserGroupInformation getUgi() {
        return this.ugi;
    }

    public String toString() {
        return this.job.getJobName();
    }

    @Override
    public long getDelay(TimeUnit unit) {
        return unit.convert(this.submissionTimeNanos - System.nanoTime(), TimeUnit.NANOSECONDS);
    }

    @Override
    public int compareTo(Delayed other) {
        if (this == other) {
            return 0;
        }
        if (other instanceof GridmixJob) {
            long otherNanos = ((GridmixJob)other).submissionTimeNanos;
            if (otherNanos < this.submissionTimeNanos) {
                return 1;
            }
            if (otherNanos > this.submissionTimeNanos) {
                return -1;
            }
            return this.id() - ((GridmixJob)other).id();
        }
        long diff = this.getDelay(TimeUnit.NANOSECONDS) - other.getDelay(TimeUnit.NANOSECONDS);
        return 0L == diff ? 0 : (diff > 0L ? 1 : -1);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof GridmixJob && this.id() == ((GridmixJob)other).id();
    }

    public int hashCode() {
        return this.id();
    }

    int id() {
        return this.seq;
    }

    Job getJob() {
        return this.job;
    }

    JobStory getJobDesc() {
        return this.jobdesc;
    }

    void setSubmitted() {
        this.submitted = true;
    }

    boolean isSubmitted() {
        return this.submitted;
    }

    static void pushDescription(int seq, List<InputSplit> splits) {
        if (null != descCache.putIfAbsent(seq, splits)) {
            throw new IllegalArgumentException("Description exists for id " + seq);
        }
    }

    static List<InputSplit> pullDescription(JobContext jobCtxt) {
        return GridmixJob.pullDescription(GridmixJob.getJobSeqId(jobCtxt));
    }

    static List<InputSplit> pullDescription(int seq) {
        return descCache.remove(seq);
    }

    static void clearAll() {
        descCache.clear();
    }

    void buildSplits(FilePool inputDir) throws IOException {
    }

    static int getJobSeqId(JobContext job) {
        return job.getConfiguration().getInt(GRIDMIX_JOB_SEQ, -1);
    }

    static class RawBytesOutputFormat<K>
    extends FileOutputFormat<K, GridmixRecord> {
        RawBytesOutputFormat() {
        }

        public RecordWriter<K, GridmixRecord> getRecordWriter(TaskAttemptContext job) throws IOException {
            Path file = this.getDefaultWorkFile(job, "");
            final DataOutputStream fileOut = new DataOutputStream(CompressionEmulationUtil.getPossiblyCompressedOutputStream(file, job.getConfiguration()));
            return new RecordWriter<K, GridmixRecord>(){

                public void write(K ignored, GridmixRecord value) throws IOException {
                    value.write(fileOut);
                }

                public void close(TaskAttemptContext ctxt) throws IOException {
                    fileOut.close();
                }
            };
        }
    }

    public static class SpecGroupingComparator
    implements RawComparator<GridmixKey> {
        private final DataInputBuffer di = new DataInputBuffer();
        private final byte[] reset = this.di.getData();

        public int compare(GridmixKey g1, GridmixKey g2) {
            byte t1 = g1.getType();
            byte t2 = g2.getType();
            if (t1 == 0 || t2 == 0) {
                return t1 - t2;
            }
            assert (t1 == 1);
            assert (t2 == 1);
            return g1.compareTo(g2);
        }

        public int compare(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) {
            try {
                int ret;
                this.di.reset(b1, s1, l1);
                int x1 = WritableUtils.readVInt((DataInput)this.di);
                this.di.reset(b2, s2, l2);
                int x2 = WritableUtils.readVInt((DataInput)this.di);
                byte t1 = b1[s1 + x1];
                byte t2 = b2[s2 + x2];
                if (t1 == 0 || t2 == 0) {
                    ret = t1 - t2;
                } else {
                    assert (t1 == 1);
                    assert (t2 == 1);
                    ret = WritableComparator.compareBytes((byte[])b1, (int)s1, (int)x1, (byte[])b2, (int)s2, (int)x2);
                }
                this.di.reset(this.reset, 0, 0);
                return ret;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static class DraftPartitioner<V>
    extends Partitioner<GridmixKey, V> {
        public int getPartition(GridmixKey key, V value, int numReduceTasks) {
            return key.getPartition();
        }
    }
}

