/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred.gridmix;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.mapred.gridmix.AvgRecordFactory;
import org.apache.hadoop.mapred.gridmix.GridmixKey;
import org.apache.hadoop.mapred.gridmix.GridmixRecord;
import org.apache.hadoop.mapred.gridmix.RecordFactory;

class ReadRecordFactory
extends RecordFactory {
    public static final String GRIDMIX_READ_BUF_SIZE = "gridmix.read.buffer.size";
    private final byte[] buf;
    private final InputStream src;
    private final RecordFactory factory;

    public ReadRecordFactory(long targetBytes, long targetRecords, InputStream src, Configuration conf) {
        this(new AvgRecordFactory(targetBytes, targetRecords, conf), src, conf);
    }

    public ReadRecordFactory(RecordFactory factory, InputStream src, Configuration conf) {
        this.src = src;
        this.factory = factory;
        this.buf = new byte[conf.getInt(GRIDMIX_READ_BUF_SIZE, 65536)];
    }

    @Override
    public boolean next(GridmixKey key, GridmixRecord val) throws IOException {
        if (!this.factory.next(key, val)) {
            return false;
        }
        for (int len = (null == key ? 0 : key.getSize()) + val.getSize(); len > 0; len -= this.buf.length) {
            IOUtils.readFully((InputStream)this.src, (byte[])this.buf, (int)0, (int)Math.min(this.buf.length, len));
        }
        return true;
    }

    @Override
    public float getProgress() throws IOException {
        return this.factory.getProgress();
    }

    @Override
    public void close() throws IOException {
        IOUtils.cleanup(null, (Closeable[])new Closeable[]{this.src});
        this.factory.close();
    }
}

