/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.ha;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.DFSUtilClient;
import org.apache.hadoop.hdfs.HAUtilClient;
import org.apache.hadoop.hdfs.server.namenode.ha.AbstractNNFailoverProxyProvider;
import org.apache.hadoop.hdfs.server.namenode.ha.HAProxyFactory;
import org.apache.hadoop.io.retry.FailoverProxyProvider;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.security.UserGroupInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfiguredFailoverProxyProvider<T>
extends AbstractNNFailoverProxyProvider<T> {
    private static final Logger LOG = LoggerFactory.getLogger(ConfiguredFailoverProxyProvider.class);
    protected final Configuration conf;
    protected final List<AddressRpcProxyPair<T>> proxies = new ArrayList<AddressRpcProxyPair<T>>();
    private final UserGroupInformation ugi;
    protected final Class<T> xface;
    private int currentProxyIndex = 0;
    private final HAProxyFactory<T> factory;

    public ConfiguredFailoverProxyProvider(Configuration conf, URI uri, Class<T> xface, HAProxyFactory<T> factory) {
        this.xface = xface;
        this.conf = new Configuration(conf);
        int maxRetries = this.conf.getInt("dfs.client.failover.connection.retries", 0);
        this.conf.setInt("ipc.client.connect.max.retries", maxRetries);
        int maxRetriesOnSocketTimeouts = this.conf.getInt("dfs.client.failover.connection.retries.on.timeouts", 0);
        this.conf.setInt("ipc.client.connect.max.retries.on.timeouts", maxRetriesOnSocketTimeouts);
        try {
            this.ugi = UserGroupInformation.getCurrentUser();
            Map<String, Map<String, InetSocketAddress>> map = DFSUtilClient.getHaNnRpcAddresses(conf);
            Map<String, InetSocketAddress> addressesInNN = map.get(uri.getHost());
            if (addressesInNN == null || addressesInNN.size() == 0) {
                throw new RuntimeException("Could not find any configured addresses for URI " + uri);
            }
            Collection<InetSocketAddress> addressesOfNns = addressesInNN.values();
            for (InetSocketAddress address : addressesOfNns) {
                this.proxies.add(new AddressRpcProxyPair(address));
            }
            HAUtilClient.cloneDelegationTokenForLogicalUri(this.ugi, uri, addressesOfNns);
            this.factory = factory;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Class<T> getInterface() {
        return this.xface;
    }

    public synchronized FailoverProxyProvider.ProxyInfo<T> getProxy() {
        AddressRpcProxyPair<T> current = this.proxies.get(this.currentProxyIndex);
        if (current.namenode == null) {
            try {
                current.namenode = this.factory.createProxy(this.conf, current.address, this.xface, this.ugi, false, this.getFallbackToSimpleAuth());
            }
            catch (IOException e) {
                LOG.error("Failed to create RPC proxy to NameNode", (Throwable)e);
                throw new RuntimeException(e);
            }
        }
        return new FailoverProxyProvider.ProxyInfo(current.namenode, current.address.toString());
    }

    public void performFailover(T currentProxy) {
        this.incrementProxyIndex();
    }

    synchronized void incrementProxyIndex() {
        this.currentProxyIndex = (this.currentProxyIndex + 1) % this.proxies.size();
    }

    public synchronized void close() throws IOException {
        for (AddressRpcProxyPair<T> proxy : this.proxies) {
            if (proxy.namenode == null) continue;
            if (proxy.namenode instanceof Closeable) {
                ((Closeable)proxy.namenode).close();
                continue;
            }
            RPC.stopProxy(proxy.namenode);
        }
    }

    @Override
    public boolean useLogicalURI() {
        return true;
    }

    private static class AddressRpcProxyPair<T> {
        public final InetSocketAddress address;
        public T namenode;

        public AddressRpcProxyPair(InetSocketAddress address) {
            this.address = address;
        }
    }
}

