/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.IOException;
import java.util.concurrent.atomic.LongAccumulator;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.ipc.AlignmentContext;
import org.apache.hadoop.ipc.protobuf.RpcHeaderProtos;
import org.apache.hadoop.thirdparty.protobuf.ByteString;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class ClientGSIContext
implements AlignmentContext {
    private final LongAccumulator lastSeenStateId;
    private ByteString routerFederatedState;

    public ClientGSIContext() {
        this(new LongAccumulator(Math::max, Long.MIN_VALUE));
    }

    public ClientGSIContext(LongAccumulator lastSeenStateId) {
        this.lastSeenStateId = lastSeenStateId;
        this.routerFederatedState = null;
    }

    public long getLastSeenStateId() {
        return this.lastSeenStateId.get();
    }

    public boolean isCoordinatedCall(String protocolName, String method) {
        throw new UnsupportedOperationException("Client should not be checking uncoordinated call");
    }

    public void updateResponseState(RpcHeaderProtos.RpcResponseHeaderProto.Builder header) {
    }

    public synchronized void receiveResponseState(RpcHeaderProtos.RpcResponseHeaderProto header) {
        if (header.hasRouterFederatedState()) {
            this.routerFederatedState = header.getRouterFederatedState();
        } else {
            this.lastSeenStateId.accumulate(header.getStateId());
        }
    }

    public synchronized void updateRequestState(RpcHeaderProtos.RpcRequestHeaderProto.Builder header) {
        if (this.lastSeenStateId.get() != Long.MIN_VALUE) {
            header.setStateId(this.lastSeenStateId.get());
        }
        if (this.routerFederatedState != null) {
            header.setRouterFederatedState(this.routerFederatedState);
        }
    }

    public long receiveRequestState(RpcHeaderProtos.RpcRequestHeaderProto header, long threshold) throws IOException {
        return 0L;
    }
}

