/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.client;

import java.io.IOException;
import java.net.URI;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class HdfsUtils {
    public static final Logger LOG = LoggerFactory.getLogger(HdfsUtils.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isHealthy(URI uri) {
        String scheme = uri.getScheme();
        if (!"hdfs".equalsIgnoreCase(scheme)) {
            throw new IllegalArgumentException("The scheme is not hdfs, uri=" + uri);
        }
        Configuration conf = new Configuration();
        conf.setBoolean(String.format("fs.%s.impl.disable.cache", scheme), true);
        conf.setBoolean("dfs.client.retry.policy.enabled", false);
        conf.setInt("ipc.client.connect.max.retries", 0);
        try (DistributedFileSystem fs = (DistributedFileSystem)FileSystem.get((URI)uri, (Configuration)conf);){
            boolean safemode = fs.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_GET);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Is namenode in safemode? " + safemode + "; uri=" + uri);
            }
            boolean bl = !safemode;
            return bl;
        }
        catch (IOException e) {
            if (!LOG.isDebugEnabled()) return false;
            LOG.debug("Got an exception for uri=" + uri, (Throwable)e);
            return false;
        }
    }
}

