/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestDataDirs {
    @Test(timeout=10000L)
    public void testGetDataDirsFromURIs() throws Throwable {
        DataNode.DataNodeDiskChecker diskChecker = (DataNode.DataNodeDiskChecker)Mockito.mock(DataNode.DataNodeDiskChecker.class);
        ((DataNode.DataNodeDiskChecker)Mockito.doThrow((Throwable)new IOException()).doThrow((Throwable)new IOException()).doNothing().when((Object)diskChecker)).checkDir((LocalFileSystem)Mockito.any(LocalFileSystem.class), (Path)Mockito.any(Path.class));
        LocalFileSystem fs = (LocalFileSystem)Mockito.mock(LocalFileSystem.class);
        List<URI> uris = Arrays.asList(new URI("file:/p1/"), new URI("file:/p2/"), new URI("file:/p3/"));
        ArrayList dirs = DataNode.getDataDirsFromURIs(uris, (LocalFileSystem)fs, (DataNode.DataNodeDiskChecker)diskChecker);
        Assert.assertEquals((String)"number of valid data dirs", (long)1L, (long)dirs.size());
        String validDir = ((File)dirs.iterator().next()).getPath();
        Assert.assertEquals((String)"p3 should be valid", (Object)new File("/p3").getPath(), (Object)validDir);
    }
}

