/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode.fsdataset;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsVolumeSpi;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.RoundRobinVolumeChoosingPolicy;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.VolumeChoosingPolicy;
import org.apache.hadoop.util.DiskChecker;
import org.apache.hadoop.util.ReflectionUtils;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestRoundRobinVolumeChoosingPolicy {
    @Test
    public void testRR() throws Exception {
        RoundRobinVolumeChoosingPolicy policy = (RoundRobinVolumeChoosingPolicy)ReflectionUtils.newInstance(RoundRobinVolumeChoosingPolicy.class, null);
        TestRoundRobinVolumeChoosingPolicy.testRR((VolumeChoosingPolicy<FsVolumeSpi>)policy);
    }

    public static void testRR(VolumeChoosingPolicy<FsVolumeSpi> policy) throws Exception {
        ArrayList<Object> volumes = new ArrayList<Object>();
        volumes.add(Mockito.mock(FsVolumeSpi.class));
        Mockito.when((Object)((FsVolumeSpi)volumes.get(0)).getAvailable()).thenReturn((Object)100L);
        volumes.add(Mockito.mock(FsVolumeSpi.class));
        Mockito.when((Object)((FsVolumeSpi)volumes.get(1)).getAvailable()).thenReturn((Object)200L);
        Assert.assertEquals(volumes.get(0), (Object)policy.chooseVolume(volumes, 0L));
        Assert.assertEquals(volumes.get(1), (Object)policy.chooseVolume(volumes, 0L));
        Assert.assertEquals(volumes.get(0), (Object)policy.chooseVolume(volumes, 0L));
        Assert.assertEquals(volumes.get(1), (Object)policy.chooseVolume(volumes, 0L));
        Assert.assertEquals(volumes.get(1), (Object)policy.chooseVolume(volumes, 150L));
        try {
            policy.chooseVolume(volumes, Long.MAX_VALUE);
            Assert.fail();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    public void testRRPolicyExceptionMessage() throws Exception {
        RoundRobinVolumeChoosingPolicy policy = new RoundRobinVolumeChoosingPolicy();
        TestRoundRobinVolumeChoosingPolicy.testRRPolicyExceptionMessage((VolumeChoosingPolicy<FsVolumeSpi>)policy);
    }

    public static void testRRPolicyExceptionMessage(VolumeChoosingPolicy<FsVolumeSpi> policy) throws Exception {
        ArrayList<Object> volumes = new ArrayList<Object>();
        volumes.add(Mockito.mock(FsVolumeSpi.class));
        Mockito.when((Object)((FsVolumeSpi)volumes.get(0)).getAvailable()).thenReturn((Object)500L);
        volumes.add(Mockito.mock(FsVolumeSpi.class));
        Mockito.when((Object)((FsVolumeSpi)volumes.get(1)).getAvailable()).thenReturn((Object)600L);
        int blockSize = 700;
        try {
            policy.chooseVolume(volumes, (long)blockSize);
            Assert.fail((String)"expected to throw DiskOutOfSpaceException");
        }
        catch (DiskChecker.DiskOutOfSpaceException e) {
            Assert.assertEquals((String)"Not returnig the expected message", (Object)("Out of space: The volume with the most available space (=600 B) is less than the block size (=" + blockSize + " B)."), (Object)e.getMessage());
        }
    }
}

