/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.File;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.DF;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeManager;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.junit.Assert;
import org.junit.Test;

public class TestNamenodeCapacityReport {
    private static final Log LOG = LogFactory.getLog(TestNamenodeCapacityReport.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testVolumeSize() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = null;
        long reserved = 10000L;
        conf.setLong("dfs.datanode.du.reserved", reserved);
        try {
            float percentBpUsed;
            long bpUsed;
            float percentRemaining;
            float percentUsed;
            long configCapacity;
            long nonDFSUsed;
            long remaining;
            long used;
            cluster = new MiniDFSCluster.Builder((Configuration)conf).build();
            cluster.waitActive();
            FSNamesystem namesystem = cluster.getNamesystem();
            DatanodeManager dm = cluster.getNamesystem().getBlockManager().getDatanodeManager();
            ArrayList live = new ArrayList();
            ArrayList dead = new ArrayList();
            dm.fetchDatanodes(live, dead, false);
            Assert.assertTrue((live.size() == 1 ? 1 : 0) != 0);
            for (DatanodeDescriptor datanode : live) {
                used = datanode.getDfsUsed();
                remaining = datanode.getRemaining();
                nonDFSUsed = datanode.getNonDfsUsed();
                configCapacity = datanode.getCapacity();
                percentUsed = datanode.getDfsUsedPercent();
                percentRemaining = datanode.getRemainingPercent();
                bpUsed = datanode.getBlockPoolUsed();
                percentBpUsed = datanode.getBlockPoolUsedPercent();
                LOG.info((Object)("Datanode configCapacity " + configCapacity + " used " + used + " non DFS used " + nonDFSUsed + " remaining " + remaining + " perentUsed " + percentUsed + " percentRemaining " + percentRemaining));
                Assert.assertTrue((configCapacity == used + remaining + nonDFSUsed ? 1 : 0) != 0);
                Assert.assertTrue((percentUsed == DFSUtil.getPercentUsed((long)used, (long)configCapacity) ? 1 : 0) != 0);
                Assert.assertTrue((percentRemaining == DFSUtil.getPercentRemaining((long)remaining, (long)configCapacity) ? 1 : 0) != 0);
                Assert.assertTrue((percentBpUsed == DFSUtil.getPercentUsed((long)bpUsed, (long)configCapacity) ? 1 : 0) != 0);
            }
            DF df = new DF(new File(cluster.getDataDirectory()), (Configuration)conf);
            int numOfDataDirs = 2;
            long diskCapacity = (long)numOfDataDirs * df.getCapacity();
            reserved *= (long)numOfDataDirs;
            configCapacity = namesystem.getCapacityTotal();
            used = namesystem.getCapacityUsed();
            nonDFSUsed = namesystem.getNonDfsUsedSpace();
            remaining = namesystem.getCapacityRemaining();
            percentUsed = namesystem.getPercentUsed();
            percentRemaining = namesystem.getPercentRemaining();
            bpUsed = namesystem.getBlockPoolUsedSpace();
            percentBpUsed = namesystem.getPercentBlockPoolUsed();
            LOG.info((Object)("Data node directory " + cluster.getDataDirectory()));
            LOG.info((Object)("Name node diskCapacity " + diskCapacity + " configCapacity " + configCapacity + " reserved " + reserved + " used " + used + " remaining " + remaining + " nonDFSUsed " + nonDFSUsed + " remaining " + remaining + " percentUsed " + percentUsed + " percentRemaining " + percentRemaining + " bpUsed " + bpUsed + " percentBpUsed " + percentBpUsed));
            Assert.assertTrue((configCapacity == diskCapacity - reserved ? 1 : 0) != 0);
            Assert.assertTrue((configCapacity == used + remaining + nonDFSUsed ? 1 : 0) != 0);
            Assert.assertTrue((percentUsed == DFSUtil.getPercentUsed((long)used, (long)configCapacity) ? 1 : 0) != 0);
            Assert.assertTrue((percentBpUsed == DFSUtil.getPercentUsed((long)bpUsed, (long)configCapacity) ? 1 : 0) != 0);
            Assert.assertTrue((percentRemaining == (float)remaining * 100.0f / (float)configCapacity ? 1 : 0) != 0);
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }
}

