/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.tools.offlineImageViewer;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.hadoop.hdfs.tools.offlineImageViewer.ImageVisitor;

class SpotCheckImageVisitor
extends ImageVisitor {
    private final ImageInfo inodes = new ImageInfo();
    private final ImageInfo INUCs = new ImageInfo();
    private ImageInfo current = null;

    SpotCheckImageVisitor() {
    }

    void visit(ImageVisitor.ImageElement element, String value) throws IOException {
        if (element == ImageVisitor.ImageElement.NUM_BYTES) {
            this.current.totalFileSize += Long.valueOf(value).longValue();
        } else if (element == ImageVisitor.ImageElement.REPLICATION) {
            this.current.totalReplications += Long.valueOf(value).longValue();
        } else if (element == ImageVisitor.ImageElement.INODE_PATH) {
            this.current.pathNames.add(value);
        }
    }

    void visitEnclosingElement(ImageVisitor.ImageElement element, ImageVisitor.ImageElement key, String value) throws IOException {
        switch (element) {
            case INODES: {
                this.current = this.inodes;
                break;
            }
            case INODES_UNDER_CONSTRUCTION: {
                this.current = this.INUCs;
                break;
            }
            case BLOCKS: {
                this.current.totalNumBlocks += Long.valueOf(value).longValue();
            }
        }
    }

    public ImageInfo getINodesInfo() {
        return this.inodes;
    }

    public ImageInfo getINUCsInfo() {
        return this.INUCs;
    }

    void finish() throws IOException {
    }

    void finishAbnormally() throws IOException {
    }

    void leaveEnclosingElement() throws IOException {
    }

    void start() throws IOException {
    }

    void visitEnclosingElement(ImageVisitor.ImageElement element) throws IOException {
    }

    public static class ImageInfo {
        public long totalNumBlocks = 0L;
        public Set<String> pathNames = new HashSet<String>();
        public long totalFileSize = 0L;
        public long totalReplications = 0L;
    }
}

