/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.web;

import java.io.IOException;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.DelegationTokenRenewer;
import org.apache.hadoop.hdfs.web.WebHdfsFileSystem;
import org.apache.hadoop.hdfs.web.resources.DeleteOpParam;
import org.apache.hadoop.hdfs.web.resources.GetOpParam;
import org.apache.hadoop.hdfs.web.resources.HttpOpParam;
import org.apache.hadoop.hdfs.web.resources.Param;
import org.apache.hadoop.hdfs.web.resources.PostOpParam;
import org.apache.hadoop.hdfs.web.resources.PutOpParam;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestWebHdfsTokens {
    static Configuration conf;
    static UserGroupInformation ugi;

    @BeforeClass
    public static void setup() throws IOException {
        conf = new Configuration();
        SecurityUtil.setAuthenticationMethod((UserGroupInformation.AuthenticationMethod)UserGroupInformation.AuthenticationMethod.KERBEROS, (Configuration)conf);
        UserGroupInformation.setConfiguration((Configuration)conf);
        ugi = UserGroupInformation.getCurrentUser();
    }

    @Test(timeout=1000L)
    public void testInitWithNoToken() throws IOException {
        WebHdfsFileSystem fs = (WebHdfsFileSystem)Mockito.spy((Object)new WebHdfsFileSystem());
        ((WebHdfsFileSystem)Mockito.doReturn(null).when((Object)fs)).getDelegationToken(Mockito.anyString());
        ((WebHdfsFileSystem)Mockito.doNothing().when((Object)fs)).addRenewAction((WebHdfsFileSystem)Mockito.any(WebHdfsFileSystem.class));
        fs.initialize(URI.create("webhdfs://127.0.0.1:0"), conf);
        ((WebHdfsFileSystem)Mockito.verify((Object)fs)).initDelegationToken();
        ((WebHdfsFileSystem)Mockito.verify((Object)fs)).selectDelegationToken(ugi);
        ((WebHdfsFileSystem)Mockito.verify((Object)fs, (VerificationMode)Mockito.never())).setDelegationToken((Token)Mockito.any(Token.class));
        ((WebHdfsFileSystem)Mockito.verify((Object)fs, (VerificationMode)Mockito.never())).getDelegationToken();
        ((WebHdfsFileSystem)Mockito.verify((Object)fs, (VerificationMode)Mockito.never())).getDelegationToken(Mockito.anyString());
    }

    @Test(timeout=1000L)
    public void testInitWithUGIToken() throws IOException {
        WebHdfsFileSystem fs = (WebHdfsFileSystem)Mockito.spy((Object)new WebHdfsFileSystem());
        Token token = (Token)Mockito.mock(Token.class);
        ((WebHdfsFileSystem)Mockito.doReturn((Object)token).when((Object)fs)).selectDelegationToken(ugi);
        ((WebHdfsFileSystem)Mockito.doReturn(null).when((Object)fs)).getDelegationToken(Mockito.anyString());
        ((WebHdfsFileSystem)Mockito.doNothing().when((Object)fs)).addRenewAction((WebHdfsFileSystem)Mockito.any(WebHdfsFileSystem.class));
        fs.initialize(URI.create("webhdfs://127.0.0.1:0"), conf);
        ((WebHdfsFileSystem)Mockito.verify((Object)fs)).initDelegationToken();
        ((WebHdfsFileSystem)Mockito.verify((Object)fs)).selectDelegationToken(ugi);
        ((WebHdfsFileSystem)Mockito.verify((Object)fs)).setDelegationToken(token);
        ((WebHdfsFileSystem)Mockito.verify((Object)fs, (VerificationMode)Mockito.never())).getDelegationToken();
        ((WebHdfsFileSystem)Mockito.verify((Object)fs, (VerificationMode)Mockito.never())).getDelegationToken(Mockito.anyString());
        ((WebHdfsFileSystem)Mockito.verify((Object)fs, (VerificationMode)Mockito.never())).addRenewAction(fs);
    }

    @Test(timeout=1000L)
    public void testInternalGetDelegationToken() throws IOException {
        WebHdfsFileSystem fs = (WebHdfsFileSystem)Mockito.spy((Object)new WebHdfsFileSystem());
        Token token = (Token)Mockito.mock(Token.class);
        ((WebHdfsFileSystem)Mockito.doReturn(null).when((Object)fs)).selectDelegationToken(ugi);
        ((WebHdfsFileSystem)Mockito.doReturn((Object)token).when((Object)fs)).getDelegationToken(Mockito.anyString());
        ((WebHdfsFileSystem)Mockito.doNothing().when((Object)fs)).addRenewAction((WebHdfsFileSystem)Mockito.any(WebHdfsFileSystem.class));
        fs.initialize(URI.create("webhdfs://127.0.0.1:0"), conf);
        Token token2 = fs.getDelegationToken();
        Assert.assertEquals((Object)token2, (Object)token);
        ((WebHdfsFileSystem)Mockito.verify((Object)fs)).getDelegationToken(null);
        ((WebHdfsFileSystem)Mockito.verify((Object)fs)).setDelegationToken(token);
        ((WebHdfsFileSystem)Mockito.verify((Object)fs)).addRenewAction(fs);
        Mockito.reset((Object[])new WebHdfsFileSystem[]{fs});
        token2 = fs.getDelegationToken();
        Assert.assertEquals((Object)token2, (Object)token);
        ((WebHdfsFileSystem)Mockito.verify((Object)fs, (VerificationMode)Mockito.never())).getDelegationToken(null);
        ((WebHdfsFileSystem)Mockito.verify((Object)fs, (VerificationMode)Mockito.never())).setDelegationToken((Token)Mockito.any(Token.class));
        ((WebHdfsFileSystem)Mockito.verify((Object)fs, (VerificationMode)Mockito.never())).addRenewAction(fs);
    }

    @Test(timeout=1000L)
    public void testTokenForNonTokenOp() throws IOException {
        WebHdfsFileSystem fs = (WebHdfsFileSystem)Mockito.spy((Object)new WebHdfsFileSystem());
        Token token = (Token)Mockito.mock(Token.class);
        ((WebHdfsFileSystem)Mockito.doReturn(null).when((Object)fs)).selectDelegationToken(ugi);
        ((WebHdfsFileSystem)Mockito.doReturn((Object)token).when((Object)fs)).getDelegationToken(null);
        ((WebHdfsFileSystem)Mockito.doNothing().when((Object)fs)).addRenewAction((WebHdfsFileSystem)Mockito.any(WebHdfsFileSystem.class));
        fs.initialize(URI.create("webhdfs://127.0.0.1:0"), conf);
        fs.toUrl((HttpOpParam.Op)GetOpParam.Op.OPEN, null, new Param[0]);
        ((WebHdfsFileSystem)Mockito.verify((Object)fs)).getDelegationToken();
        ((WebHdfsFileSystem)Mockito.verify((Object)fs)).getDelegationToken(null);
        ((WebHdfsFileSystem)Mockito.verify((Object)fs)).setDelegationToken(token);
        ((WebHdfsFileSystem)Mockito.verify((Object)fs)).addRenewAction(fs);
        Mockito.reset((Object[])new WebHdfsFileSystem[]{fs});
        fs.toUrl((HttpOpParam.Op)GetOpParam.Op.OPEN, null, new Param[0]);
        ((WebHdfsFileSystem)Mockito.verify((Object)fs)).getDelegationToken();
        ((WebHdfsFileSystem)Mockito.verify((Object)fs, (VerificationMode)Mockito.never())).getDelegationToken(null);
        ((WebHdfsFileSystem)Mockito.verify((Object)fs, (VerificationMode)Mockito.never())).setDelegationToken(token);
        ((WebHdfsFileSystem)Mockito.verify((Object)fs, (VerificationMode)Mockito.never())).addRenewAction(fs);
    }

    @Test(timeout=1000L)
    public void testNoTokenForGetToken() throws IOException {
        this.checkNoTokenForOperation((HttpOpParam.Op)GetOpParam.Op.GETDELEGATIONTOKEN);
    }

    @Test(timeout=1000L)
    public void testNoTokenForCanclToken() throws IOException {
        this.checkNoTokenForOperation((HttpOpParam.Op)PutOpParam.Op.RENEWDELEGATIONTOKEN);
    }

    @Test(timeout=1000L)
    public void testNoTokenForCancelToken() throws IOException {
        this.checkNoTokenForOperation((HttpOpParam.Op)PutOpParam.Op.CANCELDELEGATIONTOKEN);
    }

    private void checkNoTokenForOperation(HttpOpParam.Op op) throws IOException {
        WebHdfsFileSystem fs = (WebHdfsFileSystem)Mockito.spy((Object)new WebHdfsFileSystem());
        ((WebHdfsFileSystem)Mockito.doReturn(null).when((Object)fs)).selectDelegationToken(ugi);
        ((WebHdfsFileSystem)Mockito.doReturn(null).when((Object)fs)).getDelegationToken(null);
        ((WebHdfsFileSystem)Mockito.doNothing().when((Object)fs)).addRenewAction((WebHdfsFileSystem)Mockito.any(WebHdfsFileSystem.class));
        fs.initialize(URI.create("webhdfs://127.0.0.1:0"), conf);
        fs.toUrl(op, null, new Param[0]);
        ((WebHdfsFileSystem)Mockito.verify((Object)fs, (VerificationMode)Mockito.never())).getDelegationToken();
        ((WebHdfsFileSystem)Mockito.verify((Object)fs, (VerificationMode)Mockito.never())).getDelegationToken(null);
        ((WebHdfsFileSystem)Mockito.verify((Object)fs, (VerificationMode)Mockito.never())).setDelegationToken((Token)Mockito.any(Token.class));
        ((WebHdfsFileSystem)Mockito.verify((Object)fs, (VerificationMode)Mockito.never())).addRenewAction(fs);
    }

    @Test(timeout=1000L)
    public void testGetOpRequireAuth() {
        for (GetOpParam.Op op : GetOpParam.Op.values()) {
            boolean expect = op == GetOpParam.Op.GETDELEGATIONTOKEN;
            Assert.assertEquals((Object)expect, (Object)op.getRequireAuth());
        }
    }

    @Test(timeout=1000L)
    public void testPutOpRequireAuth() {
        for (PutOpParam.Op op : PutOpParam.Op.values()) {
            boolean expect = op == PutOpParam.Op.RENEWDELEGATIONTOKEN || op == PutOpParam.Op.CANCELDELEGATIONTOKEN;
            Assert.assertEquals((Object)expect, (Object)op.getRequireAuth());
        }
    }

    @Test(timeout=1000L)
    public void testPostOpRequireAuth() {
        for (PostOpParam.Op op : PostOpParam.Op.values()) {
            Assert.assertFalse((boolean)op.getRequireAuth());
        }
    }

    @Test(timeout=1000L)
    public void testDeleteOpRequireAuth() {
        for (DeleteOpParam.Op op : DeleteOpParam.Op.values()) {
            Assert.assertFalse((boolean)op.getRequireAuth());
        }
    }

    @Test
    public void testGetTokenAfterFailure() throws Exception {
        long renewCycle;
        Configuration conf = (Configuration)Mockito.mock(Configuration.class);
        Token token1 = (Token)Mockito.mock(Token.class);
        Token token2 = (Token)Mockito.mock(Token.class);
        DelegationTokenRenewer.renewCycle = renewCycle = 1000L;
        WebHdfsFileSystem fs = (WebHdfsFileSystem)Mockito.spy((Object)new WebHdfsFileSystem());
        ((WebHdfsFileSystem)Mockito.doReturn((Object)conf).when((Object)fs)).getConf();
        ((WebHdfsFileSystem)Mockito.doReturn((Object)token1).doReturn((Object)token2).when((Object)fs)).getDelegationToken(null);
        ((Token)Mockito.doThrow((Throwable)new IOException("renew failed")).when((Object)token1)).renew(conf);
        ((WebHdfsFileSystem)Mockito.doThrow((Throwable)new IOException("get failed")).when((Object)fs)).addDelegationTokens(null, null);
        Token token = fs.getDelegationToken();
        DelegationTokenRenewer.RenewAction action = fs.action;
        Assert.assertSame((Object)token1, (Object)token);
        Assert.assertTrue((boolean)action.isValid());
        token = fs.getDelegationToken();
        Assert.assertSame((Object)token1, (Object)token);
        Assert.assertSame((Object)action, (Object)fs.action);
        Assert.assertTrue((boolean)fs.action.isValid());
        Thread.sleep(renewCycle);
        Assert.assertSame((Object)action, (Object)fs.action);
        Assert.assertFalse((boolean)fs.action.isValid());
        token = fs.getDelegationToken();
        Assert.assertSame((Object)token2, (Object)token);
        Assert.assertNotSame((Object)action, (Object)fs.action);
        Assert.assertTrue((boolean)fs.action.isValid());
        action = fs.action;
        token = fs.getDelegationToken();
        Assert.assertSame((Object)token2, (Object)token);
        Assert.assertSame((Object)action, (Object)fs.action);
        Assert.assertTrue((boolean)fs.action.isValid());
    }
}

