/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.web;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.BufferedOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.ws.rs.core.MediaType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.DelegationTokenRenewer;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.MD5MD5CRC32FileChecksum;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.XAttrCodec;
import org.apache.hadoop.fs.XAttrSetFlag;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.AclStatus;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.HAUtil;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.hdfs.server.namenode.SafeModeException;
import org.apache.hadoop.hdfs.web.ByteRangeInputStream;
import org.apache.hadoop.hdfs.web.JsonUtil;
import org.apache.hadoop.hdfs.web.TokenAspect;
import org.apache.hadoop.hdfs.web.URLConnectionFactory;
import org.apache.hadoop.hdfs.web.resources.AccessTimeParam;
import org.apache.hadoop.hdfs.web.resources.AclPermissionParam;
import org.apache.hadoop.hdfs.web.resources.BlockSizeParam;
import org.apache.hadoop.hdfs.web.resources.BufferSizeParam;
import org.apache.hadoop.hdfs.web.resources.ConcatSourcesParam;
import org.apache.hadoop.hdfs.web.resources.CreateParentParam;
import org.apache.hadoop.hdfs.web.resources.DelegationParam;
import org.apache.hadoop.hdfs.web.resources.DeleteOpParam;
import org.apache.hadoop.hdfs.web.resources.DestinationParam;
import org.apache.hadoop.hdfs.web.resources.DoAsParam;
import org.apache.hadoop.hdfs.web.resources.GetOpParam;
import org.apache.hadoop.hdfs.web.resources.GroupParam;
import org.apache.hadoop.hdfs.web.resources.HttpOpParam;
import org.apache.hadoop.hdfs.web.resources.LengthParam;
import org.apache.hadoop.hdfs.web.resources.ModificationTimeParam;
import org.apache.hadoop.hdfs.web.resources.OffsetParam;
import org.apache.hadoop.hdfs.web.resources.OldSnapshotNameParam;
import org.apache.hadoop.hdfs.web.resources.OverwriteParam;
import org.apache.hadoop.hdfs.web.resources.OwnerParam;
import org.apache.hadoop.hdfs.web.resources.Param;
import org.apache.hadoop.hdfs.web.resources.PermissionParam;
import org.apache.hadoop.hdfs.web.resources.PostOpParam;
import org.apache.hadoop.hdfs.web.resources.PutOpParam;
import org.apache.hadoop.hdfs.web.resources.RecursiveParam;
import org.apache.hadoop.hdfs.web.resources.RenameOptionSetParam;
import org.apache.hadoop.hdfs.web.resources.RenewerParam;
import org.apache.hadoop.hdfs.web.resources.ReplicationParam;
import org.apache.hadoop.hdfs.web.resources.SnapshotNameParam;
import org.apache.hadoop.hdfs.web.resources.TokenArgumentParam;
import org.apache.hadoop.hdfs.web.resources.UserParam;
import org.apache.hadoop.hdfs.web.resources.XAttrEncodingParam;
import org.apache.hadoop.hdfs.web.resources.XAttrNameParam;
import org.apache.hadoop.hdfs.web.resources.XAttrSetFlagParam;
import org.apache.hadoop.hdfs.web.resources.XAttrValueParam;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.retry.RetryPolicies;
import org.apache.hadoop.io.retry.RetryPolicy;
import org.apache.hadoop.io.retry.RetryUtils;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.security.token.TokenSelector;
import org.apache.hadoop.security.token.delegation.AbstractDelegationTokenSelector;
import org.apache.hadoop.util.Progressable;
import org.mortbay.util.ajax.JSON;

public class WebHdfsFileSystem
extends FileSystem
implements DelegationTokenRenewer.Renewable,
TokenAspect.TokenManagementDelegator {
    public static final Log LOG = LogFactory.getLog(WebHdfsFileSystem.class);
    public static final String SCHEME = "webhdfs";
    public static final int VERSION = 1;
    public static final String PATH_PREFIX = "/webhdfs/v1";
    protected URLConnectionFactory connectionFactory;
    public static final Text TOKEN_KIND = new Text("WEBHDFS delegation");
    private boolean canRefreshDelegationToken;
    private UserGroupInformation ugi;
    private URI uri;
    private Token<?> delegationToken;
    protected Text tokenServiceName;
    private RetryPolicy retryPolicy = null;
    private Path workingDir;
    private InetSocketAddress[] nnAddrs;
    private int currentNNAddrIndex;
    TokenSelector<DelegationTokenIdentifier> tokenSelector = new AbstractDelegationTokenSelector<DelegationTokenIdentifier>(this.getTokenKind()){};
    private static final String OFFSET_PARAM_PREFIX = "offset=";

    public String getScheme() {
        return SCHEME;
    }

    protected String getTransportScheme() {
        return "http";
    }

    protected Text getTokenKind() {
        return TOKEN_KIND;
    }

    public synchronized void initialize(URI uri, Configuration conf) throws IOException {
        super.initialize(uri, conf);
        this.setConf(conf);
        UserParam.setUserPattern(conf.get("dfs.webhdfs.user.provider.user.pattern", "^[A-Za-z_][A-Za-z0-9._-]*[$]?$"));
        this.connectionFactory = URLConnectionFactory.newDefaultURLConnectionFactory(conf);
        this.ugi = UserGroupInformation.getCurrentUser();
        this.uri = URI.create(uri.getScheme() + "://" + uri.getAuthority());
        this.nnAddrs = this.resolveNNAddr();
        boolean isHA = HAUtil.isClientFailoverConfigured(conf, this.uri);
        boolean isLogicalUri = isHA && HAUtil.isLogicalUri(conf, this.uri);
        Text text = this.tokenServiceName = isLogicalUri ? HAUtil.buildTokenServiceForLogicalUri(uri) : SecurityUtil.buildTokenService((URI)this.getCanonicalUri());
        if (!isHA) {
            this.retryPolicy = RetryUtils.getDefaultRetryPolicy((Configuration)conf, (String)"dfs.http.client.retry.policy.enabled", (boolean)false, (String)"dfs.http.client.retry.policy.spec", (String)"10000,6,60000,10", SafeModeException.class);
        } else {
            int maxFailoverAttempts = conf.getInt("dfs.http.client.failover.max.attempts", 15);
            int maxRetryAttempts = conf.getInt("dfs.http.client.retry.max.attempts", 10);
            int failoverSleepBaseMillis = conf.getInt("dfs.http.client.failover.sleep.base.millis", 500);
            int failoverSleepMaxMillis = conf.getInt("dfs.http.client.failover.sleep.max.millis", 15000);
            this.retryPolicy = RetryPolicies.failoverOnNetworkException((RetryPolicy)RetryPolicies.TRY_ONCE_THEN_FAIL, (int)maxFailoverAttempts, (int)maxRetryAttempts, (long)failoverSleepBaseMillis, (long)failoverSleepMaxMillis);
        }
        this.workingDir = this.getHomeDirectory();
        this.canRefreshDelegationToken = UserGroupInformation.isSecurityEnabled();
        this.delegationToken = null;
    }

    public URI getCanonicalUri() {
        return super.getCanonicalUri();
    }

    public static boolean isEnabled(Configuration conf, Log log) {
        boolean b = conf.getBoolean("dfs.webhdfs.enabled", true);
        return b;
    }

    protected synchronized Token<?> getDelegationToken() throws IOException {
        try {
            if (this.canRefreshDelegationToken && this.delegationToken == null) {
                Token<DelegationTokenIdentifier> token = this.tokenSelector.selectToken(new Text(this.getCanonicalServiceName()), this.ugi.getTokens());
                if (token != null) {
                    LOG.debug((Object)("Using UGI token: " + token));
                    this.canRefreshDelegationToken = false;
                } else {
                    token = this.getDelegationToken(null);
                    if (token != null) {
                        LOG.debug((Object)("Fetched new token: " + token));
                    } else {
                        this.canRefreshDelegationToken = false;
                    }
                }
                this.setDelegationToken(token);
            }
            return this.delegationToken;
        }
        catch (IOException e) {
            LOG.warn((Object)e.getMessage());
            LOG.debug((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @VisibleForTesting
    synchronized boolean replaceExpiredDelegationToken() throws IOException {
        boolean replaced = false;
        if (this.canRefreshDelegationToken) {
            Token<DelegationTokenIdentifier> token = this.getDelegationToken(null);
            LOG.debug((Object)("Replaced expired token: " + token));
            this.setDelegationToken(token);
            replaced = token != null;
        }
        return replaced;
    }

    @VisibleForTesting
    public int getDefaultPort() {
        return this.getConf().getInt("dfs.http.port", 50070);
    }

    public URI getUri() {
        return this.uri;
    }

    protected URI canonicalizeUri(URI uri) {
        return NetUtils.getCanonicalUri((URI)uri, (int)this.getDefaultPort());
    }

    public static String getHomeDirectoryString(UserGroupInformation ugi) {
        return "/user/" + ugi.getShortUserName();
    }

    public Path getHomeDirectory() {
        return this.makeQualified(new Path(WebHdfsFileSystem.getHomeDirectoryString(this.ugi)));
    }

    public synchronized Path getWorkingDirectory() {
        return this.workingDir;
    }

    public synchronized void setWorkingDirectory(Path dir) {
        String result = this.makeAbsolute(dir).toUri().getPath();
        if (!DFSUtil.isValidName(result)) {
            throw new IllegalArgumentException("Invalid DFS directory name " + result);
        }
        this.workingDir = this.makeAbsolute(dir);
    }

    private Path makeAbsolute(Path f) {
        return f.isAbsolute() ? f : new Path(this.workingDir, f);
    }

    static Map<?, ?> jsonParse(HttpURLConnection c, boolean useErrorStream) throws IOException {
        MediaType parsed;
        InputStream in;
        if (c.getContentLength() == 0) {
            return null;
        }
        InputStream inputStream = in = useErrorStream ? c.getErrorStream() : c.getInputStream();
        if (in == null) {
            throw new IOException("The " + (useErrorStream ? "error" : "input") + " stream is null.");
        }
        String contentType = c.getContentType();
        if (contentType != null && !MediaType.APPLICATION_JSON_TYPE.isCompatible(parsed = MediaType.valueOf((String)contentType))) {
            throw new IOException("Content-Type \"" + contentType + "\" is incompatible with \"" + "application/json" + "\" (parsed=\"" + parsed + "\")");
        }
        return (Map)JSON.parse((Reader)new InputStreamReader(in, Charsets.UTF_8));
    }

    private static Map<?, ?> validateResponse(HttpOpParam.Op op, HttpURLConnection conn, boolean unwrapException) throws IOException {
        int code = conn.getResponseCode();
        if (code == 401) {
            throw new AccessControlException(conn.getResponseMessage());
        }
        if (code != op.getExpectedHttpResponseCode()) {
            Map<?, ?> m;
            try {
                m = WebHdfsFileSystem.jsonParse(conn, true);
            }
            catch (Exception e) {
                throw new IOException("Unexpected HTTP response: code=" + code + " != " + op.getExpectedHttpResponseCode() + ", " + op.toQueryString() + ", message=" + conn.getResponseMessage(), e);
            }
            if (m == null) {
                throw new IOException("Unexpected HTTP response: code=" + code + " != " + op.getExpectedHttpResponseCode() + ", " + op.toQueryString() + ", message=" + conn.getResponseMessage());
            }
            if (m.get(RemoteException.class.getSimpleName()) == null) {
                return m;
            }
            Throwable re = JsonUtil.toRemoteException(m);
            if (re.getMessage().startsWith("Failed to obtain user group information:")) {
                String[] parts = re.getMessage().split(":\\s+", 3);
                re = new RemoteException(parts[1], parts[2]);
                re = re.unwrapRemoteException(new Class[]{SecretManager.InvalidToken.class});
            }
            throw unwrapException ? WebHdfsFileSystem.toIOException((Exception)re) : re;
        }
        return null;
    }

    private static IOException toIOException(Exception e) {
        if (!(e instanceof IOException)) {
            return new IOException(e);
        }
        IOException ioe = (IOException)e;
        if (!(ioe instanceof RemoteException)) {
            return ioe;
        }
        return ((RemoteException)((Object)ioe)).unwrapRemoteException();
    }

    private synchronized InetSocketAddress getCurrentNNAddr() {
        return this.nnAddrs[this.currentNNAddrIndex];
    }

    private synchronized void resetStateToFailOver() {
        this.currentNNAddrIndex = (this.currentNNAddrIndex + 1) % this.nnAddrs.length;
    }

    private URL getNamenodeURL(String path, String query) throws IOException {
        InetSocketAddress nnAddr = this.getCurrentNNAddr();
        URL url = new URL(this.getTransportScheme(), nnAddr.getHostName(), nnAddr.getPort(), path + '?' + query);
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("url=" + url));
        }
        return url;
    }

    Param<?, ?>[] getAuthParameters(HttpOpParam.Op op) throws IOException {
        ArrayList authParams = Lists.newArrayList();
        Token<?> token = null;
        if (!op.getRequireAuth()) {
            token = this.getDelegationToken();
        }
        if (token != null) {
            authParams.add(new DelegationParam(token.encodeToUrlString()));
        } else {
            UserGroupInformation userUgi = this.ugi;
            UserGroupInformation realUgi = userUgi.getRealUser();
            if (realUgi != null) {
                authParams.add(new DoAsParam(userUgi.getShortUserName()));
                userUgi = realUgi;
            }
            authParams.add(new UserParam(userUgi.getShortUserName()));
        }
        return authParams.toArray(new Param[0]);
    }

    URL toUrl(HttpOpParam.Op op, Path fspath, Param<?, ?> ... parameters) throws IOException {
        String path = PATH_PREFIX + (fspath == null ? "/" : this.makeQualified(fspath).toUri().getRawPath());
        String query = op.toQueryString() + Param.toSortedString("&", this.getAuthParameters(op)) + Param.toSortedString("&", parameters);
        URL url = this.getNamenodeURL(path, query);
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("url=" + url));
        }
        return url;
    }

    private FsPermission applyUMask(FsPermission permission) {
        if (permission == null) {
            permission = FsPermission.getDefault();
        }
        return permission.applyUMask(FsPermission.getUMask((Configuration)this.getConf()));
    }

    private HdfsFileStatus getHdfsFileStatus(Path f) throws IOException {
        GetOpParam.Op op = GetOpParam.Op.GETFILESTATUS;
        HdfsFileStatus status = (HdfsFileStatus)new FsPathResponseRunner<HdfsFileStatus>((HttpOpParam.Op)op, f, new Param[0]){

            @Override
            HdfsFileStatus decodeResponse(Map<?, ?> json) {
                return JsonUtil.toFileStatus(json, true);
            }
        }.run();
        if (status == null) {
            throw new FileNotFoundException("File does not exist: " + f);
        }
        return status;
    }

    public FileStatus getFileStatus(Path f) throws IOException {
        this.statistics.incrementReadOps(1);
        return this.makeQualified(this.getHdfsFileStatus(f), f);
    }

    private FileStatus makeQualified(HdfsFileStatus f, Path parent) {
        return new FileStatus(f.getLen(), f.isDir(), (int)f.getReplication(), f.getBlockSize(), f.getModificationTime(), f.getAccessTime(), f.getPermission(), f.getOwner(), f.getGroup(), f.isSymlink() ? new Path(f.getSymlink()) : null, f.getFullPath(parent).makeQualified(this.getUri(), this.getWorkingDirectory()));
    }

    public AclStatus getAclStatus(Path f) throws IOException {
        GetOpParam.Op op = GetOpParam.Op.GETACLSTATUS;
        AclStatus status = (AclStatus)new FsPathResponseRunner<AclStatus>((HttpOpParam.Op)op, f, new Param[0]){

            @Override
            AclStatus decodeResponse(Map<?, ?> json) {
                return JsonUtil.toAclStatus(json);
            }
        }.run();
        if (status == null) {
            throw new FileNotFoundException("File does not exist: " + f);
        }
        return status;
    }

    public boolean mkdirs(Path f, FsPermission permission) throws IOException {
        this.statistics.incrementWriteOps(1);
        PutOpParam.Op op = PutOpParam.Op.MKDIRS;
        return (Boolean)new FsPathBooleanRunner((HttpOpParam.Op)op, f, new PermissionParam(this.applyUMask(permission))).run();
    }

    public void createSymlink(Path destination, Path f, boolean createParent) throws IOException {
        this.statistics.incrementWriteOps(1);
        PutOpParam.Op op = PutOpParam.Op.CREATESYMLINK;
        new FsPathRunner((HttpOpParam.Op)op, f, new DestinationParam(this.makeQualified(destination).toUri().getPath()), new CreateParentParam(createParent)).run();
    }

    public boolean rename(Path src, Path dst) throws IOException {
        this.statistics.incrementWriteOps(1);
        PutOpParam.Op op = PutOpParam.Op.RENAME;
        return (Boolean)new FsPathBooleanRunner((HttpOpParam.Op)op, src, new DestinationParam(this.makeQualified(dst).toUri().getPath())).run();
    }

    public void rename(Path src, Path dst, Options.Rename ... options) throws IOException {
        this.statistics.incrementWriteOps(1);
        PutOpParam.Op op = PutOpParam.Op.RENAME;
        new FsPathRunner((HttpOpParam.Op)op, src, new DestinationParam(this.makeQualified(dst).toUri().getPath()), new RenameOptionSetParam(options)).run();
    }

    public void setXAttr(Path p, String name, byte[] value, EnumSet<XAttrSetFlag> flag) throws IOException {
        this.statistics.incrementWriteOps(1);
        PutOpParam.Op op = PutOpParam.Op.SETXATTR;
        if (value != null) {
            new FsPathRunner((HttpOpParam.Op)op, p, new XAttrNameParam(name), new XAttrValueParam(XAttrCodec.encodeValue((byte[])value, (XAttrCodec)XAttrCodec.HEX)), new XAttrSetFlagParam(flag)).run();
        } else {
            new FsPathRunner((HttpOpParam.Op)op, p, new XAttrNameParam(name), new XAttrSetFlagParam(flag)).run();
        }
    }

    public byte[] getXAttr(Path p, final String name) throws IOException {
        GetOpParam.Op op = GetOpParam.Op.GETXATTRS;
        return (byte[])new FsPathResponseRunner<byte[]>((HttpOpParam.Op)op, p, new Param[]{new XAttrNameParam(name), new XAttrEncodingParam(XAttrCodec.HEX)}){

            @Override
            byte[] decodeResponse(Map<?, ?> json) throws IOException {
                return JsonUtil.getXAttr(json, name);
            }
        }.run();
    }

    public Map<String, byte[]> getXAttrs(Path p) throws IOException {
        GetOpParam.Op op = GetOpParam.Op.GETXATTRS;
        return (Map)new FsPathResponseRunner<Map<String, byte[]>>((HttpOpParam.Op)op, p, new Param[]{new XAttrEncodingParam(XAttrCodec.HEX)}){

            @Override
            Map<String, byte[]> decodeResponse(Map<?, ?> json) throws IOException {
                return JsonUtil.toXAttrs(json);
            }
        }.run();
    }

    public Map<String, byte[]> getXAttrs(Path p, List<String> names) throws IOException {
        Preconditions.checkArgument((names != null && !names.isEmpty() ? 1 : 0) != 0, (Object)"XAttr names cannot be null or empty.");
        Param[] parameters = new Param[names.size() + 1];
        for (int i = 0; i < parameters.length - 1; ++i) {
            parameters[i] = new XAttrNameParam(names.get(i));
        }
        parameters[parameters.length - 1] = new XAttrEncodingParam(XAttrCodec.HEX);
        GetOpParam.Op op = GetOpParam.Op.GETXATTRS;
        return (Map)new FsPathResponseRunner<Map<String, byte[]>>((HttpOpParam.Op)op, parameters, p){

            @Override
            Map<String, byte[]> decodeResponse(Map<?, ?> json) throws IOException {
                return JsonUtil.toXAttrs(json);
            }
        }.run();
    }

    public List<String> listXAttrs(Path p) throws IOException {
        GetOpParam.Op op = GetOpParam.Op.LISTXATTRS;
        return (List)new FsPathResponseRunner<List<String>>((HttpOpParam.Op)op, p, new Param[0]){

            @Override
            List<String> decodeResponse(Map<?, ?> json) throws IOException {
                return JsonUtil.toXAttrNames(json);
            }
        }.run();
    }

    public void removeXAttr(Path p, String name) throws IOException {
        this.statistics.incrementWriteOps(1);
        PutOpParam.Op op = PutOpParam.Op.REMOVEXATTR;
        new FsPathRunner((HttpOpParam.Op)op, p, new XAttrNameParam(name)).run();
    }

    public void setOwner(Path p, String owner, String group) throws IOException {
        if (owner == null && group == null) {
            throw new IOException("owner == null && group == null");
        }
        this.statistics.incrementWriteOps(1);
        PutOpParam.Op op = PutOpParam.Op.SETOWNER;
        new FsPathRunner((HttpOpParam.Op)op, p, new OwnerParam(owner), new GroupParam(group)).run();
    }

    public void setPermission(Path p, FsPermission permission) throws IOException {
        this.statistics.incrementWriteOps(1);
        PutOpParam.Op op = PutOpParam.Op.SETPERMISSION;
        new FsPathRunner((HttpOpParam.Op)op, p, new PermissionParam(permission)).run();
    }

    public void modifyAclEntries(Path path, List<AclEntry> aclSpec) throws IOException {
        this.statistics.incrementWriteOps(1);
        PutOpParam.Op op = PutOpParam.Op.MODIFYACLENTRIES;
        new FsPathRunner((HttpOpParam.Op)op, path, new AclPermissionParam(aclSpec)).run();
    }

    public void removeAclEntries(Path path, List<AclEntry> aclSpec) throws IOException {
        this.statistics.incrementWriteOps(1);
        PutOpParam.Op op = PutOpParam.Op.REMOVEACLENTRIES;
        new FsPathRunner((HttpOpParam.Op)op, path, new AclPermissionParam(aclSpec)).run();
    }

    public void removeDefaultAcl(Path path) throws IOException {
        this.statistics.incrementWriteOps(1);
        PutOpParam.Op op = PutOpParam.Op.REMOVEDEFAULTACL;
        new FsPathRunner((HttpOpParam.Op)op, path, new Param[0]).run();
    }

    public void removeAcl(Path path) throws IOException {
        this.statistics.incrementWriteOps(1);
        PutOpParam.Op op = PutOpParam.Op.REMOVEACL;
        new FsPathRunner((HttpOpParam.Op)op, path, new Param[0]).run();
    }

    public void setAcl(Path p, List<AclEntry> aclSpec) throws IOException {
        this.statistics.incrementWriteOps(1);
        PutOpParam.Op op = PutOpParam.Op.SETACL;
        new FsPathRunner((HttpOpParam.Op)op, p, new AclPermissionParam(aclSpec)).run();
    }

    public Path createSnapshot(Path path, String snapshotName) throws IOException {
        this.statistics.incrementWriteOps(1);
        PutOpParam.Op op = PutOpParam.Op.CREATESNAPSHOT;
        Path spath = (Path)new FsPathResponseRunner<Path>((HttpOpParam.Op)op, path, new Param[]{new SnapshotNameParam(snapshotName)}){

            @Override
            Path decodeResponse(Map<?, ?> json) {
                return new Path((String)json.get(Path.class.getSimpleName()));
            }
        }.run();
        return spath;
    }

    public void deleteSnapshot(Path path, String snapshotName) throws IOException {
        this.statistics.incrementWriteOps(1);
        DeleteOpParam.Op op = DeleteOpParam.Op.DELETESNAPSHOT;
        new FsPathRunner((HttpOpParam.Op)op, path, new SnapshotNameParam(snapshotName)).run();
    }

    public void renameSnapshot(Path path, String snapshotOldName, String snapshotNewName) throws IOException {
        this.statistics.incrementWriteOps(1);
        PutOpParam.Op op = PutOpParam.Op.RENAMESNAPSHOT;
        new FsPathRunner((HttpOpParam.Op)op, path, new OldSnapshotNameParam(snapshotOldName), new SnapshotNameParam(snapshotNewName)).run();
    }

    public boolean setReplication(Path p, short replication) throws IOException {
        this.statistics.incrementWriteOps(1);
        PutOpParam.Op op = PutOpParam.Op.SETREPLICATION;
        return (Boolean)new FsPathBooleanRunner((HttpOpParam.Op)op, p, new ReplicationParam(replication)).run();
    }

    public void setTimes(Path p, long mtime, long atime) throws IOException {
        this.statistics.incrementWriteOps(1);
        PutOpParam.Op op = PutOpParam.Op.SETTIMES;
        new FsPathRunner((HttpOpParam.Op)op, p, new ModificationTimeParam(mtime), new AccessTimeParam(atime)).run();
    }

    public long getDefaultBlockSize() {
        return this.getConf().getLongBytes("dfs.blocksize", 0x8000000L);
    }

    public short getDefaultReplication() {
        return (short)this.getConf().getInt("dfs.replication", 3);
    }

    public void concat(Path trg, Path[] srcs) throws IOException {
        this.statistics.incrementWriteOps(1);
        PostOpParam.Op op = PostOpParam.Op.CONCAT;
        new FsPathRunner((HttpOpParam.Op)op, trg, new ConcatSourcesParam(srcs)).run();
    }

    public FSDataOutputStream create(Path f, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        this.statistics.incrementWriteOps(1);
        PutOpParam.Op op = PutOpParam.Op.CREATE;
        return (FSDataOutputStream)new FsPathOutputStreamRunner((HttpOpParam.Op)op, f, bufferSize, new PermissionParam(this.applyUMask(permission)), new OverwriteParam(overwrite), new BufferSizeParam(bufferSize), new ReplicationParam(replication), new BlockSizeParam(blockSize)).run();
    }

    public FSDataOutputStream append(Path f, int bufferSize, Progressable progress) throws IOException {
        this.statistics.incrementWriteOps(1);
        PostOpParam.Op op = PostOpParam.Op.APPEND;
        return (FSDataOutputStream)new FsPathOutputStreamRunner((HttpOpParam.Op)op, f, bufferSize, new BufferSizeParam(bufferSize)).run();
    }

    public boolean delete(Path f, boolean recursive) throws IOException {
        DeleteOpParam.Op op = DeleteOpParam.Op.DELETE;
        return (Boolean)new FsPathBooleanRunner((HttpOpParam.Op)op, f, new RecursiveParam(recursive)).run();
    }

    public FSDataInputStream open(Path f, int buffersize) throws IOException {
        this.statistics.incrementReadOps(1);
        GetOpParam.Op op = GetOpParam.Op.OPEN;
        FsPathConnectionRunner runner = new FsPathConnectionRunner((HttpOpParam.Op)op, f, new BufferSizeParam(buffersize));
        return new FSDataInputStream((InputStream)((Object)new OffsetUrlInputStream(new UnresolvedUrlOpener(runner), new OffsetUrlOpener(null))));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() throws IOException {
        try {
            if (this.canRefreshDelegationToken && this.delegationToken != null) {
                this.cancelDelegationToken(this.delegationToken);
            }
        }
        catch (IOException ioe) {
            LOG.debug((Object)("Token cancel failed: " + ioe));
        }
        finally {
            super.close();
        }
    }

    static URL removeOffsetParam(URL url) throws MalformedURLException {
        String query = url.getQuery();
        if (query == null) {
            return url;
        }
        String lower = query.toLowerCase();
        if (!lower.startsWith(OFFSET_PARAM_PREFIX) && !lower.contains("&offset=")) {
            return url;
        }
        StringBuilder b = null;
        StringTokenizer st = new StringTokenizer(query, "&");
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token.toLowerCase().startsWith(OFFSET_PARAM_PREFIX)) continue;
            if (b == null) {
                b = new StringBuilder("?").append(token);
                continue;
            }
            b.append('&').append(token);
        }
        query = b == null ? "" : b.toString();
        String urlStr = url.toString();
        return new URL(urlStr.substring(0, urlStr.indexOf(63)) + query);
    }

    public FileStatus[] listStatus(final Path f) throws IOException {
        this.statistics.incrementReadOps(1);
        GetOpParam.Op op = GetOpParam.Op.LISTSTATUS;
        return (FileStatus[])new FsPathResponseRunner<FileStatus[]>((HttpOpParam.Op)op, f, new Param[0]){

            @Override
            FileStatus[] decodeResponse(Map<?, ?> json) {
                Map rootmap = (Map)json.get(FileStatus.class.getSimpleName() + "es");
                Object[] array = (Object[])rootmap.get(FileStatus.class.getSimpleName());
                FileStatus[] statuses = new FileStatus[array.length];
                for (int i = 0; i < array.length; ++i) {
                    Map m = (Map)array[i];
                    statuses[i] = WebHdfsFileSystem.this.makeQualified(JsonUtil.toFileStatus(m, false), f);
                }
                return statuses;
            }
        }.run();
    }

    public Token<DelegationTokenIdentifier> getDelegationToken(String renewer) throws IOException {
        try {
            GetOpParam.Op op = GetOpParam.Op.GETDELEGATIONTOKEN;
            Token token = (Token)new FsPathResponseRunner<Token<DelegationTokenIdentifier>>((HttpOpParam.Op)op, null, new Param[]{new RenewerParam(renewer)}){

                @Override
                Token<DelegationTokenIdentifier> decodeResponse(Map<?, ?> json) throws IOException {
                    return JsonUtil.toDelegationToken(json);
                }
            }.run();
            token.setService(this.tokenServiceName);
            return token;
        }
        catch (IOException e) {
            LOG.warn((Object)e.getMessage());
            LOG.debug((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public synchronized Token<?> getRenewToken() {
        return this.delegationToken;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends TokenIdentifier> void setDelegationToken(Token<T> token) {
        WebHdfsFileSystem webHdfsFileSystem = this;
        synchronized (webHdfsFileSystem) {
            this.delegationToken = token;
        }
    }

    @Override
    public synchronized long renewDelegationToken(Token<?> token) throws IOException {
        PutOpParam.Op op = PutOpParam.Op.RENEWDELEGATIONTOKEN;
        return (Long)new FsPathResponseRunner<Long>((HttpOpParam.Op)op, null, new Param[]{new TokenArgumentParam(token.encodeToUrlString())}){

            @Override
            Long decodeResponse(Map<?, ?> json) throws IOException {
                return (Long)json.get("long");
            }
        }.run();
    }

    @Override
    public synchronized void cancelDelegationToken(Token<?> token) throws IOException {
        PutOpParam.Op op = PutOpParam.Op.CANCELDELEGATIONTOKEN;
        new FsPathRunner((HttpOpParam.Op)op, null, new TokenArgumentParam(token.encodeToUrlString())).run();
    }

    public BlockLocation[] getFileBlockLocations(FileStatus status, long offset, long length) throws IOException {
        if (status == null) {
            return null;
        }
        return this.getFileBlockLocations(status.getPath(), offset, length);
    }

    public BlockLocation[] getFileBlockLocations(Path p, long offset, long length) throws IOException {
        this.statistics.incrementReadOps(1);
        GetOpParam.Op op = GetOpParam.Op.GET_BLOCK_LOCATIONS;
        return (BlockLocation[])new FsPathResponseRunner<BlockLocation[]>((HttpOpParam.Op)op, p, new Param[]{new OffsetParam(offset), new LengthParam(length)}){

            @Override
            BlockLocation[] decodeResponse(Map<?, ?> json) throws IOException {
                return DFSUtil.locatedBlocks2Locations(JsonUtil.toLocatedBlocks(json));
            }
        }.run();
    }

    public ContentSummary getContentSummary(Path p) throws IOException {
        this.statistics.incrementReadOps(1);
        GetOpParam.Op op = GetOpParam.Op.GETCONTENTSUMMARY;
        return (ContentSummary)new FsPathResponseRunner<ContentSummary>((HttpOpParam.Op)op, p, new Param[0]){

            @Override
            ContentSummary decodeResponse(Map<?, ?> json) {
                return JsonUtil.toContentSummary(json);
            }
        }.run();
    }

    public MD5MD5CRC32FileChecksum getFileChecksum(Path p) throws IOException {
        this.statistics.incrementReadOps(1);
        GetOpParam.Op op = GetOpParam.Op.GETFILECHECKSUM;
        return (MD5MD5CRC32FileChecksum)new FsPathResponseRunner<MD5MD5CRC32FileChecksum>((HttpOpParam.Op)op, p, new Param[0]){

            @Override
            MD5MD5CRC32FileChecksum decodeResponse(Map<?, ?> json) throws IOException {
                return JsonUtil.toMD5MD5CRC32FileChecksum(json);
            }
        }.run();
    }

    private InetSocketAddress[] resolveNNAddr() throws IOException {
        Configuration conf = this.getConf();
        String scheme = this.uri.getScheme();
        ArrayList<InetSocketAddress> ret = new ArrayList<InetSocketAddress>();
        if (!HAUtil.isLogicalUri(conf, this.uri)) {
            InetSocketAddress addr = NetUtils.createSocketAddr((String)this.uri.getAuthority(), (int)this.getDefaultPort());
            ret.add(addr);
        } else {
            Map<String, Map<String, InetSocketAddress>> addresses = DFSUtil.getHaNnWebHdfsAddresses(conf, scheme);
            Map<String, InetSocketAddress> addrs = addresses.get(this.uri.getHost());
            for (InetSocketAddress addr : addrs.values()) {
                ret.add(addr);
            }
        }
        InetSocketAddress[] r = new InetSocketAddress[ret.size()];
        return ret.toArray(r);
    }

    public String getCanonicalServiceName() {
        return this.tokenServiceName == null ? super.getCanonicalServiceName() : this.tokenServiceName.toString();
    }

    @VisibleForTesting
    InetSocketAddress[] getResolvedNNAddr() {
        return this.nnAddrs;
    }

    static class OffsetUrlInputStream
    extends ByteRangeInputStream {
        OffsetUrlInputStream(UnresolvedUrlOpener o, OffsetUrlOpener r) throws IOException {
            super(o, r);
        }

        @Override
        protected URL getResolvedUrl(HttpURLConnection connection) throws MalformedURLException {
            return WebHdfsFileSystem.removeOffsetParam(connection.getURL());
        }
    }

    class OffsetUrlOpener
    extends ByteRangeInputStream.URLOpener {
        OffsetUrlOpener(URL url) {
            super(url);
        }

        @Override
        protected HttpURLConnection connect(long offset, boolean resolved) throws IOException {
            URL offsetUrl = offset == 0L ? this.url : new URL(this.url + "&" + new OffsetParam(offset));
            return (HttpURLConnection)new URLRunner(GetOpParam.Op.OPEN, offsetUrl, resolved).run();
        }
    }

    class UnresolvedUrlOpener
    extends ByteRangeInputStream.URLOpener {
        private final FsPathConnectionRunner runner;

        UnresolvedUrlOpener(FsPathConnectionRunner runner) {
            super(null);
            this.runner = runner;
        }

        @Override
        protected HttpURLConnection connect(long offset, boolean resolved) throws IOException {
            assert (offset == 0L);
            HttpURLConnection conn = (HttpURLConnection)this.runner.run();
            this.setURL(conn.getURL());
            return conn;
        }
    }

    final class URLRunner
    extends AbstractRunner<HttpURLConnection> {
        private final URL url;

        @Override
        protected URL getUrl() {
            return this.url;
        }

        protected URLRunner(HttpOpParam.Op op, URL url, boolean redirected) {
            super(op, redirected);
            this.url = url;
        }

        @Override
        HttpURLConnection getResponse(HttpURLConnection conn) throws IOException {
            return conn;
        }
    }

    class FsPathConnectionRunner
    extends AbstractFsPathRunner<HttpURLConnection> {
        FsPathConnectionRunner(HttpOpParam.Op op, Path fspath, Param<?, ?> ... parameters) {
            super(op, fspath, parameters);
        }

        @Override
        HttpURLConnection getResponse(HttpURLConnection conn) throws IOException {
            return conn;
        }
    }

    class FsPathOutputStreamRunner
    extends AbstractFsPathRunner<FSDataOutputStream> {
        private final int bufferSize;

        FsPathOutputStreamRunner(HttpOpParam.Op op, Path fspath, int bufferSize, Param<?, ?> ... parameters) {
            super(op, fspath, parameters);
            this.bufferSize = bufferSize;
        }

        @Override
        FSDataOutputStream getResponse(final HttpURLConnection conn) throws IOException {
            return new FSDataOutputStream(new BufferedOutputStream(conn.getOutputStream(), this.bufferSize), WebHdfsFileSystem.this.statistics){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void close() throws IOException {
                    try {
                        super.close();
                    }
                    finally {
                        try {
                            WebHdfsFileSystem.validateResponse(FsPathOutputStreamRunner.this.op, conn, true);
                        }
                        finally {
                            conn.disconnect();
                        }
                    }
                }
            };
        }
    }

    class FsPathBooleanRunner
    extends FsPathResponseRunner<Boolean> {
        FsPathBooleanRunner(HttpOpParam.Op op, Path fspath, Param<?, ?> ... parameters) {
            super(op, fspath, parameters);
        }

        @Override
        Boolean decodeResponse(Map<?, ?> json) throws IOException {
            return (Boolean)json.get("boolean");
        }
    }

    abstract class FsPathResponseRunner<T>
    extends AbstractFsPathRunner<T> {
        FsPathResponseRunner(HttpOpParam.Op op, Path fspath, Param<?, ?> ... parameters) {
            super(op, fspath, parameters);
        }

        FsPathResponseRunner(HttpOpParam.Op op, Param<?, ?>[] parameters, Path fspath) {
            super(op, parameters, fspath);
        }

        @Override
        final T getResponse(HttpURLConnection conn) throws IOException {
            try {
                Map<?, ?> json = WebHdfsFileSystem.jsonParse(conn, false);
                if (json == null) {
                    throw new IllegalStateException("Missing response");
                }
                T t = this.decodeResponse(json);
                return t;
            }
            catch (IOException ioe) {
                throw ioe;
            }
            catch (Exception e) {
                IOException ioe = new IOException("Response decoding failure: " + e.toString(), e);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)ioe);
                }
                throw ioe;
            }
            finally {
                conn.disconnect();
            }
        }

        abstract T decodeResponse(Map<?, ?> var1) throws IOException;
    }

    class FsPathRunner
    extends AbstractFsPathRunner<Void> {
        FsPathRunner(HttpOpParam.Op op, Path fspath, Param<?, ?> ... parameters) {
            super(op, fspath, parameters);
        }

        @Override
        Void getResponse(HttpURLConnection conn) throws IOException {
            return null;
        }
    }

    abstract class AbstractFsPathRunner<T>
    extends AbstractRunner<T> {
        private final Path fspath;
        private final Param<?, ?>[] parameters;

        AbstractFsPathRunner(HttpOpParam.Op op, Path fspath, Param<?, ?> ... parameters) {
            super(op, false);
            this.fspath = fspath;
            this.parameters = parameters;
        }

        AbstractFsPathRunner(HttpOpParam.Op op, Param<?, ?>[] parameters, Path fspath) {
            super(op, false);
            this.fspath = fspath;
            this.parameters = parameters;
        }

        @Override
        protected URL getUrl() throws IOException {
            return WebHdfsFileSystem.this.toUrl(this.op, this.fspath, this.parameters);
        }
    }

    abstract class AbstractRunner<T> {
        protected final HttpOpParam.Op op;
        private final boolean redirected;
        private boolean checkRetry;

        protected abstract URL getUrl() throws IOException;

        protected AbstractRunner(HttpOpParam.Op op, boolean redirected) {
            this.op = op;
            this.redirected = redirected;
        }

        T run() throws IOException {
            UserGroupInformation connectUgi = WebHdfsFileSystem.this.ugi.getRealUser();
            if (connectUgi == null) {
                connectUgi = WebHdfsFileSystem.this.ugi;
            }
            if (this.op.getRequireAuth()) {
                connectUgi.checkTGTAndReloginFromKeytab();
            }
            try {
                return (T)connectUgi.doAs(new PrivilegedExceptionAction<T>(){

                    @Override
                    public T run() throws IOException {
                        return AbstractRunner.this.runWithRetry();
                    }
                });
            }
            catch (InterruptedException e) {
                throw new IOException(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private HttpURLConnection connect(URL url) throws IOException {
            if (this.op.getRedirect() && !this.redirected) {
                HttpOpParam.TemporaryRedirectOp redirectOp = HttpOpParam.TemporaryRedirectOp.valueOf(this.op);
                HttpURLConnection conn = this.connect(redirectOp, url);
                if (conn.getResponseCode() == this.op.getExpectedHttpResponseCode()) {
                    return conn;
                }
                try {
                    WebHdfsFileSystem.validateResponse(redirectOp, conn, false);
                    url = new URL(conn.getHeaderField("Location"));
                }
                finally {
                    conn.disconnect();
                }
            }
            return this.connect(this.op, url);
        }

        private HttpURLConnection connect(HttpOpParam.Op op, URL url) throws IOException {
            HttpURLConnection conn = (HttpURLConnection)WebHdfsFileSystem.this.connectionFactory.openConnection(url);
            boolean doOutput = op.getDoOutput();
            conn.setRequestMethod(op.getType().toString());
            conn.setInstanceFollowRedirects(false);
            switch (op.getType()) {
                case POST: 
                case PUT: {
                    conn.setDoOutput(true);
                    if (!doOutput) {
                        conn.getOutputStream().close();
                        break;
                    }
                    conn.setRequestProperty("Content-Type", "application/octet-stream");
                    conn.setChunkedStreamingMode(32768);
                    break;
                }
                default: {
                    conn.setDoOutput(doOutput);
                }
            }
            conn.connect();
            return conn;
        }

        private T runWithRetry() throws IOException {
            int retry = 0;
            while (true) {
                this.checkRetry = !this.redirected;
                URL url = this.getUrl();
                try {
                    HttpURLConnection conn = this.connect(url);
                    if (!this.op.getDoOutput()) {
                        WebHdfsFileSystem.validateResponse(this.op, conn, false);
                    }
                    return this.getResponse(conn);
                }
                catch (AccessControlException ace) {
                    throw ace;
                }
                catch (SecretManager.InvalidToken it) {
                    if (this.op.getRequireAuth() || !WebHdfsFileSystem.this.replaceExpiredDelegationToken()) {
                        throw it;
                    }
                }
                catch (IOException ioe) {
                    this.shouldRetry(ioe, retry);
                }
                ++retry;
            }
        }

        private void shouldRetry(IOException ioe, int retry) throws IOException {
            InetSocketAddress nnAddr = WebHdfsFileSystem.this.getCurrentNNAddr();
            if (this.checkRetry) {
                try {
                    boolean isFailoverAndRetry;
                    RetryPolicy.RetryAction a = WebHdfsFileSystem.this.retryPolicy.shouldRetry((Exception)ioe, retry, 0, true);
                    boolean isRetry = a.action == RetryPolicy.RetryAction.RetryDecision.RETRY;
                    boolean bl = isFailoverAndRetry = a.action == RetryPolicy.RetryAction.RetryDecision.FAILOVER_AND_RETRY;
                    if (isRetry || isFailoverAndRetry) {
                        LOG.info((Object)("Retrying connect to namenode: " + nnAddr + ". Already tried " + retry + " time(s); retry policy is " + WebHdfsFileSystem.this.retryPolicy + ", delay " + a.delayMillis + "ms."));
                        if (isFailoverAndRetry) {
                            WebHdfsFileSystem.this.resetStateToFailOver();
                        }
                        Thread.sleep(a.delayMillis);
                        return;
                    }
                }
                catch (Exception e) {
                    LOG.warn((Object)"Original exception is ", (Throwable)ioe);
                    throw WebHdfsFileSystem.toIOException(e);
                }
            }
            throw WebHdfsFileSystem.toIOException(ioe);
        }

        abstract T getResponse(HttpURLConnection var1) throws IOException;
    }
}

