/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.BlockListAsLongs;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsVolumeSpi;
import org.apache.hadoop.hdfs.server.protocol.DatanodeRegistration;
import org.apache.hadoop.hdfs.server.protocol.DatanodeStorage;
import org.apache.hadoop.hdfs.server.protocol.StorageBlockReport;
import org.apache.hadoop.test.GenericTestUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestBlockHasMultipleReplicasOnSameDN {
    public static final Log LOG = LogFactory.getLog(TestBlockHasMultipleReplicasOnSameDN.class);
    private static final short NUM_DATANODES = 2;
    private static final int BLOCK_SIZE = 1024;
    private static final long NUM_BLOCKS = 5L;
    private static final long seed = 464384013L;
    private Configuration conf;
    private MiniDFSCluster cluster;
    private DistributedFileSystem fs;
    private DFSClient client;
    private String bpid;

    @Before
    public void startUpCluster() throws IOException {
        this.conf = new HdfsConfiguration();
        this.cluster = new MiniDFSCluster.Builder(this.conf).numDataNodes(2).build();
        this.fs = this.cluster.getFileSystem();
        this.client = this.fs.getClient();
        this.bpid = this.cluster.getNamesystem().getBlockPoolId();
    }

    @After
    public void shutDownCluster() throws IOException {
        if (this.cluster != null) {
            this.fs.close();
            this.cluster.shutdown();
            this.cluster = null;
        }
    }

    private String makeFileName(String prefix) {
        return "/" + prefix + ".dat";
    }

    @Test
    public void testBlockHasMultipleReplicasOnSameDN() throws IOException {
        String filename = this.makeFileName(GenericTestUtils.getMethodName());
        Path filePath = new Path(filename);
        DFSTestUtil.createFile((FileSystem)this.fs, filePath, 1024, 5120L, 1024L, (short)2, 464384013L);
        LocatedBlocks locatedBlocks = this.client.getLocatedBlocks(filePath.toString(), 0L, 5120L);
        DataNode dn = this.cluster.getDataNodes().get(0);
        DatanodeRegistration dnReg = dn.getDNRegistrationForBP(this.bpid);
        StorageBlockReport[] reports = new StorageBlockReport[2];
        ArrayList<Block> blocks = new ArrayList<Block>();
        for (LocatedBlock locatedBlock : locatedBlocks.getLocatedBlocks()) {
            blocks.add(locatedBlock.getBlock().getLocalBlock());
        }
        for (int i = 0; i < 2; ++i) {
            BlockListAsLongs bll = new BlockListAsLongs(blocks, null);
            FsVolumeSpi v = (FsVolumeSpi)dn.getFSDataset().getVolumes().get(i);
            DatanodeStorage dns = new DatanodeStorage(v.getStorageID());
            reports[i] = new StorageBlockReport(dns, bll.getBlockListAsLongs());
        }
        this.cluster.getNameNodeRpc().blockReport(dnReg, this.bpid, reports);
        locatedBlocks = this.client.getLocatedBlocks(filename, 0L, 5120L);
        for (LocatedBlock locatedBlock : locatedBlocks.getLocatedBlocks()) {
            DatanodeInfo[] locations = locatedBlock.getLocations();
            Assert.assertThat((Object)locations.length, (Matcher)Is.is((Object)2));
            Assert.assertThat((Object)locations[0].getDatanodeUuid(), (Matcher)CoreMatchers.not((Object)locations[1].getDatanodeUuid()));
        }
    }
}

