/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.protocol;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hdfs.protocol.Block;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class BlocksWithLocations {
    private final BlockWithLocations[] blocks;

    public BlocksWithLocations(BlockWithLocations[] blocks) {
        this.blocks = blocks;
    }

    public BlockWithLocations[] getBlocks() {
        return this.blocks;
    }

    @InterfaceAudience.Private
    @InterfaceStability.Evolving
    public static class BlockWithLocations {
        final Block block;
        final String[] datanodeUuids;
        final String[] storageIDs;

        public BlockWithLocations(Block block, String[] datanodeUuids, String[] storageIDs) {
            this.block = block;
            this.datanodeUuids = datanodeUuids;
            this.storageIDs = storageIDs;
        }

        public Block getBlock() {
            return this.block;
        }

        public String[] getDatanodeUuids() {
            return this.datanodeUuids;
        }

        public String[] getStorageIDs() {
            return this.storageIDs;
        }

        public String toString() {
            StringBuilder b = new StringBuilder();
            b.append(this.block);
            if (this.datanodeUuids.length == 0) {
                return b.append("[]").toString();
            }
            b.append(this.storageIDs[0]).append('@').append(this.datanodeUuids[0]);
            for (int i = 1; i < this.datanodeUuids.length; ++i) {
                b.append(", ").append(this.storageIDs[i]).append("@").append(this.datanodeUuids[i]);
            }
            return b.append("]").toString();
        }
    }
}

