/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocol.datatransfer;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.apache.hadoop.hdfs.AppendTestUtil;
import org.apache.hadoop.hdfs.protocol.datatransfer.PacketHeader;
import org.apache.hadoop.hdfs.protocol.datatransfer.PacketReceiver;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestPacketReceiver {
    private static final long OFFSET_IN_BLOCK = 12345L;
    private static final int SEQNO = 54321;

    private byte[] prepareFakePacket(byte[] data, byte[] sums) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        int packetLen = data.length + sums.length + 4;
        PacketHeader header = new PacketHeader(packetLen, 12345L, 54321L, false, data.length, false);
        header.write(dos);
        dos.write(sums);
        dos.write(data);
        dos.flush();
        return baos.toByteArray();
    }

    private static byte[] remainingAsArray(ByteBuffer buf) {
        byte[] b = new byte[buf.remaining()];
        buf.get(b);
        return b;
    }

    @Test
    public void testReceiveAndMirror() throws IOException {
        PacketReceiver pr = new PacketReceiver(false);
        this.doTestReceiveAndMirror(pr, 100, 10);
        this.doTestReceiveAndMirror(pr, 50, 10);
        this.doTestReceiveAndMirror(pr, 150, 10);
        pr.close();
    }

    private void doTestReceiveAndMirror(PacketReceiver pr, int dataLen, int checksumsLen) throws IOException {
        byte[] DATA = AppendTestUtil.initBuffer(dataLen);
        byte[] CHECKSUMS = AppendTestUtil.initBuffer(checksumsLen);
        byte[] packet = this.prepareFakePacket(DATA, CHECKSUMS);
        ByteArrayInputStream in = new ByteArrayInputStream(packet);
        pr.receiveNextPacket((InputStream)in);
        ByteBuffer parsedData = pr.getDataSlice();
        Assert.assertArrayEquals((byte[])DATA, (byte[])TestPacketReceiver.remainingAsArray(parsedData));
        ByteBuffer parsedChecksums = pr.getChecksumSlice();
        Assert.assertArrayEquals((byte[])CHECKSUMS, (byte[])TestPacketReceiver.remainingAsArray(parsedChecksums));
        PacketHeader header = pr.getHeader();
        Assert.assertEquals((long)54321L, (long)header.getSeqno());
        Assert.assertEquals((long)12345L, (long)header.getOffsetInBlock());
        Assert.assertEquals((long)(dataLen + checksumsLen + 4), (long)header.getPacketLen());
        ByteArrayOutputStream mirrored = new ByteArrayOutputStream();
        mirrored = (ByteArrayOutputStream)Mockito.spy((Object)mirrored);
        pr.mirrorPacketTo(new DataOutputStream(mirrored));
        ((ByteArrayOutputStream)Mockito.verify((Object)mirrored, (VerificationMode)Mockito.times((int)1))).write((byte[])Mockito.any(), Mockito.anyInt(), Mockito.eq((int)packet.length));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{mirrored});
        Assert.assertArrayEquals((byte[])packet, (byte[])mirrored.toByteArray());
    }
}

