/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Lists;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.hdfs.DFSOutputStream;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.BlockListAsLongs;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockCollection;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfoContiguous;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfoContiguousUnderConstruction;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManagerTestUtil;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockPlacementPolicyDefault;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeStorageInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.NumberReplicas;
import org.apache.hadoop.hdfs.server.datanode.DataNodeTestUtils;
import org.apache.hadoop.hdfs.server.datanode.FinalizedReplica;
import org.apache.hadoop.hdfs.server.datanode.Replica;
import org.apache.hadoop.hdfs.server.datanode.ReplicaBeingWritten;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.NameNodeAdapter;
import org.apache.hadoop.hdfs.server.namenode.Namesystem;
import org.apache.hadoop.hdfs.server.protocol.DatanodeRegistration;
import org.apache.hadoop.hdfs.server.protocol.DatanodeStorage;
import org.apache.hadoop.hdfs.server.protocol.NamenodeProtocols;
import org.apache.hadoop.hdfs.server.protocol.ReceivedDeletedBlockInfo;
import org.apache.hadoop.hdfs.server.protocol.StorageReceivedDeletedBlocks;
import org.apache.hadoop.io.EnumSetWritable;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.net.NetworkTopology;
import org.apache.hadoop.net.Node;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.test.MetricsAsserts;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class TestBlockManager {
    private DatanodeStorageInfo[] storages;
    private List<DatanodeDescriptor> nodes;
    private List<DatanodeDescriptor> rackA;
    private List<DatanodeDescriptor> rackB;
    private static final int NUM_TEST_ITERS = 30;
    private static final int BLOCK_SIZE = 65536;
    private FSNamesystem fsn;
    private BlockManager bm;

    @Before
    public void setupMockCluster() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.set("net.topology.script.file.name", "need to set a dummy value here so it assumes a multi-rack cluster");
        this.fsn = (FSNamesystem)Mockito.mock(FSNamesystem.class);
        ((FSNamesystem)Mockito.doReturn((Object)true).when((Object)this.fsn)).hasWriteLock();
        this.bm = new BlockManager((Namesystem)this.fsn, (Configuration)conf);
        String[] racks = new String[]{"/rackA", "/rackA", "/rackA", "/rackB", "/rackB", "/rackB"};
        this.storages = DFSTestUtil.createDatanodeStorageInfos(racks);
        this.nodes = Arrays.asList(DFSTestUtil.toDatanodeDescriptor(this.storages));
        this.rackA = this.nodes.subList(0, 3);
        this.rackB = this.nodes.subList(3, 6);
    }

    private void addNodes(Iterable<DatanodeDescriptor> nodesToAdd) {
        NetworkTopology cluster = this.bm.getDatanodeManager().getNetworkTopology();
        for (DatanodeDescriptor dn : nodesToAdd) {
            cluster.add((Node)dn);
            dn.getStorageInfos()[0].setUtilizationForTesting(131072L, 0L, 131072L, 0L);
            dn.updateHeartbeat(BlockManagerTestUtil.getStorageReportsForDatanode(dn), 0L, 0L, 0, 0, null);
            this.bm.getDatanodeManager().checkIfClusterIsNowMultiRack(dn);
        }
    }

    private void removeNode(DatanodeDescriptor deadNode) {
        NetworkTopology cluster = this.bm.getDatanodeManager().getNetworkTopology();
        cluster.remove((Node)deadNode);
        this.bm.removeBlocksAssociatedTo(deadNode);
    }

    @Test
    public void testBasicReplication() throws Exception {
        this.addNodes(this.nodes);
        for (int i = 0; i < 30; ++i) {
            this.doBasicTest(i);
        }
    }

    private void doBasicTest(int testIndex) {
        List<DatanodeStorageInfo> origStorages = this.getStorages(0, 1);
        List<DatanodeDescriptor> origNodes = this.getNodes(origStorages);
        BlockInfoContiguous blockInfo = this.addBlockOnNodes(testIndex, origNodes);
        DatanodeStorageInfo[] pipeline = this.scheduleSingleReplication((Block)blockInfo);
        Assert.assertEquals((long)2L, (long)pipeline.length);
        Assert.assertTrue((String)("Source of replication should be one of the nodes the block was on. Was: " + pipeline[0]), (boolean)origStorages.contains(pipeline[0]));
        Assert.assertTrue((String)("Destination of replication should be on the other rack. Was: " + pipeline[1]), (boolean)this.rackB.contains(pipeline[1].getDatanodeDescriptor()));
    }

    @Test
    public void testTwoOfThreeNodesDecommissioned() throws Exception {
        this.addNodes(this.nodes);
        for (int i = 0; i < 30; ++i) {
            this.doTestTwoOfThreeNodesDecommissioned(i);
        }
    }

    private void doTestTwoOfThreeNodesDecommissioned(int testIndex) throws Exception {
        List<DatanodeStorageInfo> origStorages = this.getStorages(0, 1, 3);
        List<DatanodeDescriptor> origNodes = this.getNodes(origStorages);
        BlockInfoContiguous blockInfo = this.addBlockOnNodes(testIndex, origNodes);
        List<DatanodeDescriptor> decomNodes = this.startDecommission(0, 1);
        Object[] pipeline = this.scheduleSingleReplication((Block)blockInfo);
        Assert.assertTrue((String)("Source of replication should be one of the nodes the block was on. Was: " + pipeline[0]), (boolean)origStorages.contains(pipeline[0]));
        Assert.assertEquals((String)"Should have three targets", (long)3L, (long)pipeline.length);
        boolean foundOneOnRackA = false;
        for (int i = 1; i < pipeline.length; ++i) {
            DatanodeDescriptor target = pipeline[i].getDatanodeDescriptor();
            if (this.rackA.contains(target)) {
                foundOneOnRackA = true;
            }
            Assert.assertFalse((boolean)decomNodes.contains(target));
            Assert.assertFalse((boolean)origNodes.contains(target));
        }
        Assert.assertTrue((String)("Should have at least one target on rack A. Pipeline: " + Joiner.on((String)",").join(pipeline)), (boolean)foundOneOnRackA);
    }

    @Test
    public void testAllNodesHoldingReplicasDecommissioned() throws Exception {
        this.addNodes(this.nodes);
        for (int i = 0; i < 30; ++i) {
            this.doTestAllNodesHoldingReplicasDecommissioned(i);
        }
    }

    private void doTestAllNodesHoldingReplicasDecommissioned(int testIndex) throws Exception {
        List<DatanodeStorageInfo> origStorages = this.getStorages(0, 1, 3);
        List<DatanodeDescriptor> origNodes = this.getNodes(origStorages);
        BlockInfoContiguous blockInfo = this.addBlockOnNodes(testIndex, origNodes);
        List<DatanodeDescriptor> decomNodes = this.startDecommission(0, 1, 3);
        Object[] pipeline = this.scheduleSingleReplication((Block)blockInfo);
        Assert.assertTrue((String)("Source of replication should be one of the nodes the block was on. Was: " + pipeline[0]), (boolean)origStorages.contains(pipeline[0]));
        Assert.assertEquals((String)"Should have three targets", (long)4L, (long)pipeline.length);
        boolean foundOneOnRackA = false;
        boolean foundOneOnRackB = false;
        for (int i = 1; i < pipeline.length; ++i) {
            DatanodeDescriptor target = pipeline[i].getDatanodeDescriptor();
            if (this.rackA.contains(target)) {
                foundOneOnRackA = true;
            } else if (this.rackB.contains(target)) {
                foundOneOnRackB = true;
            }
            Assert.assertFalse((boolean)decomNodes.contains(target));
            Assert.assertFalse((boolean)origNodes.contains(target));
        }
        Assert.assertTrue((String)("Should have at least one target on rack A. Pipeline: " + Joiner.on((String)",").join(pipeline)), (boolean)foundOneOnRackA);
        Assert.assertTrue((String)("Should have at least one target on rack B. Pipeline: " + Joiner.on((String)",").join(pipeline)), (boolean)foundOneOnRackB);
    }

    @Test
    public void testOneOfTwoRacksDecommissioned() throws Exception {
        this.addNodes(this.nodes);
        for (int i = 0; i < 30; ++i) {
            this.doTestOneOfTwoRacksDecommissioned(i);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doTestOneOfTwoRacksDecommissioned(int testIndex) throws Exception {
        List<DatanodeStorageInfo> origStorages = this.getStorages(0, 1, 3);
        List<DatanodeDescriptor> origNodes = this.getNodes(origStorages);
        BlockInfoContiguous blockInfo = this.addBlockOnNodes(testIndex, origNodes);
        List<DatanodeDescriptor> decomNodes = this.startDecommission(0, 1, 2);
        Object[] pipeline = this.scheduleSingleReplication((Block)blockInfo);
        Assert.assertTrue((String)("Source of replication should be one of the nodes the block was on. Was: " + pipeline[0]), (boolean)origStorages.contains(pipeline[0]));
        Assert.assertEquals((String)"Should have two targets", (long)2L, (long)pipeline.length);
        boolean foundOneOnRackB = false;
        for (int i = 1; i < pipeline.length; ++i) {
            DatanodeDescriptor target = pipeline[i].getDatanodeDescriptor();
            if (this.rackB.contains(target)) {
                foundOneOnRackB = true;
            }
            Assert.assertFalse((boolean)decomNodes.contains(target));
            Assert.assertFalse((boolean)origNodes.contains(target));
        }
        Assert.assertTrue((String)("Should have at least one target on rack B. Pipeline: " + Joiner.on((String)",").join(pipeline)), (boolean)foundOneOnRackB);
        this.fulfillPipeline(blockInfo, (DatanodeStorageInfo[])pipeline);
        DatanodeDescriptor rackCNode = DFSTestUtil.getDatanodeDescriptor("7.7.7.7", "/rackC");
        rackCNode.updateStorage(new DatanodeStorage(DatanodeStorage.generateUuid()));
        this.addNodes((Iterable<DatanodeDescriptor>)ImmutableList.of((Object)rackCNode));
        try {
            DatanodeStorageInfo[] pipeline2 = this.scheduleSingleReplication((Block)blockInfo);
            Assert.assertEquals((long)2L, (long)pipeline2.length);
            Assert.assertEquals((Object)rackCNode, (Object)pipeline2[1].getDatanodeDescriptor());
        }
        finally {
            this.removeNode(rackCNode);
        }
    }

    @Test
    public void testSufficientlyReplBlocksUsesNewRack() throws Exception {
        this.addNodes(this.nodes);
        for (int i = 0; i < 30; ++i) {
            this.doTestSufficientlyReplBlocksUsesNewRack(i);
        }
    }

    private void doTestSufficientlyReplBlocksUsesNewRack(int testIndex) {
        List<DatanodeDescriptor> origNodes = this.rackA;
        BlockInfoContiguous blockInfo = this.addBlockOnNodes(testIndex, origNodes);
        DatanodeStorageInfo[] pipeline = this.scheduleSingleReplication((Block)blockInfo);
        Assert.assertEquals((long)2L, (long)pipeline.length);
        Assert.assertTrue((String)("Source of replication should be one of the nodes the block was on. Was: " + pipeline[0]), (boolean)origNodes.contains(pipeline[0].getDatanodeDescriptor()));
        Assert.assertTrue((String)("Destination of replication should be on the other rack. Was: " + pipeline[1]), (boolean)this.rackB.contains(pipeline[1].getDatanodeDescriptor()));
    }

    @Test
    public void testBlocksAreNotUnderreplicatedInSingleRack() throws Exception {
        ImmutableList nodes = ImmutableList.of((Object)BlockManagerTestUtil.getDatanodeDescriptor("1.1.1.1", "/rackA", true), (Object)BlockManagerTestUtil.getDatanodeDescriptor("2.2.2.2", "/rackA", true), (Object)BlockManagerTestUtil.getDatanodeDescriptor("3.3.3.3", "/rackA", true), (Object)BlockManagerTestUtil.getDatanodeDescriptor("4.4.4.4", "/rackA", true), (Object)BlockManagerTestUtil.getDatanodeDescriptor("5.5.5.5", "/rackA", true), (Object)BlockManagerTestUtil.getDatanodeDescriptor("6.6.6.6", "/rackA", true));
        this.addNodes((Iterable<DatanodeDescriptor>)nodes);
        List<DatanodeDescriptor> origNodes = nodes.subList(0, 3);
        for (int i = 0; i < 30; ++i) {
            this.doTestSingleRackClusterIsSufficientlyReplicated(i, origNodes);
        }
    }

    private void doTestSingleRackClusterIsSufficientlyReplicated(int testIndex, List<DatanodeDescriptor> origNodes) throws Exception {
        Assert.assertEquals((long)0L, (long)this.bm.numOfUnderReplicatedBlocks());
        this.addBlockOnNodes(testIndex, origNodes);
        this.bm.processMisReplicatedBlocks();
        Assert.assertEquals((long)0L, (long)this.bm.numOfUnderReplicatedBlocks());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testNeededReplicationWhileAppending() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        String src = "/test-file";
        Path file = new Path(src);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).build();
        cluster.waitActive();
        try {
            BlockManager bm = cluster.getNamesystem().getBlockManager();
            DistributedFileSystem fs = cluster.getFileSystem();
            NamenodeProtocols namenode = cluster.getNameNodeRpc();
            DFSOutputStream out = null;
            try {
                out = (DFSOutputStream)fs.create(file).getWrappedStream();
                out.write(1);
                out.hflush();
                out.close();
                FSDataInputStream in = null;
                ExtendedBlock oldBlock = null;
                LocatedBlock oldLoactedBlock = null;
                try {
                    in = fs.open(file);
                    oldLoactedBlock = DFSTestUtil.getAllBlocks(in).get(0);
                    oldBlock = oldLoactedBlock.getBlock();
                }
                finally {
                    IOUtils.closeStream((Closeable)in);
                }
                String clientName = fs.getClient().getClientName();
                namenode.append(src, clientName, new EnumSetWritable(EnumSet.of(CreateFlag.APPEND)));
                LocatedBlock newLocatedBlock = namenode.updateBlockForPipeline(oldBlock, clientName);
                ExtendedBlock newBlock = new ExtendedBlock(oldBlock.getBlockPoolId(), oldBlock.getBlockId(), oldBlock.getNumBytes(), newLocatedBlock.getBlock().getGenerationStamp());
                namenode.updatePipeline(clientName, oldBlock, newBlock, (DatanodeID[])oldLoactedBlock.getLocations(), oldLoactedBlock.getStorageIDs());
                BlockInfoContiguous bi = bm.getStoredBlock(newBlock.getLocalBlock());
                Assert.assertFalse((boolean)bm.isNeededReplication((Block)bi, oldLoactedBlock.getLocations().length, bm.countLiveNodes(bi)));
            }
            catch (Throwable throwable) {
                IOUtils.closeStream(out);
                throw throwable;
            }
            IOUtils.closeStream((Closeable)out);
        }
        finally {
            cluster.shutdown();
        }
    }

    private void fulfillPipeline(BlockInfoContiguous blockInfo, DatanodeStorageInfo[] pipeline) throws IOException {
        for (int i = 1; i < pipeline.length; ++i) {
            DatanodeStorageInfo storage = pipeline[i];
            this.bm.addBlock(storage, (Block)blockInfo, null);
            blockInfo.addStorage(storage);
        }
    }

    private BlockInfoContiguous blockOnNodes(long blkId, List<DatanodeDescriptor> nodes) {
        Block block = new Block(blkId);
        BlockInfoContiguous blockInfo = new BlockInfoContiguous(block, 3);
        for (DatanodeDescriptor dn : nodes) {
            for (DatanodeStorageInfo storage : dn.getStorageInfos()) {
                blockInfo.addStorage(storage);
            }
        }
        return blockInfo;
    }

    private List<DatanodeDescriptor> getNodes(int ... indexes) {
        ArrayList ret = Lists.newArrayList();
        for (int idx : indexes) {
            ret.add(this.nodes.get(idx));
        }
        return ret;
    }

    private List<DatanodeDescriptor> getNodes(List<DatanodeStorageInfo> storages) {
        ArrayList ret = Lists.newArrayList();
        for (DatanodeStorageInfo s : storages) {
            ret.add(s.getDatanodeDescriptor());
        }
        return ret;
    }

    private List<DatanodeStorageInfo> getStorages(int ... indexes) {
        ArrayList ret = Lists.newArrayList();
        for (int idx : indexes) {
            ret.add(this.storages[idx]);
        }
        return ret;
    }

    private List<DatanodeDescriptor> startDecommission(int ... indexes) {
        List<DatanodeDescriptor> nodes = this.getNodes(indexes);
        for (DatanodeDescriptor node : nodes) {
            node.startDecommission();
        }
        return nodes;
    }

    private BlockInfoContiguous addBlockOnNodes(long blockId, List<DatanodeDescriptor> nodes) {
        BlockCollection bc = (BlockCollection)Mockito.mock(BlockCollection.class);
        ((BlockCollection)Mockito.doReturn((Object)3).when((Object)bc)).getBlockReplication();
        BlockInfoContiguous blockInfo = this.blockOnNodes(blockId, nodes);
        this.bm.blocksMap.addBlockCollection(blockInfo, bc);
        return blockInfo;
    }

    private DatanodeStorageInfo[] scheduleSingleReplication(Block block) {
        ArrayList<Block> list_p1 = new ArrayList<Block>();
        list_p1.add(block);
        ArrayList list_all = new ArrayList();
        list_all.add(new ArrayList());
        list_all.add(list_p1);
        Assert.assertEquals((String)"Block not initially pending replication", (long)0L, (long)this.bm.pendingReplications.getNumReplicas(block));
        Assert.assertEquals((String)"computeReplicationWork should indicate replication is needed", (long)1L, (long)this.bm.computeReplicationWorkForBlocks(list_all));
        Assert.assertTrue((String)"replication is pending after work is computed", (this.bm.pendingReplications.getNumReplicas(block) > 0 ? 1 : 0) != 0);
        LinkedListMultimap<DatanodeStorageInfo, DatanodeDescriptor.BlockTargetPair> repls = this.getAllPendingReplications();
        Assert.assertEquals((long)1L, (long)repls.size());
        Map.Entry repl = (Map.Entry)repls.entries().iterator().next();
        DatanodeStorageInfo[] targets = ((DatanodeDescriptor.BlockTargetPair)repl.getValue()).targets;
        DatanodeStorageInfo[] pipeline = new DatanodeStorageInfo[1 + targets.length];
        pipeline[0] = (DatanodeStorageInfo)repl.getKey();
        System.arraycopy(targets, 0, pipeline, 1, targets.length);
        return pipeline;
    }

    private LinkedListMultimap<DatanodeStorageInfo, DatanodeDescriptor.BlockTargetPair> getAllPendingReplications() {
        LinkedListMultimap repls = LinkedListMultimap.create();
        for (DatanodeDescriptor dn : this.nodes) {
            List thisRepls = dn.getReplicationCommand(10);
            if (thisRepls == null) continue;
            for (DatanodeStorageInfo storage : dn.getStorageInfos()) {
                repls.putAll((Object)storage, (Iterable)thisRepls);
            }
        }
        return repls;
    }

    @Test
    public void testHighestPriReplSrcChosenDespiteMaxReplLimit() throws Exception {
        this.bm.maxReplicationStreams = 0;
        this.bm.replicationStreamsHardLimit = 1;
        long blockId = 42L;
        Block aBlock = new Block(blockId, 0L, 0L);
        List<DatanodeDescriptor> origNodes = this.getNodes(0, 1);
        this.addBlockOnNodes(blockId, origNodes.subList(0, 1));
        LinkedList cntNodes = new LinkedList();
        LinkedList liveNodes = new LinkedList();
        Assert.assertNotNull((String)"Chooses source node for a highest-priority replication even if all available source nodes have reached their replication limits below the hard limit.", (Object)this.bm.chooseSourceDatanode(aBlock, cntNodes, liveNodes, new NumberReplicas(), 0));
        Assert.assertNull((String)"Does not choose a source node for a less-than-highest-priority replication since all available source nodes have reached their replication limits.", (Object)this.bm.chooseSourceDatanode(aBlock, cntNodes, liveNodes, new NumberReplicas(), 1));
        DatanodeStorageInfo[] targets = new DatanodeStorageInfo[]{origNodes.get(1).getStorageInfos()[0]};
        origNodes.get(0).addBlockToBeReplicated(aBlock, targets);
        Assert.assertNull((String)"Does not choose a source node for a highest-priority replication when all available nodes exceed the hard limit.", (Object)this.bm.chooseSourceDatanode(aBlock, cntNodes, liveNodes, new NumberReplicas(), 0));
    }

    @Test
    public void testFavorDecomUntilHardLimit() throws Exception {
        this.bm.maxReplicationStreams = 0;
        this.bm.replicationStreamsHardLimit = 1;
        long blockId = 42L;
        Block aBlock = new Block(blockId, 0L, 0L);
        List<DatanodeDescriptor> origNodes = this.getNodes(0, 1);
        this.addBlockOnNodes(blockId, origNodes.subList(0, 1));
        origNodes.get(0).startDecommission();
        LinkedList cntNodes = new LinkedList();
        LinkedList liveNodes = new LinkedList();
        Assert.assertNotNull((String)"Chooses decommissioning source node for a normal replication if all available source nodes have reached their replication limits below the hard limit.", (Object)this.bm.chooseSourceDatanode(aBlock, cntNodes, liveNodes, new NumberReplicas(), 2));
        DatanodeStorageInfo[] targets = new DatanodeStorageInfo[]{origNodes.get(1).getStorageInfos()[0]};
        origNodes.get(0).addBlockToBeReplicated(aBlock, targets);
        Assert.assertNull((String)"Does not choose a source decommissioning node for a normal replication when all available nodes exceed the hard limit.", (Object)this.bm.chooseSourceDatanode(aBlock, cntNodes, liveNodes, new NumberReplicas(), 2));
    }

    @Test
    public void testSafeModeIBR() throws Exception {
        DatanodeDescriptor node = (DatanodeDescriptor)Mockito.spy((Object)this.nodes.get(0));
        DatanodeStorageInfo ds = node.getStorageInfos()[0];
        node.isAlive = true;
        DatanodeRegistration nodeReg = new DatanodeRegistration((DatanodeID)node, null, null, "");
        ((FSNamesystem)Mockito.doReturn((Object)true).when((Object)this.fsn)).isInStartupSafeMode();
        this.bm.getDatanodeManager().registerDatanode(nodeReg);
        this.bm.getDatanodeManager().addDatanode(node);
        Assert.assertEquals((Object)node, (Object)this.bm.getDatanodeManager().getDatanode((DatanodeID)node));
        Assert.assertEquals((long)0L, (long)ds.getBlockReportCount());
        Mockito.reset((Object[])new DatanodeDescriptor[]{node});
        this.bm.processReport((DatanodeID)node, new DatanodeStorage(ds.getStorageID()), BlockListAsLongs.EMPTY, null, false);
        Assert.assertEquals((long)1L, (long)ds.getBlockReportCount());
        Mockito.reset((Object[])new DatanodeDescriptor[]{node});
        this.bm.processReport((DatanodeID)node, new DatanodeStorage(ds.getStorageID()), BlockListAsLongs.EMPTY, null, false);
        Assert.assertEquals((long)1L, (long)ds.getBlockReportCount());
        this.bm.getDatanodeManager().removeDatanode((DatanodeID)node);
        Mockito.reset((Object[])new DatanodeDescriptor[]{node});
        this.bm.getDatanodeManager().registerDatanode(nodeReg);
        ((DatanodeDescriptor)Mockito.verify((Object)node)).updateRegInfo((DatanodeID)nodeReg);
        Mockito.reset((Object[])new DatanodeDescriptor[]{node});
        this.bm.processReport((DatanodeID)node, new DatanodeStorage(ds.getStorageID()), BlockListAsLongs.EMPTY, null, false);
        ds = node.getStorageInfos()[0];
        Assert.assertEquals((long)1L, (long)ds.getBlockReportCount());
    }

    @Test
    public void testSafeModeIBRAfterIncremental() throws Exception {
        DatanodeDescriptor node = (DatanodeDescriptor)Mockito.spy((Object)this.nodes.get(0));
        DatanodeStorageInfo ds = node.getStorageInfos()[0];
        node.isAlive = true;
        DatanodeRegistration nodeReg = new DatanodeRegistration((DatanodeID)node, null, null, "");
        ((FSNamesystem)Mockito.doReturn((Object)true).when((Object)this.fsn)).isInStartupSafeMode();
        this.bm.getDatanodeManager().registerDatanode(nodeReg);
        this.bm.getDatanodeManager().addDatanode(node);
        Assert.assertEquals((Object)node, (Object)this.bm.getDatanodeManager().getDatanode((DatanodeID)node));
        Assert.assertEquals((long)0L, (long)ds.getBlockReportCount());
        Mockito.reset((Object[])new DatanodeDescriptor[]{node});
        ((DatanodeDescriptor)Mockito.doReturn((Object)1).when((Object)node)).numBlocks();
        this.bm.processReport((DatanodeID)node, new DatanodeStorage(ds.getStorageID()), BlockListAsLongs.EMPTY, null, false);
        Assert.assertEquals((long)1L, (long)ds.getBlockReportCount());
    }

    @Test
    public void testSafeModeIBRBeforeFirstFullBR() throws Exception {
        ((FSNamesystem)Mockito.doReturn((Object)true).when((Object)this.fsn)).isInStartupSafeMode();
        DatanodeDescriptor node = this.nodes.get(0);
        DatanodeStorageInfo ds = node.getStorageInfos()[0];
        node.isAlive = true;
        DatanodeRegistration nodeReg = new DatanodeRegistration((DatanodeID)node, null, null, "");
        this.bm.getDatanodeManager().registerDatanode(nodeReg);
        this.bm.getDatanodeManager().addDatanode(node);
        Assert.assertEquals((Object)node, (Object)this.bm.getDatanodeManager().getDatanode((DatanodeID)node));
        Assert.assertEquals((long)0L, (long)ds.getBlockReportCount());
        ArrayList<ReceivedDeletedBlockInfo> rdbiList = new ArrayList<ReceivedDeletedBlockInfo>();
        BlockListAsLongs.Builder builder = BlockListAsLongs.builder();
        long receivedBlockId = 42L;
        BlockInfoContiguous receivedBlock = this.addBlockToBM(receivedBlockId);
        rdbiList.add(new ReceivedDeletedBlockInfo(new Block((Block)receivedBlock), ReceivedDeletedBlockInfo.BlockStatus.RECEIVED_BLOCK, null));
        builder.add((Replica)new FinalizedReplica((Block)receivedBlock, null, null));
        long receivingBlockId = 43L;
        BlockInfoContiguous receivingBlock = this.addUcBlockToBM(receivingBlockId);
        rdbiList.add(new ReceivedDeletedBlockInfo(new Block((Block)receivingBlock), ReceivedDeletedBlockInfo.BlockStatus.RECEIVING_BLOCK, null));
        builder.add((Replica)new ReplicaBeingWritten((Block)receivingBlock, null, null, null));
        long receivingReceivedBlockId = 44L;
        BlockInfoContiguous receivingReceivedBlock = this.addBlockToBM(receivingReceivedBlockId);
        rdbiList.add(new ReceivedDeletedBlockInfo(new Block((Block)receivingReceivedBlock), ReceivedDeletedBlockInfo.BlockStatus.RECEIVING_BLOCK, null));
        rdbiList.add(new ReceivedDeletedBlockInfo(new Block((Block)receivingReceivedBlock), ReceivedDeletedBlockInfo.BlockStatus.RECEIVED_BLOCK, null));
        builder.add((Replica)new FinalizedReplica((Block)receivingReceivedBlock, null, null));
        long ReceivedDeletedBlockId = 45L;
        rdbiList.add(new ReceivedDeletedBlockInfo(new Block(ReceivedDeletedBlockId), ReceivedDeletedBlockInfo.BlockStatus.RECEIVED_BLOCK, null));
        rdbiList.add(new ReceivedDeletedBlockInfo(new Block(ReceivedDeletedBlockId), ReceivedDeletedBlockInfo.BlockStatus.DELETED_BLOCK, null));
        long existedBlockId = 46L;
        BlockInfoContiguous existedBlock = this.addBlockToBM(existedBlockId);
        builder.add((Replica)new FinalizedReplica((Block)existedBlock, null, null));
        StorageReceivedDeletedBlocks srdb = new StorageReceivedDeletedBlocks(new DatanodeStorage(ds.getStorageID()), rdbiList.toArray(new ReceivedDeletedBlockInfo[rdbiList.size()]));
        this.bm.processIncrementalBlockReport((DatanodeID)node, srdb);
        Assert.assertEquals((long)0L, (long)ds.getBlockReportCount());
        this.bm.processReport((DatanodeID)node, new DatanodeStorage(ds.getStorageID()), builder.build(), null, false);
        Assert.assertEquals((long)1L, (long)ds.getBlockReportCount());
        Assert.assertTrue((this.bm.getStoredBlock(new Block(receivedBlockId)).findStorageInfo(ds) >= 0 ? 1 : 0) != 0);
        Assert.assertTrue((((BlockInfoContiguousUnderConstruction)this.bm.getStoredBlock(new Block(receivingBlockId))).getNumExpectedLocations() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((this.bm.getStoredBlock(new Block(receivingReceivedBlockId)).findStorageInfo(ds) >= 0 ? 1 : 0) != 0);
        Assert.assertNull((Object)this.bm.getStoredBlock(new Block(ReceivedDeletedBlockId)));
        Assert.assertTrue((this.bm.getStoredBlock(new Block((Block)existedBlock)).findStorageInfo(ds) >= 0 ? 1 : 0) != 0);
    }

    private BlockInfoContiguous addBlockToBM(long blkId) {
        Block block = new Block(blkId);
        BlockInfoContiguous blockInfo = new BlockInfoContiguous(block, 3);
        BlockCollection bc = (BlockCollection)Mockito.mock(BlockCollection.class);
        ((BlockCollection)Mockito.doReturn((Object)3).when((Object)bc)).getBlockReplication();
        this.bm.blocksMap.addBlockCollection(blockInfo, bc);
        return blockInfo;
    }

    private BlockInfoContiguous addUcBlockToBM(long blkId) {
        Block block = new Block(blkId);
        BlockInfoContiguousUnderConstruction blockInfo = new BlockInfoContiguousUnderConstruction(block, 3);
        BlockCollection bc = (BlockCollection)Mockito.mock(BlockCollection.class);
        ((BlockCollection)Mockito.doReturn((Object)3).when((Object)bc)).getBlockReplication();
        this.bm.blocksMap.addBlockCollection((BlockInfoContiguous)blockInfo, bc);
        return blockInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStorageWithRemainingCapacity() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).build();
        FileSystem fs = FileSystem.get((Configuration)conf);
        Path file1 = null;
        try {
            cluster.waitActive();
            FSNamesystem namesystem = cluster.getNamesystem();
            String poolId = namesystem.getBlockPoolId();
            DatanodeRegistration nodeReg = DataNodeTestUtils.getDNRegistrationForBP(cluster.getDataNodes().get(0), poolId);
            DatanodeDescriptor dd = NameNodeAdapter.getDatanode(namesystem, (DatanodeID)nodeReg);
            for (DatanodeStorageInfo storage : dd.getStorageInfos()) {
                storage.setUtilizationForTesting(65536L, 0L, 65536L, 0L);
            }
            dd.setRemaining(131072L);
            file1 = new Path("testRemainingStorage.dat");
            try {
                DFSTestUtil.createFile(fs, file1, 102400, 102400L, 102400L, (short)1, 464346861L);
            }
            catch (RemoteException re) {
                GenericTestUtils.assertExceptionContains((String)"nodes instead of minReplication", (Throwable)re);
            }
        }
        catch (Throwable throwable) {
            Assert.assertTrue((boolean)fs.exists(file1));
            fs.delete(file1, true);
            Assert.assertTrue((!fs.exists(file1) ? 1 : 0) != 0);
            cluster.shutdown();
            throw throwable;
        }
        Assert.assertTrue((boolean)fs.exists(file1));
        fs.delete(file1, true);
        Assert.assertTrue((!fs.exists(file1) ? 1 : 0) != 0);
        cluster.shutdown();
    }

    @Test
    public void testUseDelHint() {
        DatanodeStorageInfo delHint = new DatanodeStorageInfo(DFSTestUtil.getLocalDatanodeDescriptor(), new DatanodeStorage("id"));
        List<DatanodeStorageInfo> moreThan1Racks = Arrays.asList(delHint);
        ArrayList<StorageType> excessTypes = new ArrayList<StorageType>();
        excessTypes.add(StorageType.DEFAULT);
        Assert.assertTrue((boolean)BlockPlacementPolicyDefault.useDelHint((boolean)true, (DatanodeStorageInfo)delHint, null, moreThan1Racks, excessTypes));
        excessTypes.remove(0);
        excessTypes.add(StorageType.SSD);
        Assert.assertFalse((boolean)BlockPlacementPolicyDefault.useDelHint((boolean)true, (DatanodeStorageInfo)delHint, null, moreThan1Racks, excessTypes));
    }

    @Test
    public void testAllReplicasOnSameRack() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.unset("net.topology.script.file.name");
        this.fsn = (FSNamesystem)Mockito.mock(FSNamesystem.class);
        ((FSNamesystem)Mockito.doReturn((Object)true).when((Object)this.fsn)).hasWriteLock();
        ((FSNamesystem)Mockito.doReturn((Object)true).when((Object)this.fsn)).hasReadLock();
        this.bm = new BlockManager((Namesystem)this.fsn, (Configuration)conf);
        this.addNodes(this.nodes);
        BlockInfoContiguous blockInfo = this.addBlockOnNodes(1L, this.rackA);
        Assert.assertFalse((String)"Replicas for block is not stored on enough racks", (boolean)this.bm.isPlacementPolicySatisfied((Block)blockInfo));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBlockReportQueueing() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).build();
        try {
            cluster.waitActive();
            FSNamesystem fsn = cluster.getNamesystem();
            final BlockManager bm = fsn.getBlockManager();
            ExecutorService executor = Executors.newCachedThreadPool();
            final CyclicBarrier startBarrier = new CyclicBarrier(2);
            final CountDownLatch endLatch = new CountDownLatch(3);
            FutureTask<Void> blockingOp = new FutureTask<Void>(new Callable<Void>(){

                @Override
                public Void call() throws IOException {
                    return (Void)bm.runBlockOp((Callable)new Callable<Void>(){

                        @Override
                        public Void call() throws InterruptedException, BrokenBarrierException {
                            startBarrier.await();
                            endLatch.countDown();
                            return null;
                        }
                    });
                }
            });
            Callable<Void> asyncOp = new Callable<Void>(){

                @Override
                public Void call() throws IOException {
                    bm.enqueueBlockOp(new Runnable(){

                        @Override
                        public void run() {
                            endLatch.countDown();
                        }
                    });
                    return null;
                }
            };
            Future<?> blockedFuture = executor.submit(blockingOp);
            boolean isBlocked = false;
            try {
                blockedFuture.get(1L, TimeUnit.SECONDS);
            }
            catch (TimeoutException te) {
                isBlocked = true;
            }
            Assert.assertTrue((boolean)isBlocked);
            executor.submit(asyncOp).get(1L, TimeUnit.SECONDS);
            executor.submit(asyncOp).get(1L, TimeUnit.SECONDS);
            Assert.assertEquals((long)2L, (long)bm.getBlockOpQueueLength());
            Assert.assertFalse((boolean)blockedFuture.isDone());
            startBarrier.await(1L, TimeUnit.SECONDS);
            Assert.assertTrue((boolean)endLatch.await(1L, TimeUnit.SECONDS));
            Assert.assertEquals((long)0L, (long)bm.getBlockOpQueueLength());
            Assert.assertTrue((boolean)blockingOp.isDone());
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAsyncIBR() throws Exception {
        Logger.getRootLogger().setLevel(Level.WARN);
        int blkSize = 4096;
        int fileSize = 409600;
        final byte[] buf = new byte[8192];
        int numWriters = 4;
        int repl = 3;
        final CyclicBarrier barrier = new CyclicBarrier(4);
        final CountDownLatch writeLatch = new CountDownLatch(4);
        final AtomicBoolean failure = new AtomicBoolean();
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.getLong("dfs.namenode.fs-limits.min-block-size", 4096L);
        final MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(8).build();
        try {
            MetricsRecordBuilder rb;
            cluster.waitActive();
            Thread[] writers = new Thread[4];
            for (int i = 0; i < writers.length; ++i) {
                final Path p = new Path("/writer" + i);
                writers[i] = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            DistributedFileSystem fs = cluster.getFileSystem();
                            FSDataOutputStream os = fs.create(p, true, buf.length, (short)3, 4096L);
                            barrier.await();
                            for (int remaining = 409600; remaining > 0; remaining -= buf.length) {
                                os.write(buf);
                            }
                            os.close();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            failure.set(true);
                        }
                        writeLatch.countDown();
                    }
                });
                writers[i].start();
            }
            boolean sawQueued = false;
            while (!writeLatch.await(10L, TimeUnit.MILLISECONDS)) {
                Assert.assertFalse((boolean)failure.get());
                rb = MetricsAsserts.getMetrics((String)"NameNodeActivity");
                long queued = MetricsAsserts.getIntGauge((String)"BlockOpsQueued", (MetricsRecordBuilder)rb);
                sawQueued |= queued > 0L;
            }
            Assert.assertFalse((boolean)failure.get());
            Assert.assertTrue((boolean)sawQueued);
            rb = MetricsAsserts.getMetrics((String)"NameNodeActivity");
            long batched = MetricsAsserts.getLongCounter((String)"BlockOpsBatched", (MetricsRecordBuilder)rb);
            Assert.assertTrue((batched > 0L ? 1 : 0) != 0);
        }
        finally {
            cluster.shutdown();
        }
    }
}

