/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.FileNotFoundException;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.namenode.FSDirectory;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeDirectory;
import org.apache.hadoop.hdfs.server.namenode.INodeFile;
import org.apache.hadoop.hdfs.server.namenode.INodesInPath;
import org.apache.hadoop.hdfs.server.namenode.snapshot.Snapshot;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestSnapshotPathINodes {
    private static final long seed = 0L;
    private static final short REPLICATION = 3;
    private static final Path dir = new Path("/TestSnapshot");
    private static final Path sub1 = new Path(dir, "sub1");
    private static final Path file1 = new Path(sub1, "file1");
    private static final Path file2 = new Path(sub1, "file2");
    private static MiniDFSCluster cluster;
    private static FSDirectory fsdir;
    private static DistributedFileSystem hdfs;

    @BeforeClass
    public static void setUp() throws Exception {
        Configuration conf = new Configuration();
        cluster = new MiniDFSCluster.Builder(conf).numDataNodes(3).build();
        cluster.waitActive();
        FSNamesystem fsn = cluster.getNamesystem();
        fsdir = fsn.getFSDirectory();
        hdfs = cluster.getFileSystem();
    }

    @Before
    public void reset() throws Exception {
        DFSTestUtil.createFile((FileSystem)hdfs, file1, 1024L, (short)3, 0L);
        DFSTestUtil.createFile((FileSystem)hdfs, file2, 1024L, (short)3, 0L);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        if (cluster != null) {
            cluster.shutdown();
        }
    }

    @Test(timeout=15000L)
    public void testAllowSnapshot() throws Exception {
        String pathStr = sub1.toString();
        INode before = fsdir.getINode(pathStr);
        Assert.assertFalse((boolean)before.asDirectory().isSnapshottable());
        Path path = new Path(pathStr);
        hdfs.allowSnapshot(path);
        INode after = fsdir.getINode(pathStr);
        Assert.assertTrue((boolean)after.asDirectory().isSnapshottable());
        hdfs.disallowSnapshot(path);
        after = fsdir.getINode(pathStr);
        Assert.assertFalse((boolean)after.asDirectory().isSnapshottable());
    }

    static Snapshot getSnapshot(INodesInPath inodesInPath, String name, int index) {
        if (name == null) {
            return null;
        }
        INode inode = inodesInPath.getINode(index - 1);
        return inode.asDirectory().getSnapshot(DFSUtil.string2Bytes((String)name));
    }

    static void assertSnapshot(INodesInPath inodesInPath, boolean isSnapshot, Snapshot snapshot, int index) {
        Assert.assertEquals((Object)isSnapshot, (Object)inodesInPath.isSnapshot());
        Assert.assertEquals((long)Snapshot.getSnapshotId((Snapshot)(isSnapshot ? snapshot : null)), (long)inodesInPath.getPathSnapshotId());
        if (!isSnapshot) {
            Assert.assertEquals((long)Snapshot.getSnapshotId((Snapshot)snapshot), (long)inodesInPath.getLatestSnapshotId());
        }
        if (isSnapshot && index >= 0) {
            Assert.assertEquals(Snapshot.Root.class, inodesInPath.getINode(index).getClass());
        }
    }

    static void assertINodeFile(INode inode, Path path) {
        Assert.assertEquals((Object)path.getName(), (Object)inode.getLocalName());
        Assert.assertEquals(INodeFile.class, inode.getClass());
    }

    @Test(timeout=15000L)
    public void testNonSnapshotPathINodes() throws Exception {
        String[] names = INode.getPathNames((String)file1.toString());
        byte[][] components = INode.getPathComponents((String[])names);
        INodesInPath nodesInPath = INodesInPath.resolve((INodeDirectory)TestSnapshotPathINodes.fsdir.rootDir, (byte[][])components, (boolean)false);
        Assert.assertEquals((long)nodesInPath.length(), (long)components.length);
        TestSnapshotPathINodes.assertSnapshot(nodesInPath, false, null, -1);
        Assert.assertTrue((String)("file1=" + file1 + ", nodesInPath=" + nodesInPath), (nodesInPath.getINode(components.length - 1) != null ? 1 : 0) != 0);
        Assert.assertEquals((Object)nodesInPath.getINode(components.length - 1).getFullPathName(), (Object)file1.toString());
        Assert.assertEquals((Object)nodesInPath.getINode(components.length - 2).getFullPathName(), (Object)sub1.toString());
        Assert.assertEquals((Object)nodesInPath.getINode(components.length - 3).getFullPathName(), (Object)dir.toString());
        nodesInPath = INodesInPath.resolve((INodeDirectory)TestSnapshotPathINodes.fsdir.rootDir, (byte[][])components, (boolean)false);
        Assert.assertEquals((long)nodesInPath.length(), (long)components.length);
        TestSnapshotPathINodes.assertSnapshot(nodesInPath, false, null, -1);
        Assert.assertEquals((Object)nodesInPath.getLastINode().getFullPathName(), (Object)file1.toString());
    }

    @Test(timeout=15000L)
    public void testSnapshotPathINodes() throws Exception {
        hdfs.allowSnapshot(sub1);
        hdfs.createSnapshot(sub1, "s1");
        String snapshotPath = sub1.toString() + "/.snapshot/s1/file1";
        String[] names = INode.getPathNames((String)snapshotPath);
        byte[][] components = INode.getPathComponents((String[])names);
        INodesInPath nodesInPath = INodesInPath.resolve((INodeDirectory)TestSnapshotPathINodes.fsdir.rootDir, (byte[][])components, (boolean)false);
        Assert.assertEquals((long)nodesInPath.length(), (long)(components.length - 1));
        Snapshot snapshot = TestSnapshotPathINodes.getSnapshot(nodesInPath, "s1", 3);
        TestSnapshotPathINodes.assertSnapshot(nodesInPath, true, snapshot, 3);
        INode snapshotFileNode = nodesInPath.getLastINode();
        TestSnapshotPathINodes.assertINodeFile(snapshotFileNode, file1);
        Assert.assertTrue((boolean)snapshotFileNode.getParent().isWithSnapshot());
        nodesInPath = INodesInPath.resolve((INodeDirectory)TestSnapshotPathINodes.fsdir.rootDir, (byte[][])components, (boolean)false);
        Assert.assertEquals((long)nodesInPath.length(), (long)(components.length - 1));
        TestSnapshotPathINodes.assertSnapshot(nodesInPath, true, snapshot, 3);
        TestSnapshotPathINodes.assertINodeFile(nodesInPath.getLastINode(), file1);
        String dotSnapshotPath = sub1.toString() + "/.snapshot";
        names = INode.getPathNames((String)dotSnapshotPath);
        components = INode.getPathComponents((String[])names);
        nodesInPath = INodesInPath.resolve((INodeDirectory)TestSnapshotPathINodes.fsdir.rootDir, (byte[][])components, (boolean)false);
        Assert.assertEquals((long)nodesInPath.length(), (long)components.length);
        TestSnapshotPathINodes.assertSnapshot(nodesInPath, true, snapshot, -1);
        Assert.assertNull((Object)nodesInPath.getLastINode());
        Assert.assertEquals((Object)nodesInPath.getINode(-2).getFullPathName(), (Object)sub1.toString());
        Assert.assertTrue((boolean)nodesInPath.getINode(-2).isDirectory());
        String[] invalidPathComponent = new String[]{"invalidDir", "foo", ".snapshot", "bar"};
        Path invalidPath = new Path(invalidPathComponent[0]);
        for (int i = 1; i < invalidPathComponent.length; ++i) {
            invalidPath = new Path(invalidPath, invalidPathComponent[i]);
            try {
                hdfs.getFileStatus(invalidPath);
                Assert.fail();
                continue;
            }
            catch (FileNotFoundException fnfe) {
                System.out.println("The exception is expected: " + fnfe);
            }
        }
        hdfs.deleteSnapshot(sub1, "s1");
        hdfs.disallowSnapshot(sub1);
    }

    @Test(timeout=15000L)
    public void testSnapshotPathINodesAfterDeletion() throws Exception {
        hdfs.allowSnapshot(sub1);
        hdfs.createSnapshot(sub1, "s2");
        hdfs.delete(file1, false);
        String snapshotPath = sub1.toString() + "/.snapshot/s2/file1";
        String[] names = INode.getPathNames((String)snapshotPath);
        byte[][] components = INode.getPathComponents((String[])names);
        INodesInPath nodesInPath = INodesInPath.resolve((INodeDirectory)TestSnapshotPathINodes.fsdir.rootDir, (byte[][])components, (boolean)false);
        Assert.assertEquals((long)nodesInPath.length(), (long)(components.length - 1));
        Snapshot snapshot = TestSnapshotPathINodes.getSnapshot(nodesInPath, "s2", 3);
        TestSnapshotPathINodes.assertSnapshot(nodesInPath, true, snapshot, 3);
        INode inode = nodesInPath.getLastINode();
        Assert.assertEquals((Object)file1.getName(), (Object)inode.getLocalName());
        Assert.assertTrue((boolean)inode.asFile().isWithSnapshot());
        String[] names2 = INode.getPathNames((String)file1.toString());
        byte[][] components2 = INode.getPathComponents((String[])names2);
        INodesInPath nodesInPath2 = INodesInPath.resolve((INodeDirectory)TestSnapshotPathINodes.fsdir.rootDir, (byte[][])components2, (boolean)false);
        Assert.assertEquals((long)nodesInPath2.length(), (long)components2.length);
        Assert.assertEquals((long)this.getNumNonNull(nodesInPath2), (long)(components2.length - 1));
        TestSnapshotPathINodes.assertSnapshot(nodesInPath2, false, snapshot, -1);
        Assert.assertNull((Object)nodesInPath2.getINode(components2.length - 1));
        Assert.assertEquals((Object)nodesInPath2.getINode(components2.length - 2).getFullPathName(), (Object)sub1.toString());
        Assert.assertEquals((Object)nodesInPath2.getINode(components2.length - 3).getFullPathName(), (Object)dir.toString());
        hdfs.deleteSnapshot(sub1, "s2");
        hdfs.disallowSnapshot(sub1);
    }

    private int getNumNonNull(INodesInPath iip) {
        List inodes = iip.getReadOnlyINodes();
        for (int i = inodes.size() - 1; i >= 0; --i) {
            if (inodes.get(i) == null) continue;
            return i + 1;
        }
        return 0;
    }

    @Test(timeout=15000L)
    public void testSnapshotPathINodesWithAddedFile() throws Exception {
        hdfs.allowSnapshot(sub1);
        hdfs.createSnapshot(sub1, "s4");
        Path file3 = new Path(sub1, "file3");
        DFSTestUtil.createFile((FileSystem)hdfs, file3, 1024L, (short)3, 0L);
        String snapshotPath = sub1.toString() + "/.snapshot/s4/file3";
        String[] names = INode.getPathNames((String)snapshotPath);
        byte[][] components = INode.getPathComponents((String[])names);
        INodesInPath nodesInPath = INodesInPath.resolve((INodeDirectory)TestSnapshotPathINodes.fsdir.rootDir, (byte[][])components, (boolean)false);
        Assert.assertEquals((long)nodesInPath.length(), (long)(components.length - 1));
        Assert.assertEquals((long)this.getNumNonNull(nodesInPath), (long)(components.length - 2));
        Snapshot s4 = TestSnapshotPathINodes.getSnapshot(nodesInPath, "s4", 3);
        TestSnapshotPathINodes.assertSnapshot(nodesInPath, true, s4, 3);
        Assert.assertNull((Object)nodesInPath.getINode(nodesInPath.length() - 1));
        String[] names2 = INode.getPathNames((String)file3.toString());
        byte[][] components2 = INode.getPathComponents((String[])names2);
        INodesInPath nodesInPath2 = INodesInPath.resolve((INodeDirectory)TestSnapshotPathINodes.fsdir.rootDir, (byte[][])components2, (boolean)false);
        Assert.assertEquals((long)nodesInPath2.length(), (long)components2.length);
        TestSnapshotPathINodes.assertSnapshot(nodesInPath2, false, s4, -1);
        Assert.assertEquals((Object)nodesInPath2.getINode(components2.length - 1).getFullPathName(), (Object)file3.toString());
        Assert.assertEquals((Object)nodesInPath2.getINode(components2.length - 2).getFullPathName(), (Object)sub1.toString());
        Assert.assertEquals((Object)nodesInPath2.getINode(components2.length - 3).getFullPathName(), (Object)dir.toString());
        hdfs.deleteSnapshot(sub1, "s4");
        hdfs.disallowSnapshot(sub1);
    }

    @Test(timeout=15000L)
    public void testSnapshotPathINodesAfterModification() throws Exception {
        String[] names = INode.getPathNames((String)file1.toString());
        byte[][] components = INode.getPathComponents((String[])names);
        INodesInPath nodesInPath = INodesInPath.resolve((INodeDirectory)TestSnapshotPathINodes.fsdir.rootDir, (byte[][])components, (boolean)false);
        Assert.assertEquals((long)nodesInPath.length(), (long)components.length);
        Assert.assertEquals((Object)nodesInPath.getINode(components.length - 1).getFullPathName(), (Object)file1.toString());
        long modTime = nodesInPath.getINode(nodesInPath.length() - 1).getModificationTime();
        hdfs.allowSnapshot(sub1);
        hdfs.createSnapshot(sub1, "s3");
        DFSTestUtil.appendFile((FileSystem)hdfs, file1, "the content for appending");
        String snapshotPath = sub1.toString() + "/.snapshot/s3/file1";
        names = INode.getPathNames((String)snapshotPath);
        components = INode.getPathComponents((String[])names);
        INodesInPath ssNodesInPath = INodesInPath.resolve((INodeDirectory)TestSnapshotPathINodes.fsdir.rootDir, (byte[][])components, (boolean)false);
        Assert.assertEquals((long)ssNodesInPath.length(), (long)(components.length - 1));
        Snapshot s3 = TestSnapshotPathINodes.getSnapshot(ssNodesInPath, "s3", 3);
        TestSnapshotPathINodes.assertSnapshot(ssNodesInPath, true, s3, 3);
        INode snapshotFileNode = ssNodesInPath.getLastINode();
        Assert.assertEquals((Object)snapshotFileNode.getLocalName(), (Object)file1.getName());
        Assert.assertTrue((boolean)snapshotFileNode.asFile().isWithSnapshot());
        Assert.assertEquals((long)modTime, (long)snapshotFileNode.getModificationTime(ssNodesInPath.getPathSnapshotId()));
        names = INode.getPathNames((String)file1.toString());
        components = INode.getPathComponents((String[])names);
        INodesInPath newNodesInPath = INodesInPath.resolve((INodeDirectory)TestSnapshotPathINodes.fsdir.rootDir, (byte[][])components, (boolean)false);
        TestSnapshotPathINodes.assertSnapshot(newNodesInPath, false, s3, -1);
        Assert.assertEquals((long)newNodesInPath.length(), (long)components.length);
        int last = components.length - 1;
        Assert.assertEquals((Object)newNodesInPath.getINode(last).getFullPathName(), (Object)file1.toString());
        Assert.assertFalse((modTime == newNodesInPath.getINode(last).getModificationTime() ? 1 : 0) != 0);
        hdfs.deleteSnapshot(sub1, "s3");
        hdfs.disallowSnapshot(sub1);
    }
}

