/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.BlockReaderTestUtil;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.junit.Assert;
import org.junit.Test;

public class TestDisableConnCache {
    static final Log LOG = LogFactory.getLog(TestDisableConnCache.class);
    static final int BLOCK_SIZE = 4096;
    static final int FILE_SIZE = 12288;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDisableCache() throws Exception {
        HdfsConfiguration confWithoutCache = new HdfsConfiguration();
        confWithoutCache.setInt("dfs.client.socketcache.capacity", 0);
        BlockReaderTestUtil util = new BlockReaderTestUtil(1, confWithoutCache);
        Path testFile = new Path("/testConnCache.dat");
        util.writeFile(testFile, 12);
        FileSystem fsWithoutCache = FileSystem.newInstance((Configuration)util.getConf());
        try {
            DFSTestUtil.readFile(fsWithoutCache, testFile);
            Assert.assertEquals((long)0L, (long)((DistributedFileSystem)fsWithoutCache).dfs.getClientContext().getPeerCache().size());
        }
        finally {
            fsWithoutCache.close();
            util.shutdown();
        }
    }
}

