/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import java.io.IOException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockIdManager;
import org.apache.hadoop.hdfs.server.blockmanagement.SequentialBlockIdGenerator;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestSequentialBlockId {
    private static final Log LOG = LogFactory.getLog((String)"TestSequentialBlockId");
    final int BLOCK_SIZE = 1024;
    final int IO_SIZE = 1024;
    final short REPLICATION = 1;
    final long SEED = 0L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBlockIdGeneration() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setInt("dfs.replication", 1);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).build();
        try {
            cluster.waitActive();
            DistributedFileSystem fs = cluster.getFileSystem();
            Path path = new Path("testBlockIdGeneration.dat");
            DFSTestUtil.createFile((FileSystem)fs, path, 1024, 10240L, 1024L, (short)1, 0L);
            List<LocatedBlock> blocks = DFSTestUtil.getAllBlocks((FileSystem)fs, path);
            LOG.info((Object)("Block0 id is " + blocks.get(0).getBlock().getBlockId()));
            long nextBlockExpectedId = blocks.get(0).getBlock().getBlockId() + 1L;
            for (int i = 1; i < blocks.size(); ++i) {
                long nextBlockId = blocks.get(i).getBlock().getBlockId();
                LOG.info((Object)("Block" + i + " id is " + nextBlockId));
                Assert.assertThat((Object)nextBlockId, (Matcher)CoreMatchers.is((Object)nextBlockExpectedId));
                ++nextBlockExpectedId;
            }
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTriggerBlockIdCollision() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setInt("dfs.replication", 1);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).build();
        try {
            cluster.waitActive();
            DistributedFileSystem fs = cluster.getFileSystem();
            FSNamesystem fsn = cluster.getNamesystem();
            int blockCount = 10;
            Path path1 = new Path("testBlockIdCollisionDetection_file1.dat");
            DFSTestUtil.createFile((FileSystem)fs, path1, 1024, 10240L, 1024L, (short)1, 0L);
            List<LocatedBlock> blocks1 = DFSTestUtil.getAllBlocks((FileSystem)fs, path1);
            SequentialBlockIdGenerator blockIdGenerator = fsn.getBlockIdManager().getBlockIdGenerator();
            blockIdGenerator.setCurrentValue(blockIdGenerator.getCurrentValue() - 5L);
            Path path2 = new Path("testBlockIdCollisionDetection_file2.dat");
            DFSTestUtil.createFile((FileSystem)fs, path2, 1024, 10240L, 1024L, (short)1, 0L);
            List<LocatedBlock> blocks2 = DFSTestUtil.getAllBlocks((FileSystem)fs, path2);
            Assert.assertThat((Object)blocks2.size(), (Matcher)CoreMatchers.is((Object)10));
            Assert.assertThat((Object)blocks2.get(0).getBlock().getBlockId(), (Matcher)CoreMatchers.is((Object)(blocks1.get(9).getBlock().getBlockId() + 1L)));
        }
        finally {
            cluster.shutdown();
        }
    }

    @Test
    public void testBlockTypeDetection() throws IOException {
        BlockIdManager bid = (BlockIdManager)Mockito.mock(BlockIdManager.class);
        long maxGenStampForLegacyBlocks = 10000L;
        Mockito.when((Object)bid.getGenerationStampV1Limit()).thenReturn((Object)10000L);
        Block legacyBlock = (Block)Mockito.spy((Object)new Block());
        Mockito.when((Object)legacyBlock.getGenerationStamp()).thenReturn((Object)5000L);
        Block newBlock = (Block)Mockito.spy((Object)new Block());
        Mockito.when((Object)newBlock.getGenerationStamp()).thenReturn((Object)10001L);
        Mockito.when((Object)bid.isLegacyBlock((Block)Mockito.any(Block.class))).thenCallRealMethod();
        Assert.assertThat((Object)bid.isLegacyBlock(legacyBlock), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)bid.isLegacyBlock(newBlock), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void testGenerationStampUpdate() throws IOException {
        BlockIdManager bid = (BlockIdManager)Mockito.mock(BlockIdManager.class);
        long nextGenerationStampV1 = 5000L;
        long nextGenerationStampV2 = 20000L;
        Mockito.when((Object)bid.getNextGenerationStampV1()).thenReturn((Object)5000L);
        Mockito.when((Object)bid.getNextGenerationStampV2()).thenReturn((Object)20000L);
        Mockito.when((Object)bid.nextGenerationStamp(Mockito.anyBoolean())).thenCallRealMethod();
        Assert.assertThat((Object)bid.nextGenerationStamp(true), (Matcher)CoreMatchers.is((Object)5000L));
        Assert.assertThat((Object)bid.nextGenerationStamp(false), (Matcher)CoreMatchers.is((Object)20000L));
    }
}

