/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import com.google.common.base.Supplier;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.BlockListAsLongs;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.DataNodeTestUtils;
import org.apache.hadoop.hdfs.server.protocol.BlockReportContext;
import org.apache.hadoop.hdfs.server.protocol.DatanodeCommand;
import org.apache.hadoop.hdfs.server.protocol.DatanodeRegistration;
import org.apache.hadoop.hdfs.server.protocol.DatanodeStorage;
import org.apache.hadoop.hdfs.server.protocol.NamenodeProtocols;
import org.apache.hadoop.hdfs.server.protocol.ReceivedDeletedBlockInfo;
import org.apache.hadoop.hdfs.server.protocol.RegisterCommand;
import org.apache.hadoop.hdfs.server.protocol.StorageBlockReport;
import org.apache.hadoop.hdfs.server.protocol.StorageReceivedDeletedBlocks;
import org.apache.hadoop.hdfs.server.protocol.StorageReport;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class TestDeadDatanode {
    private static final Log LOG = LogFactory.getLog(TestDeadDatanode.class);
    private MiniDFSCluster cluster;

    @After
    public void cleanup() {
        this.cluster.shutdown();
    }

    @Test
    public void testDeadDatanode() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setInt("dfs.namenode.heartbeat.recheck-interval", 500);
        conf.setLong("dfs.heartbeat.interval", 1L);
        this.cluster = new MiniDFSCluster.Builder((Configuration)conf).build();
        this.cluster.waitActive();
        String poolId = this.cluster.getNamesystem().getBlockPoolId();
        DataNode dn = this.cluster.getDataNodes().get(0);
        DatanodeRegistration reg = DataNodeTestUtils.getDNRegistrationForBP(this.cluster.getDataNodes().get(0), poolId);
        DFSTestUtil.waitForDatanodeState(this.cluster, reg.getDatanodeUuid(), true, 20000);
        dn.shutdown();
        DFSTestUtil.waitForDatanodeState(this.cluster, reg.getDatanodeUuid(), false, 20000);
        NamenodeProtocols dnp = this.cluster.getNameNodeRpc();
        ReceivedDeletedBlockInfo[] blocks = new ReceivedDeletedBlockInfo[]{new ReceivedDeletedBlockInfo(new Block(0L), ReceivedDeletedBlockInfo.BlockStatus.RECEIVED_BLOCK, null)};
        StorageReceivedDeletedBlocks[] storageBlocks = new StorageReceivedDeletedBlocks[]{new StorageReceivedDeletedBlocks(reg.getDatanodeUuid(), blocks)};
        dnp.blockReceivedAndDeleted(reg, poolId, storageBlocks);
        BlockManager bm = this.cluster.getNamesystem().getBlockManager();
        bm.flushBlockOps();
        Assert.assertFalse((boolean)bm.getDatanodeManager().getDatanode((DatanodeID)reg).isRegistered());
        StorageBlockReport[] report = new StorageBlockReport[]{new StorageBlockReport(new DatanodeStorage(reg.getDatanodeUuid()), BlockListAsLongs.EMPTY)};
        try {
            dnp.blockReport(reg, poolId, report, new BlockReportContext(1, 0, System.nanoTime()));
            Assert.fail((String)"Expected IOException is not thrown");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        StorageReport[] rep = new StorageReport[]{new StorageReport(new DatanodeStorage(reg.getDatanodeUuid()), false, 0L, 0L, 0L, 0L, 0L)};
        DatanodeCommand[] cmd = dnp.sendHeartbeat(reg, rep, 0L, 0L, 0, 0, 0, null).getCommands();
        Assert.assertEquals((long)1L, (long)cmd.length);
        Assert.assertEquals((long)cmd[0].getAction(), (long)RegisterCommand.REGISTER.getAction());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNonDFSUsedONDeadNodeReReg() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setInt("dfs.heartbeat.interval", 1);
        conf.setInt("dfs.namenode.heartbeat.recheck-interval", 1);
        conf.setInt("dfs.namenode.stale.datanode.interval", 6000);
        try {
            this.cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(2).build();
            long initialCapacity = this.cluster.getNamesystem(0).getCapacityTotal();
            Assert.assertTrue((initialCapacity > 0L ? 1 : 0) != 0);
            DataNode dn1 = this.cluster.getDataNodes().get(0);
            DataNode dn2 = this.cluster.getDataNodes().get(1);
            DatanodeDescriptor dn2Desc = this.cluster.getNamesystem(0).getBlockManager().getDatanodeManager().getDatanode(dn2.getDatanodeId());
            dn1.setHeartbeatsDisabledForTests(true);
            this.cluster.setDataNodeDead(dn1.getDatanodeId());
            Assert.assertEquals((String)"Capacity shouldn't include DeadNode", (long)dn2Desc.getCapacity(), (long)this.cluster.getNamesystem(0).getCapacityTotal());
            Assert.assertEquals((String)"NonDFS-used shouldn't include DeadNode", (long)dn2Desc.getNonDfsUsed(), (long)this.cluster.getNamesystem(0).getNonDfsUsedSpace());
            dn1.setHeartbeatsDisabledForTests(false);
            final DatanodeDescriptor dn1Desc = this.cluster.getNamesystem(0).getBlockManager().getDatanodeManager().getDatanode(dn1.getDatanodeId());
            GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

                public Boolean get() {
                    return dn1Desc.isAlive && dn1Desc.isHeartbeatedSinceRegistration();
                }
            }, (int)100, (int)5000);
            Assert.assertEquals((String)"Capacity should be 0 after all DNs dead", (long)initialCapacity, (long)this.cluster.getNamesystem(0).getCapacityTotal());
            long nonDFSAfterReg = this.cluster.getNamesystem(0).getNonDfsUsedSpace();
            Assert.assertEquals((String)"NonDFS should include actual DN NonDFSUsed", (long)(dn1Desc.getNonDfsUsed() + dn2Desc.getNonDfsUsed()), (long)nonDFSAfterReg);
        }
        finally {
            if (this.cluster != null) {
                this.cluster.shutdown();
            }
        }
    }
}

