/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.startupprogress;

import org.apache.hadoop.hdfs.server.namenode.startupprogress.Phase;
import org.apache.hadoop.hdfs.server.namenode.startupprogress.StartupProgress;
import org.apache.hadoop.hdfs.server.namenode.startupprogress.Step;
import org.apache.hadoop.hdfs.server.namenode.startupprogress.StepType;

public class StartupProgressTestHelper {
    public static void incrementCounter(StartupProgress prog, Phase phase, Step step, long delta) {
        StartupProgress.Counter counter = prog.getCounter(phase, step);
        for (long i = 0L; i < delta; ++i) {
            counter.increment();
        }
    }

    public static void setStartupProgressForRunningState(StartupProgress prog) {
        prog.beginPhase(Phase.LOADING_FSIMAGE);
        Step loadingFsImageInodes = new Step(StepType.INODES);
        prog.beginStep(Phase.LOADING_FSIMAGE, loadingFsImageInodes);
        prog.setTotal(Phase.LOADING_FSIMAGE, loadingFsImageInodes, 100L);
        StartupProgressTestHelper.incrementCounter(prog, Phase.LOADING_FSIMAGE, loadingFsImageInodes, 100L);
        prog.endStep(Phase.LOADING_FSIMAGE, loadingFsImageInodes);
        prog.endPhase(Phase.LOADING_FSIMAGE);
        prog.beginPhase(Phase.LOADING_EDITS);
        Step loadingEditsFile = new Step("file", 1000L);
        prog.beginStep(Phase.LOADING_EDITS, loadingEditsFile);
        prog.setTotal(Phase.LOADING_EDITS, loadingEditsFile, 200L);
        StartupProgressTestHelper.incrementCounter(prog, Phase.LOADING_EDITS, loadingEditsFile, 100L);
    }

    public static void setStartupProgressForFinalState(StartupProgress prog) {
        prog.beginPhase(Phase.LOADING_FSIMAGE);
        Step loadingFsImageInodes = new Step(StepType.INODES);
        prog.beginStep(Phase.LOADING_FSIMAGE, loadingFsImageInodes);
        prog.setTotal(Phase.LOADING_FSIMAGE, loadingFsImageInodes, 100L);
        StartupProgressTestHelper.incrementCounter(prog, Phase.LOADING_FSIMAGE, loadingFsImageInodes, 100L);
        prog.endStep(Phase.LOADING_FSIMAGE, loadingFsImageInodes);
        prog.endPhase(Phase.LOADING_FSIMAGE);
        prog.beginPhase(Phase.LOADING_EDITS);
        Step loadingEditsFile = new Step("file", 1000L);
        prog.beginStep(Phase.LOADING_EDITS, loadingEditsFile);
        prog.setTotal(Phase.LOADING_EDITS, loadingEditsFile, 200L);
        StartupProgressTestHelper.incrementCounter(prog, Phase.LOADING_EDITS, loadingEditsFile, 200L);
        prog.endStep(Phase.LOADING_EDITS, loadingEditsFile);
        prog.endPhase(Phase.LOADING_EDITS);
        prog.beginPhase(Phase.SAVING_CHECKPOINT);
        Step savingCheckpointInodes = new Step(StepType.INODES);
        prog.beginStep(Phase.SAVING_CHECKPOINT, savingCheckpointInodes);
        prog.setTotal(Phase.SAVING_CHECKPOINT, savingCheckpointInodes, 300L);
        StartupProgressTestHelper.incrementCounter(prog, Phase.SAVING_CHECKPOINT, savingCheckpointInodes, 300L);
        prog.endStep(Phase.SAVING_CHECKPOINT, savingCheckpointInodes);
        prog.endPhase(Phase.SAVING_CHECKPOINT);
        prog.beginPhase(Phase.SAFEMODE);
        Step awaitingBlocks = new Step(StepType.AWAITING_REPORTED_BLOCKS);
        prog.beginStep(Phase.SAFEMODE, awaitingBlocks);
        prog.setTotal(Phase.SAFEMODE, awaitingBlocks, 400L);
        StartupProgressTestHelper.incrementCounter(prog, Phase.SAFEMODE, awaitingBlocks, 400L);
        prog.endStep(Phase.SAFEMODE, awaitingBlocks);
        prog.endPhase(Phase.SAFEMODE);
    }
}

