/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.File;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.TestDFSUpgradeFromImage;
import org.junit.Test;

public class TestDatanodeLayoutUpgrade {
    private static final String HADOOP_DATANODE_DIR_TXT = "hadoop-datanode-dir.txt";
    private static final String HADOOP24_DATANODE = "hadoop-24-datanode-dir.tgz";
    private static final String HADOOP_56_DN_LAYOUT_TXT = "hadoop-to-57-dn-layout-dir.txt";
    private static final String HADOOP_56_DN_LAYOUT = "hadoop-56-layout-datanode-dir.tgz";

    @Test
    public void testUpgradeToIdBasedLayout() throws IOException {
        TestDFSUpgradeFromImage upgrade = new TestDFSUpgradeFromImage();
        upgrade.unpackStorage(HADOOP24_DATANODE, HADOOP_DATANODE_DIR_TXT);
        Configuration conf = new Configuration(TestDFSUpgradeFromImage.upgradeConf);
        conf.set("dfs.datanode.data.dir", new File(System.getProperty("test.build.data"), "dfs" + File.separator + "data").toURI().toString());
        conf.set("dfs.namenode.name.dir", new File(System.getProperty("test.build.data"), "dfs" + File.separator + "name").toURI().toString());
        upgrade.upgradeAndVerify(new MiniDFSCluster.Builder(conf).numDataNodes(1).manageDataDfsDirs(false).manageNameDfsDirs(false), null);
    }

    @Test
    public void testUpgradeFrom256To32Layout() throws IOException {
        TestDFSUpgradeFromImage upgrade = new TestDFSUpgradeFromImage();
        upgrade.unpackStorage(HADOOP_56_DN_LAYOUT, HADOOP_56_DN_LAYOUT_TXT);
        Configuration conf = new Configuration(TestDFSUpgradeFromImage.upgradeConf);
        conf.set("dfs.datanode.data.dir", new File(System.getProperty("test.build.data"), "dfs" + File.separator + "data").toURI().toString());
        conf.set("dfs.namenode.name.dir", new File(System.getProperty("test.build.data"), "dfs" + File.separator + "name").toURI().toString());
        upgrade.upgradeAndVerify(new MiniDFSCluster.Builder(conf).numDataNodes(1).manageDataDfsDirs(false).manageNameDfsDirs(false), null);
    }
}

