/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeoutException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.HardLink;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.AppendTestUtil;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DFSUtilClient;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.AlreadyBeingCreatedException;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.DataNodeTestUtils;
import org.apache.hadoop.hdfs.server.datanode.ReplicaBeingWritten;
import org.apache.hadoop.hdfs.server.datanode.ReplicaHandler;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsDatasetSpi;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.ReplicaOutputStreams;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsDatasetTestUtil;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsDatasetUtil;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.util.DataChecksum;
import org.apache.hadoop.util.Time;
import org.junit.Assert;
import org.junit.Test;

public class TestFileAppend {
    private static final long RANDOM_TEST_RUNTIME = 10000L;
    private static byte[] fileContents = null;
    static final DataChecksum DEFAULT_CHECKSUM = DataChecksum.newDataChecksum((DataChecksum.Type)DataChecksum.Type.CRC32C, (int)512);

    private void writeFile(FSDataOutputStream stm) throws IOException {
        byte[] buffer = AppendTestUtil.initBuffer(10241);
        stm.write(buffer);
    }

    private void checkFile(DistributedFileSystem fileSys, Path name, int repl) throws IOException {
        boolean done = false;
        block2: while (!done) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            done = true;
            BlockLocation[] locations = fileSys.getFileBlockLocations(fileSys.getFileStatus(name), 0L, 10241L);
            if (locations.length < 10) {
                System.out.println("Number of blocks found " + locations.length);
                done = false;
                continue;
            }
            for (int idx = 0; idx < 10; ++idx) {
                if (locations[idx].getHosts().length >= repl) continue;
                System.out.println("Block index " + idx + " not yet replciated.");
                done = false;
                continue block2;
            }
        }
        byte[] expected = new byte[10240];
        System.arraycopy(fileContents, 0, expected, 0, expected.length);
        AppendTestUtil.checkFullFile((FileSystem)fileSys, name, 10240, expected, "Read 1", false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBreakHardlinksIfNeeded() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).build();
        DistributedFileSystem fs = cluster.getFileSystem();
        InetSocketAddress addr = new InetSocketAddress("localhost", cluster.getNameNodePort());
        DFSClient client = new DFSClient(addr, (Configuration)conf);
        try {
            ExtendedBlock b;
            int i;
            Path file1 = new Path("/filestatus.dat");
            FSDataOutputStream stm = AppendTestUtil.createFile((FileSystem)fs, file1, 1);
            this.writeFile(stm);
            stm.close();
            DataNode[] dn = cluster.listDataNodes();
            Assert.assertTrue((String)("There should be only one datanode but found " + dn.length), (dn.length == 1 ? 1 : 0) != 0);
            LocatedBlocks locations = client.getNamenode().getBlockLocations(file1.toString(), 0L, Long.MAX_VALUE);
            List blocks = locations.getLocatedBlocks();
            FsDatasetSpi fsd = dn[0].getFSDataset();
            for (i = 0; i < blocks.size(); i += 2) {
                b = ((LocatedBlock)blocks.get(i)).getBlock();
                File f = FsDatasetTestUtil.getBlockFile(fsd, b.getBlockPoolId(), b.getLocalBlock());
                File link = new File(f.toString() + ".link");
                System.out.println("Creating hardlink for File " + f + " to " + link);
                HardLink.createHardLink((File)f, (File)link);
            }
            for (i = 0; i < blocks.size(); ++i) {
                b = ((LocatedBlock)blocks.get(i)).getBlock();
                System.out.println("breakHardlinksIfNeeded detaching block " + b);
                Assert.assertTrue((String)("breakHardlinksIfNeeded(" + b + ") should have returned true"), (boolean)FsDatasetTestUtil.breakHardlinksIfNeeded(fsd, b));
            }
            for (i = 0; i < blocks.size(); ++i) {
                b = ((LocatedBlock)blocks.get(i)).getBlock();
                System.out.println("breakHardlinksIfNeeded re-attempting to detach block " + b);
                Assert.assertTrue((String)("breakHardlinksIfNeeded(" + b + ") should have returned false"), (boolean)FsDatasetTestUtil.breakHardlinksIfNeeded(fsd, b));
            }
        }
        finally {
            client.close();
            fs.close();
            cluster.shutdown();
        }
    }

    @Test
    public void testSimpleFlush() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        fileContents = AppendTestUtil.initBuffer(10241);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).build();
        DistributedFileSystem fs = cluster.getFileSystem();
        try {
            Path file1 = new Path("/simpleFlush.dat");
            FSDataOutputStream stm = AppendTestUtil.createFile((FileSystem)fs, file1, 1);
            System.out.println("Created file simpleFlush.dat");
            int mid = 5120;
            stm.write(fileContents, 0, mid);
            stm.hflush();
            System.out.println("Wrote and Flushed first part of file.");
            stm.write(fileContents, mid, 10241 - mid);
            System.out.println("Written second part of file");
            stm.hflush();
            stm.hflush();
            System.out.println("Wrote and Flushed second part of file.");
            this.checkFile(fs, file1, 1);
            stm.close();
            System.out.println("Closed file.");
            AppendTestUtil.checkFullFile((FileSystem)fs, file1, 10241, fileContents, "Read 2");
        }
        catch (IOException e) {
            System.out.println("Exception :" + e);
            throw e;
        }
        catch (Throwable e) {
            System.out.println("Throwable :" + e);
            e.printStackTrace();
            throw new IOException("Throwable : " + e);
        }
        finally {
            fs.close();
            cluster.shutdown();
        }
    }

    @Test
    public void testComplexFlush() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        fileContents = AppendTestUtil.initBuffer(10241);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).build();
        DistributedFileSystem fs = cluster.getFileSystem();
        try {
            Path file1 = new Path("/complexFlush.dat");
            FSDataOutputStream stm = AppendTestUtil.createFile((FileSystem)fs, file1, 1);
            System.out.println("Created file complexFlush.dat");
            int start = 0;
            start = 0;
            while (start + 29 < 10241) {
                stm.write(fileContents, start, 29);
                stm.hflush();
                start += 29;
            }
            stm.write(fileContents, start, 10241 - start);
            stm.flush();
            this.checkFile(fs, file1, 1);
            stm.close();
            AppendTestUtil.checkFullFile((FileSystem)fs, file1, 10241, fileContents, "Read 2");
        }
        catch (IOException e) {
            System.out.println("Exception :" + e);
            throw e;
        }
        catch (Throwable e) {
            System.out.println("Throwable :" + e);
            e.printStackTrace();
            throw new IOException("Throwable : " + e);
        }
        finally {
            fs.close();
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=FileNotFoundException.class)
    public void testFileNotFound() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).build();
        DistributedFileSystem fs = cluster.getFileSystem();
        try {
            Path file1 = new Path("/nonexistingfile.dat");
            fs.append(file1);
        }
        finally {
            fs.close();
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAppendTwice() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).build();
        DistributedFileSystem fs1 = cluster.getFileSystem();
        FileSystem fs2 = AppendTestUtil.createHdfsWithDifferentUsername((Configuration)conf);
        try {
            Path p = new Path("/testAppendTwice/foo");
            int len = 65536;
            byte[] fileContents = AppendTestUtil.initBuffer(65536);
            FSDataOutputStream out = fs2.create(p, true, 4096, (short)1, 65536L);
            out.write(fileContents, 0, 65536);
            out.close();
            fs2.append(p);
            fs1.append(p);
            Assert.fail();
        }
        catch (RemoteException re) {
            AppendTestUtil.LOG.info((Object)"Got an exception:", (Throwable)re);
            Assert.assertEquals((Object)AlreadyBeingCreatedException.class.getName(), (Object)re.getClassName());
        }
        finally {
            fs2.close();
            fs1.close();
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAppend2Twice() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).build();
        DistributedFileSystem fs1 = cluster.getFileSystem();
        FileSystem fs2 = AppendTestUtil.createHdfsWithDifferentUsername((Configuration)conf);
        try {
            Path p = new Path("/testAppendTwice/foo");
            int len = 65536;
            byte[] fileContents = AppendTestUtil.initBuffer(65536);
            FSDataOutputStream out = fs2.create(p, true, 4096, (short)1, 65536L);
            out.write(fileContents, 0, 65536);
            out.close();
            ((DistributedFileSystem)fs2).append(p, EnumSet.of(CreateFlag.APPEND, CreateFlag.NEW_BLOCK), 4096, null);
            fs1.append(p);
            Assert.fail();
        }
        catch (RemoteException re) {
            AppendTestUtil.LOG.info((Object)"Got an exception:", (Throwable)re);
            Assert.assertEquals((Object)AlreadyBeingCreatedException.class.getName(), (Object)re.getClassName());
        }
        finally {
            fs2.close();
            fs1.close();
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMultipleAppends() throws Exception {
        long startTime = Time.monotonicNow();
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setInt("dfs.namenode.file.close.num-committed-allowed", 1);
        conf.setBoolean("dfs.client.block.write.replace-datanode-on-failure.enable", false);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(4).build();
        DistributedFileSystem fs = cluster.getFileSystem();
        try {
            int appendLen;
            Path p = new Path("/testMultipleAppend/foo");
            int blockSize = 65536;
            byte[] data = AppendTestUtil.initBuffer(65536);
            fs.create(p, true, 4096, (short)3, 65536L).close();
            int fileLen = 0;
            for (int i = 0; (i < 10 || Time.monotonicNow() - startTime < 10000L) && fileLen + (appendLen = ThreadLocalRandom.current().nextInt(100) + 1) <= data.length; ++i) {
                AppendTestUtil.LOG.info((Object)(i + ") fileLen=" + fileLen + ", appendLen=" + appendLen));
                FSDataOutputStream out = fs.append(p);
                out.write(data, fileLen, appendLen);
                out.close();
                fileLen += appendLen;
            }
            Assert.assertEquals((long)fileLen, (long)fs.getFileStatus(p).getLen());
            byte[] actual = new byte[fileLen];
            FSDataInputStream in = fs.open(p);
            in.readFully(actual);
            in.close();
            for (int i = 0; i < fileLen; ++i) {
                Assert.assertEquals((long)data[i], (long)actual[i]);
            }
        }
        finally {
            fs.close();
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAppendAfterSoftLimit() throws IOException, InterruptedException {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setInt("dfs.replication", 1);
        conf.setBoolean("dfs.support.append", true);
        long softLimit = 1L;
        long hardLimit = 9999999L;
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).build();
        cluster.setLeasePeriod(1L, 9999999L);
        cluster.waitActive();
        DistributedFileSystem fs = cluster.getFileSystem();
        DistributedFileSystem fs2 = new DistributedFileSystem();
        fs2.initialize(fs.getUri(), (Configuration)conf);
        Path testPath = new Path("/testAppendAfterSoftLimit");
        byte[] fileContents = AppendTestUtil.initBuffer(32);
        FSDataOutputStream out = fs.create(testPath);
        out.write(fileContents);
        Thread.sleep(250L);
        try {
            FSDataOutputStream appendStream2 = fs2.append(testPath);
            appendStream2.write(fileContents);
            appendStream2.close();
            Assert.assertEquals((long)fileContents.length, (long)fs.getFileStatus(testPath).getLen());
        }
        finally {
            fs.close();
            fs2.close();
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAppend2AfterSoftLimit() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setInt("dfs.replication", 1);
        long softLimit = 1L;
        long hardLimit = 9999999L;
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).build();
        cluster.setLeasePeriod(1L, 9999999L);
        cluster.waitActive();
        DistributedFileSystem fs = cluster.getFileSystem();
        DistributedFileSystem fs2 = new DistributedFileSystem();
        fs2.initialize(fs.getUri(), (Configuration)conf);
        Path testPath = new Path("/testAppendAfterSoftLimit");
        byte[] fileContents = AppendTestUtil.initBuffer(32);
        FSDataOutputStream out = fs.create(testPath);
        out.write(fileContents);
        Thread.sleep(250L);
        try {
            FSDataOutputStream appendStream2 = fs2.append(testPath, EnumSet.of(CreateFlag.APPEND, CreateFlag.NEW_BLOCK), 4096, null);
            appendStream2.write(fileContents);
            appendStream2.close();
            Assert.assertEquals((long)fileContents.length, (long)fs.getFileStatus(testPath).getLen());
            LocatedBlocks blks = fs.getClient().getLocatedBlocks(testPath.toString(), 0L);
            Assert.assertEquals((long)1L, (long)blks.getLocatedBlocks().size());
            for (LocatedBlock blk : blks.getLocatedBlocks()) {
                Assert.assertEquals((long)fileContents.length, (long)blk.getBlockSize());
            }
        }
        finally {
            fs.close();
            fs2.close();
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFailedAppendBlockRejection() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.set("dfs.client.block.write.replace-datanode-on-failure.enable", "false");
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(3).build();
        DistributedFileSystem fs = null;
        try {
            String[] names;
            fs = cluster.getFileSystem();
            Path path = new Path("/test");
            FSDataOutputStream out = fs.create(path);
            out.writeBytes("hello\n");
            out.close();
            MiniDFSCluster.DataNodeProperties dnProp = cluster.stopDataNode(0);
            String dnAddress = dnProp.datanode.getXferAddress().toString();
            if (dnAddress.startsWith("/")) {
                dnAddress = dnAddress.substring(1);
            }
            for (int i = 0; i < 2; ++i) {
                out = fs.append(path);
                out.writeBytes("helloagain\n");
                out.close();
            }
            out = fs.append(path);
            cluster.restartDataNode(dnProp, true);
            Thread.sleep(2000L);
            BlockLocation[] locations = fs.getFileBlockLocations(path, 0L, Long.MAX_VALUE);
            for (String node : names = locations[0].getNames()) {
                if (!node.equals(dnAddress)) continue;
                Assert.fail((String)"Failed append should not be present in latest block locations.");
            }
            out.close();
        }
        finally {
            IOUtils.closeStream((Closeable)fs);
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMultiAppend2() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.set("dfs.client.block.write.replace-datanode-on-failure.enable", "false");
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(3).build();
        DistributedFileSystem fs = null;
        String hello = "hello\n";
        try {
            fs = cluster.getFileSystem();
            Path path = new Path("/test");
            FSDataOutputStream out = fs.create(path);
            out.writeBytes("hello\n");
            out.close();
            MiniDFSCluster.DataNodeProperties dnProp = cluster.stopDataNode(0);
            String dnAddress = dnProp.datanode.getXferAddress().toString();
            if (dnAddress.startsWith("/")) {
                dnAddress = dnAddress.substring(1);
            }
            for (int i = 0; i < 2; ++i) {
                out = fs.append(path, EnumSet.of(CreateFlag.APPEND, CreateFlag.NEW_BLOCK), 4096, null);
                out.writeBytes("hello\n");
                out.close();
            }
            out = fs.append(path, EnumSet.of(CreateFlag.APPEND, CreateFlag.NEW_BLOCK), 4096, null);
            cluster.restartDataNode(dnProp, true);
            Thread.sleep(2000L);
            out.writeBytes("hello\n");
            out.close();
            LocatedBlocks blocks = fs.getClient().getLocatedBlocks(path.toString(), 0L);
            Assert.assertEquals((long)4L, (long)blocks.getLocatedBlocks().size());
            for (LocatedBlock block : blocks.getLocatedBlocks()) {
                Assert.assertEquals((long)"hello\n".length(), (long)block.getBlockSize());
            }
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < 4; ++i) {
                sb.append("hello\n");
            }
            byte[] content = sb.toString().getBytes();
            AppendTestUtil.checkFullFile((FileSystem)fs, path, content.length, content, "Read /test");
            cluster.restartNameNode(true);
            cluster.waitActive();
            AppendTestUtil.checkFullFile((FileSystem)fs, path, content.length, content, "Read /test");
            blocks = fs.getClient().getLocatedBlocks(path.toString(), 0L);
            Assert.assertEquals((long)4L, (long)blocks.getLocatedBlocks().size());
            for (LocatedBlock block : blocks.getLocatedBlocks()) {
                Assert.assertEquals((long)"hello\n".length(), (long)block.getBlockSize());
            }
        }
        finally {
            IOUtils.closeStream((Closeable)fs);
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testAppendCorruptedBlock() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setInt("dfs.blocksize", 1024);
        conf.setInt("dfs.replication", 1);
        conf.setInt("dfs.min.replication", 1);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).build();
        try {
            DistributedFileSystem fs = cluster.getFileSystem();
            Path fileName = new Path("/appendCorruptBlock");
            DFSTestUtil.createFile((FileSystem)fs, fileName, 512L, (short)1, 0L);
            DFSTestUtil.waitReplication((FileSystem)fs, fileName, (short)1);
            Assert.assertTrue((String)"File not created", (boolean)fs.exists(fileName));
            ExtendedBlock block = DFSTestUtil.getFirstBlock((FileSystem)fs, fileName);
            cluster.corruptBlockOnDataNodes(block);
            DFSTestUtil.appendFile((FileSystem)fs, fileName, "appendCorruptBlock");
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testConcurrentAppendRead() throws IOException, TimeoutException, InterruptedException {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setInt("dfs.blocksize", 1024);
        conf.setInt("dfs.replication", 1);
        conf.setInt("dfs.min.replication", 1);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).build();
        try {
            cluster.waitActive();
            DataNode dn = cluster.getDataNodes().get(0);
            FsDatasetSpi<?> dataSet = DataNodeTestUtils.getFSDataset(dn);
            long initialFileLength = 1L;
            DistributedFileSystem fs = cluster.getFileSystem();
            Path fileName = new Path("/appendCorruptBlock");
            DFSTestUtil.createFile((FileSystem)fs, fileName, initialFileLength, (short)1, 0L);
            DFSTestUtil.waitReplication((FileSystem)fs, fileName, (short)1);
            Assert.assertTrue((String)"File not created", (boolean)fs.exists(fileName));
            ExtendedBlock block = DFSTestUtil.getFirstBlock((FileSystem)fs, fileName);
            long newGS = block.getGenerationStamp() + 1L;
            ReplicaHandler replicaHandler = dataSet.append(block, newGS, initialFileLength);
            ReplicaBeingWritten rbw = (ReplicaBeingWritten)replicaHandler.getReplica();
            ReplicaOutputStreams outputStreams = rbw.createStreams(false, DEFAULT_CHECKSUM);
            OutputStream dataOutput = outputStreams.getDataOut();
            byte[] appendBytes = new byte[1];
            dataOutput.write(appendBytes, 0, 1);
            dataOutput.flush();
            dataOutput.close();
            int smallBufferSize = DFSUtilClient.getSmallBufferSize((Configuration)conf);
            FsDatasetUtil.computeChecksum((File)rbw.getMetaFile(), (File)rbw.getMetaFile(), (File)rbw.getBlockFile(), (int)smallBufferSize, (Configuration)conf);
            byte[] readBlock = DFSTestUtil.readFileBuffer((FileSystem)fs, fileName);
            Assert.assertEquals((String)"should have read only one byte!", (long)1L, (long)readBlock.length);
        }
        finally {
            cluster.shutdown();
        }
    }
}

