/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfo;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.internal.util.reflection.Whitebox;

public class TestNameNodeMetadataConsistency {
    private static final Path filePath1 = new Path("/testdata1.txt");
    private static final Path filePath2 = new Path("/testdata2.txt");
    private static final int SCAN_INTERVAL = 1;
    private static final int SCAN_WAIT = 3;
    MiniDFSCluster cluster;
    HdfsConfiguration conf;

    @Before
    public void InitTest() throws IOException {
        this.conf = new HdfsConfiguration();
        this.conf.setLong("dfs.datanode.directoryscan.interval", 1L);
        this.cluster = new MiniDFSCluster.Builder((Configuration)this.conf).numDataNodes(1).build();
    }

    @After
    public void cleanup() {
        if (this.cluster != null) {
            this.cluster.shutdown();
            this.cluster = null;
        }
    }

    @Test
    public void testGenerationStampInFuture() throws IOException, InterruptedException {
        String testData = " This is test data";
        int datalen = testData.length();
        this.cluster.waitActive();
        DistributedFileSystem fs = this.cluster.getFileSystem();
        FSDataOutputStream ostream = fs.create(filePath1);
        ostream.write(testData.getBytes());
        ostream.close();
        ExtendedBlock block = DFSTestUtil.getFirstBlock((FileSystem)fs, filePath1);
        long genStamp = block.getGenerationStamp();
        this.cluster.changeGenStampOfBlock(0, block, genStamp + 1L);
        MiniDFSCluster.DataNodeProperties dnProps = this.cluster.stopDataNode(0);
        this.cluster.restartNameNode(true);
        BlockInfo bInfo = this.cluster.getNameNode().getNamesystem().getBlockManager().getStoredBlock(block.getLocalBlock());
        this.cluster.getNameNode().getNamesystem().writeLock();
        bInfo.delete();
        this.cluster.getNameNode().getNamesystem().getBlockManager().removeBlock(bInfo);
        this.cluster.getNameNode().getNamesystem().writeUnlock();
        FSNamesystem spyNameSystem = (FSNamesystem)Mockito.spy((Object)this.cluster.getNameNode().getNamesystem());
        spyNameSystem.enableSafeModeForTesting((Configuration)this.conf);
        Whitebox.setInternalState((Object)this.cluster.getNameNode().getNamesystem().getBlockManager(), (String)"namesystem", (Object)spyNameSystem);
        Whitebox.setInternalState((Object)this.cluster.getNameNode(), (String)"namesystem", (Object)spyNameSystem);
        ((FSNamesystem)Mockito.doReturn((Object)true).when((Object)spyNameSystem)).isInStartupSafeMode();
        this.cluster.restartDataNode(dnProps);
        this.waitTil(TimeUnit.SECONDS.toMillis(3L));
        this.cluster.triggerBlockReports();
        this.waitTil(TimeUnit.SECONDS.toMillis(3L));
        Assert.assertEquals((long)datalen, (long)this.cluster.getNameNode().getBytesWithFutureGenerationStamps());
        String safeModeMessage = this.cluster.getNameNode().getNamesystem().getSafeModeTip();
        Assert.assertThat((Object)safeModeMessage, (Matcher)CoreMatchers.containsString((String)"Name node detected blocks with generation stamps in future"));
    }

    @Test
    public void testEnsureGenStampsIsStartupOnly() throws IOException, InterruptedException {
        String testData = " This is test data";
        this.cluster.restartDataNodes();
        this.cluster.restartNameNodes();
        this.cluster.waitActive();
        DistributedFileSystem fs = this.cluster.getFileSystem();
        FSDataOutputStream ostream = fs.create(filePath2);
        ostream.write(testData.getBytes());
        ostream.close();
        ExtendedBlock block = DFSTestUtil.getFirstBlock((FileSystem)fs, filePath2);
        long genStamp = block.getGenerationStamp();
        this.cluster.changeGenStampOfBlock(0, block, genStamp + 1L);
        MiniDFSCluster.DataNodeProperties dnProps = this.cluster.stopDataNode(0);
        this.cluster.restartNameNode(true);
        BlockInfo bInfo = this.cluster.getNameNode().getNamesystem().getBlockManager().getStoredBlock(block.getLocalBlock());
        this.cluster.getNameNode().getNamesystem().writeLock();
        bInfo.delete();
        this.cluster.getNameNode().getNamesystem().getBlockManager().removeBlock(bInfo);
        this.cluster.getNameNode().getNamesystem().writeUnlock();
        this.cluster.restartDataNode(dnProps);
        this.waitTil(TimeUnit.SECONDS.toMillis(3L));
        this.cluster.triggerBlockReports();
        this.waitTil(TimeUnit.SECONDS.toMillis(3L));
        Assert.assertEquals((long)0L, (long)this.cluster.getNameNode().getBytesWithFutureGenerationStamps());
    }

    private void waitTil(long waitPeriod) {
        try {
            Thread.sleep(waitPeriod);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }
}

