/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.snapshot;

import org.apache.hadoop.hdfs.protocol.SnapshotException;
import org.apache.hadoop.hdfs.server.namenode.FSDirectory;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeDirectory;
import org.apache.hadoop.hdfs.server.namenode.INodesInPath;
import org.apache.hadoop.hdfs.server.namenode.snapshot.SnapshotManager;
import org.apache.hadoop.util.StringUtils;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class TestSnapshotManager {
    private static final int testMaxSnapshotLimit = 7;

    @Test(timeout=10000L)
    public void testSnapshotLimits() throws Exception {
        INodeDirectory ids = (INodeDirectory)Mockito.mock(INodeDirectory.class);
        FSDirectory fsdir = (FSDirectory)Mockito.mock(FSDirectory.class);
        INodesInPath iip = (INodesInPath)Mockito.mock(INodesInPath.class);
        SnapshotManager sm = (SnapshotManager)Mockito.spy((Object)new SnapshotManager(fsdir));
        ((SnapshotManager)Mockito.doReturn((Object)ids).when((Object)sm)).getSnapshottableRoot((INodesInPath)Matchers.anyObject());
        ((SnapshotManager)Mockito.doReturn((Object)7).when((Object)sm)).getMaxSnapshotID();
        Integer i = 0;
        while (i < 7) {
            sm.createSnapshot(iip, "dummy", i.toString());
            i = i + 1;
        }
        try {
            sm.createSnapshot(iip, "dummy", "shouldFailSnapshot");
            Assert.fail((String)"Expected SnapshotException not thrown");
        }
        catch (SnapshotException se) {
            Assert.assertTrue((boolean)StringUtils.toLowerCase((String)se.getMessage()).contains("rollover"));
        }
        sm.deleteSnapshot(iip, "", (INode.ReclaimContext)Mockito.mock(INode.ReclaimContext.class));
        try {
            sm.createSnapshot(iip, "dummy", "shouldFailSnapshot2");
            Assert.fail((String)"Expected SnapshotException not thrown");
        }
        catch (SnapshotException se) {
            Assert.assertTrue((boolean)StringUtils.toLowerCase((String)se.getMessage()).contains("rollover"));
        }
    }
}

