/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.PrivilegedExceptionAction;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.apache.hadoop.crypto.CipherSuite;
import org.apache.hadoop.crypto.CryptoProtocolVersion;
import org.apache.hadoop.crypto.key.KeyProvider;
import org.apache.hadoop.crypto.key.KeyProviderCryptoExtension;
import org.apache.hadoop.fs.BatchedRemoteIterator;
import org.apache.hadoop.fs.FileEncryptionInfo;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.UnresolvedLinkException;
import org.apache.hadoop.fs.XAttr;
import org.apache.hadoop.fs.XAttrSetFlag;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.hdfs.XAttrHelper;
import org.apache.hadoop.hdfs.protocol.EncryptionZone;
import org.apache.hadoop.hdfs.protocol.SnapshotAccessControlException;
import org.apache.hadoop.hdfs.protocol.proto.HdfsProtos;
import org.apache.hadoop.hdfs.protocolPB.PBHelperClient;
import org.apache.hadoop.hdfs.server.namenode.EncryptionFaultInjector;
import org.apache.hadoop.hdfs.server.namenode.FSDirXAttrOp;
import org.apache.hadoop.hdfs.server.namenode.FSDirectory;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.FSPermissionChecker;
import org.apache.hadoop.hdfs.server.namenode.INodesInPath;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.RetryStartFileException;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.util.Time;

final class FSDirEncryptionZoneOp {
    private FSDirEncryptionZoneOp() {
    }

    private static KeyProviderCryptoExtension.EncryptedKeyVersion generateEncryptedDataEncryptionKey(final FSDirectory fsd, final String ezKeyName) throws IOException {
        assert (!fsd.getFSNamesystem().hasReadLock());
        assert (!fsd.getFSNamesystem().hasWriteLock());
        if (ezKeyName == null) {
            return null;
        }
        long generateEDEKStartTime = Time.monotonicNow();
        KeyProviderCryptoExtension.EncryptedKeyVersion edek = (KeyProviderCryptoExtension.EncryptedKeyVersion)SecurityUtil.doAsLoginUser((PrivilegedExceptionAction)new PrivilegedExceptionAction<KeyProviderCryptoExtension.EncryptedKeyVersion>(){

            @Override
            public KeyProviderCryptoExtension.EncryptedKeyVersion run() throws IOException {
                try {
                    return fsd.getProvider().generateEncryptedKey(ezKeyName);
                }
                catch (GeneralSecurityException e) {
                    throw new IOException(e);
                }
            }
        });
        long generateEDEKTime = Time.monotonicNow() - generateEDEKStartTime;
        NameNode.getNameNodeMetrics().addGenerateEDEKTime(generateEDEKTime);
        Preconditions.checkNotNull((Object)edek);
        return edek;
    }

    static KeyProvider.Metadata ensureKeyIsInitialized(FSDirectory fsd, String keyName, String src) throws IOException {
        KeyProviderCryptoExtension provider = fsd.getProvider();
        if (provider == null) {
            throw new IOException("Can't create an encryption zone for " + src + " since no key provider is available.");
        }
        if (keyName == null || keyName.isEmpty()) {
            throw new IOException("Must specify a key name when creating an encryption zone");
        }
        KeyProvider.Metadata metadata = provider.getMetadata(keyName);
        if (metadata == null) {
            throw new IOException("Key " + keyName + " doesn't exist.");
        }
        provider.warmUpEncryptedKeys(new String[]{keyName});
        return metadata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static FileStatus createEncryptionZone(FSDirectory fsd, String srcArg, FSPermissionChecker pc, String cipher, String keyName, boolean logRetryCache) throws IOException {
        INodesInPath iip;
        CipherSuite suite = CipherSuite.convert((String)cipher);
        ArrayList xAttrs = Lists.newArrayListWithCapacity((int)1);
        CryptoProtocolVersion version = CryptoProtocolVersion.ENCRYPTION_ZONES;
        fsd.writeLock();
        try {
            iip = fsd.resolvePath(pc, srcArg, FSDirectory.DirOp.WRITE);
            XAttr ezXAttr = fsd.ezManager.createEncryptionZone(iip, suite, version, keyName);
            xAttrs.add(ezXAttr);
        }
        finally {
            fsd.writeUnlock();
        }
        fsd.getEditLog().logSetXAttrs(iip.getPath(), xAttrs, logRetryCache);
        return fsd.getAuditFileInfo(iip);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Map.Entry<EncryptionZone, FileStatus> getEZForPath(FSDirectory fsd, String srcArg, FSPermissionChecker pc) throws IOException {
        EncryptionZone ret;
        INodesInPath iip;
        fsd.readLock();
        try {
            iip = fsd.resolvePath(pc, srcArg, FSDirectory.DirOp.READ);
            if (fsd.isPermissionEnabled()) {
                fsd.checkPathAccess(pc, iip, FsAction.READ);
            }
            ret = fsd.ezManager.getEZINodeForPath(iip);
        }
        finally {
            fsd.readUnlock();
        }
        FileStatus auditStat = fsd.getAuditFileInfo(iip);
        return new AbstractMap.SimpleImmutableEntry<EncryptionZone, FileStatus>(ret, auditStat);
    }

    static EncryptionZone getEZForPath(FSDirectory fsd, INodesInPath iip) {
        fsd.readLock();
        try {
            EncryptionZone encryptionZone = fsd.ezManager.getEZINodeForPath(iip);
            return encryptionZone;
        }
        finally {
            fsd.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static BatchedRemoteIterator.BatchedListEntries<EncryptionZone> listEncryptionZones(FSDirectory fsd, long prevId) throws IOException {
        fsd.readLock();
        try {
            BatchedRemoteIterator.BatchedListEntries<EncryptionZone> batchedListEntries = fsd.ezManager.listEncryptionZones(prevId);
            return batchedListEntries;
        }
        finally {
            fsd.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void setFileEncryptionInfo(FSDirectory fsd, INodesInPath iip, FileEncryptionInfo info) throws IOException {
        HdfsProtos.PerFileEncryptionInfoProto proto = PBHelperClient.convertPerFileEncInfo((FileEncryptionInfo)info);
        byte[] protoBytes = proto.toByteArray();
        XAttr fileEncryptionAttr = XAttrHelper.buildXAttr((String)"raw.hdfs.crypto.file.encryption.info", (byte[])protoBytes);
        ArrayList xAttrs = Lists.newArrayListWithCapacity((int)1);
        xAttrs.add(fileEncryptionAttr);
        fsd.writeLock();
        try {
            FSDirXAttrOp.unprotectedSetXAttrs(fsd, iip, xAttrs, EnumSet.of(XAttrSetFlag.CREATE));
        }
        finally {
            fsd.writeUnlock();
        }
    }

    static FileEncryptionInfo getFileEncryptionInfo(FSDirectory fsd, INodesInPath iip) throws IOException {
        if (iip.isRaw() || !fsd.ezManager.hasCreatedEncryptionZone() || !iip.getLastINode().isFile()) {
            return null;
        }
        fsd.readLock();
        try {
            EncryptionZone encryptionZone = FSDirEncryptionZoneOp.getEZForPath(fsd, iip);
            if (encryptionZone == null) {
                FileEncryptionInfo fileEncryptionInfo = null;
                return fileEncryptionInfo;
            }
            if ((encryptionZone.getPath() == null || encryptionZone.getPath().isEmpty()) && NameNode.LOG.isDebugEnabled()) {
                NameNode.LOG.debug("Encryption zone " + encryptionZone.getPath() + " does not have a valid path.");
            }
            CryptoProtocolVersion version = encryptionZone.getVersion();
            CipherSuite suite = encryptionZone.getSuite();
            String keyName = encryptionZone.getKeyName();
            XAttr fileXAttr = FSDirXAttrOp.unprotectedGetXAttrByPrefixedName(iip, "raw.hdfs.crypto.file.encryption.info");
            if (fileXAttr == null) {
                NameNode.LOG.warn("Could not find encryption XAttr for file " + iip.getPath() + " in encryption zone " + encryptionZone.getPath());
                FileEncryptionInfo fileEncryptionInfo = null;
                return fileEncryptionInfo;
            }
            HdfsProtos.PerFileEncryptionInfoProto fileProto = HdfsProtos.PerFileEncryptionInfoProto.parseFrom((byte[])fileXAttr.getValue());
            FileEncryptionInfo fileEncryptionInfo = PBHelperClient.convert((HdfsProtos.PerFileEncryptionInfoProto)fileProto, (CipherSuite)suite, (CryptoProtocolVersion)version, (String)keyName);
            return fileEncryptionInfo;
        }
        finally {
            fsd.readUnlock();
        }
    }

    static FileEncryptionInfo getFileEncryptionInfo(FSDirectory dir, INodesInPath iip, EncryptionKeyInfo ezInfo) throws RetryStartFileException {
        FileEncryptionInfo feInfo = null;
        EncryptionZone zone = FSDirEncryptionZoneOp.getEZForPath(dir, iip);
        if (zone != null) {
            if (ezInfo == null) {
                throw new RetryStartFileException();
            }
            String ezKeyName = zone.getKeyName();
            if (!ezKeyName.equals(ezInfo.edek.getEncryptionKeyName())) {
                throw new RetryStartFileException();
            }
            feInfo = new FileEncryptionInfo(ezInfo.suite, ezInfo.protocolVersion, ezInfo.edek.getEncryptedKeyVersion().getMaterial(), ezInfo.edek.getEncryptedKeyIv(), ezKeyName, ezInfo.edek.getEncryptionKeyVersionName());
        }
        return feInfo;
    }

    static boolean isInAnEZ(FSDirectory fsd, INodesInPath iip) throws UnresolvedLinkException, SnapshotAccessControlException {
        if (!fsd.ezManager.hasCreatedEncryptionZone()) {
            return false;
        }
        fsd.readLock();
        try {
            boolean bl = fsd.ezManager.isInAnEZ(iip);
            return bl;
        }
        finally {
            fsd.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void warmUpEdekCache(ExecutorService executor, FSDirectory fsd, int delay, int interval) {
        fsd.readLock();
        try {
            String[] edeks = fsd.ezManager.getKeyNames();
            executor.execute(new EDEKCacheLoader(edeks, fsd.getProvider(), delay, interval));
        }
        finally {
            fsd.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static EncryptionKeyInfo getEncryptionKeyInfo(FSNamesystem fsn, INodesInPath iip, CryptoProtocolVersion[] supportedVersions) throws IOException {
        FSDirectory fsd = fsn.getFSDirectory();
        EncryptionZone zone = FSDirEncryptionZoneOp.getEZForPath(fsd, iip);
        if (zone == null) {
            EncryptionFaultInjector.getInstance().startFileNoKey();
            return null;
        }
        CryptoProtocolVersion protocolVersion = fsn.chooseProtocolVersion(zone, supportedVersions);
        CipherSuite suite = zone.getSuite();
        String ezKeyName = zone.getKeyName();
        Preconditions.checkNotNull((Object)protocolVersion);
        Preconditions.checkNotNull((Object)suite);
        Preconditions.checkArgument((!suite.equals((Object)CipherSuite.UNKNOWN) ? 1 : 0) != 0, (Object)"Chose an UNKNOWN CipherSuite!");
        Preconditions.checkNotNull((Object)ezKeyName);
        fsn.writeUnlock();
        try {
            EncryptionFaultInjector.getInstance().startFileBeforeGenerateKey();
            EncryptionKeyInfo encryptionKeyInfo = new EncryptionKeyInfo(protocolVersion, suite, ezKeyName, FSDirEncryptionZoneOp.generateEncryptedDataEncryptionKey(fsd, ezKeyName));
            return encryptionKeyInfo;
        }
        finally {
            fsn.writeLock();
            EncryptionFaultInjector.getInstance().startFileAfterGenerateKey();
        }
    }

    static class EncryptionKeyInfo {
        final CryptoProtocolVersion protocolVersion;
        final CipherSuite suite;
        final String ezKeyName;
        final KeyProviderCryptoExtension.EncryptedKeyVersion edek;

        EncryptionKeyInfo(CryptoProtocolVersion protocolVersion, CipherSuite suite, String ezKeyName, KeyProviderCryptoExtension.EncryptedKeyVersion edek) {
            this.protocolVersion = protocolVersion;
            this.suite = suite;
            this.ezKeyName = ezKeyName;
            this.edek = edek;
        }
    }

    static class EDEKCacheLoader
    implements Runnable {
        private final String[] keyNames;
        private final KeyProviderCryptoExtension kp;
        private int initialDelay;
        private int retryInterval;

        EDEKCacheLoader(String[] names, KeyProviderCryptoExtension kp, int delay, int interval) {
            this.keyNames = names;
            this.kp = kp;
            this.initialDelay = delay;
            this.retryInterval = interval;
        }

        @Override
        public void run() {
            NameNode.LOG.info("Warming up {} EDEKs... (initialDelay={}, retryInterval={})", new Object[]{this.keyNames.length, this.initialDelay, this.retryInterval});
            try {
                Thread.sleep(this.initialDelay);
            }
            catch (InterruptedException ie) {
                NameNode.LOG.info("EDEKCacheLoader interrupted before warming up.");
                return;
            }
            int logCoolDown = 10000;
            int sinceLastLog = 10000;
            boolean success = false;
            IOException lastSeenIOE = null;
            long warmUpEDEKStartTime = Time.monotonicNow();
            while (true) {
                try {
                    this.kp.warmUpEncryptedKeys(this.keyNames);
                    NameNode.LOG.info("Successfully warmed up {} EDEKs.", (Object)this.keyNames.length);
                    success = true;
                    break;
                }
                catch (IOException ioe) {
                    lastSeenIOE = ioe;
                    if (sinceLastLog >= 10000) {
                        NameNode.LOG.info("Failed to warm up EDEKs.", (Throwable)ioe);
                        sinceLastLog = 0;
                    } else {
                        NameNode.LOG.debug("Failed to warm up EDEKs.", (Throwable)ioe);
                    }
                }
                catch (Exception e) {
                    NameNode.LOG.error("Cannot warm up EDEKs.", (Throwable)e);
                    throw e;
                }
                try {
                    Thread.sleep(this.retryInterval);
                }
                catch (InterruptedException ie) {
                    NameNode.LOG.info("EDEKCacheLoader interrupted during retry.");
                    break;
                }
                sinceLastLog += this.retryInterval;
            }
            long warmUpEDEKTime = Time.monotonicNow() - warmUpEDEKStartTime;
            NameNode.getNameNodeMetrics().addWarmUpEDEKTime(warmUpEDEKTime);
            if (!success) {
                NameNode.LOG.warn("Unable to warm up EDEKs.");
                if (lastSeenIOE != null) {
                    NameNode.LOG.warn("Last seen exception:", (Throwable)lastSeenIOE);
                }
            }
        }
    }
}

