/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.namenode.FSImageFormat;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.Assert;
import org.junit.Test;

public class TestNameNodeOptionParsing {
    @Test(timeout=10000L)
    public void testUpgrade() {
        HdfsServerConstants.StartupOption opt = null;
        opt = NameNode.parseArguments((String[])new String[]{"-upgrade"});
        Assert.assertEquals((Object)opt, (Object)HdfsServerConstants.StartupOption.UPGRADE);
        Assert.assertNull((Object)opt.getClusterId());
        Assert.assertTrue((boolean)FSImageFormat.renameReservedMap.isEmpty());
        opt = NameNode.parseArguments((String[])new String[]{"-upgrade", "-clusterid", "mycid"});
        Assert.assertEquals((Object)HdfsServerConstants.StartupOption.UPGRADE, (Object)opt);
        Assert.assertEquals((Object)"mycid", (Object)opt.getClusterId());
        Assert.assertTrue((boolean)FSImageFormat.renameReservedMap.isEmpty());
        opt = NameNode.parseArguments((String[])new String[]{"-upgrade", "-clusterid", "mycid", "-renameReserved", ".snapshot=.my-snapshot,.reserved=.my-reserved"});
        Assert.assertEquals((Object)HdfsServerConstants.StartupOption.UPGRADE, (Object)opt);
        Assert.assertEquals((Object)"mycid", (Object)opt.getClusterId());
        Assert.assertEquals((Object)".my-snapshot", FSImageFormat.renameReservedMap.get(".snapshot"));
        Assert.assertEquals((Object)".my-reserved", FSImageFormat.renameReservedMap.get(".reserved"));
        FSImageFormat.renameReservedMap.clear();
        opt = NameNode.parseArguments((String[])new String[]{"-upgrade", "-renameReserved", ".reserved=.my-reserved,.snapshot=.my-snapshot", "-clusterid", "mycid"});
        Assert.assertEquals((Object)HdfsServerConstants.StartupOption.UPGRADE, (Object)opt);
        Assert.assertEquals((Object)"mycid", (Object)opt.getClusterId());
        Assert.assertEquals((Object)".my-snapshot", FSImageFormat.renameReservedMap.get(".snapshot"));
        Assert.assertEquals((Object)".my-reserved", FSImageFormat.renameReservedMap.get(".reserved"));
        opt = NameNode.parseArguments((String[])new String[]{"-upgrade", "-renameReserved"});
        Assert.assertEquals((Object)HdfsServerConstants.StartupOption.UPGRADE, (Object)opt);
        Assert.assertEquals((Object)(".snapshot." + HdfsServerConstants.NAMENODE_LAYOUT_VERSION + ".UPGRADE_RENAMED"), FSImageFormat.renameReservedMap.get(".snapshot"));
        Assert.assertEquals((Object)(".reserved." + HdfsServerConstants.NAMENODE_LAYOUT_VERSION + ".UPGRADE_RENAMED"), FSImageFormat.renameReservedMap.get(".reserved"));
        try {
            opt = NameNode.parseArguments((String[])new String[]{"-upgrade", "-renameReserved", ".reserved=.my-reserved,.not-reserved=.my-not-reserved"});
        }
        catch (IllegalArgumentException e) {
            GenericTestUtils.assertExceptionContains((String)"Unknown reserved path", (Throwable)e);
        }
        try {
            opt = NameNode.parseArguments((String[])new String[]{"-upgrade", "-renameReserved", ".reserved=.my-reserved,.snapshot=.snapshot"});
        }
        catch (IllegalArgumentException e) {
            GenericTestUtils.assertExceptionContains((String)"Invalid rename path", (Throwable)e);
        }
        try {
            opt = NameNode.parseArguments((String[])new String[]{"-upgrade", "-renameReserved", ".snapshot=.reserved"});
        }
        catch (IllegalArgumentException e) {
            GenericTestUtils.assertExceptionContains((String)"Invalid rename path", (Throwable)e);
        }
        opt = NameNode.parseArguments((String[])new String[]{"-upgrade", "-cid"});
        Assert.assertNull((Object)opt);
    }

    @Test(timeout=10000L)
    public void testRollingUpgrade() {
        String[] args = new String[]{"-rollingUpgrade"};
        HdfsServerConstants.StartupOption opt = NameNode.parseArguments((String[])args);
        Assert.assertNull((Object)opt);
        args = new String[]{"-rollingUpgrade", "started"};
        opt = NameNode.parseArguments((String[])args);
        Assert.assertEquals((Object)HdfsServerConstants.StartupOption.ROLLINGUPGRADE, (Object)opt);
        Assert.assertEquals((Object)HdfsServerConstants.RollingUpgradeStartupOption.STARTED, (Object)opt.getRollingUpgradeStartupOption());
        Assert.assertTrue((boolean)HdfsServerConstants.RollingUpgradeStartupOption.STARTED.matches(opt));
        args = new String[]{"-rollingUpgrade", "downgrade"};
        opt = NameNode.parseArguments((String[])args);
        Assert.assertEquals((Object)HdfsServerConstants.StartupOption.ROLLINGUPGRADE, (Object)opt);
        Assert.assertEquals((Object)HdfsServerConstants.RollingUpgradeStartupOption.DOWNGRADE, (Object)opt.getRollingUpgradeStartupOption());
        Assert.assertTrue((boolean)HdfsServerConstants.RollingUpgradeStartupOption.DOWNGRADE.matches(opt));
        args = new String[]{"-rollingUpgrade", "rollback"};
        opt = NameNode.parseArguments((String[])args);
        Assert.assertEquals((Object)HdfsServerConstants.StartupOption.ROLLINGUPGRADE, (Object)opt);
        Assert.assertEquals((Object)HdfsServerConstants.RollingUpgradeStartupOption.ROLLBACK, (Object)opt.getRollingUpgradeStartupOption());
        Assert.assertTrue((boolean)HdfsServerConstants.RollingUpgradeStartupOption.ROLLBACK.matches(opt));
        args = new String[]{"-rollingUpgrade", "foo"};
        try {
            NameNode.parseArguments((String[])args);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

