/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Lists;
import com.google.protobuf.BlockingService;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.management.ManagementFactory;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.ReconfigurableBase;
import org.apache.hadoop.conf.ReconfigurationException;
import org.apache.hadoop.conf.ReconfigurationTaskStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.DFSUtilClient;
import org.apache.hadoop.hdfs.HDFSPolicyProvider;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.client.BlockReportOptions;
import org.apache.hadoop.hdfs.client.HdfsClientConfigKeys;
import org.apache.hadoop.hdfs.net.DomainPeerServer;
import org.apache.hadoop.hdfs.net.TcpPeerServer;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.BlockLocalPathInfo;
import org.apache.hadoop.hdfs.protocol.ClientDatanodeProtocol;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.DatanodeLocalInfo;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.HdfsBlocksMetadata;
import org.apache.hadoop.hdfs.protocol.datatransfer.BlockConstructionStage;
import org.apache.hadoop.hdfs.protocol.datatransfer.DataTransferProtocol;
import org.apache.hadoop.hdfs.protocol.datatransfer.IOStreamPair;
import org.apache.hadoop.hdfs.protocol.datatransfer.PipelineAck;
import org.apache.hadoop.hdfs.protocol.datatransfer.Sender;
import org.apache.hadoop.hdfs.protocol.datatransfer.sasl.DataEncryptionKeyFactory;
import org.apache.hadoop.hdfs.protocol.datatransfer.sasl.SaslDataTransferClient;
import org.apache.hadoop.hdfs.protocol.datatransfer.sasl.SaslDataTransferServer;
import org.apache.hadoop.hdfs.protocol.proto.ClientDatanodeProtocolProtos;
import org.apache.hadoop.hdfs.protocol.proto.DataTransferProtos;
import org.apache.hadoop.hdfs.protocol.proto.InterDatanodeProtocolProtos;
import org.apache.hadoop.hdfs.protocolPB.ClientDatanodeProtocolPB;
import org.apache.hadoop.hdfs.protocolPB.ClientDatanodeProtocolServerSideTranslatorPB;
import org.apache.hadoop.hdfs.protocolPB.DatanodeLifelineProtocolClientSideTranslatorPB;
import org.apache.hadoop.hdfs.protocolPB.DatanodeProtocolClientSideTranslatorPB;
import org.apache.hadoop.hdfs.protocolPB.InterDatanodeProtocolPB;
import org.apache.hadoop.hdfs.protocolPB.InterDatanodeProtocolServerSideTranslatorPB;
import org.apache.hadoop.hdfs.protocolPB.InterDatanodeProtocolTranslatorPB;
import org.apache.hadoop.hdfs.protocolPB.PBHelperClient;
import org.apache.hadoop.hdfs.security.token.block.BlockPoolTokenSecretManager;
import org.apache.hadoop.hdfs.security.token.block.BlockTokenIdentifier;
import org.apache.hadoop.hdfs.security.token.block.BlockTokenSecretManager;
import org.apache.hadoop.hdfs.security.token.block.DataEncryptionKey;
import org.apache.hadoop.hdfs.security.token.block.ExportedBlockKeys;
import org.apache.hadoop.hdfs.security.token.block.InvalidBlockTokenException;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.common.MetricsLoggerTask;
import org.apache.hadoop.hdfs.server.common.Storage;
import org.apache.hadoop.hdfs.server.common.StorageInfo;
import org.apache.hadoop.hdfs.server.datanode.BPOfferService;
import org.apache.hadoop.hdfs.server.datanode.BPServiceActor;
import org.apache.hadoop.hdfs.server.datanode.BlockPoolManager;
import org.apache.hadoop.hdfs.server.datanode.BlockPoolSliceStorage;
import org.apache.hadoop.hdfs.server.datanode.BlockRecoveryWorker;
import org.apache.hadoop.hdfs.server.datanode.BlockScanner;
import org.apache.hadoop.hdfs.server.datanode.BlockSender;
import org.apache.hadoop.hdfs.server.datanode.CachingStrategy;
import org.apache.hadoop.hdfs.server.datanode.DNConf;
import org.apache.hadoop.hdfs.server.datanode.DataNodeFaultInjector;
import org.apache.hadoop.hdfs.server.datanode.DataNodeLayoutVersion;
import org.apache.hadoop.hdfs.server.datanode.DataNodeMXBean;
import org.apache.hadoop.hdfs.server.datanode.DataStorage;
import org.apache.hadoop.hdfs.server.datanode.DataXceiverServer;
import org.apache.hadoop.hdfs.server.datanode.DatanodeUtil;
import org.apache.hadoop.hdfs.server.datanode.DirectoryScanner;
import org.apache.hadoop.hdfs.server.datanode.Replica;
import org.apache.hadoop.hdfs.server.datanode.ReplicaNotFoundException;
import org.apache.hadoop.hdfs.server.datanode.SecureDataNodeStarter;
import org.apache.hadoop.hdfs.server.datanode.ShortCircuitRegistry;
import org.apache.hadoop.hdfs.server.datanode.StorageLocation;
import org.apache.hadoop.hdfs.server.datanode.UnexpectedReplicaStateException;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsDatasetSpi;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsVolumeSpi;
import org.apache.hadoop.hdfs.server.datanode.metrics.DataNodeMetrics;
import org.apache.hadoop.hdfs.server.datanode.web.DatanodeHttpServer;
import org.apache.hadoop.hdfs.server.protocol.BlockRecoveryCommand;
import org.apache.hadoop.hdfs.server.protocol.DatanodeRegistration;
import org.apache.hadoop.hdfs.server.protocol.InterDatanodeProtocol;
import org.apache.hadoop.hdfs.server.protocol.NamespaceInfo;
import org.apache.hadoop.hdfs.server.protocol.ReplicaRecoveryInfo;
import org.apache.hadoop.http.HttpConfig;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.ReadaheadPool;
import org.apache.hadoop.io.nativeio.NativeIO;
import org.apache.hadoop.ipc.ProtobufRpcEngine;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.RetriableException;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.util.MBeans;
import org.apache.hadoop.net.DNS;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.net.unix.DomainSocket;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.SaslPropertiesResolver;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.PolicyProvider;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.tracing.SpanReceiverInfo;
import org.apache.hadoop.tracing.TraceAdminPB;
import org.apache.hadoop.tracing.TraceAdminProtocol;
import org.apache.hadoop.tracing.TraceAdminProtocolPB;
import org.apache.hadoop.tracing.TraceAdminProtocolServerSideTranslatorPB;
import org.apache.hadoop.tracing.TraceUtils;
import org.apache.hadoop.tracing.TracerConfigurationManager;
import org.apache.hadoop.util.AutoCloseableLock;
import org.apache.hadoop.util.Daemon;
import org.apache.hadoop.util.DiskChecker;
import org.apache.hadoop.util.ExitUtil;
import org.apache.hadoop.util.GenericOptionsParser;
import org.apache.hadoop.util.InvalidChecksumSizeException;
import org.apache.hadoop.util.JvmPauseMonitor;
import org.apache.hadoop.util.ServicePlugin;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.Time;
import org.apache.hadoop.util.VersionInfo;
import org.apache.htrace.core.Tracer;
import org.mortbay.util.ajax.JSON;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class DataNode
extends ReconfigurableBase
implements InterDatanodeProtocol,
ClientDatanodeProtocol,
TraceAdminProtocol,
DataNodeMXBean {
    public static final Logger LOG = LoggerFactory.getLogger(DataNode.class);
    public static final String DN_CLIENTTRACE_FORMAT = "src: %s, dest: %s, bytes: %s, op: %s, cliID: %s, offset: %s, srvID: %s, blockid: %s, duration: %s";
    static final Log ClientTraceLog;
    private static final String USAGE = "Usage: hdfs datanode [-regular | -rollback | -rollingupgrade rollback ]\n    -regular                 : Normal DataNode startup (default).\n    -rollback                : Rollback a standard or rolling upgrade.\n    -rollingupgrade rollback : Rollback a rolling upgrade operation.\n  Refer to HDFS documentation for the difference between standard\n  and rolling upgrades.";
    static final int CURRENT_BLOCK_FORMAT_VERSION = 1;
    private static final List<String> RECONFIGURABLE_PROPERTIES;
    public static final Log METRICS_LOG;
    private static final String DATANODE_HTRACE_PREFIX = "datanode.htrace.";
    volatile boolean shouldRun = true;
    volatile boolean shutdownForUpgrade = false;
    private boolean shutdownInProgress = false;
    private BlockPoolManager blockPoolManager;
    volatile FsDatasetSpi<? extends FsVolumeSpi> data = null;
    private String clusterId = null;
    final AtomicInteger xmitsInProgress = new AtomicInteger();
    Daemon dataXceiverServer = null;
    DataXceiverServer xserver = null;
    Daemon localDataXceiverServer = null;
    ShortCircuitRegistry shortCircuitRegistry = null;
    ThreadGroup threadGroup = null;
    private DNConf dnConf;
    private volatile boolean heartbeatsDisabledForTests = false;
    private volatile boolean cacheReportsDisabledForTests = false;
    private DataStorage storage = null;
    private DatanodeHttpServer httpServer = null;
    private int infoPort;
    private int infoSecurePort;
    DataNodeMetrics metrics;
    private InetSocketAddress streamingAddr;
    private LoadingCache<String, Map<String, Long>> datanodeNetworkCounts;
    private String hostName;
    private DatanodeID id;
    private final String fileDescriptorPassingDisabledReason;
    boolean isBlockTokenEnabled;
    BlockPoolTokenSecretManager blockPoolTokenSecretManager;
    private boolean hasAnyBlockPoolRegistered = false;
    private BlockScanner blockScanner;
    private DirectoryScanner directoryScanner = null;
    private List<ServicePlugin> plugins;
    public RPC.Server ipcServer;
    private JvmPauseMonitor pauseMonitor;
    private SecureDataNodeStarter.SecureResources secureResources = null;
    private List<StorageLocation> dataDirs;
    private Configuration conf;
    private final String confVersion;
    private final long maxNumberOfBlocksToLog;
    private final boolean pipelineSupportECN;
    private final List<String> usersWithLocalPathAccess;
    private final boolean connectToDnViaHostname;
    ReadaheadPool readaheadPool;
    SaslDataTransferClient saslClient;
    SaslDataTransferServer saslServer;
    private final boolean getHdfsBlockLocationsEnabled;
    private ObjectName dataNodeInfoBeanName;
    private Thread checkDiskErrorThread = null;
    protected final int checkDiskErrorInterval;
    private boolean checkDiskErrorFlag = false;
    private Object checkDiskErrorMutex = new Object();
    private long lastDiskErrorCheck;
    private String supergroup;
    private boolean isPermissionEnabled;
    private String dnUserName = null;
    private BlockRecoveryWorker blockRecoveryWorker;
    final Tracer tracer;
    private final TracerConfigurationManager tracerConfigurationManager;
    private static final int NUM_CORES;
    private static final double CONGESTION_RATIO = 1.5;
    private long[] oobTimeouts;
    private ScheduledThreadPoolExecutor metricsLoggerTimer;

    @Deprecated
    public static InetSocketAddress createSocketAddr(String target) {
        return NetUtils.createSocketAddr((String)target);
    }

    private static Tracer createTracer(Configuration conf) {
        return new Tracer.Builder("DataNode").conf(TraceUtils.wrapHadoopConf((String)DATANODE_HTRACE_PREFIX, (Configuration)conf)).build();
    }

    @InterfaceAudience.LimitedPrivate(value={"HDFS"})
    @VisibleForTesting
    DataNode(Configuration conf) {
        super(conf);
        this.blockScanner = new BlockScanner(this, conf);
        this.tracer = DataNode.createTracer(conf);
        this.tracerConfigurationManager = new TracerConfigurationManager(DATANODE_HTRACE_PREFIX, conf);
        this.fileDescriptorPassingDisabledReason = null;
        this.maxNumberOfBlocksToLog = 0L;
        this.confVersion = null;
        this.usersWithLocalPathAccess = null;
        this.connectToDnViaHostname = false;
        this.getHdfsBlockLocationsEnabled = false;
        this.pipelineSupportECN = false;
        this.checkDiskErrorInterval = ThreadLocalRandom.current().nextInt(5000, 6250);
        this.initOOBTimeout();
    }

    DataNode(Configuration conf, List<StorageLocation> dataDirs, SecureDataNodeStarter.SecureResources resources) throws IOException {
        super(conf);
        this.tracer = DataNode.createTracer(conf);
        this.tracerConfigurationManager = new TracerConfigurationManager(DATANODE_HTRACE_PREFIX, conf);
        this.blockScanner = new BlockScanner(this, conf);
        this.lastDiskErrorCheck = 0L;
        this.maxNumberOfBlocksToLog = conf.getLong("dfs.namenode.max-num-blocks-to-log", 1000L);
        this.usersWithLocalPathAccess = Arrays.asList(conf.getTrimmedStrings("dfs.block.local-path-access.user"));
        this.connectToDnViaHostname = conf.getBoolean("dfs.datanode.use.datanode.hostname", false);
        this.getHdfsBlockLocationsEnabled = conf.getBoolean("dfs.datanode.hdfs-blocks-metadata.enabled", false);
        this.supergroup = conf.get("dfs.permissions.superusergroup", "supergroup");
        this.isPermissionEnabled = conf.getBoolean("dfs.permissions.enabled", true);
        this.pipelineSupportECN = conf.getBoolean("dfs.pipeline.ecn", false);
        this.confVersion = "core-" + conf.get("hadoop.common.configuration.version", "UNSPECIFIED") + ",hdfs-" + conf.get("hadoop.hdfs.configuration.version", "UNSPECIFIED");
        this.checkDiskErrorInterval = ThreadLocalRandom.current().nextInt(5000, 6250);
        if (conf.getBoolean(HdfsClientConfigKeys.Read.ShortCircuit.KEY, false)) {
            String reason = DomainSocket.getLoadingFailureReason();
            if (reason != null) {
                LOG.warn("File descriptor passing is disabled because " + reason);
                this.fileDescriptorPassingDisabledReason = reason;
            } else {
                LOG.info("File descriptor passing is enabled.");
                this.fileDescriptorPassingDisabledReason = null;
            }
        } else {
            this.fileDescriptorPassingDisabledReason = "File descriptor passing was not configured.";
            LOG.debug(this.fileDescriptorPassingDisabledReason);
        }
        try {
            this.hostName = DataNode.getHostName(conf);
            LOG.info("Configured hostname is " + this.hostName);
            this.startDataNode(conf, dataDirs, resources);
        }
        catch (IOException ie) {
            this.shutdown();
            throw ie;
        }
        int dncCacheMaxSize = conf.getInt("dfs.datanode.network.counts.cache.max.size", Integer.MAX_VALUE);
        this.datanodeNetworkCounts = CacheBuilder.newBuilder().maximumSize((long)dncCacheMaxSize).build((CacheLoader)new CacheLoader<String, Map<String, Long>>(){

            public Map<String, Long> load(String key) throws Exception {
                HashMap<String, Long> ret = new HashMap<String, Long>();
                ret.put("networkErrors", 0L);
                return ret;
            }
        });
        this.initOOBTimeout();
    }

    protected Configuration getNewConf() {
        return new HdfsConfiguration();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String reconfigurePropertyImpl(String property, String newVal) throws ReconfigurationException {
        switch (property) {
            case "dfs.datanode.data.dir": {
                IOException rootException = null;
                try {
                    LOG.info("Reconfiguring " + property + " to " + newVal);
                    this.refreshVolumes(newVal);
                    String string = this.conf.get("dfs.datanode.data.dir");
                    return string;
                }
                catch (IOException e) {
                    rootException = e;
                    return rootException;
                }
                finally {
                    try {
                        this.triggerBlockReport(new BlockReportOptions.Factory().setIncremental(false).build());
                    }
                    catch (IOException e) {
                        LOG.warn("Exception while sending the block report after refreshing volumes " + property + " to " + newVal, (Throwable)e);
                        if (rootException == null) {
                            rootException = e;
                            return rootException;
                        }
                    }
                    finally {
                        if (rootException == null) throw new ReconfigurationException(property, newVal, this.getConf().get(property));
                        throw new ReconfigurationException(property, newVal, this.getConf().get(property), (Throwable)rootException);
                    }
                }
            }
            case "dfs.datanode.balance.max.concurrent.moves": {
                ReconfigurationException rootException = null;
                try {
                    int movers;
                    LOG.info("Reconfiguring " + property + " to " + newVal);
                    if (newVal == null) {
                        movers = 50;
                    } else {
                        movers = Integer.parseInt(newVal);
                        if (movers <= 0) {
                            rootException = new ReconfigurationException(property, newVal, this.getConf().get(property), (Throwable)new IllegalArgumentException("balancer max concurrent movers must be larger than 0"));
                        }
                    }
                    this.xserver.updateBalancerMaxConcurrentMovers(movers);
                    String string = Integer.toString(movers);
                    if (rootException == null) return string;
                }
                catch (NumberFormatException nfe) {
                    try {
                        rootException = new ReconfigurationException(property, newVal, this.getConf().get(property), (Throwable)nfe);
                        if (rootException == null) throw new ReconfigurationException(property, newVal, this.getConf().get(property));
                    }
                    catch (Throwable throwable) {
                        if (rootException == null) throw throwable;
                        LOG.warn(String.format("Exception in updating balancer max concurrent movers %s to %s", property, newVal), (Throwable)rootException);
                        throw rootException;
                    }
                    LOG.warn(String.format("Exception in updating balancer max concurrent movers %s to %s", property, newVal), (Throwable)rootException);
                    throw rootException;
                }
                LOG.warn(String.format("Exception in updating balancer max concurrent movers %s to %s", property, newVal), (Throwable)rootException);
                throw rootException;
            }
        }
        throw new ReconfigurationException(property, newVal, this.getConf().get(property));
    }

    public Collection<String> getReconfigurableProperties() {
        return RECONFIGURABLE_PROPERTIES;
    }

    public PipelineAck.ECN getECN() {
        if (!this.pipelineSupportECN) {
            return PipelineAck.ECN.DISABLED;
        }
        double load = ManagementFactory.getOperatingSystemMXBean().getSystemLoadAverage();
        return load > (double)NUM_CORES * 1.5 ? PipelineAck.ECN.CONGESTED : PipelineAck.ECN.SUPPORTED;
    }

    @VisibleForTesting
    ChangedVolumes parseChangedVolumes(String newVolumes) throws IOException {
        Configuration conf = new Configuration();
        conf.set("dfs.datanode.data.dir", newVolumes);
        List<StorageLocation> locations = DataNode.getStorageLocations(conf);
        if (locations.isEmpty()) {
            throw new IOException("No directory is specified.");
        }
        HashMap<String, StorageLocation> existingLocations = new HashMap<String, StorageLocation>();
        for (StorageLocation loc : DataNode.getStorageLocations(this.conf)) {
            existingLocations.put(loc.getFile().getCanonicalPath(), loc);
        }
        ChangedVolumes results = new ChangedVolumes();
        results.newLocations.addAll(locations);
        Iterator<Storage.StorageDirectory> it = this.storage.dirIterator();
        while (it.hasNext()) {
            Storage.StorageDirectory dir = it.next();
            boolean found = false;
            Iterator<StorageLocation> sl = results.newLocations.iterator();
            while (sl.hasNext()) {
                StorageLocation location = sl.next();
                if (!location.getFile().getCanonicalPath().equals(dir.getRoot().getCanonicalPath())) continue;
                sl.remove();
                StorageLocation old = (StorageLocation)existingLocations.get(location.getFile().getCanonicalPath());
                if (old != null && old.getStorageType() != location.getStorageType()) {
                    throw new IOException("Changing storage type is not allowed.");
                }
                results.unchangedLocations.add(location);
                found = true;
                break;
            }
            if (found) continue;
            results.deactivateLocations.add(StorageLocation.parse(dir.getRoot().toString()));
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void refreshVolumes(String newVolumes) throws IOException {
        Configuration conf = this.getConf();
        conf.set("dfs.datanode.data.dir", newVolumes);
        ExecutorService service = null;
        int numOldDataDirs = this.dataDirs.size();
        ChangedVolumes changedVolumes = this.parseChangedVolumes(newVolumes);
        StringBuilder errorMessageBuilder = new StringBuilder();
        ArrayList effectiveVolumes = Lists.newArrayList();
        for (StorageLocation sl : changedVolumes.unchangedLocations) {
            effectiveVolumes.add(sl.toString());
        }
        try {
            if (numOldDataDirs + changedVolumes.newLocations.size() - changedVolumes.deactivateLocations.size() <= 0) {
                throw new IOException("Attempt to remove all volumes.");
            }
            if (!changedVolumes.newLocations.isEmpty()) {
                LOG.info("Adding new volumes: " + Joiner.on((String)",").join(changedVolumes.newLocations));
                final ArrayList nsInfos = Lists.newArrayList();
                for (BPOfferService bpos : this.blockPoolManager.getAllNamenodeThreads()) {
                    nsInfos.add(bpos.getNamespaceInfo());
                }
                service = Executors.newFixedThreadPool(changedVolumes.newLocations.size());
                ArrayList exceptions = Lists.newArrayList();
                for (final StorageLocation location : changedVolumes.newLocations) {
                    exceptions.add(service.submit(new Callable<IOException>(){

                        @Override
                        public IOException call() {
                            try {
                                DataNode.this.data.addVolume(location, nsInfos);
                            }
                            catch (IOException e) {
                                return e;
                            }
                            return null;
                        }
                    }));
                }
                for (int i = 0; i < changedVolumes.newLocations.size(); ++i) {
                    StorageLocation volume = changedVolumes.newLocations.get(i);
                    Future ioExceptionFuture = (Future)exceptions.get(i);
                    try {
                        IOException ioe = (IOException)ioExceptionFuture.get();
                        if (ioe != null) {
                            errorMessageBuilder.append(String.format("FAILED TO ADD: %s: %s%n", volume, ioe.getMessage()));
                            LOG.error("Failed to add volume: " + volume, (Throwable)ioe);
                            continue;
                        }
                        effectiveVolumes.add(volume.toString());
                        LOG.info("Successfully added volume: " + volume);
                        continue;
                    }
                    catch (Exception e) {
                        errorMessageBuilder.append(String.format("FAILED to ADD: %s: %s%n", volume, e.toString()));
                        LOG.error("Failed to add volume: " + volume, (Throwable)e);
                    }
                }
            }
            try {
                this.removeVolumes(changedVolumes.deactivateLocations);
            }
            catch (IOException e) {
                errorMessageBuilder.append(e.getMessage());
                LOG.error("Failed to remove volume: " + e.getMessage(), (Throwable)e);
            }
            if (errorMessageBuilder.length() > 0) {
                throw new IOException(errorMessageBuilder.toString());
            }
        }
        finally {
            if (service != null) {
                service.shutdown();
            }
            conf.set("dfs.datanode.data.dir", Joiner.on((String)",").join((Iterable)effectiveVolumes));
            this.dataDirs = DataNode.getStorageLocations(conf);
        }
    }

    private void removeVolumes(Collection<StorageLocation> locations) throws IOException {
        if (locations.isEmpty()) {
            return;
        }
        HashSet<File> volumesToRemove = new HashSet<File>();
        for (StorageLocation loc : locations) {
            volumesToRemove.add(loc.getFile().getAbsoluteFile());
        }
        this.removeVolumes(volumesToRemove, true);
    }

    private synchronized void removeVolumes(Set<File> absoluteVolumePaths, boolean clearFailure) throws IOException {
        for (File vol : absoluteVolumePaths) {
            Preconditions.checkArgument((boolean)vol.isAbsolute());
        }
        if (absoluteVolumePaths.isEmpty()) {
            return;
        }
        LOG.info(String.format("Deactivating volumes (clear failure=%b): %s", clearFailure, Joiner.on((String)",").join(absoluteVolumePaths)));
        IOException ioe = null;
        this.data.removeVolumes(absoluteVolumePaths, clearFailure);
        try {
            this.storage.removeVolumes(absoluteVolumePaths);
        }
        catch (IOException e) {
            ioe = e;
        }
        Iterator<StorageLocation> it = this.dataDirs.iterator();
        while (it.hasNext()) {
            StorageLocation loc = it.next();
            if (!absoluteVolumePaths.contains(loc.getFile().getAbsoluteFile())) continue;
            it.remove();
        }
        this.conf.set("dfs.datanode.data.dir", Joiner.on((String)",").join(this.dataDirs));
        if (ioe != null) {
            throw ioe;
        }
    }

    private synchronized void setClusterId(String nsCid, String bpid) throws IOException {
        if (this.clusterId != null && !this.clusterId.equals(nsCid)) {
            throw new IOException("Cluster IDs not matched: dn cid=" + this.clusterId + " but ns cid=" + nsCid + "; bpid=" + bpid);
        }
        this.clusterId = nsCid;
    }

    private static String getHostName(Configuration config) throws UnknownHostException {
        String name = config.get("dfs.datanode.hostname");
        if (name == null) {
            String dnsInterface = config.get("hadoop.security.dns.interface");
            String nameServer = config.get("hadoop.security.dns.nameserver");
            boolean fallbackToHosts = false;
            if (dnsInterface == null) {
                dnsInterface = config.get("dfs.datanode.dns.interface");
                nameServer = config.get("dfs.datanode.dns.nameserver");
            } else {
                fallbackToHosts = true;
            }
            name = DNS.getDefaultHost((String)dnsInterface, (String)nameServer, (boolean)fallbackToHosts);
        }
        return name;
    }

    private void startInfoServer(Configuration conf) throws IOException {
        ServerSocketChannel httpServerChannel = this.secureResources != null ? this.secureResources.getHttpServerChannel() : null;
        this.httpServer = new DatanodeHttpServer(conf, this, httpServerChannel);
        this.httpServer.start();
        if (this.httpServer.getHttpAddress() != null) {
            this.infoPort = this.httpServer.getHttpAddress().getPort();
        }
        if (this.httpServer.getHttpsAddress() != null) {
            this.infoSecurePort = this.httpServer.getHttpsAddress().getPort();
        }
    }

    private void startPlugins(Configuration conf) {
        try {
            this.plugins = conf.getInstances("dfs.datanode.plugins", ServicePlugin.class);
        }
        catch (RuntimeException e) {
            String pluginsValue = conf.get("dfs.datanode.plugins");
            LOG.error("Unable to load DataNode plugins. Specified list of plugins: " + pluginsValue, (Throwable)e);
            throw e;
        }
        for (ServicePlugin p : this.plugins) {
            try {
                p.start((Object)this);
                LOG.info("Started plug-in " + p);
            }
            catch (Throwable t) {
                LOG.warn("ServicePlugin " + p + " could not be started", t);
            }
        }
    }

    private void initIpcServer(Configuration conf) throws IOException {
        InetSocketAddress ipcAddr = NetUtils.createSocketAddr((String)conf.getTrimmed("dfs.datanode.ipc.address"));
        RPC.setProtocolEngine((Configuration)conf, ClientDatanodeProtocolPB.class, ProtobufRpcEngine.class);
        ClientDatanodeProtocolServerSideTranslatorPB clientDatanodeProtocolXlator = new ClientDatanodeProtocolServerSideTranslatorPB(this);
        BlockingService service = ClientDatanodeProtocolProtos.ClientDatanodeProtocolService.newReflectiveBlockingService((ClientDatanodeProtocolProtos.ClientDatanodeProtocolService.BlockingInterface)clientDatanodeProtocolXlator);
        this.ipcServer = new RPC.Builder(conf).setProtocol(ClientDatanodeProtocolPB.class).setInstance((Object)service).setBindAddress(ipcAddr.getHostName()).setPort(ipcAddr.getPort()).setNumHandlers(conf.getInt("dfs.datanode.handler.count", 10)).setVerbose(false).setSecretManager((SecretManager)this.blockPoolTokenSecretManager).build();
        InterDatanodeProtocolServerSideTranslatorPB interDatanodeProtocolXlator = new InterDatanodeProtocolServerSideTranslatorPB(this);
        service = InterDatanodeProtocolProtos.InterDatanodeProtocolService.newReflectiveBlockingService(interDatanodeProtocolXlator);
        DFSUtil.addPBProtocol(conf, InterDatanodeProtocolPB.class, service, this.ipcServer);
        TraceAdminProtocolServerSideTranslatorPB traceAdminXlator = new TraceAdminProtocolServerSideTranslatorPB((TraceAdminProtocol)this);
        BlockingService traceAdminService = TraceAdminPB.TraceAdminService.newReflectiveBlockingService((TraceAdminPB.TraceAdminService.BlockingInterface)traceAdminXlator);
        DFSUtil.addPBProtocol(conf, TraceAdminProtocolPB.class, traceAdminService, this.ipcServer);
        LOG.info("Opened IPC server at " + this.ipcServer.getListenerAddress());
        if (conf.getBoolean("hadoop.security.authorization", false)) {
            this.ipcServer.refreshServiceAcl(conf, (PolicyProvider)new HDFSPolicyProvider());
        }
    }

    private void checkSuperuserPrivilege() throws IOException, AccessControlException {
        if (!this.isPermissionEnabled) {
            return;
        }
        DataNode dataNode = this;
        UserGroupInformation callerUgi = dataNode.ipcServer.getRemoteUser();
        if (callerUgi == null) {
            callerUgi = UserGroupInformation.getCurrentUser();
        }
        assert (this.dnUserName != null);
        if (callerUgi.getUserName().equals(this.dnUserName)) {
            return;
        }
        List<String> groups = Arrays.asList(callerUgi.getGroupNames());
        if (groups.contains(this.supergroup)) {
            return;
        }
        throw new AccessControlException();
    }

    private void shutdownPeriodicScanners() {
        this.shutdownDirectoryScanner();
        this.blockScanner.removeAllVolumeScanners();
    }

    private synchronized void initDirectoryScanner(Configuration conf) {
        if (this.directoryScanner != null) {
            return;
        }
        String reason = null;
        if (conf.getInt("dfs.datanode.directoryscan.interval", 21600) < 0) {
            reason = "verification is turned off by configuration";
        } else if ("SimulatedFSDataset".equals(this.data.getClass().getSimpleName())) {
            reason = "verifcation is not supported by SimulatedFSDataset";
        }
        if (reason == null) {
            this.directoryScanner = new DirectoryScanner(this, this.data, conf);
            this.directoryScanner.start();
        } else {
            LOG.info("Periodic Directory Tree Verification scan is disabled because " + reason);
        }
    }

    private synchronized void shutdownDirectoryScanner() {
        if (this.directoryScanner != null) {
            this.directoryScanner.shutdown();
        }
    }

    private void initDataXceiver(Configuration conf) throws IOException {
        DomainPeerServer domainPeerServer;
        TcpPeerServer tcpPeerServer;
        if (this.secureResources != null) {
            tcpPeerServer = new TcpPeerServer(this.secureResources);
        } else {
            int backlogLength = conf.getInt("ipc.server.listen.queue.size", 128);
            tcpPeerServer = new TcpPeerServer(this.dnConf.socketWriteTimeout, DataNode.getStreamingAddr(conf), backlogLength);
        }
        if (this.dnConf.getTransferSocketRecvBufferSize() > 0) {
            tcpPeerServer.setReceiveBufferSize(this.dnConf.getTransferSocketRecvBufferSize());
        }
        this.streamingAddr = tcpPeerServer.getStreamingAddr();
        LOG.info("Opened streaming server at " + this.streamingAddr);
        this.threadGroup = new ThreadGroup("dataXceiverServer");
        this.xserver = new DataXceiverServer(tcpPeerServer, conf, this);
        this.dataXceiverServer = new Daemon(this.threadGroup, (Runnable)this.xserver);
        this.threadGroup.setDaemon(true);
        if ((conf.getBoolean(HdfsClientConfigKeys.Read.ShortCircuit.KEY, false) || conf.getBoolean("dfs.client.domain.socket.data.traffic", false)) && (domainPeerServer = DataNode.getDomainPeerServer(conf, this.streamingAddr.getPort())) != null) {
            this.localDataXceiverServer = new Daemon(this.threadGroup, (Runnable)new DataXceiverServer(domainPeerServer, conf, this));
            LOG.info("Listening on UNIX domain socket: " + domainPeerServer.getBindPath());
        }
        this.shortCircuitRegistry = new ShortCircuitRegistry(conf);
    }

    private static DomainPeerServer getDomainPeerServer(Configuration conf, int port) throws IOException {
        String domainSocketPath = conf.getTrimmed("dfs.domain.socket.path", "");
        if (domainSocketPath.isEmpty()) {
            if (conf.getBoolean(HdfsClientConfigKeys.Read.ShortCircuit.KEY, false) && !conf.getBoolean("dfs.client.use.legacy.blockreader.local", false)) {
                LOG.warn("Although short-circuit local reads are configured, they are disabled because you didn't configure dfs.domain.socket.path");
            }
            return null;
        }
        if (DomainSocket.getLoadingFailureReason() != null) {
            throw new RuntimeException("Although a UNIX domain socket path is configured as " + domainSocketPath + ", we cannot " + "start a localDataXceiverServer because " + DomainSocket.getLoadingFailureReason());
        }
        DomainPeerServer domainPeerServer = new DomainPeerServer(domainSocketPath, port);
        int recvBufferSize = conf.getInt("dfs.datanode.transfer.socket.recv.buffer.size", 0);
        if (recvBufferSize > 0) {
            domainPeerServer.setReceiveBufferSize(recvBufferSize);
        }
        return domainPeerServer;
    }

    public void notifyNamenodeReceivedBlock(ExtendedBlock block, String delHint, String storageUuid, boolean isOnTransientStorage) {
        BPOfferService bpos = this.blockPoolManager.get(block.getBlockPoolId());
        if (bpos != null) {
            bpos.notifyNamenodeReceivedBlock(block, delHint, storageUuid, isOnTransientStorage);
        } else {
            LOG.error("Cannot find BPOfferService for reporting block received for bpid=" + block.getBlockPoolId());
        }
    }

    protected void notifyNamenodeReceivingBlock(ExtendedBlock block, String storageUuid) {
        BPOfferService bpos = this.blockPoolManager.get(block.getBlockPoolId());
        if (bpos != null) {
            bpos.notifyNamenodeReceivingBlock(block, storageUuid);
        } else {
            LOG.error("Cannot find BPOfferService for reporting block receiving for bpid=" + block.getBlockPoolId());
        }
    }

    public void notifyNamenodeDeletedBlock(ExtendedBlock block, String storageUuid) {
        BPOfferService bpos = this.blockPoolManager.get(block.getBlockPoolId());
        if (bpos != null) {
            bpos.notifyNamenodeDeletedBlock(block, storageUuid);
        } else {
            LOG.error("Cannot find BPOfferService for reporting block deleted for bpid=" + block.getBlockPoolId());
        }
    }

    public void reportBadBlocks(ExtendedBlock block) throws IOException {
        Object volume = this.getFSDataset().getVolume(block);
        if (volume == null) {
            LOG.warn("Cannot find FsVolumeSpi to report bad block: " + block);
            return;
        }
        this.reportBadBlocks(block, (FsVolumeSpi)volume);
    }

    public void reportBadBlocks(ExtendedBlock block, FsVolumeSpi volume) throws IOException {
        BPOfferService bpos = this.getBPOSForBlock(block);
        bpos.reportBadBlocks(block, volume.getStorageID(), volume.getStorageType());
    }

    public void reportRemoteBadBlock(DatanodeInfo srcDataNode, ExtendedBlock block) throws IOException {
        BPOfferService bpos = this.getBPOSForBlock(block);
        bpos.reportRemoteBadBlock(srcDataNode, block);
    }

    void trySendErrorReport(String bpid, int errCode, String errMsg) {
        BPOfferService bpos = this.blockPoolManager.get(bpid);
        if (bpos == null) {
            throw new IllegalArgumentException("Bad block pool: " + bpid);
        }
        bpos.trySendErrorReport(errCode, errMsg);
    }

    private BPOfferService getBPOSForBlock(ExtendedBlock block) throws IOException {
        Preconditions.checkNotNull((Object)block);
        BPOfferService bpos = this.blockPoolManager.get(block.getBlockPoolId());
        if (bpos == null) {
            throw new IOException("cannot locate OfferService thread for bp=" + block.getBlockPoolId());
        }
        return bpos;
    }

    @VisibleForTesting
    public void setHeartbeatsDisabledForTests(boolean heartbeatsDisabledForTests) {
        this.heartbeatsDisabledForTests = heartbeatsDisabledForTests;
    }

    @VisibleForTesting
    boolean areHeartbeatsDisabledForTests() {
        return this.heartbeatsDisabledForTests;
    }

    @VisibleForTesting
    void setCacheReportsDisabledForTest(boolean disabled) {
        this.cacheReportsDisabledForTests = disabled;
    }

    @VisibleForTesting
    boolean areCacheReportsDisabledForTests() {
        return this.cacheReportsDisabledForTests;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startDataNode(Configuration conf, List<StorageLocation> dataDirs, SecureDataNodeStarter.SecureResources resources) throws IOException {
        this.secureResources = resources;
        DataNode dataNode = this;
        synchronized (dataNode) {
            this.dataDirs = dataDirs;
        }
        this.conf = conf;
        this.dnConf = new DNConf(conf);
        DataNode.checkSecureConfig(this.dnConf, conf, resources);
        if (this.dnConf.maxLockedMemory > 0L) {
            if (!NativeIO.POSIX.getCacheManipulator().verifyCanMlock()) {
                throw new RuntimeException(String.format("Cannot start datanode because the configured max locked memory size (%s) is greater than zero and native code is not available.", "dfs.datanode.max.locked.memory"));
            }
            if (Path.WINDOWS) {
                NativeIO.Windows.extendWorkingSetSize((long)this.dnConf.maxLockedMemory);
            } else {
                long ulimit = NativeIO.POSIX.getCacheManipulator().getMemlockLimit();
                if (this.dnConf.maxLockedMemory > ulimit) {
                    throw new RuntimeException(String.format("Cannot start datanode because the configured max locked memory size (%s) of %d bytes is more than the datanode's available RLIMIT_MEMLOCK ulimit of %d bytes.", "dfs.datanode.max.locked.memory", this.dnConf.maxLockedMemory, ulimit));
                }
            }
        }
        LOG.info("Starting DataNode with maxLockedMemory = " + this.dnConf.maxLockedMemory);
        int volFailuresTolerated = this.dnConf.getVolFailuresTolerated();
        int volsConfigured = this.dnConf.getVolsConfigured();
        if (volFailuresTolerated < 0 || volFailuresTolerated >= volsConfigured) {
            throw new DiskChecker.DiskErrorException("Invalid value configured for dfs.datanode.failed.volumes.tolerated - " + volFailuresTolerated + ". Value configured is either less than 0 or >= " + "to the number of configured volumes (" + volsConfigured + ").");
        }
        this.storage = new DataStorage();
        this.registerMXBean();
        this.initDataXceiver(conf);
        this.startInfoServer(conf);
        this.pauseMonitor = new JvmPauseMonitor(conf);
        this.pauseMonitor.start();
        this.blockPoolTokenSecretManager = new BlockPoolTokenSecretManager();
        this.dnUserName = UserGroupInformation.getCurrentUser().getUserName();
        LOG.info("dnUserName = " + this.dnUserName);
        LOG.info("supergroup = " + this.supergroup);
        this.initIpcServer(conf);
        this.metrics = DataNodeMetrics.create(conf, this.getDisplayName());
        this.metrics.getJvmMetrics().setPauseMonitor(this.pauseMonitor);
        this.blockRecoveryWorker = new BlockRecoveryWorker(this);
        this.blockPoolManager = new BlockPoolManager(this);
        this.blockPoolManager.refreshNamenodes(conf);
        this.readaheadPool = ReadaheadPool.getInstance();
        this.saslClient = new SaslDataTransferClient(this.dnConf.conf, this.dnConf.saslPropsResolver, this.dnConf.trustedChannelResolver);
        this.saslServer = new SaslDataTransferServer(this.dnConf, this.blockPoolTokenSecretManager);
        this.startMetricsLogger(conf);
    }

    private static void checkSecureConfig(DNConf dnConf, Configuration conf, SecureDataNodeStarter.SecureResources resources) throws RuntimeException {
        if (!UserGroupInformation.isSecurityEnabled()) {
            return;
        }
        boolean isEnabled = conf.getBoolean("dfs.block.access.token.enable", false);
        if (!isEnabled) {
            String errMessage = "Security is enabled but block access tokens (via dfs.block.access.token.enable) aren't enabled. This may cause issues when clients attempt to connect to a DataNode. Aborting DataNode";
            throw new RuntimeException(errMessage);
        }
        SaslPropertiesResolver saslPropsResolver = dnConf.getSaslPropsResolver();
        if (resources != null && saslPropsResolver == null) {
            return;
        }
        if (dnConf.getIgnoreSecurePortsForTesting()) {
            return;
        }
        if (saslPropsResolver != null && DFSUtil.getHttpPolicy(conf) == HttpConfig.Policy.HTTPS_ONLY && resources == null) {
            return;
        }
        throw new RuntimeException("Cannot start secure DataNode without configuring either privileged resources or SASL RPC data transfer protection and SSL for HTTP.  Using privileged resources in combination with SASL RPC data transfer protection is not supported.");
    }

    public static String generateUuid() {
        return UUID.randomUUID().toString();
    }

    synchronized void checkDatanodeUuid() throws IOException {
        if (this.storage.getDatanodeUuid() == null) {
            this.storage.setDatanodeUuid(DataNode.generateUuid());
            this.storage.writeAll();
            LOG.info("Generated and persisted new Datanode UUID " + this.storage.getDatanodeUuid());
        }
    }

    DatanodeRegistration createBPRegistration(NamespaceInfo nsInfo) {
        StorageInfo storageInfo = this.storage.getBPStorage(nsInfo.getBlockPoolID());
        if (storageInfo == null) {
            storageInfo = new StorageInfo(DataNodeLayoutVersion.CURRENT_LAYOUT_VERSION, nsInfo.getNamespaceID(), nsInfo.clusterID, nsInfo.getCTime(), HdfsServerConstants.NodeType.DATA_NODE);
        }
        DatanodeID dnId = new DatanodeID(this.streamingAddr.getAddress().getHostAddress(), this.hostName, this.storage.getDatanodeUuid(), this.getXferPort(), this.getInfoPort(), this.infoSecurePort, this.getIpcPort());
        return new DatanodeRegistration(dnId, storageInfo, new ExportedBlockKeys(), VersionInfo.getVersion());
    }

    synchronized void bpRegistrationSucceeded(DatanodeRegistration bpRegistration, String blockPoolId) throws IOException {
        this.id = bpRegistration;
        if (!this.storage.getDatanodeUuid().equals(bpRegistration.getDatanodeUuid())) {
            throw new IOException("Inconsistent Datanode IDs. Name-node returned " + bpRegistration.getDatanodeUuid() + ". Expecting " + this.storage.getDatanodeUuid());
        }
        this.registerBlockPoolWithSecretManager(bpRegistration, blockPoolId);
    }

    private synchronized void registerBlockPoolWithSecretManager(DatanodeRegistration bpRegistration, String blockPoolId) throws IOException {
        ExportedBlockKeys keys = bpRegistration.getExportedKeys();
        if (!this.hasAnyBlockPoolRegistered) {
            this.hasAnyBlockPoolRegistered = true;
            this.isBlockTokenEnabled = keys.isBlockTokenEnabled();
        } else if (this.isBlockTokenEnabled != keys.isBlockTokenEnabled()) {
            throw new RuntimeException("Inconsistent configuration of block access tokens. Either all block pools must be configured to use block tokens, or none may be.");
        }
        if (!this.isBlockTokenEnabled) {
            return;
        }
        if (!this.blockPoolTokenSecretManager.isBlockPoolRegistered(blockPoolId)) {
            long blockKeyUpdateInterval = keys.getKeyUpdateInterval();
            long blockTokenLifetime = keys.getTokenLifetime();
            LOG.info("Block token params received from NN: for block pool " + blockPoolId + " keyUpdateInterval=" + blockKeyUpdateInterval / 60000L + " min(s), tokenLifetime=" + blockTokenLifetime / 60000L + " min(s)");
            BlockTokenSecretManager secretMgr = new BlockTokenSecretManager(0L, blockTokenLifetime, blockPoolId, this.dnConf.encryptionAlgorithm);
            this.blockPoolTokenSecretManager.addBlockPool(blockPoolId, secretMgr);
        }
    }

    void shutdownBlockPool(BPOfferService bpos) {
        this.blockPoolManager.remove(bpos);
        if (bpos.hasBlockPoolId()) {
            String bpId = bpos.getBlockPoolId();
            this.blockScanner.disableBlockPoolId(bpId);
            if (this.data != null) {
                this.data.shutdownBlockPool(bpId);
            }
            if (this.storage != null) {
                this.storage.removeBlockPoolStorage(bpId);
            }
        }
    }

    void initBlockPool(BPOfferService bpos) throws IOException {
        NamespaceInfo nsInfo = bpos.getNamespaceInfo();
        if (nsInfo == null) {
            throw new IOException("NamespaceInfo not found: Block pool " + bpos + " should have retrieved namespace info before initBlockPool.");
        }
        this.setClusterId(nsInfo.clusterID, nsInfo.getBlockPoolID());
        this.blockPoolManager.addBlockPool(bpos);
        this.initStorage(nsInfo);
        this.checkDiskError();
        this.data.addBlockPool(nsInfo.getBlockPoolID(), this.conf);
        this.blockScanner.enableBlockPoolId(bpos.getBlockPoolId());
        this.initDirectoryScanner(this.conf);
    }

    List<BPOfferService> getAllBpOs() {
        return this.blockPoolManager.getAllNamenodeThreads();
    }

    BPOfferService getBPOfferService(String bpid) {
        return this.blockPoolManager.get(bpid);
    }

    int getBpOsCount() {
        return this.blockPoolManager.getAllNamenodeThreads().size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initStorage(NamespaceInfo nsInfo) throws IOException {
        FsDatasetSpi.Factory<?> factory = FsDatasetSpi.Factory.getFactory(this.conf);
        if (!factory.isSimulated()) {
            HdfsServerConstants.StartupOption startOpt = DataNode.getStartupOption(this.conf);
            if (startOpt == null) {
                throw new IOException("Startup option not set.");
            }
            String bpid = nsInfo.getBlockPoolID();
            DataNode dataNode = this;
            synchronized (dataNode) {
                this.storage.recoverTransitionRead(this, nsInfo, this.dataDirs, startOpt);
            }
            BlockPoolSliceStorage bpStorage = this.storage.getBPStorage(bpid);
            LOG.info("Setting up storage: nsid=" + bpStorage.getNamespaceID() + ";bpid=" + bpid + ";lv=" + this.storage.getLayoutVersion() + ";nsInfo=" + nsInfo + ";dnuuid=" + this.storage.getDatanodeUuid());
        }
        this.checkDatanodeUuid();
        DataNode dataNode = this;
        synchronized (dataNode) {
            if (this.data == null) {
                this.data = factory.newInstance(this, this.storage, this.conf);
            }
        }
    }

    public static InetSocketAddress getInfoAddr(Configuration conf) {
        return NetUtils.createSocketAddr((String)conf.getTrimmed("dfs.datanode.http.address", "0.0.0.0:50075"));
    }

    private void registerMXBean() {
        this.dataNodeInfoBeanName = MBeans.register((String)"DataNode", (String)"DataNodeInfo", (Object)this);
    }

    @VisibleForTesting
    public DataXceiverServer getXferServer() {
        return this.xserver;
    }

    @VisibleForTesting
    public int getXferPort() {
        return this.streamingAddr.getPort();
    }

    public String getDisplayName() {
        return this.hostName + ":" + this.getXferPort();
    }

    public InetSocketAddress getXferAddress() {
        return this.streamingAddr;
    }

    public int getIpcPort() {
        return this.ipcServer.getListenerAddress().getPort();
    }

    @VisibleForTesting
    public DatanodeRegistration getDNRegistrationForBP(String bpid) throws IOException {
        DataNodeFaultInjector.get().noRegistration();
        BPOfferService bpos = this.blockPoolManager.get(bpid);
        if (bpos == null || bpos.bpRegistration == null) {
            throw new IOException("cannot find BPOfferService for bpid=" + bpid);
        }
        return bpos.bpRegistration;
    }

    protected Socket newSocket() throws IOException {
        return this.dnConf.socketWriteTimeout > 0 ? SocketChannel.open().socket() : new Socket();
    }

    DatanodeProtocolClientSideTranslatorPB connectToNN(InetSocketAddress nnAddr) throws IOException {
        return new DatanodeProtocolClientSideTranslatorPB(nnAddr, this.conf);
    }

    DatanodeLifelineProtocolClientSideTranslatorPB connectToLifelineNN(InetSocketAddress lifelineNnAddr) throws IOException {
        return new DatanodeLifelineProtocolClientSideTranslatorPB(lifelineNnAddr, this.conf);
    }

    public static InterDatanodeProtocol createInterDataNodeProtocolProxy(DatanodeID datanodeid, final Configuration conf, final int socketTimeout, boolean connectToDnViaHostname) throws IOException {
        String dnAddr = datanodeid.getIpcAddr(connectToDnViaHostname);
        final InetSocketAddress addr = NetUtils.createSocketAddr((String)dnAddr);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Connecting to datanode " + dnAddr + " addr=" + addr);
        }
        final UserGroupInformation loginUgi = UserGroupInformation.getLoginUser();
        try {
            return (InterDatanodeProtocol)loginUgi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<InterDatanodeProtocol>(){

                @Override
                public InterDatanodeProtocol run() throws IOException {
                    return new InterDatanodeProtocolTranslatorPB(addr, loginUgi, conf, NetUtils.getDefaultSocketFactory((Configuration)conf), socketTimeout);
                }
            });
        }
        catch (InterruptedException ie) {
            throw new IOException(ie.getMessage());
        }
    }

    public DataNodeMetrics getMetrics() {
        return this.metrics;
    }

    private void checkKerberosAuthMethod(String msg) throws IOException {
        if (!UserGroupInformation.isSecurityEnabled()) {
            return;
        }
        if (UserGroupInformation.getCurrentUser().getAuthenticationMethod() != UserGroupInformation.AuthenticationMethod.KERBEROS) {
            throw new AccessControlException("Error in " + msg + "Only kerberos based authentication is allowed.");
        }
    }

    private void checkBlockLocalPathAccess() throws IOException {
        this.checkKerberosAuthMethod("getBlockLocalPathInfo()");
        String currentUser = UserGroupInformation.getCurrentUser().getShortUserName();
        if (!this.usersWithLocalPathAccess.contains(currentUser)) {
            throw new AccessControlException("Can't continue with getBlockLocalPathInfo() authorization. The user " + currentUser + " is not configured in " + "dfs.block.local-path-access.user");
        }
    }

    public long getMaxNumberOfBlocksToLog() {
        return this.maxNumberOfBlocksToLog;
    }

    public BlockLocalPathInfo getBlockLocalPathInfo(ExtendedBlock block, Token<BlockTokenIdentifier> token) throws IOException {
        this.checkBlockLocalPathAccess();
        this.checkBlockToken(block, token, BlockTokenIdentifier.AccessMode.READ);
        Preconditions.checkNotNull(this.data, (Object)"Storage not yet initialized");
        BlockLocalPathInfo info = this.data.getBlockLocalPathInfo(block);
        if (LOG.isDebugEnabled()) {
            if (info != null) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("getBlockLocalPathInfo successful block=" + block + " blockfile " + info.getBlockPath() + " metafile " + info.getMetaPath());
                }
            } else if (LOG.isTraceEnabled()) {
                LOG.trace("getBlockLocalPathInfo for block=" + block + " returning null");
            }
        }
        this.metrics.incrBlocksGetLocalPathInfo();
        return info;
    }

    FileInputStream[] requestShortCircuitFdsForRead(ExtendedBlock blk, Token<BlockTokenIdentifier> token, int maxVersion) throws ShortCircuitFdsUnsupportedException, ShortCircuitFdsVersionException, IOException {
        if (this.fileDescriptorPassingDisabledReason != null) {
            throw new ShortCircuitFdsUnsupportedException(this.fileDescriptorPassingDisabledReason);
        }
        int blkVersion = 1;
        if (maxVersion < blkVersion) {
            throw new ShortCircuitFdsVersionException("Your client is too old to read this block!  Its format version is " + blkVersion + ", but the highest format version you can read is " + maxVersion);
        }
        this.metrics.incrBlocksGetLocalPathInfo();
        FileInputStream[] fis = new FileInputStream[2];
        try {
            fis[0] = (FileInputStream)this.data.getBlockInputStream(blk, 0L);
            fis[1] = DatanodeUtil.getMetaDataInputStream(blk, this.data);
        }
        catch (ClassCastException e) {
            LOG.debug("requestShortCircuitFdsForRead failed", (Throwable)e);
            throw new ShortCircuitFdsUnsupportedException("This DataNode's FsDatasetSpi does not support short-circuit local reads");
        }
        return fis;
    }

    public HdfsBlocksMetadata getHdfsBlocksMetadata(String bpId, long[] blockIds, List<Token<BlockTokenIdentifier>> tokens) throws IOException, UnsupportedOperationException {
        if (!this.getHdfsBlockLocationsEnabled) {
            throw new UnsupportedOperationException("Datanode#getHdfsBlocksMetadata  is not enabled in datanode config");
        }
        if (blockIds.length != tokens.size()) {
            throw new IOException("Differing number of blocks and tokens");
        }
        for (int i = 0; i < blockIds.length; ++i) {
            this.checkBlockToken(new ExtendedBlock(bpId, blockIds[i]), tokens.get(i), BlockTokenIdentifier.AccessMode.READ);
        }
        DataNodeFaultInjector.get().getHdfsBlocksMetadata();
        return this.data.getHdfsBlocksMetadata(bpId, blockIds);
    }

    private void checkBlockToken(ExtendedBlock block, Token<BlockTokenIdentifier> token, BlockTokenIdentifier.AccessMode accessMode) throws IOException {
        if (this.isBlockTokenEnabled) {
            BlockTokenIdentifier id = new BlockTokenIdentifier();
            ByteArrayInputStream buf = new ByteArrayInputStream(token.getIdentifier());
            DataInputStream in = new DataInputStream(buf);
            id.readFields((DataInput)in);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Got: " + id.toString());
            }
            this.blockPoolTokenSecretManager.checkAccess(id, null, block, accessMode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        ArrayList<BPOfferService> bposArray;
        this.stopMetricsLogger();
        if (this.plugins != null) {
            for (ServicePlugin p : this.plugins) {
                try {
                    p.stop();
                    LOG.info("Stopped plug-in " + p);
                }
                catch (Throwable t) {
                    LOG.warn("ServicePlugin " + p + " could not be stopped", t);
                }
            }
        }
        List<Object> list = bposArray = this.blockPoolManager == null ? new ArrayList() : this.blockPoolManager.getAllNamenodeThreads();
        if (!this.shutdownForUpgrade) {
            this.shouldRun = false;
        }
        if (this.dataXceiverServer != null) {
            try {
                this.xserver.sendOOBToPeers();
                ((DataXceiverServer)this.dataXceiverServer.getRunnable()).kill();
                this.dataXceiverServer.interrupt();
            }
            catch (Exception e) {
                LOG.trace("Exception interrupting DataXceiverServer: ", (Throwable)e);
            }
        }
        if (this.checkDiskErrorThread != null) {
            this.checkDiskErrorThread.interrupt();
        }
        long timeNotified = Time.monotonicNow();
        if (this.localDataXceiverServer != null) {
            ((DataXceiverServer)this.localDataXceiverServer.getRunnable()).kill();
            this.localDataXceiverServer.interrupt();
        }
        this.shutdownPeriodicScanners();
        if (this.httpServer != null) {
            try {
                this.httpServer.close();
            }
            catch (Exception e) {
                LOG.warn("Exception shutting down DataNode HttpServer", (Throwable)e);
            }
        }
        if (this.pauseMonitor != null) {
            this.pauseMonitor.stop();
        }
        this.shouldRun = false;
        this.shutdownReconfigurationTask();
        if (this.threadGroup != null) {
            int sleepMs = 2;
            while (true) {
                if (!this.shutdownForUpgrade || this.shutdownForUpgrade && Time.monotonicNow() - timeNotified > 1000L) {
                    this.threadGroup.interrupt();
                    break;
                }
                LOG.info("Waiting for threadgroup to exit, active threads is " + this.threadGroup.activeCount());
                if (this.threadGroup.activeCount() == 0) break;
                try {
                    Thread.sleep(sleepMs);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if ((sleepMs = sleepMs * 3 / 2) <= 200) continue;
                sleepMs = 200;
            }
            this.threadGroup = null;
        }
        if (this.dataXceiverServer != null) {
            try {
                this.dataXceiverServer.join();
            }
            catch (InterruptedException sleepMs) {
                // empty catch block
            }
        }
        if (this.localDataXceiverServer != null) {
            try {
                this.localDataXceiverServer.join();
            }
            catch (InterruptedException sleepMs) {
                // empty catch block
            }
        }
        if (this.ipcServer != null) {
            this.ipcServer.stop();
        }
        if (this.blockPoolManager != null) {
            try {
                this.blockPoolManager.shutDownAll(bposArray);
            }
            catch (InterruptedException ie) {
                LOG.warn("Received exception in BlockPoolManager#shutDownAll: ", (Throwable)ie);
            }
        }
        if (this.storage != null) {
            try {
                this.storage.unlockAll();
            }
            catch (IOException ie) {
                LOG.warn("Exception when unlocking storage: " + ie, (Throwable)ie);
            }
        }
        if (this.data != null) {
            this.data.shutdown();
        }
        if (this.metrics != null) {
            this.metrics.shutdown();
        }
        if (this.dataNodeInfoBeanName != null) {
            MBeans.unregister((ObjectName)this.dataNodeInfoBeanName);
            this.dataNodeInfoBeanName = null;
        }
        if (this.shortCircuitRegistry != null) {
            this.shortCircuitRegistry.shutdown();
        }
        LOG.info("Shutdown complete.");
        DataNode dataNode = this;
        synchronized (dataNode) {
            this.shouldRun = false;
            this.notifyAll();
        }
        this.tracer.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkDiskErrorAsync() {
        Object object = this.checkDiskErrorMutex;
        synchronized (object) {
            this.checkDiskErrorFlag = true;
            if (this.checkDiskErrorThread == null) {
                this.startCheckDiskErrorThread();
                this.checkDiskErrorThread.start();
                LOG.info("Starting CheckDiskError Thread");
            }
        }
    }

    private void handleDiskError(String errMsgr) {
        boolean hasEnoughResources = this.data.hasEnoughResource();
        LOG.warn("DataNode.handleDiskError: Keep Running: " + hasEnoughResources);
        int dpError = hasEnoughResources ? 1 : 3;
        this.metrics.incrVolumeFailures();
        for (BPOfferService bpos : this.blockPoolManager.getAllNamenodeThreads()) {
            bpos.trySendErrorReport(dpError, errMsgr);
        }
        if (hasEnoughResources) {
            this.scheduleAllBlockReport(0L);
            return;
        }
        LOG.warn("DataNode is shutting down: " + errMsgr);
        this.shouldRun = false;
    }

    @Override
    public int getXceiverCount() {
        return this.threadGroup == null ? 0 : this.threadGroup.activeCount();
    }

    @Override
    public Map<String, Map<String, Long>> getDatanodeNetworkCounts() {
        return this.datanodeNetworkCounts.asMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void incrDatanodeNetworkErrors(String host) {
        this.metrics.incrDatanodeNetworkErrors();
        LoadingCache<String, Map<String, Long>> loadingCache = this.datanodeNetworkCounts;
        synchronized (loadingCache) {
            try {
                Map curCount = (Map)this.datanodeNetworkCounts.get((Object)host);
                curCount.put("networkErrors", (Long)curCount.get("networkErrors") + 1L);
                this.datanodeNetworkCounts.put((Object)host, (Object)curCount);
            }
            catch (ExecutionException e) {
                LOG.warn("failed to increment network error counts for " + host);
            }
        }
    }

    @Override
    public int getXmitsInProgress() {
        return this.xmitsInProgress.get();
    }

    private void reportBadBlock(BPOfferService bpos, ExtendedBlock block, String msg) {
        Object volume = this.getFSDataset().getVolume(block);
        if (volume == null) {
            LOG.warn("Cannot find FsVolumeSpi to report bad block: " + block);
            return;
        }
        bpos.reportBadBlocks(block, volume.getStorageID(), volume.getStorageType());
        LOG.warn(msg);
    }

    @VisibleForTesting
    void transferBlock(ExtendedBlock block, DatanodeInfo[] xferTargets, StorageType[] xferTargetStorageTypes) throws IOException {
        BPOfferService bpos = this.getBPOSForBlock(block);
        DatanodeRegistration bpReg = this.getDNRegistrationForBP(block.getBlockPoolId());
        boolean replicaNotExist = false;
        boolean replicaStateNotFinalized = false;
        boolean blockFileNotExist = false;
        boolean lengthTooShort = false;
        try {
            this.data.checkBlock(block, block.getNumBytes(), HdfsServerConstants.ReplicaState.FINALIZED);
        }
        catch (ReplicaNotFoundException e) {
            replicaNotExist = true;
        }
        catch (UnexpectedReplicaStateException e) {
            replicaStateNotFinalized = true;
        }
        catch (FileNotFoundException e) {
            blockFileNotExist = true;
        }
        catch (EOFException e) {
            lengthTooShort = true;
        }
        catch (IOException e) {
            blockFileNotExist = true;
        }
        if (replicaNotExist || replicaStateNotFinalized) {
            String errStr = "Can't send invalid block " + block;
            LOG.info(errStr);
            bpos.trySendErrorReport(2, errStr);
            return;
        }
        if (blockFileNotExist) {
            this.reportBadBlock(bpos, block, "Can't replicate block " + block + " because the block file doesn't exist, or is not accessible");
            return;
        }
        if (lengthTooShort) {
            this.reportBadBlock(bpos, block, "Can't replicate block " + block + " because on-disk length " + this.data.getLength(block) + " is shorter than NameNode recorded length " + block.getNumBytes());
            return;
        }
        int numTargets = xferTargets.length;
        if (numTargets > 0) {
            StringBuilder xfersBuilder = new StringBuilder();
            for (int i = 0; i < numTargets; ++i) {
                xfersBuilder.append(xferTargets[i]);
                xfersBuilder.append(" ");
            }
            LOG.info(bpReg + " Starting thread to transfer " + block + " to " + xfersBuilder);
            new Daemon((Runnable)new DataTransfer(xferTargets, xferTargetStorageTypes, block, BlockConstructionStage.PIPELINE_SETUP_CREATE, "")).start();
        }
    }

    void transferBlocks(String poolId, Block[] blocks, DatanodeInfo[][] xferTargets, StorageType[][] xferTargetStorageTypes) {
        for (int i = 0; i < blocks.length; ++i) {
            try {
                this.transferBlock(new ExtendedBlock(poolId, blocks[i]), xferTargets[i], xferTargetStorageTypes[i]);
                continue;
            }
            catch (IOException ie) {
                LOG.warn("Failed to transfer block " + blocks[i], (Throwable)ie);
            }
        }
    }

    DataEncryptionKeyFactory getDataEncryptionKeyFactoryForBlock(final ExtendedBlock block) {
        return new DataEncryptionKeyFactory(){

            public DataEncryptionKey newDataEncryptionKey() {
                return ((DataNode)DataNode.this).dnConf.encryptDataTransfer ? DataNode.this.blockPoolTokenSecretManager.generateDataEncryptionKey(block.getBlockPoolId()) : null;
            }
        };
    }

    void closeBlock(ExtendedBlock block, String delHint, String storageUuid, boolean isTransientStorage) {
        this.metrics.incrBlocksWritten();
        this.notifyNamenodeReceivedBlock(block, delHint, storageUuid, isTransientStorage);
    }

    public void runDatanodeDaemon() throws IOException {
        this.blockPoolManager.startAll();
        this.dataXceiverServer.start();
        if (this.localDataXceiverServer != null) {
            this.localDataXceiverServer.start();
        }
        this.ipcServer.setTracer(this.tracer);
        this.ipcServer.start();
        this.startPlugins(this.conf);
    }

    public boolean isDatanodeUp() {
        for (BPOfferService bp : this.blockPoolManager.getAllNamenodeThreads()) {
            if (!bp.isAlive()) continue;
            return true;
        }
        return false;
    }

    public static DataNode instantiateDataNode(String[] args, Configuration conf) throws IOException {
        return DataNode.instantiateDataNode(args, conf, null);
    }

    public static DataNode instantiateDataNode(String[] args, Configuration conf, SecureDataNodeStarter.SecureResources resources) throws IOException {
        if (conf == null) {
            conf = new HdfsConfiguration();
        }
        if (args != null) {
            GenericOptionsParser hParser = new GenericOptionsParser(conf, args);
            args = hParser.getRemainingArgs();
        }
        if (!DataNode.parseArguments(args, conf)) {
            DataNode.printUsage(System.err);
            return null;
        }
        List<StorageLocation> dataLocations = DataNode.getStorageLocations(conf);
        UserGroupInformation.setConfiguration((Configuration)conf);
        SecurityUtil.login((Configuration)conf, (String)"dfs.datanode.keytab.file", (String)"dfs.datanode.kerberos.principal", (String)DataNode.getHostName(conf));
        return DataNode.makeInstance(dataLocations, conf, resources);
    }

    public static List<StorageLocation> getStorageLocations(Configuration conf) {
        Collection rawLocations = conf.getTrimmedStringCollection("dfs.datanode.data.dir");
        ArrayList<StorageLocation> locations = new ArrayList<StorageLocation>(rawLocations.size());
        for (String locationString : rawLocations) {
            StorageLocation location;
            try {
                location = StorageLocation.parse(locationString);
            }
            catch (IOException ioe) {
                LOG.error("Failed to initialize storage directory " + locationString + ". Exception details: " + ioe);
                continue;
            }
            catch (SecurityException se) {
                LOG.error("Failed to initialize storage directory " + locationString + ". Exception details: " + se);
                continue;
            }
            locations.add(location);
        }
        return locations;
    }

    @VisibleForTesting
    public static DataNode createDataNode(String[] args, Configuration conf) throws IOException {
        return DataNode.createDataNode(args, conf, null);
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    public static DataNode createDataNode(String[] args, Configuration conf, SecureDataNodeStarter.SecureResources resources) throws IOException {
        DataNode dn = DataNode.instantiateDataNode(args, conf, resources);
        if (dn != null) {
            dn.runDatanodeDaemon();
        }
        return dn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void join() {
        while (this.shouldRun) {
            try {
                this.blockPoolManager.joinAll();
                if (this.blockPoolManager.getAllNamenodeThreads().size() == 0) {
                    this.shouldRun = false;
                }
                DataNode dataNode = this;
                synchronized (dataNode) {
                    this.wait(2000L);
                }
            }
            catch (InterruptedException ex) {
                LOG.warn("Received exception in Datanode#join: " + ex);
            }
        }
    }

    static DataNode makeInstance(Collection<StorageLocation> dataDirs, Configuration conf, SecureDataNodeStarter.SecureResources resources) throws IOException {
        LocalFileSystem localFS = FileSystem.getLocal((Configuration)conf);
        FsPermission permission = new FsPermission(conf.get("dfs.datanode.data.dir.perm", "700"));
        DataNodeDiskChecker dataNodeDiskChecker = new DataNodeDiskChecker(permission);
        List<StorageLocation> locations = DataNode.checkStorageLocations(dataDirs, localFS, dataNodeDiskChecker);
        DefaultMetricsSystem.initialize((String)"DataNode");
        assert (locations.size() > 0) : "number of data directories should be > 0";
        return new DataNode(conf, locations, resources);
    }

    static List<StorageLocation> checkStorageLocations(Collection<StorageLocation> dataDirs, LocalFileSystem localFS, DataNodeDiskChecker dataNodeDiskChecker) throws IOException {
        ArrayList<StorageLocation> locations = new ArrayList<StorageLocation>();
        StringBuilder invalidDirs = new StringBuilder();
        for (StorageLocation location : dataDirs) {
            URI uri = location.getUri();
            try {
                dataNodeDiskChecker.checkDir(localFS, new Path(uri));
                locations.add(location);
            }
            catch (IOException ioe) {
                LOG.warn("Invalid dfs.datanode.data.dir " + location.getFile() + " : ", (Throwable)ioe);
                invalidDirs.append("\"").append(uri.getPath()).append("\" ");
            }
        }
        if (locations.size() == 0) {
            throw new IOException("All directories in dfs.datanode.data.dir are invalid: " + invalidDirs);
        }
        return locations;
    }

    public String toString() {
        return "DataNode{data=" + this.data + ", localName='" + this.getDisplayName() + "', datanodeUuid='" + this.storage.getDatanodeUuid() + "', xmitsInProgress=" + this.xmitsInProgress.get() + "}";
    }

    private static void printUsage(PrintStream out) {
        out.println("Usage: hdfs datanode [-regular | -rollback | -rollingupgrade rollback ]\n    -regular                 : Normal DataNode startup (default).\n    -rollback                : Rollback a standard or rolling upgrade.\n    -rollingupgrade rollback : Rollback a rolling upgrade operation.\n  Refer to HDFS documentation for the difference between standard\n  and rolling upgrades.\n");
    }

    @VisibleForTesting
    static boolean parseArguments(String[] args, Configuration conf) {
        HdfsServerConstants.StartupOption startOpt = HdfsServerConstants.StartupOption.REGULAR;
        int i = 0;
        if (args != null && args.length != 0) {
            String cmd;
            if ("-r".equalsIgnoreCase(cmd = args[i++]) || "--rack".equalsIgnoreCase(cmd)) {
                LOG.error("-r, --rack arguments are not supported anymore. RackID resolution is handled by the NameNode.");
                return false;
            }
            if (HdfsServerConstants.StartupOption.ROLLBACK.getName().equalsIgnoreCase(cmd)) {
                startOpt = HdfsServerConstants.StartupOption.ROLLBACK;
            } else if (HdfsServerConstants.StartupOption.REGULAR.getName().equalsIgnoreCase(cmd)) {
                startOpt = HdfsServerConstants.StartupOption.REGULAR;
            } else {
                return false;
            }
        }
        DataNode.setStartupOption(conf, startOpt);
        return args == null || i == args.length;
    }

    private static void setStartupOption(Configuration conf, HdfsServerConstants.StartupOption opt) {
        conf.set("dfs.datanode.startup", opt.toString());
    }

    static HdfsServerConstants.StartupOption getStartupOption(Configuration conf) {
        String value = conf.get("dfs.datanode.startup", HdfsServerConstants.StartupOption.REGULAR.toString());
        return HdfsServerConstants.StartupOption.getEnum(value);
    }

    public void scheduleAllBlockReport(long delay) {
        for (BPOfferService bpos : this.blockPoolManager.getAllNamenodeThreads()) {
            bpos.scheduleBlockReport(delay);
        }
    }

    @VisibleForTesting
    public FsDatasetSpi<?> getFSDataset() {
        return this.data;
    }

    @VisibleForTesting
    public BlockScanner getBlockScanner() {
        return this.blockScanner;
    }

    @VisibleForTesting
    DirectoryScanner getDirectoryScanner() {
        return this.directoryScanner;
    }

    @VisibleForTesting
    public BlockPoolTokenSecretManager getBlockPoolTokenSecretManager() {
        return this.blockPoolTokenSecretManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void secureMain(String[] args, SecureDataNodeStarter.SecureResources resources) {
        int errorCode = 0;
        try {
            StringUtils.startupShutdownMessage(DataNode.class, (String[])args, (Logger)LOG);
            DataNode datanode = DataNode.createDataNode(args, null, resources);
            if (datanode != null) {
                datanode.join();
            } else {
                errorCode = 1;
            }
        }
        catch (Throwable e) {
            LOG.error("Exception in secureMain", e);
            ExitUtil.terminate((int)1, (Throwable)e);
        }
        finally {
            LOG.warn("Exiting Datanode");
            ExitUtil.terminate((int)errorCode);
        }
    }

    public static void main(String[] args) {
        if (DFSUtil.parseHelpArgument(args, USAGE, System.out, true)) {
            System.exit(0);
        }
        DataNode.secureMain(args, null);
    }

    @Override
    public ReplicaRecoveryInfo initReplicaRecovery(BlockRecoveryCommand.RecoveringBlock rBlock) throws IOException {
        return this.data.initReplicaRecovery(rBlock);
    }

    @Override
    public String updateReplicaUnderRecovery(ExtendedBlock oldBlock, long recoveryId, long newBlockId, long newLength) throws IOException {
        Replica r = this.data.updateReplicaUnderRecovery(oldBlock, recoveryId, newBlockId, newLength);
        ExtendedBlock newBlock = new ExtendedBlock(oldBlock);
        newBlock.setGenerationStamp(recoveryId);
        newBlock.setBlockId(newBlockId);
        newBlock.setNumBytes(newLength);
        String storageID = r.getStorageUuid();
        this.notifyNamenodeReceivedBlock(newBlock, null, storageID, r.isOnTransientStorage());
        return storageID;
    }

    public long getReplicaVisibleLength(ExtendedBlock block) throws IOException {
        this.checkReadAccess(block);
        return this.data.getReplicaVisibleLength(block);
    }

    private void checkReadAccess(ExtendedBlock block) throws IOException {
        try {
            this.getDNRegistrationForBP(block.getBlockPoolId());
        }
        catch (IOException e) {
            throw new RetriableException("Datanode not registered. Try again later.");
        }
        if (this.isBlockTokenEnabled) {
            Set tokenIds = UserGroupInformation.getCurrentUser().getTokenIdentifiers();
            if (tokenIds.size() != 1) {
                throw new IOException("Can't continue since none or more than one BlockTokenIdentifier is found.");
            }
            for (TokenIdentifier tokenId : tokenIds) {
                BlockTokenIdentifier id = (BlockTokenIdentifier)tokenId;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Got: " + id.toString());
                }
                this.blockPoolTokenSecretManager.checkAccess(id, null, block, BlockTokenIdentifier.AccessMode.READ);
            }
        }
    }

    void transferReplicaForPipelineRecovery(ExtendedBlock b, DatanodeInfo[] targets, StorageType[] targetStorageTypes, String client) throws IOException {
        long visible;
        BlockConstructionStage stage;
        try (AutoCloseableLock lock = this.data.acquireDatasetLock();){
            Block storedBlock = this.data.getStoredBlock(b.getBlockPoolId(), b.getBlockId());
            if (null == storedBlock) {
                throw new IOException(b + " not found in datanode.");
            }
            long storedGS = storedBlock.getGenerationStamp();
            if (storedGS < b.getGenerationStamp()) {
                throw new IOException(storedGS + " = storedGS < b.getGenerationStamp(), b=" + b);
            }
            b.setGenerationStamp(storedGS);
            if (this.data.isValidRbw(b)) {
                stage = BlockConstructionStage.TRANSFER_RBW;
            } else if (this.data.isValidBlock(b)) {
                stage = BlockConstructionStage.TRANSFER_FINALIZED;
            } else {
                String r = this.data.getReplicaString(b.getBlockPoolId(), b.getBlockId());
                throw new IOException(b + " is neither a RBW nor a Finalized, r=" + r);
            }
            visible = this.data.getReplicaVisibleLength(b);
        }
        b.setNumBytes(visible);
        if (targets.length > 0) {
            new DataTransfer(targets, targetStorageTypes, b, stage, client).run();
        }
    }

    void finalizeUpgradeForPool(String blockPoolId) throws IOException {
        this.storage.finalizeUpgrade(blockPoolId);
    }

    static InetSocketAddress getStreamingAddr(Configuration conf) {
        return NetUtils.createSocketAddr((String)conf.getTrimmed("dfs.datanode.address", "0.0.0.0:50010"));
    }

    @Override
    public String getVersion() {
        return VersionInfo.getVersion();
    }

    @Override
    public String getRpcPort() {
        InetSocketAddress ipcAddr = NetUtils.createSocketAddr((String)this.getConf().get("dfs.datanode.ipc.address"));
        return Integer.toString(ipcAddr.getPort());
    }

    @Override
    public String getDataPort() {
        InetSocketAddress dataAddr = NetUtils.createSocketAddr((String)this.getConf().get("dfs.datanode.address"));
        return Integer.toString(dataAddr.getPort());
    }

    @Override
    public String getHttpPort() {
        return this.getConf().get("dfs.datanode.info.port");
    }

    public int getInfoPort() {
        return this.infoPort;
    }

    public int getInfoSecurePort() {
        return this.infoSecurePort;
    }

    @Override
    public String getNamenodeAddresses() {
        HashMap<String, String> info = new HashMap<String, String>();
        for (BPOfferService bpos : this.blockPoolManager.getAllNamenodeThreads()) {
            if (bpos == null) continue;
            for (BPServiceActor actor : bpos.getBPServiceActors()) {
                info.put(actor.getNNSocketAddress().getHostName(), bpos.getBlockPoolId());
            }
        }
        return JSON.toString(info);
    }

    @Override
    public String getDatanodeHostname() {
        return this.hostName;
    }

    @Override
    public String getBPServiceActorInfo() {
        ArrayList<Map<String, String>> infoArray = new ArrayList<Map<String, String>>();
        for (BPOfferService bpos : this.blockPoolManager.getAllNamenodeThreads()) {
            if (bpos == null) continue;
            for (BPServiceActor actor : bpos.getBPServiceActors()) {
                infoArray.add(actor.getActorInfoMap());
            }
        }
        return JSON.toString(infoArray);
    }

    @Override
    public String getVolumeInfo() {
        Preconditions.checkNotNull(this.data, (Object)"Storage not yet initialized");
        return JSON.toString(this.data.getVolumeInfoMap());
    }

    @Override
    public synchronized String getClusterId() {
        return this.clusterId;
    }

    public void refreshNamenodes(Configuration conf) throws IOException {
        this.blockPoolManager.refreshNamenodes(conf);
    }

    public void refreshNamenodes() throws IOException {
        this.checkSuperuserPrivilege();
        this.conf = new Configuration();
        this.refreshNamenodes(this.conf);
    }

    public void deleteBlockPool(String blockPoolId, boolean force) throws IOException {
        this.checkSuperuserPrivilege();
        LOG.info("deleteBlockPool command received for block pool " + blockPoolId + ", force=" + force);
        if (this.blockPoolManager.get(blockPoolId) != null) {
            LOG.warn("The block pool " + blockPoolId + " is still running, cannot be deleted.");
            throw new IOException("The block pool is still running. First do a refreshNamenodes to shutdown the block pool service");
        }
        this.data.deleteBlockPool(blockPoolId, force);
    }

    public synchronized void shutdownDatanode(boolean forUpgrade) throws IOException {
        this.checkSuperuserPrivilege();
        LOG.info("shutdownDatanode command received (upgrade=" + forUpgrade + "). Shutting down Datanode...");
        if (this.shutdownInProgress) {
            throw new IOException("Shutdown already in progress.");
        }
        this.shutdownInProgress = true;
        this.shutdownForUpgrade = forUpgrade;
        Thread shutdownThread = new Thread("Async datanode shutdown thread"){

            @Override
            public void run() {
                if (!DataNode.this.shutdownForUpgrade) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                DataNode.this.shutdown();
            }
        };
        shutdownThread.setDaemon(true);
        shutdownThread.start();
    }

    public void evictWriters() throws IOException {
        this.checkSuperuserPrivilege();
        LOG.info("Evicting all writers.");
        this.xserver.stopWriters();
    }

    public DatanodeLocalInfo getDatanodeInfo() {
        long uptime = ManagementFactory.getRuntimeMXBean().getUptime() / 1000L;
        return new DatanodeLocalInfo(VersionInfo.getVersion(), this.confVersion, uptime);
    }

    public void startReconfiguration() throws IOException {
        this.checkSuperuserPrivilege();
        this.startReconfigurationTask();
    }

    public ReconfigurationTaskStatus getReconfigurationStatus() throws IOException {
        this.checkSuperuserPrivilege();
        return this.getReconfigurationTaskStatus();
    }

    public List<String> listReconfigurableProperties() throws IOException {
        return RECONFIGURABLE_PROPERTIES;
    }

    public void triggerBlockReport(BlockReportOptions options) throws IOException {
        this.checkSuperuserPrivilege();
        for (BPOfferService bpos : this.blockPoolManager.getAllNamenodeThreads()) {
            if (bpos == null) continue;
            for (BPServiceActor actor : bpos.getBPServiceActors()) {
                actor.triggerBlockReport(options);
            }
        }
    }

    public boolean isConnectedToNN(InetSocketAddress addr) {
        for (BPOfferService bpos : this.getAllBpOs()) {
            for (BPServiceActor bpsa : bpos.getBPServiceActors()) {
                if (!addr.equals(bpsa.getNNSocketAddress())) continue;
                return bpsa.isAlive();
            }
        }
        return false;
    }

    public boolean isBPServiceAlive(String bpid) {
        BPOfferService bp = this.blockPoolManager.get(bpid);
        return bp != null ? bp.isAlive() : false;
    }

    boolean isRestarting() {
        return this.shutdownForUpgrade;
    }

    public boolean isDatanodeFullyStarted() {
        for (BPOfferService bp : this.blockPoolManager.getAllNamenodeThreads()) {
            if (bp.isInitialized() && bp.isAlive()) continue;
            return false;
        }
        return true;
    }

    @VisibleForTesting
    public DatanodeID getDatanodeId() {
        return this.id;
    }

    @VisibleForTesting
    public void clearAllBlockSecretKeys() {
        this.blockPoolTokenSecretManager.clearAllKeysForTesting();
    }

    public long getBalancerBandwidth() {
        DataXceiverServer dxcs = (DataXceiverServer)this.dataXceiverServer.getRunnable();
        return dxcs.balanceThrottler.getBandwidth();
    }

    public DNConf getDnConf() {
        return this.dnConf;
    }

    public String getDatanodeUuid() {
        return this.storage == null ? null : this.storage.getDatanodeUuid();
    }

    boolean shouldRun() {
        return this.shouldRun;
    }

    @VisibleForTesting
    DataStorage getStorage() {
        return this.storage;
    }

    public ShortCircuitRegistry getShortCircuitRegistry() {
        return this.shortCircuitRegistry;
    }

    private void checkDiskError() {
        Set<File> unhealthyDataDirs = this.data.checkDataDir();
        if (unhealthyDataDirs != null && !unhealthyDataDirs.isEmpty()) {
            try {
                this.removeVolumes(unhealthyDataDirs, false);
            }
            catch (IOException e) {
                LOG.warn("Error occurred when removing unhealthy storage dirs: " + e.getMessage(), (Throwable)e);
            }
            StringBuilder sb = new StringBuilder("DataNode failed volumes:");
            for (File dataDir : unhealthyDataDirs) {
                sb.append(dataDir.getAbsolutePath() + ";");
            }
            this.handleDiskError(sb.toString());
        }
    }

    private void startCheckDiskErrorThread() {
        this.checkDiskErrorThread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (DataNode.this.shouldRun) {
                    boolean tempFlag;
                    Object object = DataNode.this.checkDiskErrorMutex;
                    synchronized (object) {
                        tempFlag = DataNode.this.checkDiskErrorFlag;
                        DataNode.this.checkDiskErrorFlag = false;
                    }
                    if (tempFlag) {
                        try {
                            DataNode.this.checkDiskError();
                        }
                        catch (Exception e) {
                            LOG.warn("Unexpected exception occurred while checking disk error  " + e);
                            DataNode.this.checkDiskErrorThread = null;
                            return;
                        }
                        Object e = DataNode.this.checkDiskErrorMutex;
                        synchronized (e) {
                            DataNode.this.lastDiskErrorCheck = Time.monotonicNow();
                        }
                    }
                    try {
                        Thread.sleep(DataNode.this.checkDiskErrorInterval);
                    }
                    catch (InterruptedException e) {
                        LOG.debug("InterruptedException in check disk error thread", (Throwable)e);
                        DataNode.this.checkDiskErrorThread = null;
                        return;
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLastDiskErrorCheck() {
        Object object = this.checkDiskErrorMutex;
        synchronized (object) {
            return this.lastDiskErrorCheck;
        }
    }

    public SpanReceiverInfo[] listSpanReceivers() throws IOException {
        this.checkSuperuserPrivilege();
        return this.tracerConfigurationManager.listSpanReceivers();
    }

    public long addSpanReceiver(SpanReceiverInfo info) throws IOException {
        this.checkSuperuserPrivilege();
        return this.tracerConfigurationManager.addSpanReceiver(info);
    }

    public void removeSpanReceiver(long id) throws IOException {
        this.checkSuperuserPrivilege();
        this.tracerConfigurationManager.removeSpanReceiver(id);
    }

    public BlockRecoveryWorker getBlockRecoveryWorker() {
        return this.blockRecoveryWorker;
    }

    private void initOOBTimeout() {
        int oobStart = 8;
        int oobEnd = 11;
        int numOobTypes = 4;
        this.oobTimeouts = new long[4];
        String[] ele = this.conf.get("dfs.datanode.oob.timeout-ms", "1500,0,0,0").split(",");
        for (int i = 0; i < 4; ++i) {
            this.oobTimeouts[i] = i < ele.length ? Long.parseLong(ele[i]) : 0L;
        }
    }

    public long getOOBTimeout(DataTransferProtos.Status status) throws IOException {
        if (status.getNumber() < 8 || status.getNumber() > 11) {
            throw new IOException("Not an OOB status: " + status);
        }
        return this.oobTimeouts[status.getNumber() - 8];
    }

    protected void startMetricsLogger(Configuration metricConf) {
        long metricsLoggerPeriodSec = metricConf.getInt("dfs.datanode.metrics.logger.period.seconds", 600);
        if (metricsLoggerPeriodSec <= 0L) {
            return;
        }
        MetricsLoggerTask.makeMetricsLoggerAsync(METRICS_LOG);
        this.metricsLoggerTimer = new ScheduledThreadPoolExecutor(1);
        this.metricsLoggerTimer.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
        this.metricsLoggerTimer.scheduleWithFixedDelay(new MetricsLoggerTask(METRICS_LOG, "DataNode", 0), metricsLoggerPeriodSec, metricsLoggerPeriodSec, TimeUnit.SECONDS);
    }

    protected void stopMetricsLogger() {
        if (this.metricsLoggerTimer != null) {
            this.metricsLoggerTimer.shutdown();
            this.metricsLoggerTimer = null;
        }
    }

    @VisibleForTesting
    ScheduledThreadPoolExecutor getMetricsLoggerTimer() {
        return this.metricsLoggerTimer;
    }

    @VisibleForTesting
    void setBlockScanner(BlockScanner blockScanner) {
        this.blockScanner = blockScanner;
    }

    static {
        HdfsConfiguration.init();
        ClientTraceLog = LogFactory.getLog((String)(DataNode.class.getName() + ".clienttrace"));
        RECONFIGURABLE_PROPERTIES = Collections.unmodifiableList(Arrays.asList("dfs.datanode.data.dir", "dfs.datanode.balance.max.concurrent.moves"));
        METRICS_LOG = LogFactory.getLog((String)"DataNodeMetricsLog");
        NUM_CORES = Runtime.getRuntime().availableProcessors();
    }

    static class DataNodeDiskChecker {
        private final FsPermission expectedPermission;

        public DataNodeDiskChecker(FsPermission expectedPermission) {
            this.expectedPermission = expectedPermission;
        }

        public void checkDir(LocalFileSystem localFS, Path path) throws DiskChecker.DiskErrorException, IOException {
            DiskChecker.checkDir((LocalFileSystem)localFS, (Path)path, (FsPermission)this.expectedPermission);
        }
    }

    private class DataTransfer
    implements Runnable {
        final DatanodeInfo[] targets;
        final StorageType[] targetStorageTypes;
        final ExtendedBlock b;
        final BlockConstructionStage stage;
        private final DatanodeRegistration bpReg;
        final String clientname;
        final CachingStrategy cachingStrategy;

        DataTransfer(DatanodeInfo[] targets, StorageType[] targetStorageTypes, ExtendedBlock b, BlockConstructionStage stage, String clientname) {
            if (DataTransferProtocol.LOG.isDebugEnabled()) {
                DataTransferProtocol.LOG.debug(this.getClass().getSimpleName() + ": " + b + " (numBytes=" + b.getNumBytes() + ")" + ", stage=" + stage + ", clientname=" + clientname + ", targets=" + Arrays.asList(targets) + ", target storage types=" + (targetStorageTypes == null ? "[]" : Arrays.asList(targetStorageTypes)));
            }
            this.targets = targets;
            this.targetStorageTypes = targetStorageTypes;
            this.b = b;
            this.stage = stage;
            BPOfferService bpos = DataNode.this.blockPoolManager.get(b.getBlockPoolId());
            this.bpReg = bpos.bpRegistration;
            this.clientname = clientname;
            this.cachingStrategy = new CachingStrategy(Boolean.valueOf(true), Long.valueOf(DataNode.this.getDnConf().readaheadLength));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            DataNode.this.xmitsInProgress.getAndIncrement();
            Socket sock = null;
            DataOutputStream out = null;
            DataInputStream in = null;
            BlockSender blockSender = null;
            boolean isClient = this.clientname.length() > 0;
            try {
                String dnAddr = this.targets[0].getXferAddr(DataNode.this.connectToDnViaHostname);
                InetSocketAddress curTarget = NetUtils.createSocketAddr((String)dnAddr);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Connecting to datanode " + dnAddr);
                }
                sock = DataNode.this.newSocket();
                NetUtils.connect((Socket)sock, (SocketAddress)curTarget, (int)((DataNode)DataNode.this).dnConf.socketTimeout);
                sock.setSoTimeout(this.targets.length * ((DataNode)DataNode.this).dnConf.socketTimeout);
                Token<BlockTokenIdentifier> accessToken = BlockTokenSecretManager.DUMMY_TOKEN;
                if (DataNode.this.isBlockTokenEnabled) {
                    accessToken = DataNode.this.blockPoolTokenSecretManager.generateToken(this.b, EnumSet.of(BlockTokenIdentifier.AccessMode.WRITE));
                }
                long writeTimeout = ((DataNode)DataNode.this).dnConf.socketWriteTimeout + 5000 * (this.targets.length - 1);
                OutputStream unbufOut = NetUtils.getOutputStream((Socket)sock, (long)writeTimeout);
                Object unbufIn = NetUtils.getInputStream((Socket)sock);
                DataEncryptionKeyFactory keyFactory = DataNode.this.getDataEncryptionKeyFactoryForBlock(this.b);
                IOStreamPair saslStreams = DataNode.this.saslClient.socketSend(sock, unbufOut, (InputStream)unbufIn, keyFactory, accessToken, (DatanodeID)this.bpReg);
                unbufOut = saslStreams.out;
                unbufIn = saslStreams.in;
                out = new DataOutputStream(new BufferedOutputStream(unbufOut, DFSUtilClient.getSmallBufferSize((Configuration)DataNode.this.conf)));
                in = new DataInputStream((InputStream)unbufIn);
                blockSender = new BlockSender(this.b, 0L, this.b.getNumBytes(), false, false, true, DataNode.this, null, this.cachingStrategy);
                DatanodeInfo srcNode = new DatanodeInfo((DatanodeID)this.bpReg);
                new Sender(out).writeBlock(this.b, this.targetStorageTypes[0], accessToken, this.clientname, this.targets, this.targetStorageTypes, srcNode, this.stage, 0, 0L, 0L, 0L, blockSender.getChecksum(), this.cachingStrategy, false, false, null);
                blockSender.sendBlock(out, unbufOut, null);
                LOG.info(this.getClass().getSimpleName() + ", at " + DataNode.this.getDisplayName() + ": Transmitted " + this.b + " (numBytes=" + this.b.getNumBytes() + ") to " + curTarget);
                if (isClient) {
                    DataTransferProtos.DNTransferAckProto closeAck = DataTransferProtos.DNTransferAckProto.parseFrom((InputStream)PBHelperClient.vintPrefixed((InputStream)in));
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(this.getClass().getSimpleName() + ": close-ack=" + closeAck);
                    }
                    if (closeAck.getStatus() != DataTransferProtos.Status.SUCCESS) {
                        if (closeAck.getStatus() == DataTransferProtos.Status.ERROR_ACCESS_TOKEN) {
                            throw new InvalidBlockTokenException("Got access token error for connect ack, targets=" + Arrays.asList(this.targets));
                        }
                        throw new IOException("Bad connect ack, targets=" + Arrays.asList(this.targets) + " status=" + closeAck.getStatus());
                    }
                } else {
                    DataNode.this.metrics.incrBlocksReplicated();
                }
                DataNode.this.xmitsInProgress.getAndDecrement();
            }
            catch (IOException ie) {
                try {
                    if (ie instanceof InvalidChecksumSizeException) {
                        LOG.info("Adding block: " + this.b + " for scanning");
                        DataNode.this.blockScanner.markSuspectBlock(DataNode.this.data.getVolume(this.b).getStorageID(), this.b);
                    }
                    LOG.warn(this.bpReg + ":Failed to transfer " + this.b + " to " + this.targets[0] + " got ", (Throwable)ie);
                    DataNode.this.checkDiskErrorAsync();
                    DataNode.this.xmitsInProgress.getAndDecrement();
                }
                catch (Throwable throwable) {
                    DataNode.this.xmitsInProgress.getAndDecrement();
                    IOUtils.closeStream(blockSender);
                    IOUtils.closeStream(out);
                    IOUtils.closeStream(in);
                    IOUtils.closeSocket(sock);
                    throw throwable;
                }
                IOUtils.closeStream(blockSender);
                IOUtils.closeStream(out);
                IOUtils.closeStream(in);
                IOUtils.closeSocket((Socket)sock);
            }
            IOUtils.closeStream((Closeable)blockSender);
            IOUtils.closeStream((Closeable)out);
            IOUtils.closeStream((Closeable)in);
            IOUtils.closeSocket((Socket)sock);
        }
    }

    @InterfaceAudience.LimitedPrivate(value={"HDFS"})
    public static class ShortCircuitFdsVersionException
    extends IOException {
        private static final long serialVersionUID = 1L;

        public ShortCircuitFdsVersionException(String msg) {
            super(msg);
        }
    }

    @InterfaceAudience.LimitedPrivate(value={"HDFS"})
    public static class ShortCircuitFdsUnsupportedException
    extends IOException {
        private static final long serialVersionUID = 1L;

        public ShortCircuitFdsUnsupportedException(String msg) {
            super(msg);
        }
    }

    @VisibleForTesting
    static class ChangedVolumes {
        List<StorageLocation> newLocations = Lists.newArrayList();
        List<StorageLocation> deactivateLocations = Lists.newArrayList();
        List<StorageLocation> unchangedLocations = Lists.newArrayList();

        ChangedVolumes() {
        }
    }
}

