/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocolPB;

import com.google.protobuf.RpcController;
import com.google.protobuf.ServiceException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.BatchedRemoteIterator;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FsServerDefaults;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.QuotaUsage;
import org.apache.hadoop.fs.permission.AclStatus;
import org.apache.hadoop.hdfs.inotify.EventBatchList;
import org.apache.hadoop.hdfs.protocol.BlockStoragePolicy;
import org.apache.hadoop.hdfs.protocol.CacheDirectiveEntry;
import org.apache.hadoop.hdfs.protocol.CacheDirectiveInfo;
import org.apache.hadoop.hdfs.protocol.CachePoolEntry;
import org.apache.hadoop.hdfs.protocol.ClientProtocol;
import org.apache.hadoop.hdfs.protocol.CorruptFileBlocks;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.DirectoryListing;
import org.apache.hadoop.hdfs.protocol.EncryptionZone;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.protocol.LastBlockWithStatus;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.protocol.OpenFileEntry;
import org.apache.hadoop.hdfs.protocol.RollingUpgradeInfo;
import org.apache.hadoop.hdfs.protocol.SnapshotDiffReport;
import org.apache.hadoop.hdfs.protocol.SnapshottableDirectoryStatus;
import org.apache.hadoop.hdfs.protocol.proto.AclProtos;
import org.apache.hadoop.hdfs.protocol.proto.ClientNamenodeProtocolProtos;
import org.apache.hadoop.hdfs.protocol.proto.EncryptionZonesProtos;
import org.apache.hadoop.hdfs.protocol.proto.HdfsProtos;
import org.apache.hadoop.hdfs.protocol.proto.XAttrProtos;
import org.apache.hadoop.hdfs.protocolPB.ClientNamenodeProtocolPB;
import org.apache.hadoop.hdfs.protocolPB.PBHelperClient;
import org.apache.hadoop.hdfs.security.token.block.DataEncryptionKey;
import org.apache.hadoop.hdfs.server.protocol.DatanodeStorageReport;
import org.apache.hadoop.io.EnumSetWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.proto.SecurityProtos;
import org.apache.hadoop.security.token.Token;

@InterfaceAudience.Private
@InterfaceStability.Stable
public class ClientNamenodeProtocolServerSideTranslatorPB
implements ClientNamenodeProtocolPB {
    private final ClientProtocol server;
    static final ClientNamenodeProtocolProtos.DeleteSnapshotResponseProto VOID_DELETE_SNAPSHOT_RESPONSE = ClientNamenodeProtocolProtos.DeleteSnapshotResponseProto.newBuilder().build();
    static final ClientNamenodeProtocolProtos.RenameSnapshotResponseProto VOID_RENAME_SNAPSHOT_RESPONSE = ClientNamenodeProtocolProtos.RenameSnapshotResponseProto.newBuilder().build();
    static final ClientNamenodeProtocolProtos.AllowSnapshotResponseProto VOID_ALLOW_SNAPSHOT_RESPONSE = ClientNamenodeProtocolProtos.AllowSnapshotResponseProto.newBuilder().build();
    static final ClientNamenodeProtocolProtos.DisallowSnapshotResponseProto VOID_DISALLOW_SNAPSHOT_RESPONSE = ClientNamenodeProtocolProtos.DisallowSnapshotResponseProto.newBuilder().build();
    static final ClientNamenodeProtocolProtos.GetSnapshottableDirListingResponseProto NULL_GET_SNAPSHOTTABLE_DIR_LISTING_RESPONSE = ClientNamenodeProtocolProtos.GetSnapshottableDirListingResponseProto.newBuilder().build();
    static final ClientNamenodeProtocolProtos.SetStoragePolicyResponseProto VOID_SET_STORAGE_POLICY_RESPONSE = ClientNamenodeProtocolProtos.SetStoragePolicyResponseProto.newBuilder().build();
    static final ClientNamenodeProtocolProtos.UnsetStoragePolicyResponseProto VOID_UNSET_STORAGE_POLICY_RESPONSE = ClientNamenodeProtocolProtos.UnsetStoragePolicyResponseProto.newBuilder().build();
    private static final ClientNamenodeProtocolProtos.CreateResponseProto VOID_CREATE_RESPONSE = ClientNamenodeProtocolProtos.CreateResponseProto.newBuilder().build();
    private static final ClientNamenodeProtocolProtos.SetPermissionResponseProto VOID_SET_PERM_RESPONSE = ClientNamenodeProtocolProtos.SetPermissionResponseProto.newBuilder().build();
    private static final ClientNamenodeProtocolProtos.SetOwnerResponseProto VOID_SET_OWNER_RESPONSE = ClientNamenodeProtocolProtos.SetOwnerResponseProto.newBuilder().build();
    private static final ClientNamenodeProtocolProtos.AbandonBlockResponseProto VOID_ADD_BLOCK_RESPONSE = ClientNamenodeProtocolProtos.AbandonBlockResponseProto.newBuilder().build();
    private static final ClientNamenodeProtocolProtos.ReportBadBlocksResponseProto VOID_REP_BAD_BLOCK_RESPONSE = ClientNamenodeProtocolProtos.ReportBadBlocksResponseProto.newBuilder().build();
    private static final ClientNamenodeProtocolProtos.ConcatResponseProto VOID_CONCAT_RESPONSE = ClientNamenodeProtocolProtos.ConcatResponseProto.newBuilder().build();
    private static final ClientNamenodeProtocolProtos.Rename2ResponseProto VOID_RENAME2_RESPONSE = ClientNamenodeProtocolProtos.Rename2ResponseProto.newBuilder().build();
    private static final ClientNamenodeProtocolProtos.GetListingResponseProto VOID_GETLISTING_RESPONSE = ClientNamenodeProtocolProtos.GetListingResponseProto.newBuilder().build();
    private static final ClientNamenodeProtocolProtos.RenewLeaseResponseProto VOID_RENEWLEASE_RESPONSE = ClientNamenodeProtocolProtos.RenewLeaseResponseProto.newBuilder().build();
    private static final ClientNamenodeProtocolProtos.SaveNamespaceResponseProto VOID_SAVENAMESPACE_RESPONSE = ClientNamenodeProtocolProtos.SaveNamespaceResponseProto.newBuilder().build();
    private static final ClientNamenodeProtocolProtos.RefreshNodesResponseProto VOID_REFRESHNODES_RESPONSE = ClientNamenodeProtocolProtos.RefreshNodesResponseProto.newBuilder().build();
    private static final ClientNamenodeProtocolProtos.FinalizeUpgradeResponseProto VOID_FINALIZEUPGRADE_RESPONSE = ClientNamenodeProtocolProtos.FinalizeUpgradeResponseProto.newBuilder().build();
    private static final ClientNamenodeProtocolProtos.MetaSaveResponseProto VOID_METASAVE_RESPONSE = ClientNamenodeProtocolProtos.MetaSaveResponseProto.newBuilder().build();
    private static final ClientNamenodeProtocolProtos.GetFileInfoResponseProto VOID_GETFILEINFO_RESPONSE = ClientNamenodeProtocolProtos.GetFileInfoResponseProto.newBuilder().build();
    private static final ClientNamenodeProtocolProtos.GetFileLinkInfoResponseProto VOID_GETFILELINKINFO_RESPONSE = ClientNamenodeProtocolProtos.GetFileLinkInfoResponseProto.newBuilder().build();
    private static final ClientNamenodeProtocolProtos.SetQuotaResponseProto VOID_SETQUOTA_RESPONSE = ClientNamenodeProtocolProtos.SetQuotaResponseProto.newBuilder().build();
    private static final ClientNamenodeProtocolProtos.FsyncResponseProto VOID_FSYNC_RESPONSE = ClientNamenodeProtocolProtos.FsyncResponseProto.newBuilder().build();
    private static final ClientNamenodeProtocolProtos.SetTimesResponseProto VOID_SETTIMES_RESPONSE = ClientNamenodeProtocolProtos.SetTimesResponseProto.newBuilder().build();
    private static final ClientNamenodeProtocolProtos.CreateSymlinkResponseProto VOID_CREATESYMLINK_RESPONSE = ClientNamenodeProtocolProtos.CreateSymlinkResponseProto.newBuilder().build();
    private static final ClientNamenodeProtocolProtos.UpdatePipelineResponseProto VOID_UPDATEPIPELINE_RESPONSE = ClientNamenodeProtocolProtos.UpdatePipelineResponseProto.newBuilder().build();
    private static final SecurityProtos.CancelDelegationTokenResponseProto VOID_CANCELDELEGATIONTOKEN_RESPONSE = SecurityProtos.CancelDelegationTokenResponseProto.newBuilder().build();
    private static final ClientNamenodeProtocolProtos.SetBalancerBandwidthResponseProto VOID_SETBALANCERBANDWIDTH_RESPONSE = ClientNamenodeProtocolProtos.SetBalancerBandwidthResponseProto.newBuilder().build();
    private static final AclProtos.SetAclResponseProto VOID_SETACL_RESPONSE = AclProtos.SetAclResponseProto.getDefaultInstance();
    private static final AclProtos.ModifyAclEntriesResponseProto VOID_MODIFYACLENTRIES_RESPONSE = AclProtos.ModifyAclEntriesResponseProto.getDefaultInstance();
    private static final AclProtos.RemoveAclEntriesResponseProto VOID_REMOVEACLENTRIES_RESPONSE = AclProtos.RemoveAclEntriesResponseProto.getDefaultInstance();
    private static final AclProtos.RemoveDefaultAclResponseProto VOID_REMOVEDEFAULTACL_RESPONSE = AclProtos.RemoveDefaultAclResponseProto.getDefaultInstance();
    private static final AclProtos.RemoveAclResponseProto VOID_REMOVEACL_RESPONSE = AclProtos.RemoveAclResponseProto.getDefaultInstance();
    private static final XAttrProtos.SetXAttrResponseProto VOID_SETXATTR_RESPONSE = XAttrProtos.SetXAttrResponseProto.getDefaultInstance();
    private static final XAttrProtos.RemoveXAttrResponseProto VOID_REMOVEXATTR_RESPONSE = XAttrProtos.RemoveXAttrResponseProto.getDefaultInstance();
    private static final ClientNamenodeProtocolProtos.CheckAccessResponseProto VOID_CHECKACCESS_RESPONSE = ClientNamenodeProtocolProtos.CheckAccessResponseProto.getDefaultInstance();

    public ClientNamenodeProtocolServerSideTranslatorPB(ClientProtocol server) throws IOException {
        this.server = server;
    }

    public ClientNamenodeProtocolProtos.GetBlockLocationsResponseProto getBlockLocations(RpcController controller, ClientNamenodeProtocolProtos.GetBlockLocationsRequestProto req) throws ServiceException {
        try {
            LocatedBlocks b = this.server.getBlockLocations(req.getSrc(), req.getOffset(), req.getLength());
            ClientNamenodeProtocolProtos.GetBlockLocationsResponseProto.Builder builder = ClientNamenodeProtocolProtos.GetBlockLocationsResponseProto.newBuilder();
            if (b != null) {
                builder.setLocations(PBHelperClient.convert((LocatedBlocks)b)).build();
            }
            return builder.build();
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public ClientNamenodeProtocolProtos.GetServerDefaultsResponseProto getServerDefaults(RpcController controller, ClientNamenodeProtocolProtos.GetServerDefaultsRequestProto req) throws ServiceException {
        try {
            FsServerDefaults result = this.server.getServerDefaults();
            return ClientNamenodeProtocolProtos.GetServerDefaultsResponseProto.newBuilder().setServerDefaults(PBHelperClient.convert((FsServerDefaults)result)).build();
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public ClientNamenodeProtocolProtos.CreateResponseProto create(RpcController controller, ClientNamenodeProtocolProtos.CreateRequestProto req) throws ServiceException {
        try {
            HdfsFileStatus result = this.server.create(req.getSrc(), PBHelperClient.convert((HdfsProtos.FsPermissionProto)req.getMasked()), req.getClientName(), PBHelperClient.convertCreateFlag((int)req.getCreateFlag()), req.getCreateParent(), (short)req.getReplication(), req.getBlockSize(), PBHelperClient.convertCryptoProtocolVersions((List)req.getCryptoProtocolVersionList()));
            if (result != null) {
                return ClientNamenodeProtocolProtos.CreateResponseProto.newBuilder().setFs(PBHelperClient.convert((HdfsFileStatus)result)).build();
            }
            return VOID_CREATE_RESPONSE;
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public ClientNamenodeProtocolProtos.AppendResponseProto append(RpcController controller, ClientNamenodeProtocolProtos.AppendRequestProto req) throws ServiceException {
        try {
            EnumSetWritable flags = req.hasFlag() ? PBHelperClient.convertCreateFlag((int)req.getFlag()) : new EnumSetWritable(EnumSet.of(CreateFlag.APPEND));
            LastBlockWithStatus result = this.server.append(req.getSrc(), req.getClientName(), flags);
            ClientNamenodeProtocolProtos.AppendResponseProto.Builder builder = ClientNamenodeProtocolProtos.AppendResponseProto.newBuilder();
            if (result.getLastBlock() != null) {
                builder.setBlock(PBHelperClient.convert((LocatedBlock)result.getLastBlock()));
            }
            if (result.getFileStatus() != null) {
                builder.setStat(PBHelperClient.convert((HdfsFileStatus)result.getFileStatus()));
            }
            return builder.build();
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public ClientNamenodeProtocolProtos.SetReplicationResponseProto setReplication(RpcController controller, ClientNamenodeProtocolProtos.SetReplicationRequestProto req) throws ServiceException {
        try {
            boolean result = this.server.setReplication(req.getSrc(), (short)req.getReplication());
            return ClientNamenodeProtocolProtos.SetReplicationResponseProto.newBuilder().setResult(result).build();
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public ClientNamenodeProtocolProtos.SetPermissionResponseProto setPermission(RpcController controller, ClientNamenodeProtocolProtos.SetPermissionRequestProto req) throws ServiceException {
        try {
            this.server.setPermission(req.getSrc(), PBHelperClient.convert((HdfsProtos.FsPermissionProto)req.getPermission()));
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
        return VOID_SET_PERM_RESPONSE;
    }

    public ClientNamenodeProtocolProtos.SetOwnerResponseProto setOwner(RpcController controller, ClientNamenodeProtocolProtos.SetOwnerRequestProto req) throws ServiceException {
        try {
            this.server.setOwner(req.getSrc(), req.hasUsername() ? req.getUsername() : null, req.hasGroupname() ? req.getGroupname() : null);
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
        return VOID_SET_OWNER_RESPONSE;
    }

    public ClientNamenodeProtocolProtos.AbandonBlockResponseProto abandonBlock(RpcController controller, ClientNamenodeProtocolProtos.AbandonBlockRequestProto req) throws ServiceException {
        try {
            this.server.abandonBlock(PBHelperClient.convert((HdfsProtos.ExtendedBlockProto)req.getB()), req.getFileId(), req.getSrc(), req.getHolder());
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
        return VOID_ADD_BLOCK_RESPONSE;
    }

    public ClientNamenodeProtocolProtos.AddBlockResponseProto addBlock(RpcController controller, ClientNamenodeProtocolProtos.AddBlockRequestProto req) throws ServiceException {
        try {
            List excl = req.getExcludeNodesList();
            List favor = req.getFavoredNodesList();
            EnumSet flags = PBHelperClient.convertAddBlockFlags((List)req.getFlagsList());
            LocatedBlock result = this.server.addBlock(req.getSrc(), req.getClientName(), req.hasPrevious() ? PBHelperClient.convert((HdfsProtos.ExtendedBlockProto)req.getPrevious()) : null, excl == null || excl.size() == 0 ? null : PBHelperClient.convert((HdfsProtos.DatanodeInfoProto[])excl.toArray(new HdfsProtos.DatanodeInfoProto[excl.size()])), req.getFileId(), favor == null || favor.size() == 0 ? null : favor.toArray(new String[favor.size()]), flags);
            return ClientNamenodeProtocolProtos.AddBlockResponseProto.newBuilder().setBlock(PBHelperClient.convert((LocatedBlock)result)).build();
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public ClientNamenodeProtocolProtos.GetAdditionalDatanodeResponseProto getAdditionalDatanode(RpcController controller, ClientNamenodeProtocolProtos.GetAdditionalDatanodeRequestProto req) throws ServiceException {
        try {
            List existingList = req.getExistingsList();
            List existingStorageIDsList = req.getExistingStorageUuidsList();
            List excludesList = req.getExcludesList();
            LocatedBlock result = this.server.getAdditionalDatanode(req.getSrc(), req.getFileId(), PBHelperClient.convert((HdfsProtos.ExtendedBlockProto)req.getBlk()), PBHelperClient.convert((HdfsProtos.DatanodeInfoProto[])existingList.toArray(new HdfsProtos.DatanodeInfoProto[existingList.size()])), existingStorageIDsList.toArray(new String[existingStorageIDsList.size()]), PBHelperClient.convert((HdfsProtos.DatanodeInfoProto[])excludesList.toArray(new HdfsProtos.DatanodeInfoProto[excludesList.size()])), req.getNumAdditionalNodes(), req.getClientName());
            return ClientNamenodeProtocolProtos.GetAdditionalDatanodeResponseProto.newBuilder().setBlock(PBHelperClient.convert((LocatedBlock)result)).build();
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public ClientNamenodeProtocolProtos.CompleteResponseProto complete(RpcController controller, ClientNamenodeProtocolProtos.CompleteRequestProto req) throws ServiceException {
        try {
            boolean result = this.server.complete(req.getSrc(), req.getClientName(), req.hasLast() ? PBHelperClient.convert((HdfsProtos.ExtendedBlockProto)req.getLast()) : null, req.hasFileId() ? req.getFileId() : 0L);
            return ClientNamenodeProtocolProtos.CompleteResponseProto.newBuilder().setResult(result).build();
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public ClientNamenodeProtocolProtos.ReportBadBlocksResponseProto reportBadBlocks(RpcController controller, ClientNamenodeProtocolProtos.ReportBadBlocksRequestProto req) throws ServiceException {
        try {
            List bl = req.getBlocksList();
            this.server.reportBadBlocks(PBHelperClient.convertLocatedBlock((HdfsProtos.LocatedBlockProto[])bl.toArray(new HdfsProtos.LocatedBlockProto[bl.size()])));
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
        return VOID_REP_BAD_BLOCK_RESPONSE;
    }

    public ClientNamenodeProtocolProtos.ConcatResponseProto concat(RpcController controller, ClientNamenodeProtocolProtos.ConcatRequestProto req) throws ServiceException {
        try {
            List srcs = req.getSrcsList();
            this.server.concat(req.getTrg(), srcs.toArray(new String[srcs.size()]));
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
        return VOID_CONCAT_RESPONSE;
    }

    public ClientNamenodeProtocolProtos.RenameResponseProto rename(RpcController controller, ClientNamenodeProtocolProtos.RenameRequestProto req) throws ServiceException {
        try {
            boolean result = this.server.rename(req.getSrc(), req.getDst());
            return ClientNamenodeProtocolProtos.RenameResponseProto.newBuilder().setResult(result).build();
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public ClientNamenodeProtocolProtos.Rename2ResponseProto rename2(RpcController controller, ClientNamenodeProtocolProtos.Rename2RequestProto req) throws ServiceException {
        ArrayList<Options.Rename> optionList = new ArrayList<Options.Rename>();
        if (req.getOverwriteDest()) {
            optionList.add(Options.Rename.OVERWRITE);
        } else if (req.hasMoveToTrash()) {
            optionList.add(Options.Rename.TO_TRASH);
        }
        if (optionList.isEmpty()) {
            optionList.add(Options.Rename.NONE);
        }
        try {
            this.server.rename2(req.getSrc(), req.getDst(), optionList.toArray(new Options.Rename[optionList.size()]));
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
        return VOID_RENAME2_RESPONSE;
    }

    public ClientNamenodeProtocolProtos.TruncateResponseProto truncate(RpcController controller, ClientNamenodeProtocolProtos.TruncateRequestProto req) throws ServiceException {
        try {
            boolean result = this.server.truncate(req.getSrc(), req.getNewLength(), req.getClientName());
            return ClientNamenodeProtocolProtos.TruncateResponseProto.newBuilder().setResult(result).build();
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public ClientNamenodeProtocolProtos.DeleteResponseProto delete(RpcController controller, ClientNamenodeProtocolProtos.DeleteRequestProto req) throws ServiceException {
        try {
            boolean result = this.server.delete(req.getSrc(), req.getRecursive());
            return ClientNamenodeProtocolProtos.DeleteResponseProto.newBuilder().setResult(result).build();
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public ClientNamenodeProtocolProtos.MkdirsResponseProto mkdirs(RpcController controller, ClientNamenodeProtocolProtos.MkdirsRequestProto req) throws ServiceException {
        try {
            boolean result = this.server.mkdirs(req.getSrc(), PBHelperClient.convert((HdfsProtos.FsPermissionProto)req.getMasked()), req.getCreateParent());
            return ClientNamenodeProtocolProtos.MkdirsResponseProto.newBuilder().setResult(result).build();
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public ClientNamenodeProtocolProtos.GetListingResponseProto getListing(RpcController controller, ClientNamenodeProtocolProtos.GetListingRequestProto req) throws ServiceException {
        try {
            DirectoryListing result = this.server.getListing(req.getSrc(), req.getStartAfter().toByteArray(), req.getNeedLocation());
            if (result != null) {
                return ClientNamenodeProtocolProtos.GetListingResponseProto.newBuilder().setDirList(PBHelperClient.convert((DirectoryListing)result)).build();
            }
            return VOID_GETLISTING_RESPONSE;
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public ClientNamenodeProtocolProtos.RenewLeaseResponseProto renewLease(RpcController controller, ClientNamenodeProtocolProtos.RenewLeaseRequestProto req) throws ServiceException {
        try {
            this.server.renewLease(req.getClientName());
            return VOID_RENEWLEASE_RESPONSE;
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public ClientNamenodeProtocolProtos.RecoverLeaseResponseProto recoverLease(RpcController controller, ClientNamenodeProtocolProtos.RecoverLeaseRequestProto req) throws ServiceException {
        try {
            boolean result = this.server.recoverLease(req.getSrc(), req.getClientName());
            return ClientNamenodeProtocolProtos.RecoverLeaseResponseProto.newBuilder().setResult(result).build();
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public ClientNamenodeProtocolProtos.RestoreFailedStorageResponseProto restoreFailedStorage(RpcController controller, ClientNamenodeProtocolProtos.RestoreFailedStorageRequestProto req) throws ServiceException {
        try {
            boolean result = this.server.restoreFailedStorage(req.getArg());
            return ClientNamenodeProtocolProtos.RestoreFailedStorageResponseProto.newBuilder().setResult(result).build();
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public ClientNamenodeProtocolProtos.GetFsStatsResponseProto getFsStats(RpcController controller, ClientNamenodeProtocolProtos.GetFsStatusRequestProto req) throws ServiceException {
        try {
            return PBHelperClient.convert((long[])this.server.getStats());
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public ClientNamenodeProtocolProtos.GetDatanodeReportResponseProto getDatanodeReport(RpcController controller, ClientNamenodeProtocolProtos.GetDatanodeReportRequestProto req) throws ServiceException {
        try {
            List result = PBHelperClient.convert((DatanodeInfo[])this.server.getDatanodeReport(PBHelperClient.convert((ClientNamenodeProtocolProtos.DatanodeReportTypeProto)req.getType())));
            return ClientNamenodeProtocolProtos.GetDatanodeReportResponseProto.newBuilder().addAllDi((Iterable)result).build();
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public ClientNamenodeProtocolProtos.GetDatanodeStorageReportResponseProto getDatanodeStorageReport(RpcController controller, ClientNamenodeProtocolProtos.GetDatanodeStorageReportRequestProto req) throws ServiceException {
        try {
            List reports = PBHelperClient.convertDatanodeStorageReports((DatanodeStorageReport[])this.server.getDatanodeStorageReport(PBHelperClient.convert((ClientNamenodeProtocolProtos.DatanodeReportTypeProto)req.getType())));
            return ClientNamenodeProtocolProtos.GetDatanodeStorageReportResponseProto.newBuilder().addAllDatanodeStorageReports((Iterable)reports).build();
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public ClientNamenodeProtocolProtos.GetPreferredBlockSizeResponseProto getPreferredBlockSize(RpcController controller, ClientNamenodeProtocolProtos.GetPreferredBlockSizeRequestProto req) throws ServiceException {
        try {
            long result = this.server.getPreferredBlockSize(req.getFilename());
            return ClientNamenodeProtocolProtos.GetPreferredBlockSizeResponseProto.newBuilder().setBsize(result).build();
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public ClientNamenodeProtocolProtos.SetSafeModeResponseProto setSafeMode(RpcController controller, ClientNamenodeProtocolProtos.SetSafeModeRequestProto req) throws ServiceException {
        try {
            boolean result = this.server.setSafeMode(PBHelperClient.convert((ClientNamenodeProtocolProtos.SafeModeActionProto)req.getAction()), req.getChecked());
            return ClientNamenodeProtocolProtos.SetSafeModeResponseProto.newBuilder().setResult(result).build();
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public ClientNamenodeProtocolProtos.SaveNamespaceResponseProto saveNamespace(RpcController controller, ClientNamenodeProtocolProtos.SaveNamespaceRequestProto req) throws ServiceException {
        try {
            this.server.saveNamespace();
            return VOID_SAVENAMESPACE_RESPONSE;
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public ClientNamenodeProtocolProtos.RollEditsResponseProto rollEdits(RpcController controller, ClientNamenodeProtocolProtos.RollEditsRequestProto request) throws ServiceException {
        try {
            long txid = this.server.rollEdits();
            return ClientNamenodeProtocolProtos.RollEditsResponseProto.newBuilder().setNewSegmentTxId(txid).build();
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public ClientNamenodeProtocolProtos.RefreshNodesResponseProto refreshNodes(RpcController controller, ClientNamenodeProtocolProtos.RefreshNodesRequestProto req) throws ServiceException {
        try {
            this.server.refreshNodes();
            return VOID_REFRESHNODES_RESPONSE;
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public ClientNamenodeProtocolProtos.FinalizeUpgradeResponseProto finalizeUpgrade(RpcController controller, ClientNamenodeProtocolProtos.FinalizeUpgradeRequestProto req) throws ServiceException {
        try {
            this.server.finalizeUpgrade();
            return VOID_FINALIZEUPGRADE_RESPONSE;
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public ClientNamenodeProtocolProtos.RollingUpgradeResponseProto rollingUpgrade(RpcController controller, ClientNamenodeProtocolProtos.RollingUpgradeRequestProto req) throws ServiceException {
        try {
            RollingUpgradeInfo info = this.server.rollingUpgrade(PBHelperClient.convert((ClientNamenodeProtocolProtos.RollingUpgradeActionProto)req.getAction()));
            ClientNamenodeProtocolProtos.RollingUpgradeResponseProto.Builder b = ClientNamenodeProtocolProtos.RollingUpgradeResponseProto.newBuilder();
            if (info != null) {
                b.setRollingUpgradeInfo(PBHelperClient.convert((RollingUpgradeInfo)info));
            }
            return b.build();
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public ClientNamenodeProtocolProtos.ListCorruptFileBlocksResponseProto listCorruptFileBlocks(RpcController controller, ClientNamenodeProtocolProtos.ListCorruptFileBlocksRequestProto req) throws ServiceException {
        try {
            CorruptFileBlocks result = this.server.listCorruptFileBlocks(req.getPath(), req.hasCookie() ? req.getCookie() : null);
            return ClientNamenodeProtocolProtos.ListCorruptFileBlocksResponseProto.newBuilder().setCorrupt(PBHelperClient.convert((CorruptFileBlocks)result)).build();
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public ClientNamenodeProtocolProtos.MetaSaveResponseProto metaSave(RpcController controller, ClientNamenodeProtocolProtos.MetaSaveRequestProto req) throws ServiceException {
        try {
            this.server.metaSave(req.getFilename());
            return VOID_METASAVE_RESPONSE;
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public ClientNamenodeProtocolProtos.GetFileInfoResponseProto getFileInfo(RpcController controller, ClientNamenodeProtocolProtos.GetFileInfoRequestProto req) throws ServiceException {
        try {
            HdfsFileStatus result = this.server.getFileInfo(req.getSrc());
            if (result != null) {
                return ClientNamenodeProtocolProtos.GetFileInfoResponseProto.newBuilder().setFs(PBHelperClient.convert((HdfsFileStatus)result)).build();
            }
            return VOID_GETFILEINFO_RESPONSE;
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public ClientNamenodeProtocolProtos.GetFileLinkInfoResponseProto getFileLinkInfo(RpcController controller, ClientNamenodeProtocolProtos.GetFileLinkInfoRequestProto req) throws ServiceException {
        try {
            HdfsFileStatus result = this.server.getFileLinkInfo(req.getSrc());
            if (result != null) {
                return ClientNamenodeProtocolProtos.GetFileLinkInfoResponseProto.newBuilder().setFs(PBHelperClient.convert((HdfsFileStatus)result)).build();
            }
            return VOID_GETFILELINKINFO_RESPONSE;
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public ClientNamenodeProtocolProtos.GetContentSummaryResponseProto getContentSummary(RpcController controller, ClientNamenodeProtocolProtos.GetContentSummaryRequestProto req) throws ServiceException {
        try {
            ContentSummary result = this.server.getContentSummary(req.getPath());
            return ClientNamenodeProtocolProtos.GetContentSummaryResponseProto.newBuilder().setSummary(PBHelperClient.convert((ContentSummary)result)).build();
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public ClientNamenodeProtocolProtos.SetQuotaResponseProto setQuota(RpcController controller, ClientNamenodeProtocolProtos.SetQuotaRequestProto req) throws ServiceException {
        try {
            this.server.setQuota(req.getPath(), req.getNamespaceQuota(), req.getStoragespaceQuota(), req.hasStorageType() ? PBHelperClient.convertStorageType((HdfsProtos.StorageTypeProto)req.getStorageType()) : null);
            return VOID_SETQUOTA_RESPONSE;
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public ClientNamenodeProtocolProtos.FsyncResponseProto fsync(RpcController controller, ClientNamenodeProtocolProtos.FsyncRequestProto req) throws ServiceException {
        try {
            this.server.fsync(req.getSrc(), req.getFileId(), req.getClient(), req.getLastBlockLength());
            return VOID_FSYNC_RESPONSE;
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public ClientNamenodeProtocolProtos.SetTimesResponseProto setTimes(RpcController controller, ClientNamenodeProtocolProtos.SetTimesRequestProto req) throws ServiceException {
        try {
            this.server.setTimes(req.getSrc(), req.getMtime(), req.getAtime());
            return VOID_SETTIMES_RESPONSE;
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public ClientNamenodeProtocolProtos.CreateSymlinkResponseProto createSymlink(RpcController controller, ClientNamenodeProtocolProtos.CreateSymlinkRequestProto req) throws ServiceException {
        try {
            this.server.createSymlink(req.getTarget(), req.getLink(), PBHelperClient.convert((HdfsProtos.FsPermissionProto)req.getDirPerm()), req.getCreateParent());
            return VOID_CREATESYMLINK_RESPONSE;
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public ClientNamenodeProtocolProtos.GetLinkTargetResponseProto getLinkTarget(RpcController controller, ClientNamenodeProtocolProtos.GetLinkTargetRequestProto req) throws ServiceException {
        try {
            String result = this.server.getLinkTarget(req.getPath());
            ClientNamenodeProtocolProtos.GetLinkTargetResponseProto.Builder builder = ClientNamenodeProtocolProtos.GetLinkTargetResponseProto.newBuilder();
            if (result != null) {
                builder.setTargetPath(result);
            }
            return builder.build();
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public ClientNamenodeProtocolProtos.UpdateBlockForPipelineResponseProto updateBlockForPipeline(RpcController controller, ClientNamenodeProtocolProtos.UpdateBlockForPipelineRequestProto req) throws ServiceException {
        try {
            HdfsProtos.LocatedBlockProto result = PBHelperClient.convert((LocatedBlock)this.server.updateBlockForPipeline(PBHelperClient.convert((HdfsProtos.ExtendedBlockProto)req.getBlock()), req.getClientName()));
            return ClientNamenodeProtocolProtos.UpdateBlockForPipelineResponseProto.newBuilder().setBlock(result).build();
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public ClientNamenodeProtocolProtos.UpdatePipelineResponseProto updatePipeline(RpcController controller, ClientNamenodeProtocolProtos.UpdatePipelineRequestProto req) throws ServiceException {
        try {
            List newNodes = req.getNewNodesList();
            List newStorageIDs = req.getStorageIDsList();
            this.server.updatePipeline(req.getClientName(), PBHelperClient.convert((HdfsProtos.ExtendedBlockProto)req.getOldBlock()), PBHelperClient.convert((HdfsProtos.ExtendedBlockProto)req.getNewBlock()), PBHelperClient.convert((HdfsProtos.DatanodeIDProto[])newNodes.toArray(new HdfsProtos.DatanodeIDProto[newNodes.size()])), newStorageIDs.toArray(new String[newStorageIDs.size()]));
            return VOID_UPDATEPIPELINE_RESPONSE;
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public SecurityProtos.GetDelegationTokenResponseProto getDelegationToken(RpcController controller, SecurityProtos.GetDelegationTokenRequestProto req) throws ServiceException {
        try {
            Token token = this.server.getDelegationToken(new Text(req.getRenewer()));
            SecurityProtos.GetDelegationTokenResponseProto.Builder rspBuilder = SecurityProtos.GetDelegationTokenResponseProto.newBuilder();
            if (token != null) {
                rspBuilder.setToken(PBHelperClient.convert((Token)token));
            }
            return rspBuilder.build();
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public SecurityProtos.RenewDelegationTokenResponseProto renewDelegationToken(RpcController controller, SecurityProtos.RenewDelegationTokenRequestProto req) throws ServiceException {
        try {
            long result = this.server.renewDelegationToken(PBHelperClient.convertDelegationToken((SecurityProtos.TokenProto)req.getToken()));
            return SecurityProtos.RenewDelegationTokenResponseProto.newBuilder().setNewExpiryTime(result).build();
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public SecurityProtos.CancelDelegationTokenResponseProto cancelDelegationToken(RpcController controller, SecurityProtos.CancelDelegationTokenRequestProto req) throws ServiceException {
        try {
            this.server.cancelDelegationToken(PBHelperClient.convertDelegationToken((SecurityProtos.TokenProto)req.getToken()));
            return VOID_CANCELDELEGATIONTOKEN_RESPONSE;
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public ClientNamenodeProtocolProtos.SetBalancerBandwidthResponseProto setBalancerBandwidth(RpcController controller, ClientNamenodeProtocolProtos.SetBalancerBandwidthRequestProto req) throws ServiceException {
        try {
            this.server.setBalancerBandwidth(req.getBandwidth());
            return VOID_SETBALANCERBANDWIDTH_RESPONSE;
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public ClientNamenodeProtocolProtos.GetDataEncryptionKeyResponseProto getDataEncryptionKey(RpcController controller, ClientNamenodeProtocolProtos.GetDataEncryptionKeyRequestProto request) throws ServiceException {
        try {
            ClientNamenodeProtocolProtos.GetDataEncryptionKeyResponseProto.Builder builder = ClientNamenodeProtocolProtos.GetDataEncryptionKeyResponseProto.newBuilder();
            DataEncryptionKey encryptionKey = this.server.getDataEncryptionKey();
            if (encryptionKey != null) {
                builder.setDataEncryptionKey(PBHelperClient.convert((DataEncryptionKey)encryptionKey));
            }
            return builder.build();
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public ClientNamenodeProtocolProtos.CreateSnapshotResponseProto createSnapshot(RpcController controller, ClientNamenodeProtocolProtos.CreateSnapshotRequestProto req) throws ServiceException {
        try {
            ClientNamenodeProtocolProtos.CreateSnapshotResponseProto.Builder builder = ClientNamenodeProtocolProtos.CreateSnapshotResponseProto.newBuilder();
            String snapshotPath = this.server.createSnapshot(req.getSnapshotRoot(), req.hasSnapshotName() ? req.getSnapshotName() : null);
            if (snapshotPath != null) {
                builder.setSnapshotPath(snapshotPath);
            }
            return builder.build();
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public ClientNamenodeProtocolProtos.DeleteSnapshotResponseProto deleteSnapshot(RpcController controller, ClientNamenodeProtocolProtos.DeleteSnapshotRequestProto req) throws ServiceException {
        try {
            this.server.deleteSnapshot(req.getSnapshotRoot(), req.getSnapshotName());
            return VOID_DELETE_SNAPSHOT_RESPONSE;
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public ClientNamenodeProtocolProtos.AllowSnapshotResponseProto allowSnapshot(RpcController controller, ClientNamenodeProtocolProtos.AllowSnapshotRequestProto req) throws ServiceException {
        try {
            this.server.allowSnapshot(req.getSnapshotRoot());
            return VOID_ALLOW_SNAPSHOT_RESPONSE;
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public ClientNamenodeProtocolProtos.DisallowSnapshotResponseProto disallowSnapshot(RpcController controller, ClientNamenodeProtocolProtos.DisallowSnapshotRequestProto req) throws ServiceException {
        try {
            this.server.disallowSnapshot(req.getSnapshotRoot());
            return VOID_DISALLOW_SNAPSHOT_RESPONSE;
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public ClientNamenodeProtocolProtos.RenameSnapshotResponseProto renameSnapshot(RpcController controller, ClientNamenodeProtocolProtos.RenameSnapshotRequestProto request) throws ServiceException {
        try {
            this.server.renameSnapshot(request.getSnapshotRoot(), request.getSnapshotOldName(), request.getSnapshotNewName());
            return VOID_RENAME_SNAPSHOT_RESPONSE;
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public ClientNamenodeProtocolProtos.GetSnapshottableDirListingResponseProto getSnapshottableDirListing(RpcController controller, ClientNamenodeProtocolProtos.GetSnapshottableDirListingRequestProto request) throws ServiceException {
        try {
            SnapshottableDirectoryStatus[] result = this.server.getSnapshottableDirListing();
            if (result != null) {
                return ClientNamenodeProtocolProtos.GetSnapshottableDirListingResponseProto.newBuilder().setSnapshottableDirList(PBHelperClient.convert((SnapshottableDirectoryStatus[])result)).build();
            }
            return NULL_GET_SNAPSHOTTABLE_DIR_LISTING_RESPONSE;
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public ClientNamenodeProtocolProtos.GetSnapshotDiffReportResponseProto getSnapshotDiffReport(RpcController controller, ClientNamenodeProtocolProtos.GetSnapshotDiffReportRequestProto request) throws ServiceException {
        try {
            SnapshotDiffReport report = this.server.getSnapshotDiffReport(request.getSnapshotRoot(), request.getFromSnapshot(), request.getToSnapshot());
            return ClientNamenodeProtocolProtos.GetSnapshotDiffReportResponseProto.newBuilder().setDiffReport(PBHelperClient.convert((SnapshotDiffReport)report)).build();
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public ClientNamenodeProtocolProtos.IsFileClosedResponseProto isFileClosed(RpcController controller, ClientNamenodeProtocolProtos.IsFileClosedRequestProto request) throws ServiceException {
        try {
            boolean result = this.server.isFileClosed(request.getSrc());
            return ClientNamenodeProtocolProtos.IsFileClosedResponseProto.newBuilder().setResult(result).build();
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public ClientNamenodeProtocolProtos.AddCacheDirectiveResponseProto addCacheDirective(RpcController controller, ClientNamenodeProtocolProtos.AddCacheDirectiveRequestProto request) throws ServiceException {
        try {
            long id = this.server.addCacheDirective(PBHelperClient.convert((ClientNamenodeProtocolProtos.CacheDirectiveInfoProto)request.getInfo()), PBHelperClient.convertCacheFlags((int)request.getCacheFlags()));
            return ClientNamenodeProtocolProtos.AddCacheDirectiveResponseProto.newBuilder().setId(id).build();
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public ClientNamenodeProtocolProtos.ModifyCacheDirectiveResponseProto modifyCacheDirective(RpcController controller, ClientNamenodeProtocolProtos.ModifyCacheDirectiveRequestProto request) throws ServiceException {
        try {
            this.server.modifyCacheDirective(PBHelperClient.convert((ClientNamenodeProtocolProtos.CacheDirectiveInfoProto)request.getInfo()), PBHelperClient.convertCacheFlags((int)request.getCacheFlags()));
            return ClientNamenodeProtocolProtos.ModifyCacheDirectiveResponseProto.newBuilder().build();
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public ClientNamenodeProtocolProtos.RemoveCacheDirectiveResponseProto removeCacheDirective(RpcController controller, ClientNamenodeProtocolProtos.RemoveCacheDirectiveRequestProto request) throws ServiceException {
        try {
            this.server.removeCacheDirective(request.getId());
            return ClientNamenodeProtocolProtos.RemoveCacheDirectiveResponseProto.newBuilder().build();
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public ClientNamenodeProtocolProtos.ListCacheDirectivesResponseProto listCacheDirectives(RpcController controller, ClientNamenodeProtocolProtos.ListCacheDirectivesRequestProto request) throws ServiceException {
        try {
            CacheDirectiveInfo filter = PBHelperClient.convert((ClientNamenodeProtocolProtos.CacheDirectiveInfoProto)request.getFilter());
            BatchedRemoteIterator.BatchedEntries entries = this.server.listCacheDirectives(request.getPrevId(), filter);
            ClientNamenodeProtocolProtos.ListCacheDirectivesResponseProto.Builder builder = ClientNamenodeProtocolProtos.ListCacheDirectivesResponseProto.newBuilder();
            builder.setHasMore(entries.hasMore());
            int n = entries.size();
            for (int i = 0; i < n; ++i) {
                builder.addElements(PBHelperClient.convert((CacheDirectiveEntry)((CacheDirectiveEntry)entries.get(i))));
            }
            return builder.build();
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public ClientNamenodeProtocolProtos.AddCachePoolResponseProto addCachePool(RpcController controller, ClientNamenodeProtocolProtos.AddCachePoolRequestProto request) throws ServiceException {
        try {
            this.server.addCachePool(PBHelperClient.convert((ClientNamenodeProtocolProtos.CachePoolInfoProto)request.getInfo()));
            return ClientNamenodeProtocolProtos.AddCachePoolResponseProto.newBuilder().build();
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public ClientNamenodeProtocolProtos.ModifyCachePoolResponseProto modifyCachePool(RpcController controller, ClientNamenodeProtocolProtos.ModifyCachePoolRequestProto request) throws ServiceException {
        try {
            this.server.modifyCachePool(PBHelperClient.convert((ClientNamenodeProtocolProtos.CachePoolInfoProto)request.getInfo()));
            return ClientNamenodeProtocolProtos.ModifyCachePoolResponseProto.newBuilder().build();
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public ClientNamenodeProtocolProtos.RemoveCachePoolResponseProto removeCachePool(RpcController controller, ClientNamenodeProtocolProtos.RemoveCachePoolRequestProto request) throws ServiceException {
        try {
            this.server.removeCachePool(request.getPoolName());
            return ClientNamenodeProtocolProtos.RemoveCachePoolResponseProto.newBuilder().build();
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public ClientNamenodeProtocolProtos.ListCachePoolsResponseProto listCachePools(RpcController controller, ClientNamenodeProtocolProtos.ListCachePoolsRequestProto request) throws ServiceException {
        try {
            BatchedRemoteIterator.BatchedEntries entries = this.server.listCachePools(request.getPrevPoolName());
            ClientNamenodeProtocolProtos.ListCachePoolsResponseProto.Builder responseBuilder = ClientNamenodeProtocolProtos.ListCachePoolsResponseProto.newBuilder();
            responseBuilder.setHasMore(entries.hasMore());
            int n = entries.size();
            for (int i = 0; i < n; ++i) {
                responseBuilder.addEntries(PBHelperClient.convert((CachePoolEntry)((CachePoolEntry)entries.get(i))));
            }
            return responseBuilder.build();
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public AclProtos.ModifyAclEntriesResponseProto modifyAclEntries(RpcController controller, AclProtos.ModifyAclEntriesRequestProto req) throws ServiceException {
        try {
            this.server.modifyAclEntries(req.getSrc(), PBHelperClient.convertAclEntry((List)req.getAclSpecList()));
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
        return VOID_MODIFYACLENTRIES_RESPONSE;
    }

    public AclProtos.RemoveAclEntriesResponseProto removeAclEntries(RpcController controller, AclProtos.RemoveAclEntriesRequestProto req) throws ServiceException {
        try {
            this.server.removeAclEntries(req.getSrc(), PBHelperClient.convertAclEntry((List)req.getAclSpecList()));
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
        return VOID_REMOVEACLENTRIES_RESPONSE;
    }

    public AclProtos.RemoveDefaultAclResponseProto removeDefaultAcl(RpcController controller, AclProtos.RemoveDefaultAclRequestProto req) throws ServiceException {
        try {
            this.server.removeDefaultAcl(req.getSrc());
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
        return VOID_REMOVEDEFAULTACL_RESPONSE;
    }

    public AclProtos.RemoveAclResponseProto removeAcl(RpcController controller, AclProtos.RemoveAclRequestProto req) throws ServiceException {
        try {
            this.server.removeAcl(req.getSrc());
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
        return VOID_REMOVEACL_RESPONSE;
    }

    public AclProtos.SetAclResponseProto setAcl(RpcController controller, AclProtos.SetAclRequestProto req) throws ServiceException {
        try {
            this.server.setAcl(req.getSrc(), PBHelperClient.convertAclEntry((List)req.getAclSpecList()));
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
        return VOID_SETACL_RESPONSE;
    }

    public AclProtos.GetAclStatusResponseProto getAclStatus(RpcController controller, AclProtos.GetAclStatusRequestProto req) throws ServiceException {
        try {
            return PBHelperClient.convert((AclStatus)this.server.getAclStatus(req.getSrc()));
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public EncryptionZonesProtos.CreateEncryptionZoneResponseProto createEncryptionZone(RpcController controller, EncryptionZonesProtos.CreateEncryptionZoneRequestProto req) throws ServiceException {
        try {
            this.server.createEncryptionZone(req.getSrc(), req.getKeyName());
            return EncryptionZonesProtos.CreateEncryptionZoneResponseProto.newBuilder().build();
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public EncryptionZonesProtos.GetEZForPathResponseProto getEZForPath(RpcController controller, EncryptionZonesProtos.GetEZForPathRequestProto req) throws ServiceException {
        try {
            EncryptionZonesProtos.GetEZForPathResponseProto.Builder builder = EncryptionZonesProtos.GetEZForPathResponseProto.newBuilder();
            EncryptionZone ret = this.server.getEZForPath(req.getSrc());
            if (ret != null) {
                builder.setZone(PBHelperClient.convert((EncryptionZone)ret));
            }
            return builder.build();
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public EncryptionZonesProtos.ListEncryptionZonesResponseProto listEncryptionZones(RpcController controller, EncryptionZonesProtos.ListEncryptionZonesRequestProto req) throws ServiceException {
        try {
            BatchedRemoteIterator.BatchedEntries entries = this.server.listEncryptionZones(req.getId());
            EncryptionZonesProtos.ListEncryptionZonesResponseProto.Builder builder = EncryptionZonesProtos.ListEncryptionZonesResponseProto.newBuilder();
            builder.setHasMore(entries.hasMore());
            for (int i = 0; i < entries.size(); ++i) {
                builder.addZones(PBHelperClient.convert((EncryptionZone)((EncryptionZone)entries.get(i))));
            }
            return builder.build();
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public XAttrProtos.SetXAttrResponseProto setXAttr(RpcController controller, XAttrProtos.SetXAttrRequestProto req) throws ServiceException {
        try {
            this.server.setXAttr(req.getSrc(), PBHelperClient.convertXAttr((XAttrProtos.XAttrProto)req.getXAttr()), PBHelperClient.convert((int)req.getFlag()));
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
        return VOID_SETXATTR_RESPONSE;
    }

    public XAttrProtos.GetXAttrsResponseProto getXAttrs(RpcController controller, XAttrProtos.GetXAttrsRequestProto req) throws ServiceException {
        try {
            return PBHelperClient.convertXAttrsResponse((List)this.server.getXAttrs(req.getSrc(), PBHelperClient.convertXAttrs((List)req.getXAttrsList())));
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public XAttrProtos.ListXAttrsResponseProto listXAttrs(RpcController controller, XAttrProtos.ListXAttrsRequestProto req) throws ServiceException {
        try {
            return PBHelperClient.convertListXAttrsResponse((List)this.server.listXAttrs(req.getSrc()));
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public XAttrProtos.RemoveXAttrResponseProto removeXAttr(RpcController controller, XAttrProtos.RemoveXAttrRequestProto req) throws ServiceException {
        try {
            this.server.removeXAttr(req.getSrc(), PBHelperClient.convertXAttr((XAttrProtos.XAttrProto)req.getXAttr()));
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
        return VOID_REMOVEXATTR_RESPONSE;
    }

    public ClientNamenodeProtocolProtos.CheckAccessResponseProto checkAccess(RpcController controller, ClientNamenodeProtocolProtos.CheckAccessRequestProto req) throws ServiceException {
        try {
            this.server.checkAccess(req.getPath(), PBHelperClient.convert((AclProtos.AclEntryProto.FsActionProto)req.getMode()));
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
        return VOID_CHECKACCESS_RESPONSE;
    }

    public ClientNamenodeProtocolProtos.SetStoragePolicyResponseProto setStoragePolicy(RpcController controller, ClientNamenodeProtocolProtos.SetStoragePolicyRequestProto request) throws ServiceException {
        try {
            this.server.setStoragePolicy(request.getSrc(), request.getPolicyName());
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
        return VOID_SET_STORAGE_POLICY_RESPONSE;
    }

    public ClientNamenodeProtocolProtos.UnsetStoragePolicyResponseProto unsetStoragePolicy(RpcController controller, ClientNamenodeProtocolProtos.UnsetStoragePolicyRequestProto request) throws ServiceException {
        try {
            this.server.unsetStoragePolicy(request.getSrc());
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
        return VOID_UNSET_STORAGE_POLICY_RESPONSE;
    }

    public ClientNamenodeProtocolProtos.GetStoragePolicyResponseProto getStoragePolicy(RpcController controller, ClientNamenodeProtocolProtos.GetStoragePolicyRequestProto request) throws ServiceException {
        try {
            HdfsProtos.BlockStoragePolicyProto policy = PBHelperClient.convert((BlockStoragePolicy)this.server.getStoragePolicy(request.getPath()));
            return ClientNamenodeProtocolProtos.GetStoragePolicyResponseProto.newBuilder().setStoragePolicy(policy).build();
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public ClientNamenodeProtocolProtos.GetStoragePoliciesResponseProto getStoragePolicies(RpcController controller, ClientNamenodeProtocolProtos.GetStoragePoliciesRequestProto request) throws ServiceException {
        try {
            BlockStoragePolicy[] policies = this.server.getStoragePolicies();
            ClientNamenodeProtocolProtos.GetStoragePoliciesResponseProto.Builder builder = ClientNamenodeProtocolProtos.GetStoragePoliciesResponseProto.newBuilder();
            if (policies == null) {
                return builder.build();
            }
            for (BlockStoragePolicy policy : policies) {
                builder.addPolicies(PBHelperClient.convert((BlockStoragePolicy)policy));
            }
            return builder.build();
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public ClientNamenodeProtocolProtos.GetCurrentEditLogTxidResponseProto getCurrentEditLogTxid(RpcController controller, ClientNamenodeProtocolProtos.GetCurrentEditLogTxidRequestProto req) throws ServiceException {
        try {
            return ClientNamenodeProtocolProtos.GetCurrentEditLogTxidResponseProto.newBuilder().setTxid(this.server.getCurrentEditLogTxid()).build();
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public ClientNamenodeProtocolProtos.GetEditsFromTxidResponseProto getEditsFromTxid(RpcController controller, ClientNamenodeProtocolProtos.GetEditsFromTxidRequestProto req) throws ServiceException {
        try {
            return PBHelperClient.convertEditsResponse((EventBatchList)this.server.getEditsFromTxid(req.getTxid()));
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public ClientNamenodeProtocolProtos.GetQuotaUsageResponseProto getQuotaUsage(RpcController controller, ClientNamenodeProtocolProtos.GetQuotaUsageRequestProto req) throws ServiceException {
        try {
            QuotaUsage result = this.server.getQuotaUsage(req.getPath());
            return ClientNamenodeProtocolProtos.GetQuotaUsageResponseProto.newBuilder().setUsage(PBHelperClient.convert((QuotaUsage)result)).build();
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public ClientNamenodeProtocolProtos.ListOpenFilesResponseProto listOpenFiles(RpcController controller, ClientNamenodeProtocolProtos.ListOpenFilesRequestProto req) throws ServiceException {
        try {
            BatchedRemoteIterator.BatchedEntries entries = this.server.listOpenFiles(req.getId());
            ClientNamenodeProtocolProtos.ListOpenFilesResponseProto.Builder builder = ClientNamenodeProtocolProtos.ListOpenFilesResponseProto.newBuilder();
            builder.setHasMore(entries.hasMore());
            for (int i = 0; i < entries.size(); ++i) {
                builder.addEntries(PBHelperClient.convert((OpenFileEntry)((OpenFileEntry)entries.get(i))));
            }
            return builder.build();
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }
}

