/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSStripedOutputStream;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.StripedFileTestUtil;
import org.apache.hadoop.hdfs.TestDFSStripedOutputStreamWithFailureBase;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.test.LambdaTestUtils;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestDFSStripedOutputStreamWithFailure
extends TestDFSStripedOutputStreamWithFailureBase {
    public static final Logger LOG = LoggerFactory.getLogger(TestDFSStripedOutputStreamWithFailure.class);

    @Test(timeout=300000L)
    public void testMultipleDatanodeFailure56() throws Exception {
        this.runTestWithMultipleFailure(this.getLength(56));
    }

    public void testMultipleDatanodeFailureRandomLength() throws Exception {
        int lenIndex = RANDOM.nextInt(this.lengths.size());
        LOG.info("run testMultipleDatanodeFailureRandomLength with length index: " + lenIndex);
        this.runTestWithMultipleFailure(this.getLength(lenIndex));
    }

    @Test(timeout=240000L)
    public void testBlockTokenExpired() throws Exception {
        int length = this.dataBlocks * 65536 * 3;
        HdfsConfiguration conf = this.newHdfsConfiguration();
        conf.setBoolean("dfs.block.access.token.enable", true);
        conf.setInt("ipc.client.connect.max.retries", 0);
        conf.setInt("dfs.client.retry.window.base", 10);
        for (int dn = 0; dn < this.dataBlocks + this.parityBlocks; dn += 2) {
            try {
                this.setup((Configuration)conf);
                this.runTest(length, new int[]{length / 2}, new int[]{dn}, true);
                continue;
            }
            catch (Exception e) {
                LOG.error("failed, dn=" + dn + ", length=" + length);
                throw e;
            }
            finally {
                this.tearDown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=90000L)
    public void testAddBlockWhenNoSufficientDataBlockNumOfNodes() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setLong("dfs.blocksize", (long)this.blockSize);
        try {
            int numDatanodes;
            this.setup((Configuration)conf);
            ArrayList<DataNode> dataNodes = this.cluster.getDataNodes();
            for (numDatanodes = dataNodes.size(); numDatanodes >= this.dataBlocks; --numDatanodes) {
                this.cluster.stopDataNode(0);
            }
            this.cluster.restartNameNodes();
            this.cluster.triggerHeartbeats();
            DatanodeInfo[] info = this.dfs.getClient().datanodeReport(HdfsConstants.DatanodeReportType.LIVE);
            Assert.assertEquals((String)"Mismatches number of live Dns", (long)numDatanodes, (long)info.length);
            Path dirFile = new Path(this.dir, "ecfile");
            LambdaTestUtils.intercept(IOException.class, (String)("File " + dirFile + " could only be written to " + numDatanodes + " of the " + this.dataBlocks + " required nodes for " + this.ecPolicy.getName()), () -> {
                try (FSDataOutputStream out = this.dfs.create(dirFile, true);){
                    out.write("something".getBytes());
                    out.flush();
                }
                return 0;
            });
        }
        finally {
            this.tearDown();
        }
    }

    private void testCloseWithExceptionsInStreamer(int numFailures, boolean shouldFail) throws Exception {
        Assert.assertTrue((numFailures <= this.ecPolicy.getNumDataUnits() + this.ecPolicy.getNumParityUnits() ? 1 : 0) != 0);
        Path dirFile = new Path(this.dir, "ecfile-" + numFailures);
        try (FSDataOutputStream out = this.dfs.create(dirFile, true);){
            out.write("idempotent close".getBytes());
            LambdaTestUtils.intercept(IOException.class, () -> ((FSDataOutputStream)out).close());
            Assert.assertTrue((boolean)(out.getWrappedStream() instanceof DFSStripedOutputStream));
            DFSStripedOutputStream stripedOut = (DFSStripedOutputStream)out.getWrappedStream();
            for (int i = 0; i < numFailures; ++i) {
                stripedOut.getStripedDataStreamer(i).getLastException().set((Throwable)new IOException("injected failure"));
            }
            if (shouldFail) {
                LambdaTestUtils.intercept(IOException.class, () -> ((FSDataOutputStream)out).close());
            }
            out.close();
        }
    }

    @Test
    public void testIdempotentCloseWithFailedStreams() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setLong("dfs.blocksize", (long)this.blockSize);
        try {
            this.setup((Configuration)conf);
            while (this.cluster.getDataNodes().size() >= this.dataBlocks) {
                this.cluster.stopDataNode(0);
            }
            this.cluster.restartNameNodes();
            this.cluster.triggerHeartbeats();
            this.testCloseWithExceptionsInStreamer(1, false);
            this.testCloseWithExceptionsInStreamer(this.ecPolicy.getNumParityUnits(), false);
            this.testCloseWithExceptionsInStreamer(this.ecPolicy.getNumParityUnits() + 1, true);
            this.testCloseWithExceptionsInStreamer(this.ecPolicy.getNumDataUnits(), true);
        }
        finally {
            this.tearDown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCloseAfterAbort() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setLong("dfs.blocksize", (long)this.blockSize);
        try {
            this.setup((Configuration)conf);
            Path dirFile = new Path(this.dir, "ecfile");
            FSDataOutputStream out = this.dfs.create(dirFile, true);
            Assert.assertTrue((boolean)(out.getWrappedStream() instanceof DFSStripedOutputStream));
            DFSStripedOutputStream stripedOut = (DFSStripedOutputStream)out.getWrappedStream();
            stripedOut.abort();
            LambdaTestUtils.intercept(IOException.class, (String)"Lease timeout", () -> ((DFSStripedOutputStream)stripedOut).close());
        }
        finally {
            this.tearDown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=90000L)
    public void testAddBlockWhenNoSufficientParityNumOfNodes() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setLong("dfs.blocksize", (long)this.blockSize);
        try {
            this.setup((Configuration)conf);
            ArrayList<DataNode> dataNodes = this.cluster.getDataNodes();
            int killDns = this.parityBlocks - 1;
            int numDatanodes = dataNodes.size() - killDns;
            for (int i = 0; i < killDns; ++i) {
                this.cluster.stopDataNode(i);
            }
            this.cluster.restartNameNodes();
            this.cluster.triggerHeartbeats();
            DatanodeInfo[] info = this.dfs.getClient().datanodeReport(HdfsConstants.DatanodeReportType.LIVE);
            Assert.assertEquals((String)"Mismatches number of live Dns", (long)numDatanodes, (long)info.length);
            Path srcPath = new Path(this.dir, "testAddBlockWhenNoSufficientParityNodes");
            int fileLength = 64536;
            byte[] expected = StripedFileTestUtil.generateBytes(fileLength);
            DFSTestUtil.writeFile((FileSystem)this.dfs, srcPath, new String(expected));
            LOG.info("writing finished. Seek and read the file to verify.");
            StripedFileTestUtil.verifySeek((FileSystem)this.dfs, srcPath, fileLength, this.ecPolicy, this.blockGroupSize);
        }
        finally {
            this.tearDown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCloseWithExceptionsInStreamer() throws Exception {
        HdfsConfiguration conf = this.newHdfsConfiguration();
        int[] fileLengths = new int[]{65536 * (this.dataBlocks * 2 - 2), 65536 * this.dataBlocks + 123};
        try {
            for (int length : fileLengths) {
                int[] dnIndex = new int[]{this.dataBlocks - 2, this.dataBlocks - 1};
                int[] killPos = this.getKillPositions(length, dnIndex.length);
                try {
                    LOG.info("runTestWithMultipleFailure2: length==" + length + ", killPos=" + Arrays.toString(killPos) + ", dnIndex=" + Arrays.toString(dnIndex));
                    this.setup((Configuration)conf);
                    this.runTest(length, killPos, dnIndex, false);
                }
                catch (Throwable e) {
                    String err = "failed, killPos=" + Arrays.toString(killPos) + ", dnIndex=" + Arrays.toString(dnIndex) + ", length=" + length;
                    LOG.error(err);
                    throw e;
                }
            }
        }
        finally {
            this.tearDown();
        }
    }

    @Test
    public void runTestWithShortStripe() throws Exception {
        HdfsConfiguration conf = this.newHdfsConfiguration();
        int length = 65413;
        int[] dnIndex = new int[this.dataBlocks + this.parityBlocks - 1];
        for (int i = 0; i < dnIndex.length; ++i) {
            dnIndex[i] = i;
        }
        int[] killPos = this.getKillPositions(65413, dnIndex.length);
        try {
            LOG.info("runTestWithShortStripe: length==65413, killPos=" + Arrays.toString(killPos) + ", dnIndex=" + Arrays.toString(dnIndex));
            this.setup((Configuration)conf);
            this.runTest(65413, killPos, dnIndex, false);
        }
        catch (Throwable e) {
            String err = "failed, killPos=" + Arrays.toString(killPos) + ", dnIndex=" + Arrays.toString(dnIndex) + ", length=" + 65413;
            LOG.error(err);
            throw e;
        }
        finally {
            this.tearDown();
        }
    }
}

