/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.IOException;
import java.util.HashMap;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.crypto.key.KeyProvider;
import org.apache.hadoop.crypto.key.KeyProviderCryptoExtension;
import org.apache.hadoop.fs.FileSystemTestHelper;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.server.namenode.EncryptionZoneManager;
import org.apache.hadoop.hdfs.server.namenode.ReencryptionHandler;
import org.apache.hadoop.hdfs.server.namenode.ReencryptionUpdater;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.util.KMSUtil;
import org.apache.hadoop.util.StopWatch;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.Timeout;
import org.mockito.Mockito;
import org.mockito.internal.util.reflection.Whitebox;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public class TestReencryptionHandler {
    protected static final Logger LOG = LoggerFactory.getLogger(TestReencryptionHandler.class);
    @Rule
    public Timeout globalTimeout = new Timeout(180000);

    @Before
    public void setup() {
        GenericTestUtils.setLogLevel((Logger)ReencryptionHandler.LOG, (Level)Level.TRACE);
    }

    private ReencryptionHandler mockReencryptionhandler(Configuration conf) throws IOException {
        conf.set("hadoop.security.key.provider.path", "jceks://file" + new Path(new FileSystemTestHelper().getTestRootDir(), "test.jks").toUri());
        EncryptionZoneManager ezm = (EncryptionZoneManager)Mockito.mock(EncryptionZoneManager.class);
        KeyProvider kp = KMSUtil.createKeyProvider((Configuration)conf, (String)"hadoop.security.key.provider.path");
        Mockito.when((Object)ezm.getProvider()).thenReturn((Object)KeyProviderCryptoExtension.createKeyProviderCryptoExtension((KeyProvider)kp));
        return new ReencryptionHandler(ezm, conf);
    }

    @Test
    public void testThrottle() throws Exception {
        Configuration conf = new Configuration();
        conf.setDouble("dfs.namenode.reencrypt.throttle.limit.handler.ratio", 0.5);
        ReencryptionHandler rh = this.mockReencryptionhandler(conf);
        StopWatch mockAll = (StopWatch)Mockito.mock(StopWatch.class);
        Mockito.when((Object)mockAll.now(TimeUnit.MILLISECONDS)).thenReturn((Object)30000L);
        Mockito.when((Object)mockAll.reset()).thenReturn((Object)mockAll);
        StopWatch mockLocked = (StopWatch)Mockito.mock(StopWatch.class);
        Mockito.when((Object)mockLocked.now(TimeUnit.MILLISECONDS)).thenReturn((Object)20000L);
        Mockito.when((Object)mockLocked.reset()).thenReturn((Object)mockLocked);
        LinkedBlockingQueue queue = new LinkedBlockingQueue();
        Whitebox.setInternalState((Object)rh, (String)"throttleTimerAll", (Object)mockAll);
        Whitebox.setInternalState((Object)rh, (String)"throttleTimerLocked", (Object)mockLocked);
        Whitebox.setInternalState((Object)rh, (String)"taskQueue", queue);
        StopWatch sw = new StopWatch().start();
        rh.throttle();
        sw.stop();
        Assert.assertTrue((String)"should have throttled for at least 8 second", (sw.now(TimeUnit.MILLISECONDS) > 8000L ? 1 : 0) != 0);
        Assert.assertTrue((String)"should have throttled for at most 12 second", (sw.now(TimeUnit.MILLISECONDS) < 12000L ? 1 : 0) != 0);
    }

    @Test
    public void testThrottleNoOp() throws Exception {
        Configuration conf = new Configuration();
        conf.setDouble("dfs.namenode.reencrypt.throttle.limit.handler.ratio", 0.5);
        ReencryptionHandler rh = this.mockReencryptionhandler(conf);
        StopWatch mockAll = (StopWatch)Mockito.mock(StopWatch.class);
        Mockito.when((Object)mockAll.now()).thenReturn((Object)new Long(30000L));
        Mockito.when((Object)mockAll.reset()).thenReturn((Object)mockAll);
        StopWatch mockLocked = (StopWatch)Mockito.mock(StopWatch.class);
        Mockito.when((Object)mockLocked.now()).thenReturn((Object)new Long(10000L));
        Mockito.when((Object)mockLocked.reset()).thenReturn((Object)mockLocked);
        LinkedBlockingQueue queue = new LinkedBlockingQueue();
        Whitebox.setInternalState((Object)rh, (String)"throttleTimerAll", (Object)mockAll);
        Whitebox.setInternalState((Object)rh, (String)"throttleTimerLocked", (Object)mockLocked);
        Whitebox.setInternalState((Object)rh, (String)"taskQueue", queue);
        HashMap submissions = new HashMap();
        Whitebox.setInternalState((Object)rh, (String)"submissions", submissions);
        StopWatch sw = new StopWatch().start();
        rh.throttle();
        sw.stop();
        Assert.assertTrue((String)"should not have throttled", (sw.now(TimeUnit.MILLISECONDS) < 1000L ? 1 : 0) != 0);
    }

    @Test
    public void testThrottleConfigs() throws Exception {
        Configuration conf = new Configuration();
        conf.setDouble("dfs.namenode.reencrypt.throttle.limit.handler.ratio", -1.0);
        try {
            this.mockReencryptionhandler(conf);
            Assert.fail((String)"Should not be able to init");
        }
        catch (IllegalArgumentException e) {
            GenericTestUtils.assertExceptionContains((String)" is not positive", (Throwable)e);
        }
        conf.setDouble("dfs.namenode.reencrypt.throttle.limit.handler.ratio", 0.0);
        try {
            this.mockReencryptionhandler(conf);
            Assert.fail((String)"Should not be able to init");
        }
        catch (IllegalArgumentException e) {
            GenericTestUtils.assertExceptionContains((String)" is not positive", (Throwable)e);
        }
    }

    @Test
    public void testThrottleAccumulatingTasks() throws Exception {
        Configuration conf = new Configuration();
        ReencryptionHandler rh = this.mockReencryptionhandler(conf);
        HashMap<Long, ReencryptionUpdater.ZoneSubmissionTracker> submissions = new HashMap<Long, ReencryptionUpdater.ZoneSubmissionTracker>();
        final ReencryptionUpdater.ZoneSubmissionTracker zst = new ReencryptionUpdater.ZoneSubmissionTracker();
        submissions.put(new Long(1L), zst);
        Future mock = (Future)Mockito.mock(Future.class);
        for (int i = 0; i < Runtime.getRuntime().availableProcessors() * 3; ++i) {
            zst.addTask(mock);
        }
        Thread removeTaskThread = new Thread(){

            @Override
            public void run() {
                try {
                    Thread.sleep(3000L);
                }
                catch (InterruptedException ie) {
                    LOG.info("removeTaskThread interrupted.");
                    Thread.currentThread().interrupt();
                }
                zst.getTasks().clear();
            }
        };
        Whitebox.setInternalState((Object)rh, (String)"submissions", submissions);
        StopWatch sw = new StopWatch().start();
        removeTaskThread.start();
        rh.throttle();
        sw.stop();
        LOG.info("Throttle completed, consumed {}", (Object)sw.now(TimeUnit.MILLISECONDS));
        Assert.assertTrue((String)"should have throttled for at least 3 second", (sw.now(TimeUnit.MILLISECONDS) >= 3000L ? 1 : 0) != 0);
    }
}

