/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.datatransfer.sasl.SaslDataTransferTestCase;
import org.apache.hadoop.security.UserGroupInformation;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class TestSecureNameNode
extends SaslDataTransferTestCase {
    private static final int NUM_OF_DATANODES = 0;
    @Rule
    public ExpectedException exception = ExpectedException.none();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testName() throws Exception {
        MiniDFSCluster cluster = null;
        HdfsConfiguration conf = this.createSecureConfig("authentication,privacy");
        try {
            final MiniDFSCluster clusterRef = cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(0).build();
            cluster.waitActive();
            FileSystem fsForSuperUser = (FileSystem)UserGroupInformation.loginUserFromKeytabAndReturnUGI((String)TestSecureNameNode.getHdfsPrincipal(), (String)TestSecureNameNode.getHdfsKeytab()).doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<FileSystem>(){

                @Override
                public FileSystem run() throws Exception {
                    return clusterRef.getFileSystem();
                }
            });
            fsForSuperUser.mkdirs(new Path("/tmp"));
            fsForSuperUser.setPermission(new Path("/tmp"), new FsPermission(511));
            UserGroupInformation ugi = UserGroupInformation.loginUserFromKeytabAndReturnUGI((String)TestSecureNameNode.getUserPrincipal(), (String)TestSecureNameNode.getUserKeyTab());
            FileSystem fs = (FileSystem)ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<FileSystem>(){

                @Override
                public FileSystem run() throws Exception {
                    return clusterRef.getFileSystem();
                }
            });
            Path p = new Path("/mydir");
            this.exception.expect(IOException.class);
            fs.mkdirs(p);
            Path tmp = new Path("/tmp/alpha");
            fs.mkdirs(tmp);
            Assert.assertNotNull((Object)fs.listStatus(tmp));
            Assert.assertEquals((Object)UserGroupInformation.AuthenticationMethod.KERBEROS, (Object)ugi.getAuthenticationMethod());
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    @Test
    public void testKerberosHdfsBlockTokenInconsistencyNNStartup() throws Exception {
        MiniDFSCluster dfsCluster = null;
        HdfsConfiguration conf = this.createSecureConfig("authentication,privacy");
        try {
            conf.setBoolean("dfs.block.access.token.enable", false);
            this.exception.expect(IOException.class);
            this.exception.expectMessage("Security is enabled but block access tokens");
            dfsCluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).build();
            dfsCluster.waitActive();
        }
        finally {
            if (dfsCluster != null) {
                dfsCluster.shutdown();
            }
        }
    }
}

