/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.ha;

import com.google.common.base.Supplier;
import java.io.File;
import java.io.IOException;
import java.net.BindException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.fs.permission.PermissionStatus;
import org.apache.hadoop.ha.ServiceFailedException;
import org.apache.hadoop.hdfs.HAUtil;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.MiniDFSNNTopology;
import org.apache.hadoop.hdfs.server.namenode.FSEditLog;
import org.apache.hadoop.hdfs.server.namenode.FSImage;
import org.apache.hadoop.hdfs.server.namenode.NNStorage;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.NameNodeAdapter;
import org.apache.hadoop.hdfs.server.namenode.ha.EditLogTailer;
import org.apache.hadoop.hdfs.server.namenode.ha.HATestUtil;
import org.apache.hadoop.net.ServerSocketUtil;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.log4j.Level;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Mockito;
import org.slf4j.Logger;

@RunWith(value=Parameterized.class)
public class TestEditLogTailer {
    private static boolean useAsyncEditLog;
    private static final String DIR_PREFIX = "/dir";
    private static final int DIRS_TO_MAKE = 20;
    static final long SLEEP_TIME = 1000L;
    static final long NN_LAG_TIMEOUT = 10000L;

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        params.add(new Object[]{Boolean.FALSE});
        params.add(new Object[]{Boolean.TRUE});
        return params;
    }

    public TestEditLogTailer(Boolean async) {
        useAsyncEditLog = async;
    }

    private static Configuration getConf() {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setBoolean("dfs.namenode.edits.asynclogging", useAsyncEditLog);
        return conf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTailer() throws IOException, InterruptedException, ServiceFailedException {
        Configuration conf = TestEditLogTailer.getConf();
        conf.setInt("dfs.ha.tail-edits.period", 1);
        conf.setInt("dfs.ha.tail-edits.namenode-retries", 100);
        HAUtil.setAllowStandbyReads((Configuration)conf, (boolean)true);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).nnTopology(MiniDFSNNTopology.simpleHATopology()).numDataNodes(0).build();
        cluster.waitActive();
        cluster.transitionToActive(0);
        NameNode nn1 = cluster.getNameNode(0);
        NameNode nn2 = cluster.getNameNode(1);
        try {
            int i;
            for (i = 0; i < 10; ++i) {
                NameNodeAdapter.mkdirs(nn1, TestEditLogTailer.getDirPath(i), new PermissionStatus("test", "test", new FsPermission(493)), true);
            }
            HATestUtil.waitForStandbyToCatchUp(nn1, nn2);
            for (i = 0; i < 10; ++i) {
                Assert.assertTrue((boolean)NameNodeAdapter.getFileInfo(nn2, TestEditLogTailer.getDirPath(i), false, false, false).isDirectory());
            }
            for (i = 10; i < 20; ++i) {
                NameNodeAdapter.mkdirs(nn1, TestEditLogTailer.getDirPath(i), new PermissionStatus("test", "test", new FsPermission(493)), true);
            }
            HATestUtil.waitForStandbyToCatchUp(nn1, nn2);
            for (i = 10; i < 20; ++i) {
                Assert.assertTrue((boolean)NameNodeAdapter.getFileInfo(nn2, TestEditLogTailer.getDirPath(i), false, false, false).isDirectory());
            }
        }
        finally {
            cluster.shutdown();
        }
    }

    @Test
    public void testNN0TriggersLogRolls() throws Exception {
        TestEditLogTailer.testStandbyTriggersLogRolls(0);
    }

    @Test
    public void testNN1TriggersLogRolls() throws Exception {
        TestEditLogTailer.testStandbyTriggersLogRolls(1);
    }

    @Test
    public void testNN2TriggersLogRolls() throws Exception {
        TestEditLogTailer.testStandbyTriggersLogRolls(2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void testStandbyTriggersLogRolls(int activeIndex) throws Exception {
        Configuration conf = TestEditLogTailer.getConf();
        conf.setInt("dfs.ha.log-roll.period", 1);
        conf.setInt("dfs.ha.tail-edits.period", 1);
        conf.setInt("dfs.ha.tail-edits.namenode-retries", 100);
        MiniDFSCluster cluster = null;
        for (int i = 0; i < 5; ++i) {
            try {
                int[] ports = ServerSocketUtil.getPorts((int)3);
                MiniDFSNNTopology topology = new MiniDFSNNTopology().addNameservice(new MiniDFSNNTopology.NSConf("ns1").addNN(new MiniDFSNNTopology.NNConf("nn1").setIpcPort(ports[0])).addNN(new MiniDFSNNTopology.NNConf("nn2").setIpcPort(ports[1])).addNN(new MiniDFSNNTopology.NNConf("nn3").setIpcPort(ports[2])));
                cluster = new MiniDFSCluster.Builder(conf).nnTopology(topology).numDataNodes(0).build();
                break;
            }
            catch (BindException e) {
                continue;
            }
        }
        if (cluster == null) {
            Assert.fail((String)"failed to start mini cluster.");
        }
        try {
            cluster.transitionToActive(activeIndex);
            TestEditLogTailer.waitForLogRollInSharedDir(cluster, 3L);
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTriggersLogRollsForAllStandbyNN() throws Exception {
        Configuration conf = TestEditLogTailer.getConf();
        conf.setInt("dfs.ha.log-roll.period", 1);
        conf.setInt("dfs.ha.tail-edits.period", 1);
        conf.setInt("dfs.ha.tail-edits.namenode-retries", 100);
        MiniDFSNNTopology topology = new MiniDFSNNTopology().addNameservice(new MiniDFSNNTopology.NSConf("ns1").addNN(new MiniDFSNNTopology.NNConf("nn1").setIpcPort(ServerSocketUtil.getPort((int)0, (int)100))).addNN(new MiniDFSNNTopology.NNConf("nn2").setIpcPort(ServerSocketUtil.getPort((int)0, (int)100))).addNN(new MiniDFSNNTopology.NNConf("nn3").setIpcPort(ServerSocketUtil.getPort((int)0, (int)100))));
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).nnTopology(topology).numDataNodes(0).build();
        try {
            cluster.transitionToStandby(0);
            cluster.transitionToStandby(1);
            cluster.transitionToStandby(2);
            try {
                TestEditLogTailer.waitForLogRollInSharedDir(cluster, 3L);
                Assert.fail((String)"After all NN become Standby state, Standby NN should roll log, but it will be failed");
            }
            catch (TimeoutException timeoutException) {
                // empty catch block
            }
            cluster.transitionToActive(0);
            TestEditLogTailer.waitForLogRollInSharedDir(cluster, 3L);
        }
        finally {
            cluster.shutdown();
        }
    }

    private static String getDirPath(int suffix) {
        return DIR_PREFIX + suffix;
    }

    private static void waitForLogRollInSharedDir(MiniDFSCluster cluster, long startTxId) throws Exception {
        URI sharedUri = cluster.getSharedEditsDir(0, 2);
        File sharedDir = new File(sharedUri.getPath(), "current");
        final File expectedInProgressLog = new File(sharedDir, NNStorage.getInProgressEditsFileName((long)startTxId));
        final File expectedFinalizedLog = new File(sharedDir, NNStorage.getFinalizedEditsFileName((long)startTxId, (long)(startTxId + 1L)));
        GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

            public Boolean get() {
                return expectedInProgressLog.exists() || expectedFinalizedLog.exists();
            }
        }, (int)100, (int)10000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=20000L)
    public void testRollEditTimeoutForActiveNN() throws IOException {
        Configuration conf = TestEditLogTailer.getConf();
        conf.setInt("dfs.ha.tail-edits.rolledits.timeout", 5);
        conf.setInt("dfs.ha.tail-edits.period", 1);
        conf.setInt("dfs.ha.tail-edits.namenode-retries", 100);
        HAUtil.setAllowStandbyReads((Configuration)conf, (boolean)true);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).nnTopology(MiniDFSNNTopology.simpleHATopology()).numDataNodes(0).build();
        cluster.waitActive();
        cluster.transitionToActive(0);
        try {
            EditLogTailer tailer = (EditLogTailer)Mockito.spy((Object)cluster.getNamesystem(1).getEditLogTailer());
            final AtomicInteger flag = new AtomicInteger(0);
            Mockito.when((Object)tailer.getNameNodeProxy()).thenReturn((Object)new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    Thread.sleep(30000L);
                    Assert.assertTrue((boolean)Thread.currentThread().isInterrupted());
                    flag.addAndGet(1);
                    return null;
                }
            });
            tailer.triggerActiveLogRoll();
            Assert.assertEquals((long)0L, (long)flag.get());
        }
        finally {
            cluster.shutdown();
        }
    }

    static {
        GenericTestUtils.setLogLevel((Logger)FSEditLog.LOG, (org.slf4j.event.Level)org.slf4j.event.Level.DEBUG);
        GenericTestUtils.setLogLevel((Log)FSImage.LOG, (Level)Level.DEBUG);
        GenericTestUtils.setLogLevel((Logger)FSEditLog.LOG, (org.slf4j.event.Level)org.slf4j.event.Level.DEBUG);
        GenericTestUtils.setLogLevel((Log)EditLogTailer.LOG, (Level)Level.DEBUG);
    }
}

