/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.web;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.security.PrivilegedExceptionAction;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.FSMainOperationsBaseTest;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.AppendTestUtil;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.web.WebHdfsFileSystem;
import org.apache.hadoop.hdfs.web.resources.ExceptionHandler;
import org.apache.hadoop.hdfs.web.resources.GetOpParam;
import org.apache.hadoop.hdfs.web.resources.HttpOpParam;
import org.apache.hadoop.hdfs.web.resources.Param;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.log4j.Level;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Mockito;

public class TestFSMainOperationsWebHdfs
extends FSMainOperationsBaseTest {
    private static MiniDFSCluster cluster = null;
    private static Path defaultWorkingDirectory;
    private static FileSystem fileSystem;
    boolean closedInputStream;

    public TestFSMainOperationsWebHdfs() {
        super("/tmp/TestFSMainOperationsWebHdfs");
        GenericTestUtils.setLogLevel((Log)ExceptionHandler.LOG, (Level)Level.ALL);
        this.closedInputStream = false;
    }

    protected FileSystem createFileSystem() throws Exception {
        return fileSystem;
    }

    @BeforeClass
    public static void setupCluster() {
        final Configuration conf = new Configuration();
        conf.setLong("dfs.blocksize", 1024L);
        try {
            cluster = new MiniDFSCluster.Builder(conf).numDataNodes(2).build();
            cluster.waitActive();
            cluster.getFileSystem().setPermission(new Path("/"), new FsPermission(511));
            final String uri = "webhdfs://" + conf.get("dfs.namenode.http-address");
            UserGroupInformation current = UserGroupInformation.getCurrentUser();
            UserGroupInformation ugi = UserGroupInformation.createUserForTesting((String)(current.getShortUserName() + "x"), (String[])new String[]{"user"});
            fileSystem = (FileSystem)ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<FileSystem>(){

                @Override
                public FileSystem run() throws Exception {
                    return FileSystem.get((URI)new URI(uri), (Configuration)conf);
                }
            });
            defaultWorkingDirectory = fileSystem.getWorkingDirectory();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @AfterClass
    public static void shutdownCluster() {
        if (cluster != null) {
            cluster.shutdown();
            cluster = null;
        }
    }

    protected Path getDefaultWorkingDirectory() {
        return defaultWorkingDirectory;
    }

    @Test
    public void testConcat() throws Exception {
        Path[] paths = new Path[]{new Path("/test/hadoop/file1"), new Path("/test/hadoop/file2"), new Path("/test/hadoop/file3")};
        DFSTestUtil.createFile(this.fSys, paths[0], 1024L, (short)3, 0L);
        DFSTestUtil.createFile(this.fSys, paths[1], 1024L, (short)3, 0L);
        DFSTestUtil.createFile(this.fSys, paths[2], 1024L, (short)3, 0L);
        Path catPath = new Path("/test/hadoop/catFile");
        DFSTestUtil.createFile(this.fSys, catPath, 1024L, (short)3, 0L);
        Assert.assertTrue((boolean)TestFSMainOperationsWebHdfs.exists((FileSystem)this.fSys, (Path)catPath));
        this.fSys.concat(catPath, paths);
        Assert.assertFalse((boolean)TestFSMainOperationsWebHdfs.exists((FileSystem)this.fSys, (Path)paths[0]));
        Assert.assertFalse((boolean)TestFSMainOperationsWebHdfs.exists((FileSystem)this.fSys, (Path)paths[1]));
        Assert.assertFalse((boolean)TestFSMainOperationsWebHdfs.exists((FileSystem)this.fSys, (Path)paths[2]));
        FileStatus fileStatus = this.fSys.getFileStatus(catPath);
        Assert.assertEquals((long)4096L, (long)fileStatus.getLen());
    }

    @Test
    public void testTruncate() throws Exception {
        int repl = 3;
        int blockSize = 1024;
        int numOfBlocks = 2;
        Path dir = this.getTestRootPath(this.fSys, "test/hadoop");
        Path file = this.getTestRootPath(this.fSys, "test/hadoop/file");
        byte[] data = TestFSMainOperationsWebHdfs.getFileData((int)2, (long)1024L);
        TestFSMainOperationsWebHdfs.createFile((FileSystem)this.fSys, (Path)file, (byte[])data, (int)1024, (short)3);
        int newLength = 1024;
        boolean isReady = this.fSys.truncate(file, 1024L);
        Assert.assertTrue((String)"Recovery is not expected.", (boolean)isReady);
        FileStatus fileStatus = this.fSys.getFileStatus(file);
        Assert.assertEquals((long)fileStatus.getLen(), (long)1024L);
        AppendTestUtil.checkFullFile(this.fSys, file, 1024, data, file.toString());
        ContentSummary cs = this.fSys.getContentSummary(dir);
        Assert.assertEquals((String)"Bad disk space usage", (long)cs.getSpaceConsumed(), (long)3072L);
        Assert.assertTrue((String)"Deleted", (boolean)this.fSys.delete(dir, true));
    }

    @Test
    public void testJsonParseClosesInputStream() throws Exception {
        WebHdfsFileSystem webhdfs = (WebHdfsFileSystem)fileSystem;
        Path file = this.getTestRootPath(this.fSys, "test/hadoop/file");
        this.createFile(file);
        GetOpParam.Op op = GetOpParam.Op.GETHOMEDIRECTORY;
        URL url = webhdfs.toUrl((HttpOpParam.Op)op, file, new Param[0]);
        final HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod(op.getType().toString());
        conn.connect();
        InputStream myIn = new InputStream(){
            private HttpURLConnection localConn;
            {
                this.localConn = conn;
            }

            @Override
            public void close() throws IOException {
                TestFSMainOperationsWebHdfs.this.closedInputStream = true;
                this.localConn.getInputStream().close();
            }

            @Override
            public int read() throws IOException {
                return this.localConn.getInputStream().read();
            }
        };
        HttpURLConnection spyConn = (HttpURLConnection)Mockito.spy((Object)conn);
        ((HttpURLConnection)Mockito.doReturn((Object)myIn).when((Object)spyConn)).getInputStream();
        try {
            Assert.assertFalse((boolean)this.closedInputStream);
            WebHdfsFileSystem.jsonParse((HttpURLConnection)spyConn, (boolean)false);
            Assert.assertTrue((boolean)this.closedInputStream);
        }
        catch (IOException ioe) {
            TestCase.fail();
        }
        conn.disconnect();
    }

    @Test
    public void testMkdirsFailsForSubdirectoryOfExistingFile() throws Exception {
        Path testDir = this.getTestRootPath(this.fSys, "test/hadoop");
        Assert.assertFalse((boolean)TestFSMainOperationsWebHdfs.exists((FileSystem)this.fSys, (Path)testDir));
        this.fSys.mkdirs(testDir);
        Assert.assertTrue((boolean)TestFSMainOperationsWebHdfs.exists((FileSystem)this.fSys, (Path)testDir));
        this.createFile(this.getTestRootPath(this.fSys, "test/hadoop/file"));
        Path testSubDir = this.getTestRootPath(this.fSys, "test/hadoop/file/subdir");
        try {
            this.fSys.mkdirs(testSubDir);
            Assert.fail((String)"Should throw IOException.");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            Assert.assertFalse((boolean)TestFSMainOperationsWebHdfs.exists((FileSystem)this.fSys, (Path)testSubDir));
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
        Path testDeepSubDir = this.getTestRootPath(this.fSys, "test/hadoop/file/deep/sub/dir");
        try {
            this.fSys.mkdirs(testDeepSubDir);
            Assert.fail((String)"Should throw IOException.");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            Assert.assertFalse((boolean)TestFSMainOperationsWebHdfs.exists((FileSystem)this.fSys, (Path)testDeepSubDir));
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
    }
}

