/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.tools.offlineImageViewer;

import com.google.common.io.CountingOutputStream;
import com.google.common.primitives.Ints;
import com.google.protobuf.ByteString;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.TextFormat;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import javax.xml.bind.annotation.adapters.HexBinaryAdapter;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.protocol.proto.ClientNamenodeProtocolProtos;
import org.apache.hadoop.hdfs.protocol.proto.HdfsProtos;
import org.apache.hadoop.hdfs.protocol.proto.XAttrProtos;
import org.apache.hadoop.hdfs.server.namenode.FSImageFormatProtobuf;
import org.apache.hadoop.hdfs.server.namenode.FSImageUtil;
import org.apache.hadoop.hdfs.server.namenode.FsImageProto;
import org.apache.hadoop.hdfs.server.namenode.NameNodeLayoutVersion;
import org.apache.hadoop.hdfs.tools.offlineImageViewer.PBImageXmlWriter;
import org.apache.hadoop.hdfs.util.MD5FileUtils;
import org.apache.hadoop.hdfs.util.XMLUtils;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.MD5Hash;
import org.apache.hadoop.util.StringUtils;

@InterfaceAudience.Private
@InterfaceStability.Unstable
class OfflineImageReconstructor {
    public static final Log LOG = LogFactory.getLog(OfflineImageReconstructor.class);
    private final CountingOutputStream out;
    private final XMLEventReader events;
    private final HashMap<String, SectionProcessor> sections;
    private long sectionStartOffset;
    private final FsImageProto.FileSummary.Builder fileSummaryBld = FsImageProto.FileSummary.newBuilder();
    private final HashMap<String, Integer> stringTable = new HashMap();
    private final SimpleDateFormat isoDateFormat;
    private int latestStringId = 0;
    private static final String EMPTY_STRING = "";

    private OfflineImageReconstructor(CountingOutputStream out, InputStreamReader reader) throws XMLStreamException {
        this.out = out;
        XMLInputFactory factory = XMLInputFactory.newInstance();
        this.events = factory.createXMLEventReader(reader);
        this.sections = new HashMap();
        this.sections.put("NameSection", new NameSectionProcessor());
        this.sections.put("INodeSection", new INodeSectionProcessor());
        this.sections.put("SecretManagerSection", new SecretManagerSectionProcessor());
        this.sections.put("CacheManagerSection", new CacheManagerSectionProcessor());
        this.sections.put("SnapshotDiffSection", new SnapshotDiffSectionProcessor());
        this.sections.put("INodeReferenceSection", new INodeReferenceSectionProcessor());
        this.sections.put("INodeDirectorySection", new INodeDirectorySectionProcessor());
        this.sections.put("FileUnderConstructionSection", new FilesUnderConstructionSectionProcessor());
        this.sections.put("SnapshotSection", new SnapshotSectionProcessor());
        this.isoDateFormat = PBImageXmlWriter.createSimpleDateFormat();
    }

    private XMLEvent expectTag(String expected, boolean allowEnd) throws IOException {
        XMLEvent ev = null;
        block8: while (true) {
            try {
                ev = this.events.nextEvent();
            }
            catch (XMLStreamException e) {
                throw new IOException("Expecting " + expected + ", but got XMLStreamException", e);
            }
            switch (ev.getEventType()) {
                case 10: {
                    throw new IOException("Got unexpected attribute: " + ev);
                }
                case 4: {
                    if (ev.asCharacters().isWhiteSpace()) continue block8;
                    throw new IOException("Got unxpected characters while looking for " + expected + ": " + ev.asCharacters().getData());
                }
                case 2: {
                    if (!allowEnd) {
                        throw new IOException("Got unexpected end event while looking for " + expected);
                    }
                    return ev;
                }
                case 1: {
                    if (!expected.startsWith("[") && !ev.asStartElement().getName().getLocalPart().equals(expected)) {
                        throw new IOException("Failed to find <" + expected + ">; got " + ev.asStartElement().getName().getLocalPart() + " instead.");
                    }
                    return ev;
                }
            }
            if (!LOG.isTraceEnabled()) continue;
            LOG.trace((Object)("Skipping XMLEvent of type " + ev.getEventType() + "(" + ev + ")"));
        }
    }

    private void expectTagEnd(String expected) throws IOException {
        String tag;
        XMLEvent ev = this.expectTag(expected, true);
        if (ev.getEventType() != 2) {
            throw new IOException("Expected tag end event for " + expected + ", but got: " + ev);
        }
        if (!expected.startsWith("[") && !(tag = ev.asEndElement().getName().getLocalPart()).equals(expected)) {
            throw new IOException("Expected tag end event for " + expected + ", but got tag end event for " + tag);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void loadNodeChildrenHelper(Node parent, String expected, String[] terminators) throws IOException {
        XMLEvent ev = null;
        try {
            block8: while (true) {
                ev = this.events.peek();
                switch (ev.getEventType()) {
                    case 2: {
                        if (terminators.length != 0) {
                            return;
                        }
                        this.events.nextEvent();
                        return;
                    }
                    case 1: {
                        String key = ev.asStartElement().getName().getLocalPart();
                        for (String terminator : terminators) {
                            if (!terminator.equals(key)) continue;
                            return;
                        }
                        this.events.nextEvent();
                        Node node = new Node();
                        parent.addChild(key, node);
                        this.loadNodeChildrenHelper(node, expected, new String[0]);
                        continue block8;
                    }
                    case 4: {
                        String val = XMLUtils.unmangleXmlString(ev.asCharacters().getData(), true);
                        parent.setVal(val);
                        this.events.nextEvent();
                        continue block8;
                    }
                    case 10: {
                        throw new IOException("Unexpected XML event " + ev);
                    }
                }
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("Skipping XMLEvent " + ev));
                }
                this.events.nextEvent();
            }
        }
        catch (XMLStreamException e) {
            throw new IOException("Expecting " + expected + ", but got XMLStreamException", e);
        }
    }

    private void loadNodeChildren(Node parent, String expected, String ... terminators) throws IOException {
        this.loadNodeChildrenHelper(parent, expected, terminators);
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("loadNodeChildren(expected=" + expected + ", terminators=[" + StringUtils.join((CharSequence)",", (String[])terminators) + "]):" + parent.dump()));
        }
    }

    private FsImageProto.INodeSection.INode.Builder processINodeXml(Node node) throws IOException {
        String type = node.removeChildStr("type");
        if (type == null) {
            throw new IOException("INode XML found with no <type> tag.");
        }
        FsImageProto.INodeSection.INode.Builder inodeBld = FsImageProto.INodeSection.INode.newBuilder();
        Long id = node.removeChildLong("id");
        if (id == null) {
            throw new IOException("<inode> found without <id>");
        }
        inodeBld.setId(id);
        String name = node.removeChildStr("name");
        if (name != null) {
            inodeBld.setName(ByteString.copyFrom((String)name, (String)"UTF8"));
        }
        switch (type) {
            case "FILE": {
                this.processFileXml(node, inodeBld);
                break;
            }
            case "DIRECTORY": {
                this.processDirectoryXml(node, inodeBld);
                break;
            }
            case "SYMLINK": {
                this.processSymlinkXml(node, inodeBld);
                break;
            }
            default: {
                throw new IOException("INode XML found with unknown <type> tag " + type);
            }
        }
        node.verifyNoRemainingKeys("inode");
        return inodeBld;
    }

    private void processFileXml(Node node, FsImageProto.INodeSection.INode.Builder inodeBld) throws IOException {
        inodeBld.setType(FsImageProto.INodeSection.INode.Type.FILE);
        FsImageProto.INodeSection.INodeFile.Builder bld = this.createINodeFileBuilder(node);
        inodeBld.setFile(bld);
    }

    private FsImageProto.INodeSection.INodeFile.Builder createINodeFileBuilder(Node node) throws IOException {
        Node xattrs;
        Node acls;
        Node fileUnderConstruction;
        Node blocks;
        String perm;
        Long lval;
        FsImageProto.INodeSection.INodeFile.Builder bld = FsImageProto.INodeSection.INodeFile.newBuilder();
        Integer ival = node.removeChildInt("replication");
        if (ival != null) {
            bld.setReplication(ival);
        }
        if ((lval = node.removeChildLong("mtime")) != null) {
            bld.setModificationTime(lval);
        }
        if ((lval = node.removeChildLong("atime")) != null) {
            bld.setAccessTime(lval);
        }
        if ((lval = node.removeChildLong("preferredBlockSize")) != null) {
            bld.setPreferredBlockSize(lval);
        }
        if ((perm = node.removeChildStr("permission")) != null) {
            bld.setPermission(this.permissionXmlToU64(perm));
        }
        if ((blocks = node.removeChild("blocks")) != null) {
            Node block;
            while ((block = blocks.removeChild("block")) != null) {
                bld.addBlocks(this.createBlockBuilder(block));
            }
        }
        if ((fileUnderConstruction = node.removeChild("file-under-construction")) != null) {
            FsImageProto.INodeSection.FileUnderConstructionFeature.Builder fb = FsImageProto.INodeSection.FileUnderConstructionFeature.newBuilder();
            String clientName = fileUnderConstruction.removeChildStr("clientName");
            if (clientName == null) {
                throw new IOException("<file-under-construction> found without <clientName>");
            }
            fb.setClientName(clientName);
            String clientMachine = fileUnderConstruction.removeChildStr("clientMachine");
            if (clientMachine == null) {
                throw new IOException("<file-under-construction> found without <clientMachine>");
            }
            fb.setClientMachine(clientMachine);
            bld.setFileUC(fb);
        }
        if ((acls = node.removeChild("acls")) != null) {
            bld.setAcl(this.aclXmlToProto(acls));
        }
        if ((xattrs = node.removeChild("xattrs")) != null) {
            bld.setXAttrs(this.xattrsXmlToProto(xattrs));
        }
        if ((ival = node.removeChildInt("storagePolicyId")) != null) {
            bld.setStoragePolicyID(ival);
        }
        return bld;
    }

    private HdfsProtos.BlockProto.Builder createBlockBuilder(Node block) throws IOException {
        HdfsProtos.BlockProto.Builder blockBld = HdfsProtos.BlockProto.newBuilder();
        Long id = block.removeChildLong("id");
        if (id == null) {
            throw new IOException("<block> found without <id>");
        }
        blockBld.setBlockId(id.longValue());
        Long genstamp = block.removeChildLong("genstamp");
        if (genstamp == null) {
            throw new IOException("<block> found without <genstamp>");
        }
        blockBld.setGenStamp(genstamp.longValue());
        Long numBytes = block.removeChildLong("numBytes");
        if (numBytes == null) {
            throw new IOException("<block> found without <numBytes>");
        }
        blockBld.setNumBytes(numBytes.longValue());
        return blockBld;
    }

    private void processDirectoryXml(Node node, FsImageProto.INodeSection.INode.Builder inodeBld) throws IOException {
        inodeBld.setType(FsImageProto.INodeSection.INode.Type.DIRECTORY);
        FsImageProto.INodeSection.INodeDirectory.Builder bld = this.createINodeDirectoryBuilder(node);
        inodeBld.setDirectory(bld);
    }

    private FsImageProto.INodeSection.INodeDirectory.Builder createINodeDirectoryBuilder(Node node) throws IOException {
        Node typeQuota;
        Node xattrs;
        Node acls;
        String perm;
        FsImageProto.INodeSection.INodeDirectory.Builder bld = FsImageProto.INodeSection.INodeDirectory.newBuilder();
        Long lval = node.removeChildLong("mtime");
        if (lval != null) {
            bld.setModificationTime(lval);
        }
        if ((lval = node.removeChildLong("nsquota")) != null) {
            bld.setNsQuota(lval);
        }
        if ((lval = node.removeChildLong("dsquota")) != null) {
            bld.setDsQuota(lval);
        }
        if ((perm = node.removeChildStr("permission")) != null) {
            bld.setPermission(this.permissionXmlToU64(perm));
        }
        if ((acls = node.removeChild("acls")) != null) {
            bld.setAcl(this.aclXmlToProto(acls));
        }
        if ((xattrs = node.removeChild("xattrs")) != null) {
            bld.setXAttrs(this.xattrsXmlToProto(xattrs));
        }
        FsImageProto.INodeSection.QuotaByStorageTypeFeatureProto.Builder qf = FsImageProto.INodeSection.QuotaByStorageTypeFeatureProto.newBuilder();
        while ((typeQuota = node.removeChild("typeQuota")) != null) {
            FsImageProto.INodeSection.QuotaByStorageTypeEntryProto.Builder qbld = FsImageProto.INodeSection.QuotaByStorageTypeEntryProto.newBuilder();
            String type = typeQuota.removeChildStr("type");
            if (type == null) {
                throw new IOException("<typeQuota> was missing <type>");
            }
            HdfsProtos.StorageTypeProto storageType = HdfsProtos.StorageTypeProto.valueOf((String)type);
            if (storageType == null) {
                throw new IOException("<typeQuota> had unknown <type> " + type);
            }
            qbld.setStorageType(storageType);
            Long quota = typeQuota.removeChildLong("quota");
            if (quota == null) {
                throw new IOException("<typeQuota> was missing <quota>");
            }
            qbld.setQuota(quota);
            qf.addQuotas(qbld);
        }
        bld.setTypeQuotas(qf);
        return bld;
    }

    private void processSymlinkXml(Node node, FsImageProto.INodeSection.INode.Builder inodeBld) throws IOException {
        Long lval;
        String target;
        inodeBld.setType(FsImageProto.INodeSection.INode.Type.SYMLINK);
        FsImageProto.INodeSection.INodeSymlink.Builder bld = FsImageProto.INodeSection.INodeSymlink.newBuilder();
        String perm = node.removeChildStr("permission");
        if (perm != null) {
            bld.setPermission(this.permissionXmlToU64(perm));
        }
        if ((target = node.removeChildStr("target")) != null) {
            bld.setTarget(ByteString.copyFrom((String)target, (String)"UTF8"));
        }
        if ((lval = node.removeChildLong("mtime")) != null) {
            bld.setModificationTime(lval);
        }
        if ((lval = node.removeChildLong("atime")) != null) {
            bld.setAccessTime(lval);
        }
        inodeBld.setSymlink(bld);
    }

    private FsImageProto.INodeSection.AclFeatureProto.Builder aclXmlToProto(Node acls) throws IOException {
        Node acl;
        FsImageProto.INodeSection.AclFeatureProto.Builder b = FsImageProto.INodeSection.AclFeatureProto.newBuilder();
        while ((acl = acls.removeChild("acl")) != null) {
            String val = acl.getVal();
            AclEntry entry = AclEntry.parseAclEntry((String)val, (boolean)true);
            int nameId = this.registerStringId(entry.getName() == null ? EMPTY_STRING : entry.getName());
            int v = (nameId & 0xFFFFFF) << 6 | entry.getType().ordinal() << 3 | entry.getScope().ordinal() << 5 | entry.getPermission().ordinal();
            b.addEntries(v);
        }
        return b;
    }

    private FsImageProto.INodeSection.XAttrFeatureProto.Builder xattrsXmlToProto(Node xattrs) throws IOException {
        Node xattr;
        FsImageProto.INodeSection.XAttrFeatureProto.Builder bld = FsImageProto.INodeSection.XAttrFeatureProto.newBuilder();
        while ((xattr = xattrs.removeChild("xattr")) != null) {
            FsImageProto.INodeSection.XAttrCompactProto.Builder b = FsImageProto.INodeSection.XAttrCompactProto.newBuilder();
            String ns = xattr.removeChildStr("ns");
            if (ns == null) {
                throw new IOException("<xattr> had no <ns> entry.");
            }
            int nsIdx = XAttrProtos.XAttrProto.XAttrNamespaceProto.valueOf((String)ns).ordinal();
            String name = xattr.removeChildStr("name");
            String valStr = xattr.removeChildStr("val");
            byte[] val = null;
            if (valStr == null) {
                String valHex = xattr.removeChildStr("valHex");
                if (valHex == null) {
                    throw new IOException("<xattr> had no <val> or <valHex> entry.");
                }
                val = new HexBinaryAdapter().unmarshal(valHex);
            } else {
                val = valStr.getBytes("UTF8");
            }
            b.setValue(ByteString.copyFrom((byte[])val));
            int nameId = this.registerStringId(name);
            int encodedName = nameId << 6 | (nsIdx & 3) << 30 | (nsIdx >> 2 & 1) << 5;
            b.setName(encodedName);
            xattr.verifyNoRemainingKeys("xattr");
            bld.addXAttrs(b);
        }
        xattrs.verifyNoRemainingKeys("xattrs");
        return bld;
    }

    private long permissionXmlToU64(String perm) throws IOException {
        String[] components = perm.split(":");
        if (components.length != 3) {
            throw new IOException("Unable to parse permission string " + perm + ": expected 3 components, but only had " + components.length);
        }
        String userName = components[0];
        String groupName = components[1];
        String modeString = components[2];
        long userNameId = this.registerStringId(userName);
        long groupNameId = this.registerStringId(groupName);
        long mode = new FsPermission(modeString).toShort();
        return userNameId << 40 | groupNameId << 16 | mode;
    }

    int registerStringId(String str) throws IOException {
        int latestId;
        Integer id = this.stringTable.get(str);
        if (id != null) {
            return id;
        }
        if ((latestId = this.latestStringId++) >= 0x1FFFFFF) {
            throw new IOException("Cannot have more than 2**25 strings in the fsimage, because of the limitation on the size of string table IDs.");
        }
        this.stringTable.put(str, latestId);
        return latestId;
    }

    void recordSectionLength(String sectionNamePb) throws IOException {
        long curSectionStartOffset = this.sectionStartOffset;
        long curPos = this.out.getCount();
        this.fileSummaryBld.addSections(FsImageProto.FileSummary.Section.newBuilder().setName(sectionNamePb).setLength(curPos - curSectionStartOffset).setOffset(curSectionStartOffset));
        this.sectionStartOffset = curPos;
    }

    private void readVersion() throws IOException {
        try {
            this.expectTag("version", false);
        }
        catch (IOException e) {
            throw new IOException("No <version> section found at the top of the fsimage XML.  This XML file is too old to be processed by ovi.", e);
        }
        Node version = new Node();
        this.loadNodeChildren(version, "version fields", new String[0]);
        Integer onDiskVersion = version.removeChildInt("onDiskVersion");
        if (onDiskVersion == null) {
            throw new IOException("The <version> section doesn't contain the onDiskVersion.");
        }
        Integer layoutVersion = version.removeChildInt("layoutVersion");
        if (layoutVersion == null) {
            throw new IOException("The <version> section doesn't contain the layoutVersion.");
        }
        if (layoutVersion != NameNodeLayoutVersion.CURRENT_LAYOUT_VERSION) {
            throw new IOException("Layout version mismatch.  This oiv tool handles layout version " + NameNodeLayoutVersion.CURRENT_LAYOUT_VERSION + ", but the XML file has <layoutVersion> " + layoutVersion + ".  Please either re-generate the XML file with the proper layout version, or manually edit the XML file to be usable with this version of the oiv tool.");
        }
        this.fileSummaryBld.setOndiskVersion(onDiskVersion);
        this.fileSummaryBld.setLayoutVersion(layoutVersion);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Loaded <version> with onDiskVersion=" + onDiskVersion + ", layoutVersion=" + layoutVersion + "."));
        }
    }

    private void writeStringTableSection() throws IOException {
        FsImageProto.StringTableSection sectionHeader = FsImageProto.StringTableSection.newBuilder().setNumEntry(this.stringTable.size()).build();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(FSImageFormatProtobuf.SectionName.STRING_TABLE.name() + " writing header: {" + TextFormat.printToString((MessageOrBuilder)sectionHeader) + "}"));
        }
        sectionHeader.writeDelimitedTo((OutputStream)this.out);
        for (Map.Entry<String, Integer> entry : this.stringTable.entrySet()) {
            FsImageProto.StringTableSection.Entry stEntry = FsImageProto.StringTableSection.Entry.newBuilder().setStr(entry.getKey()).setId(entry.getValue()).build();
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Writing string table entry: {" + TextFormat.printToString((MessageOrBuilder)stEntry) + "}"));
            }
            stEntry.writeDelimitedTo((OutputStream)this.out);
        }
        this.recordSectionLength(FSImageFormatProtobuf.SectionName.STRING_TABLE.name());
    }

    private void processXml() throws Exception {
        LOG.debug((Object)"Loading <fsimage>.");
        this.expectTag("fsimage", false);
        this.readVersion();
        this.out.write(FSImageUtil.MAGIC_HEADER);
        this.sectionStartOffset = FSImageUtil.MAGIC_HEADER.length;
        HashSet<String> unprocessedSections = new HashSet<String>(this.sections.keySet());
        while (!unprocessedSections.isEmpty()) {
            XMLEvent ev = this.expectTag("[section header]", true);
            if (ev.getEventType() == 2) {
                if (ev.asEndElement().getName().getLocalPart().equals("fsimage")) {
                    throw new IOException("FSImage XML ended prematurely, without including section(s) " + StringUtils.join((CharSequence)", ", unprocessedSections));
                }
                throw new IOException("Got unexpected tag end event for " + ev.asEndElement().getName().getLocalPart() + " while looking for section header tag.");
            }
            if (ev.getEventType() != 1) {
                throw new IOException("Expected section header START_ELEMENT; got event of type " + ev.getEventType());
            }
            String sectionName = ev.asStartElement().getName().getLocalPart();
            if (!unprocessedSections.contains(sectionName)) {
                throw new IOException("Unknown or duplicate section found for " + sectionName);
            }
            SectionProcessor sectionProcessor = this.sections.get(sectionName);
            if (sectionProcessor == null) {
                throw new IOException("Unknown FSImage section " + sectionName + ".  Valid section names are [" + StringUtils.join((CharSequence)", ", this.sections.keySet()) + "]");
            }
            unprocessedSections.remove(sectionName);
            sectionProcessor.process();
        }
        this.writeStringTableSection();
        long prevOffset = this.out.getCount();
        FsImageProto.FileSummary fileSummary = this.fileSummaryBld.build();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Writing FileSummary: {" + TextFormat.printToString((MessageOrBuilder)fileSummary) + "}"));
        }
        fileSummary.writeDelimitedTo((OutputStream)this.out);
        int summaryLen = Ints.checkedCast((long)(this.out.getCount() - prevOffset));
        byte[] summaryLenBytes = new byte[4];
        ByteBuffer.wrap(summaryLenBytes).asIntBuffer().put(summaryLen);
        this.out.write(summaryLenBytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void run(String inputPath, String outputPath) throws Exception {
        MessageDigest digester = MD5Hash.getDigester();
        FileOutputStream fout = null;
        File foutHash = new File(outputPath + ".md5");
        Files.deleteIfExists(foutHash.toPath());
        CountingOutputStream out = null;
        FileInputStream fis = null;
        InputStreamReader reader = null;
        try {
            Files.deleteIfExists(Paths.get(outputPath, new String[0]));
            fout = new FileOutputStream(outputPath);
            fis = new FileInputStream(inputPath);
            reader = new InputStreamReader((InputStream)fis, Charset.forName("UTF-8"));
            out = new CountingOutputStream((OutputStream)new DigestOutputStream(new BufferedOutputStream(fout), digester));
            OfflineImageReconstructor oir = new OfflineImageReconstructor(out, reader);
            oir.processXml();
        }
        catch (Throwable throwable) {
            IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{reader, fis, out, fout});
            throw throwable;
        }
        IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{reader, fis, out, fout});
        MD5FileUtils.saveMD5File(new File(outputPath), new MD5Hash(digester.digest()));
    }

    private class SnapshotDiffSectionProcessor
    implements SectionProcessor {
        static final String NAME = "SnapshotDiffSection";

        private SnapshotDiffSectionProcessor() {
        }

        @Override
        public void process() throws IOException {
            block4: {
                String tagName;
                LOG.debug((Object)"Processing SnapshotDiffSection");
                while (true) {
                    XMLEvent ev;
                    if ((ev = OfflineImageReconstructor.this.expectTag("[diff start tag]", true)).isEndElement()) {
                        String name = ev.asEndElement().getName().getLocalPart();
                        if (!name.equals(NAME)) {
                            throw new IOException("Got unexpected end tag for " + name);
                        }
                        break block4;
                    }
                    tagName = ev.asStartElement().getName().getLocalPart();
                    if (tagName.equals("dirDiffEntry")) {
                        this.processDirDiffEntry();
                        continue;
                    }
                    if (!tagName.equals("fileDiffEntry")) break;
                    this.processFileDiffEntry();
                }
                throw new IOException("SnapshotDiffSection contained unexpected tag " + tagName);
            }
            OfflineImageReconstructor.this.recordSectionLength(FSImageFormatProtobuf.SectionName.SNAPSHOT_DIFF.name());
        }

        private void processDirDiffEntry() throws IOException {
            LOG.debug((Object)"Processing dirDiffEntry");
            FsImageProto.SnapshotDiffSection.DiffEntry.Builder headerBld = FsImageProto.SnapshotDiffSection.DiffEntry.newBuilder();
            headerBld.setType(FsImageProto.SnapshotDiffSection.DiffEntry.Type.DIRECTORYDIFF);
            Node dirDiffHeader = new Node();
            OfflineImageReconstructor.this.loadNodeChildren(dirDiffHeader, "dirDiffEntry fields", new String[]{"dirDiff"});
            Long inodeId = dirDiffHeader.removeChildLong("inodeId");
            if (inodeId == null) {
                throw new IOException("<dirDiffEntry> contained no <inodeId> entry.");
            }
            headerBld.setInodeId(inodeId);
            Integer expectedDiffs = dirDiffHeader.removeChildInt("count");
            if (expectedDiffs == null) {
                throw new IOException("<dirDiffEntry> contained no <count> entry.");
            }
            headerBld.setNumOfDiff(expectedDiffs);
            dirDiffHeader.verifyNoRemainingKeys("dirDiffEntry");
            headerBld.build().writeDelimitedTo((OutputStream)OfflineImageReconstructor.this.out);
            for (int actualDiffs = 0; actualDiffs < expectedDiffs; ++actualDiffs) {
                Node created;
                Node deleted;
                Integer expectedCreatedListSize;
                Node snapshotCopy;
                Integer childrenSize;
                try {
                    OfflineImageReconstructor.this.expectTag("dirDiff", false);
                }
                catch (IOException e) {
                    throw new IOException("Only read " + (actualDiffs + 1) + " diffs out of " + expectedDiffs, e);
                }
                Node dirDiff = new Node();
                OfflineImageReconstructor.this.loadNodeChildren(dirDiff, "dirDiff fields", new String[0]);
                FsImageProto.SnapshotDiffSection.DirectoryDiff.Builder bld = FsImageProto.SnapshotDiffSection.DirectoryDiff.newBuilder();
                Integer snapshotId = dirDiff.removeChildInt("snapshotId");
                if (snapshotId != null) {
                    bld.setSnapshotId(snapshotId);
                }
                if ((childrenSize = dirDiff.removeChildInt("childrenSize")) == null) {
                    throw new IOException("Expected to find <childrenSize> in <dirDiff> section.");
                }
                bld.setIsSnapshotRoot(dirDiff.removeChildBool("isSnapshotRoot"));
                bld.setChildrenSize(childrenSize);
                String name = dirDiff.removeChildStr("name");
                if (name != null) {
                    bld.setName(ByteString.copyFrom((String)name, (String)"UTF8"));
                }
                if ((snapshotCopy = dirDiff.removeChild("snapshotCopy")) != null) {
                    bld.setSnapshotCopy(OfflineImageReconstructor.this.createINodeDirectoryBuilder(snapshotCopy));
                }
                if ((expectedCreatedListSize = dirDiff.removeChildInt("createdListSize")) == null) {
                    throw new IOException("Expected to find <createdListSize> in <dirDiff> section.");
                }
                bld.setCreatedListSize(expectedCreatedListSize);
                while ((deleted = dirDiff.removeChild("deletedInode")) != null) {
                    bld.addDeletedINode(Long.parseLong(deleted.getVal()));
                }
                while ((deleted = dirDiff.removeChild("deletedInoderef")) != null) {
                    bld.addDeletedINodeRef(Integer.parseInt(deleted.getVal()));
                }
                bld.build().writeDelimitedTo((OutputStream)OfflineImageReconstructor.this.out);
                int actualCreatedListSize = 0;
                while ((created = dirDiff.removeChild("created")) != null) {
                    String cleName = created.removeChildStr("name");
                    if (cleName == null) {
                        throw new IOException("Expected <created> entry to have a <name> field");
                    }
                    created.verifyNoRemainingKeys("created");
                    FsImageProto.SnapshotDiffSection.CreatedListEntry.newBuilder().setName(ByteString.copyFrom((String)cleName, (String)"UTF8")).build().writeDelimitedTo((OutputStream)OfflineImageReconstructor.this.out);
                    ++actualCreatedListSize;
                }
                if (actualCreatedListSize != expectedCreatedListSize) {
                    throw new IOException("<createdListSize> was " + expectedCreatedListSize + ", but there were " + actualCreatedListSize + " <created> entries.");
                }
                dirDiff.verifyNoRemainingKeys("dirDiff");
            }
            OfflineImageReconstructor.this.expectTagEnd("dirDiffEntry");
        }

        private void processFileDiffEntry() throws IOException {
            LOG.debug((Object)"Processing fileDiffEntry");
            FsImageProto.SnapshotDiffSection.DiffEntry.Builder headerBld = FsImageProto.SnapshotDiffSection.DiffEntry.newBuilder();
            headerBld.setType(FsImageProto.SnapshotDiffSection.DiffEntry.Type.FILEDIFF);
            Node fileDiffHeader = new Node();
            OfflineImageReconstructor.this.loadNodeChildren(fileDiffHeader, "fileDiffEntry fields", new String[]{"fileDiff"});
            Long inodeId = fileDiffHeader.removeChildLong("inodeId");
            if (inodeId == null) {
                throw new IOException("<fileDiffEntry> contained no <inodeid> entry.");
            }
            headerBld.setInodeId(inodeId);
            Integer expectedDiffs = fileDiffHeader.removeChildInt("count");
            if (expectedDiffs == null) {
                throw new IOException("<fileDiffEntry> contained no <count> entry.");
            }
            headerBld.setNumOfDiff(expectedDiffs);
            fileDiffHeader.verifyNoRemainingKeys("fileDiffEntry");
            headerBld.build().writeDelimitedTo((OutputStream)OfflineImageReconstructor.this.out);
            for (int actualDiffs = 0; actualDiffs < expectedDiffs; ++actualDiffs) {
                Node blocks;
                Node snapshotCopy;
                String name;
                Long size;
                try {
                    OfflineImageReconstructor.this.expectTag("fileDiff", false);
                }
                catch (IOException e) {
                    throw new IOException("Only read " + (actualDiffs + 1) + " diffs out of " + expectedDiffs, e);
                }
                Node fileDiff = new Node();
                OfflineImageReconstructor.this.loadNodeChildren(fileDiff, "fileDiff fields", new String[0]);
                FsImageProto.SnapshotDiffSection.FileDiff.Builder bld = FsImageProto.SnapshotDiffSection.FileDiff.newBuilder();
                Integer snapshotId = fileDiff.removeChildInt("snapshotId");
                if (snapshotId != null) {
                    bld.setSnapshotId(snapshotId);
                }
                if ((size = fileDiff.removeChildLong("size")) != null) {
                    bld.setFileSize(size);
                }
                if ((name = fileDiff.removeChildStr("name")) != null) {
                    bld.setName(ByteString.copyFrom((String)name, (String)"UTF8"));
                }
                if ((snapshotCopy = fileDiff.removeChild("snapshotCopy")) != null) {
                    bld.setSnapshotCopy(OfflineImageReconstructor.this.createINodeFileBuilder(snapshotCopy));
                }
                if ((blocks = fileDiff.removeChild("blocks")) != null) {
                    Node block;
                    while ((block = blocks.removeChild("block")) != null) {
                        bld.addBlocks(OfflineImageReconstructor.this.createBlockBuilder(block));
                    }
                }
                fileDiff.verifyNoRemainingKeys("fileDiff");
                bld.build().writeDelimitedTo((OutputStream)OfflineImageReconstructor.this.out);
            }
            OfflineImageReconstructor.this.expectTagEnd("fileDiffEntry");
        }
    }

    private class SnapshotSectionProcessor
    implements SectionProcessor {
        static final String NAME = "SnapshotSection";

        private SnapshotSectionProcessor() {
        }

        @Override
        public void process() throws IOException {
            Node sd;
            FsImageProto.SnapshotSection.Builder bld = FsImageProto.SnapshotSection.newBuilder();
            Node header = new Node();
            OfflineImageReconstructor.this.loadNodeChildren(header, "SnapshotSection fields", new String[]{"snapshot"});
            Integer snapshotCounter = header.removeChildInt("snapshotCounter");
            if (snapshotCounter == null) {
                throw new IOException("No <snapshotCounter> entry found in SnapshotSection header");
            }
            bld.setSnapshotCounter(snapshotCounter);
            Integer expectedNumSnapshots = header.removeChildInt("numSnapshots");
            if (expectedNumSnapshots == null) {
                throw new IOException("No <numSnapshots> entry found in SnapshotSection header");
            }
            bld.setNumSnapshots(expectedNumSnapshots);
            while ((sd = header.removeChild("snapshottableDir")) != null) {
                Long dir = sd.removeChildLong("dir");
                sd.verifyNoRemainingKeys("<dir>");
                bld.addSnapshottableDir(dir);
            }
            header.verifyNoRemainingKeys(NAME);
            bld.build().writeDelimitedTo((OutputStream)OfflineImageReconstructor.this.out);
            for (int actualNumSnapshots = 0; actualNumSnapshots < expectedNumSnapshots; ++actualNumSnapshots) {
                try {
                    OfflineImageReconstructor.this.expectTag("snapshot", false);
                }
                catch (IOException e) {
                    throw new IOException("Only read " + actualNumSnapshots + " <snapshot> entries out of " + expectedNumSnapshots, e);
                }
                Node snapshot = new Node();
                OfflineImageReconstructor.this.loadNodeChildren(snapshot, "snapshot fields", new String[0]);
                FsImageProto.SnapshotSection.Snapshot.Builder s = FsImageProto.SnapshotSection.Snapshot.newBuilder();
                Integer snapshotId = snapshot.removeChildInt("id");
                if (snapshotId == null) {
                    throw new IOException("<snapshot> section was missing <id>");
                }
                s.setSnapshotId(snapshotId);
                Node snapshotRoot = snapshot.removeChild("root");
                FsImageProto.INodeSection.INode.Builder inodeBld = OfflineImageReconstructor.this.processINodeXml(snapshotRoot);
                s.setRoot(inodeBld);
                s.build().writeDelimitedTo((OutputStream)OfflineImageReconstructor.this.out);
            }
            OfflineImageReconstructor.this.expectTagEnd(NAME);
            OfflineImageReconstructor.this.recordSectionLength(FSImageFormatProtobuf.SectionName.SNAPSHOT.name());
        }
    }

    private class FilesUnderConstructionSectionProcessor
    implements SectionProcessor {
        static final String NAME = "FileUnderConstructionSection";

        private FilesUnderConstructionSectionProcessor() {
        }

        @Override
        public void process() throws IOException {
            XMLEvent ev;
            while (!(ev = OfflineImageReconstructor.this.expectTag("inode", true)).isEndElement()) {
                String fullpath;
                Node fileUnderConstruction = new Node();
                OfflineImageReconstructor.this.loadNodeChildren(fileUnderConstruction, "file under construction", new String[0]);
                FsImageProto.FilesUnderConstructionSection.FileUnderConstructionEntry.Builder bld = FsImageProto.FilesUnderConstructionSection.FileUnderConstructionEntry.newBuilder();
                Long id = fileUnderConstruction.removeChildLong("id");
                if (id != null) {
                    bld.setInodeId(id);
                }
                if ((fullpath = fileUnderConstruction.removeChildStr("path")) != null) {
                    bld.setFullPath(fullpath);
                }
                fileUnderConstruction.verifyNoRemainingKeys("inode");
                bld.build().writeDelimitedTo((OutputStream)OfflineImageReconstructor.this.out);
            }
            OfflineImageReconstructor.this.recordSectionLength(FSImageFormatProtobuf.SectionName.FILES_UNDERCONSTRUCTION.name());
        }
    }

    private class INodeDirectorySectionProcessor
    implements SectionProcessor {
        static final String NAME = "INodeDirectorySection";

        private INodeDirectorySectionProcessor() {
        }

        @Override
        public void process() throws IOException {
            XMLEvent ev;
            while (!(ev = OfflineImageReconstructor.this.expectTag("directory", true)).isEndElement()) {
                Node refChild;
                Node child;
                Node directory = new Node();
                FsImageProto.INodeDirectorySection.DirEntry.Builder bld = FsImageProto.INodeDirectorySection.DirEntry.newBuilder();
                OfflineImageReconstructor.this.loadNodeChildren(directory, "directory", new String[0]);
                Long parent = directory.removeChildLong("parent");
                if (parent != null) {
                    bld.setParent(parent);
                }
                while ((child = directory.removeChild("child")) != null) {
                    bld.addChildren(Long.parseLong(child.getVal()));
                }
                while ((refChild = directory.removeChild("refChild")) != null) {
                    bld.addRefChildren(Integer.parseInt(refChild.getVal()));
                }
                directory.verifyNoRemainingKeys("directory");
                bld.build().writeDelimitedTo((OutputStream)OfflineImageReconstructor.this.out);
            }
            OfflineImageReconstructor.this.recordSectionLength(FSImageFormatProtobuf.SectionName.INODE_DIR.name());
        }
    }

    private class INodeReferenceSectionProcessor
    implements SectionProcessor {
        static final String NAME = "INodeReferenceSection";

        private INodeReferenceSectionProcessor() {
        }

        @Override
        public void process() throws IOException {
            XMLEvent ev;
            while (!(ev = OfflineImageReconstructor.this.expectTag("ref", true)).isEndElement()) {
                Integer lastSnapshotId;
                Integer dstSnapshotId;
                String name;
                Node inodeRef = new Node();
                FsImageProto.INodeReferenceSection.INodeReference.Builder bld = FsImageProto.INodeReferenceSection.INodeReference.newBuilder();
                OfflineImageReconstructor.this.loadNodeChildren(inodeRef, "INodeReference", new String[0]);
                Long referredId = inodeRef.removeChildLong("referredId");
                if (referredId != null) {
                    bld.setReferredId(referredId);
                }
                if ((name = inodeRef.removeChildStr("name")) != null) {
                    bld.setName(ByteString.copyFrom((String)name, (String)"UTF8"));
                }
                if ((dstSnapshotId = inodeRef.removeChildInt("dstSnapshotId")) != null) {
                    bld.setDstSnapshotId(dstSnapshotId);
                }
                if ((lastSnapshotId = inodeRef.removeChildInt("lastSnapshotId")) != null) {
                    bld.setLastSnapshotId(lastSnapshotId);
                }
                inodeRef.verifyNoRemainingKeys("ref");
                bld.build().writeDelimitedTo((OutputStream)OfflineImageReconstructor.this.out);
            }
            OfflineImageReconstructor.this.recordSectionLength(FSImageFormatProtobuf.SectionName.INODE_REFERENCE.name());
        }
    }

    private class CacheManagerSectionProcessor
    implements SectionProcessor {
        static final String NAME = "CacheManagerSection";

        private CacheManagerSectionProcessor() {
        }

        @Override
        public void process() throws IOException {
            Node node = new Node();
            OfflineImageReconstructor.this.loadNodeChildren(node, "CacheManager fields", new String[]{"pool", "directive"});
            FsImageProto.CacheManagerSection.Builder b = FsImageProto.CacheManagerSection.newBuilder();
            Long nextDirectiveId = node.removeChildLong("nextDirectiveId");
            if (nextDirectiveId == null) {
                throw new IOException("CacheManager section had no <nextDirectiveId>");
            }
            b.setNextDirectiveId(nextDirectiveId);
            Integer expectedNumPools = node.removeChildInt("numPools");
            if (expectedNumPools == null) {
                throw new IOException("CacheManager section had no <numPools>");
            }
            b.setNumPools(expectedNumPools);
            Integer expectedNumDirectives = node.removeChildInt("numDirectives");
            if (expectedNumDirectives == null) {
                throw new IOException("CacheManager section had no <numDirectives>");
            }
            b.setNumDirectives(expectedNumDirectives);
            b.build().writeDelimitedTo((OutputStream)OfflineImageReconstructor.this.out);
            for (long actualNumPools = 0L; actualNumPools < (long)expectedNumPools.intValue(); ++actualNumPools) {
                try {
                    OfflineImageReconstructor.this.expectTag("pool", false);
                }
                catch (IOException e) {
                    throw new IOException("Only read " + actualNumPools + " cache pools out of " + expectedNumPools, e);
                }
                Node pool = new Node();
                OfflineImageReconstructor.this.loadNodeChildren(pool, "pool fields", new String[]{OfflineImageReconstructor.EMPTY_STRING});
                this.processPoolXml(node);
            }
            for (long actualNumDirectives = 0L; actualNumDirectives < (long)expectedNumDirectives.intValue(); ++actualNumDirectives) {
                try {
                    OfflineImageReconstructor.this.expectTag("directive", false);
                }
                catch (IOException e) {
                    throw new IOException("Only read " + actualNumDirectives + " cache pools out of " + expectedNumDirectives, e);
                }
                Node pool = new Node();
                OfflineImageReconstructor.this.loadNodeChildren(pool, "directive fields", new String[]{OfflineImageReconstructor.EMPTY_STRING});
                this.processDirectiveXml(node);
            }
            OfflineImageReconstructor.this.expectTagEnd(NAME);
            OfflineImageReconstructor.this.recordSectionLength(FSImageFormatProtobuf.SectionName.CACHE_MANAGER.name());
        }

        private void processPoolXml(Node pool) throws IOException {
            ClientNamenodeProtocolProtos.CachePoolInfoProto.Builder bld = ClientNamenodeProtocolProtos.CachePoolInfoProto.newBuilder();
            String poolName = pool.removeChildStr("poolName");
            if (poolName == null) {
                throw new IOException("<pool> found without <poolName>");
            }
            bld.setPoolName(poolName);
            String ownerName = pool.removeChildStr("ownerName");
            if (ownerName == null) {
                throw new IOException("<pool> found without <ownerName>");
            }
            bld.setOwnerName(ownerName);
            String groupName = pool.removeChildStr("groupName");
            if (groupName == null) {
                throw new IOException("<pool> found without <groupName>");
            }
            bld.setGroupName(groupName);
            Integer mode = pool.removeChildInt("mode");
            if (mode == null) {
                throw new IOException("<pool> found without <mode>");
            }
            bld.setMode(mode.intValue());
            Long limit = pool.removeChildLong("limit");
            if (limit == null) {
                throw new IOException("<pool> found without <limit>");
            }
            bld.setLimit(limit.longValue());
            Long maxRelativeExpiry = pool.removeChildLong("maxRelativeExpiry");
            if (maxRelativeExpiry == null) {
                throw new IOException("<pool> found without <maxRelativeExpiry>");
            }
            bld.setMaxRelativeExpiry(maxRelativeExpiry.longValue());
            pool.verifyNoRemainingKeys("pool");
            bld.build().writeDelimitedTo((OutputStream)OfflineImageReconstructor.this.out);
        }

        private void processDirectiveXml(Node directive) throws IOException {
            ClientNamenodeProtocolProtos.CacheDirectiveInfoProto.Builder bld = ClientNamenodeProtocolProtos.CacheDirectiveInfoProto.newBuilder();
            Long id = directive.removeChildLong("id");
            if (id == null) {
                throw new IOException("<directive> found without <id>");
            }
            bld.setId(id.longValue());
            String path = directive.removeChildStr("path");
            if (path == null) {
                throw new IOException("<directive> found without <path>");
            }
            bld.setPath(path);
            Integer replication = directive.removeChildInt("replication");
            if (replication == null) {
                throw new IOException("<directive> found without <replication>");
            }
            bld.setReplication(replication.intValue());
            String pool = directive.removeChildStr("pool");
            if (path == null) {
                throw new IOException("<directive> found without <pool>");
            }
            bld.setPool(pool);
            Node expiration = directive.removeChild("expiration");
            if (expiration != null) {
                ClientNamenodeProtocolProtos.CacheDirectiveInfoExpirationProto.Builder ebld = ClientNamenodeProtocolProtos.CacheDirectiveInfoExpirationProto.newBuilder();
                Long millis = expiration.removeChildLong("millis");
                if (millis == null) {
                    throw new IOException("cache directive <expiration> found without <millis>");
                }
                ebld.setMillis(millis.longValue());
                if (expiration.removeChildBool("relative")) {
                    ebld.setIsRelative(true);
                } else {
                    ebld.setIsRelative(false);
                }
                bld.setExpiration(ebld);
            }
            directive.verifyNoRemainingKeys("directive");
            bld.build().writeDelimitedTo((OutputStream)OfflineImageReconstructor.this.out);
        }
    }

    private class SecretManagerSectionProcessor
    implements SectionProcessor {
        static final String NAME = "SecretManagerSection";

        private SecretManagerSectionProcessor() {
        }

        @Override
        public void process() throws IOException {
            Node secretHeader = new Node();
            OfflineImageReconstructor.this.loadNodeChildren(secretHeader, "SecretManager fields", new String[]{"delegationKey", "token"});
            FsImageProto.SecretManagerSection.Builder b = FsImageProto.SecretManagerSection.newBuilder();
            Integer currentId = secretHeader.removeChildInt("currentId");
            if (currentId == null) {
                throw new IOException("SecretManager section had no <currentId>");
            }
            b.setCurrentId(currentId);
            Integer tokenSequenceNumber = secretHeader.removeChildInt("tokenSequenceNumber");
            if (tokenSequenceNumber == null) {
                throw new IOException("SecretManager section had no <tokenSequenceNumber>");
            }
            b.setTokenSequenceNumber(tokenSequenceNumber);
            Integer expectedNumKeys = secretHeader.removeChildInt("numDelegationKeys");
            if (expectedNumKeys == null) {
                throw new IOException("SecretManager section had no <numDelegationKeys>");
            }
            b.setNumKeys(expectedNumKeys);
            Integer expectedNumTokens = secretHeader.removeChildInt("numTokens");
            if (expectedNumTokens == null) {
                throw new IOException("SecretManager section had no <numTokens>");
            }
            b.setNumTokens(expectedNumTokens);
            secretHeader.verifyNoRemainingKeys("SecretManager");
            b.build().writeDelimitedTo((OutputStream)OfflineImageReconstructor.this.out);
            for (int actualNumKeys = 0; actualNumKeys < expectedNumKeys; ++actualNumKeys) {
                try {
                    OfflineImageReconstructor.this.expectTag("delegationKey", false);
                }
                catch (IOException e) {
                    throw new IOException("Only read " + actualNumKeys + " delegation keys out of " + expectedNumKeys, e);
                }
                FsImageProto.SecretManagerSection.DelegationKey.Builder dbld = FsImageProto.SecretManagerSection.DelegationKey.newBuilder();
                Node dkey = new Node();
                OfflineImageReconstructor.this.loadNodeChildren(dkey, "Delegation key fields", new String[0]);
                Integer id = dkey.removeChildInt("id");
                if (id == null) {
                    throw new IOException("Delegation key stanza <delegationKey> lacked an <id> field.");
                }
                dbld.setId(id);
                String expiry = dkey.removeChildStr("expiry");
                if (expiry == null) {
                    throw new IOException("Delegation key stanza <delegationKey> lacked an <expiry> field.");
                }
                dbld.setExpiryDate(this.dateStrToLong(expiry));
                String keyHex = dkey.removeChildStr("key");
                if (keyHex == null) {
                    throw new IOException("Delegation key stanza <delegationKey> lacked a <key> field.");
                }
                byte[] key = new HexBinaryAdapter().unmarshal(keyHex);
                dkey.verifyNoRemainingKeys("delegationKey");
                dbld.setKey(ByteString.copyFrom((byte[])key));
                dbld.build().writeDelimitedTo((OutputStream)OfflineImageReconstructor.this.out);
            }
            for (int actualNumTokens = 0; actualNumTokens < expectedNumTokens; ++actualNumTokens) {
                String expiryDateStr;
                Integer masterKeyId;
                Integer seqNo;
                String maxDateStr;
                String issueDateStr;
                String realUser;
                String renewer;
                String owner;
                try {
                    OfflineImageReconstructor.this.expectTag("token", false);
                }
                catch (IOException e) {
                    throw new IOException("Only read " + actualNumTokens + " tokens out of " + expectedNumTokens, e);
                }
                FsImageProto.SecretManagerSection.PersistToken.Builder tbld = FsImageProto.SecretManagerSection.PersistToken.newBuilder();
                Node token = new Node();
                OfflineImageReconstructor.this.loadNodeChildren(token, "PersistToken key fields", new String[0]);
                Integer version = token.removeChildInt("version");
                if (version != null) {
                    tbld.setVersion(version);
                }
                if ((owner = token.removeChildStr("owner")) != null) {
                    tbld.setOwner(owner);
                }
                if ((renewer = token.removeChildStr("renewer")) != null) {
                    tbld.setRenewer(renewer);
                }
                if ((realUser = token.removeChildStr("realUser")) != null) {
                    tbld.setRealUser(realUser);
                }
                if ((issueDateStr = token.removeChildStr("issueDate")) != null) {
                    tbld.setIssueDate(this.dateStrToLong(issueDateStr));
                }
                if ((maxDateStr = token.removeChildStr("maxDate")) != null) {
                    tbld.setMaxDate(this.dateStrToLong(maxDateStr));
                }
                if ((seqNo = token.removeChildInt("sequenceNumber")) != null) {
                    tbld.setSequenceNumber(seqNo);
                }
                if ((masterKeyId = token.removeChildInt("masterKeyId")) != null) {
                    tbld.setMasterKeyId(masterKeyId);
                }
                if ((expiryDateStr = token.removeChildStr("expiryDate")) != null) {
                    tbld.setExpiryDate(this.dateStrToLong(expiryDateStr));
                }
                token.verifyNoRemainingKeys("token");
                tbld.build().writeDelimitedTo((OutputStream)OfflineImageReconstructor.this.out);
            }
            OfflineImageReconstructor.this.expectTagEnd(NAME);
            OfflineImageReconstructor.this.recordSectionLength(FSImageFormatProtobuf.SectionName.SECRET_MANAGER.name());
        }

        private long dateStrToLong(String dateStr) throws IOException {
            try {
                Date date = OfflineImageReconstructor.this.isoDateFormat.parse(dateStr);
                return date.getTime();
            }
            catch (ParseException e) {
                throw new IOException("Failed to parse ISO date string " + dateStr, e);
            }
        }
    }

    private class INodeSectionProcessor
    implements SectionProcessor {
        static final String NAME = "INodeSection";

        private INodeSectionProcessor() {
        }

        @Override
        public void process() throws IOException {
            Integer expectedNumINodes;
            Node headerNode = new Node();
            OfflineImageReconstructor.this.loadNodeChildren(headerNode, "INodeSection fields", new String[]{"inode"});
            FsImageProto.INodeSection.Builder b = FsImageProto.INodeSection.newBuilder();
            Long lval = headerNode.removeChildLong("lastInodeId");
            if (lval != null) {
                b.setLastInodeId(lval);
            }
            if ((expectedNumINodes = headerNode.removeChildInt("numInodes")) == null) {
                throw new IOException("Failed to find <numInodes> in INodeSection.");
            }
            b.setNumInodes(expectedNumINodes.intValue());
            FsImageProto.INodeSection s = b.build();
            s.writeDelimitedTo((OutputStream)OfflineImageReconstructor.this.out);
            headerNode.verifyNoRemainingKeys(NAME);
            for (int actualNumINodes = 0; actualNumINodes < expectedNumINodes; ++actualNumINodes) {
                try {
                    OfflineImageReconstructor.this.expectTag("inode", false);
                }
                catch (IOException e) {
                    throw new IOException("Only found " + actualNumINodes + " <inode> entries out of " + expectedNumINodes, e);
                }
                Node inode = new Node();
                OfflineImageReconstructor.this.loadNodeChildren(inode, "INode fields", new String[0]);
                FsImageProto.INodeSection.INode.Builder inodeBld = OfflineImageReconstructor.this.processINodeXml(inode);
                inodeBld.build().writeDelimitedTo((OutputStream)OfflineImageReconstructor.this.out);
            }
            OfflineImageReconstructor.this.expectTagEnd(NAME);
            OfflineImageReconstructor.this.recordSectionLength(FSImageFormatProtobuf.SectionName.INODE.name());
        }
    }

    private class NameSectionProcessor
    implements SectionProcessor {
        static final String NAME = "NameSection";

        private NameSectionProcessor() {
        }

        @Override
        public void process() throws IOException {
            Node node = new Node();
            OfflineImageReconstructor.this.loadNodeChildren(node, "NameSection fields", new String[0]);
            FsImageProto.NameSystemSection.Builder b = FsImageProto.NameSystemSection.newBuilder();
            Integer namespaceId = node.removeChildInt("namespaceId");
            if (namespaceId == null) {
                throw new IOException("<NameSection> is missing <namespaceId>");
            }
            b.setNamespaceId(namespaceId);
            Long lval = node.removeChildLong("genstampV1");
            if (lval != null) {
                b.setGenstampV1(lval);
            }
            if ((lval = node.removeChildLong("genstampV2")) != null) {
                b.setGenstampV2(lval);
            }
            if ((lval = node.removeChildLong("genstampV1Limit")) != null) {
                b.setGenstampV1Limit(lval);
            }
            if ((lval = node.removeChildLong("lastAllocatedBlockId")) != null) {
                b.setLastAllocatedBlockId(lval);
            }
            if ((lval = node.removeChildLong("txid")) != null) {
                b.setTransactionId(lval);
            }
            if ((lval = node.removeChildLong("rollingUpgradeStartTime")) != null) {
                b.setRollingUpgradeStartTime(lval);
            }
            if ((lval = node.removeChildLong("lastAllocatedStripedBlockId")) != null) {
                throw new IOException("can't handle lastAllocatedStripedBlockId in NameSection; XML file is too new.\n");
            }
            node.verifyNoRemainingKeys(NAME);
            FsImageProto.NameSystemSection s = b.build();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(FSImageFormatProtobuf.SectionName.NS_INFO.name() + " writing header: {" + TextFormat.printToString((MessageOrBuilder)s) + "}"));
            }
            s.writeDelimitedTo((OutputStream)OfflineImageReconstructor.this.out);
            OfflineImageReconstructor.this.recordSectionLength(FSImageFormatProtobuf.SectionName.NS_INFO.name());
        }
    }

    private static interface SectionProcessor {
        public void process() throws IOException;
    }

    private static class Node {
        private static final String EMPTY = "";
        HashMap<String, LinkedList<Node>> children;
        String val = "";

        private Node() {
        }

        void addChild(String key, Node node) {
            LinkedList<Node> cur;
            if (this.children == null) {
                this.children = new HashMap();
            }
            if ((cur = this.children.get(key)) == null) {
                cur = new LinkedList();
                this.children.put(key, cur);
            }
            cur.add(node);
        }

        Node removeChild(String key) {
            if (this.children == null) {
                return null;
            }
            LinkedList<Node> cur = this.children.get(key);
            if (cur == null) {
                return null;
            }
            Node node = cur.remove();
            if (node == null || cur.isEmpty()) {
                this.children.remove(key);
            }
            return node;
        }

        String removeChildStr(String key) {
            Node child = this.removeChild(key);
            if (child == null) {
                return null;
            }
            if (child.children != null && !child.children.isEmpty()) {
                throw new RuntimeException("Node " + key + " contains children of its own.");
            }
            return child.getVal();
        }

        Integer removeChildInt(String key) throws IOException {
            String str = this.removeChildStr(key);
            if (str == null) {
                return null;
            }
            return Integer.valueOf(str);
        }

        Long removeChildLong(String key) throws IOException {
            String str = this.removeChildStr(key);
            if (str == null) {
                return null;
            }
            return Long.valueOf(str);
        }

        boolean removeChildBool(String key) throws IOException {
            String str = this.removeChildStr(key);
            return str != null;
        }

        String getRemainingKeyNames() {
            if (this.children == null) {
                return "";
            }
            return StringUtils.join((CharSequence)", ", this.children.keySet());
        }

        void verifyNoRemainingKeys(String sectionName) throws IOException {
            String remainingKeyNames = this.getRemainingKeyNames();
            if (!remainingKeyNames.isEmpty()) {
                throw new IOException("Found unknown XML keys in " + sectionName + ": " + remainingKeyNames);
            }
        }

        void setVal(String val) {
            this.val = val;
        }

        String getVal() {
            return this.val;
        }

        String dump() {
            StringBuilder bld = new StringBuilder();
            if (this.children != null && !this.children.isEmpty()) {
                bld.append("{");
            }
            if (this.val != null) {
                bld.append("[").append(this.val).append("]");
            }
            if (this.children != null && !this.children.isEmpty()) {
                String prefix = "";
                for (Map.Entry<String, LinkedList<Node>> entry : this.children.entrySet()) {
                    for (Node n : entry.getValue()) {
                        bld.append(prefix);
                        bld.append(entry.getKey()).append(": ");
                        bld.append(n.dump());
                        prefix = ", ";
                    }
                }
                bld.append("}");
            }
            return bld.toString();
        }
    }
}

