/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.AppendTestUtil;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.log4j.Level;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;

public class TestFileAppend2 {
    static final int numBlocks = 5;
    private byte[] fileContents;
    final int numDatanodes = 6;
    final int numberOfFiles = 50;
    final int numThreads = 10;
    final int numAppendsPerThread = 20;
    Workload[] workload;
    final ArrayList<Path> testFiles;
    static volatile boolean globalStatus = true;

    public TestFileAppend2() {
        DFSTestUtil.setNameNodeLogLevel(Level.ALL);
        GenericTestUtils.setLogLevel((Logger)DataNode.LOG, (Level)Level.ALL);
        GenericTestUtils.setLogLevel((Logger)DFSClient.LOG, (Level)Level.ALL);
        this.fileContents = null;
        this.numDatanodes = 6;
        this.numberOfFiles = 50;
        this.numThreads = 10;
        this.numAppendsPerThread = 20;
        this.workload = null;
        this.testFiles = new ArrayList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSimpleAppend() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setInt("dfs.datanode.handler.count", 50);
        this.fileContents = AppendTestUtil.initBuffer(10241);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).build();
        DistributedFileSystem fs = cluster.getFileSystem();
        try {
            int len;
            Path file1 = new Path("/simpleAppend.dat");
            FSDataOutputStream stm = AppendTestUtil.createFile((FileSystem)fs, file1, 1);
            System.out.println("Created file simpleAppend.dat");
            int mid = 186;
            System.out.println("Writing " + mid + " bytes to file " + file1);
            stm.write(this.fileContents, 0, mid);
            stm.close();
            System.out.println("Wrote and Closed first part of file.");
            int mid2 = 607;
            System.out.println("Writing " + mid + " bytes to file " + file1);
            stm = fs.append(file1);
            stm.write(this.fileContents, mid, mid2 - mid);
            stm.close();
            System.out.println("Wrote and Closed second part of file.");
            stm = fs.append(file1);
            Assert.assertTrue((stm.getPos() > 0L ? 1 : 0) != 0);
            System.out.println("Writing " + (10241 - mid2) + " bytes to file " + file1);
            stm.write(this.fileContents, mid2, 10241 - mid2);
            System.out.println("Written second part of file");
            stm.close();
            System.out.println("Wrote and Closed second part of file.");
            AppendTestUtil.checkFullFile((FileSystem)fs, file1, 10241, this.fileContents, "Read 2");
            FSDataOutputStream out = null;
            try {
                out = fs.append(new Path("/non-existing.dat"));
                Assert.fail((String)"Expected to have FileNotFoundException");
            }
            catch (FileNotFoundException fnfe) {
                try {
                    System.out.println("Good: got " + fnfe);
                    fnfe.printStackTrace(System.out);
                }
                catch (Throwable throwable) {
                    IOUtils.closeStream(out);
                    throw throwable;
                }
                IOUtils.closeStream((Closeable)out);
            }
            IOUtils.closeStream((Closeable)out);
            Path root = new Path("/");
            fs.setPermission(root, new FsPermission(511));
            fs.close();
            UserGroupInformation superuser = UserGroupInformation.getCurrentUser();
            String username = "testappenduser";
            String group = "testappendgroup";
            Assert.assertFalse((boolean)superuser.getShortUserName().equals(username));
            Assert.assertFalse((boolean)Arrays.asList(superuser.getGroupNames()).contains(group));
            UserGroupInformation appenduser = UserGroupInformation.createUserForTesting((String)username, (String[])new String[]{group});
            fs = DFSTestUtil.getFileSystemAs(appenduser, (Configuration)conf);
            Path dir = new Path(root, this.getClass().getSimpleName());
            Path foo = new Path(dir, "foo.dat");
            FSDataOutputStream out2 = null;
            int offset = 0;
            try {
                out2 = fs.create(foo);
                len = 10 + AppendTestUtil.nextInt(100);
                out2.write(this.fileContents, offset, len);
                offset += len;
            }
            finally {
                IOUtils.closeStream((Closeable)out2);
            }
            fs.setPermission(dir, new FsPermission(64));
            fs.setPermission(foo, new FsPermission(128));
            out2 = null;
            try {
                out2 = fs.append(foo);
                len = 10 + AppendTestUtil.nextInt(100);
                out2.write(this.fileContents, offset, len);
                offset += len;
            }
            finally {
                IOUtils.closeStream((Closeable)out2);
            }
            fs.setPermission(foo, new FsPermission(383));
            fs.setPermission(dir, new FsPermission(511));
            out2 = null;
            try {
                out2 = fs.append(foo);
                Assert.fail((String)"Expected to have AccessControlException");
            }
            catch (AccessControlException ace) {
                System.out.println("Good: got " + (Object)((Object)ace));
                ace.printStackTrace(System.out);
            }
            finally {
                IOUtils.closeStream((Closeable)out2);
            }
        }
        catch (IOException e) {
            System.out.println("Exception :" + e);
            throw e;
        }
        catch (Throwable e) {
            System.out.println("Throwable :" + e);
            e.printStackTrace();
            throw new IOException("Throwable : " + e);
        }
        finally {
            fs.close();
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSimpleAppend2() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setInt("dfs.datanode.handler.count", 50);
        this.fileContents = AppendTestUtil.initBuffer(10241);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).build();
        DistributedFileSystem fs = cluster.getFileSystem();
        try {
            int len;
            Path file1 = new Path("/simpleAppend.dat");
            FSDataOutputStream stm = AppendTestUtil.createFile((FileSystem)fs, file1, 1);
            System.out.println("Created file simpleAppend.dat");
            int mid = 186;
            System.out.println("Writing " + mid + " bytes to file " + file1);
            stm.write(this.fileContents, 0, mid);
            stm.close();
            System.out.println("Wrote and Closed first part of file.");
            int mid2 = 607;
            System.out.println("Writing " + mid + " bytes to file " + file1);
            stm = fs.append(file1, EnumSet.of(CreateFlag.APPEND, CreateFlag.NEW_BLOCK), 4096, null);
            stm.write(this.fileContents, mid, mid2 - mid);
            stm.close();
            System.out.println("Wrote and Closed second part of file.");
            stm = fs.append(file1, EnumSet.of(CreateFlag.APPEND, CreateFlag.NEW_BLOCK), 4096, null);
            Assert.assertTrue((stm.getPos() > 0L ? 1 : 0) != 0);
            System.out.println("Writing " + (10241 - mid2) + " bytes to file " + file1);
            stm.write(this.fileContents, mid2, 10241 - mid2);
            System.out.println("Written second part of file");
            stm.close();
            System.out.println("Wrote and Closed second part of file.");
            AppendTestUtil.checkFullFile((FileSystem)fs, file1, 10241, this.fileContents, "Read 2");
            List blocks = fs.getClient().getLocatedBlocks(file1.toString(), 0L).getLocatedBlocks();
            Assert.assertEquals((long)12L, (long)blocks.size());
            Assert.assertEquals((long)mid, (long)((LocatedBlock)blocks.get(0)).getBlockSize());
            Assert.assertEquals((long)(mid2 - mid), (long)((LocatedBlock)blocks.get(1)).getBlockSize());
            for (int i = 2; i < 11; ++i) {
                Assert.assertEquals((long)1024L, (long)((LocatedBlock)blocks.get(i)).getBlockSize());
            }
            Assert.assertEquals((long)((10241 - mid2) % 1024), (long)((LocatedBlock)blocks.get(11)).getBlockSize());
            FSDataOutputStream out = null;
            try {
                out = fs.append(new Path("/non-existing.dat"), EnumSet.of(CreateFlag.APPEND, CreateFlag.NEW_BLOCK), 4096, null);
                Assert.fail((String)"Expected to have FileNotFoundException");
            }
            catch (FileNotFoundException fnfe) {
                try {
                    System.out.println("Good: got " + fnfe);
                    fnfe.printStackTrace(System.out);
                }
                catch (Throwable throwable) {
                    IOUtils.closeStream(out);
                    throw throwable;
                }
                IOUtils.closeStream((Closeable)out);
            }
            IOUtils.closeStream((Closeable)out);
            Path root = new Path("/");
            fs.setPermission(root, new FsPermission(511));
            fs.close();
            UserGroupInformation superuser = UserGroupInformation.getCurrentUser();
            String username = "testappenduser";
            String group = "testappendgroup";
            Assert.assertFalse((boolean)superuser.getShortUserName().equals(username));
            Assert.assertFalse((boolean)Arrays.asList(superuser.getGroupNames()).contains(group));
            UserGroupInformation appenduser = UserGroupInformation.createUserForTesting((String)username, (String[])new String[]{group});
            fs = (DistributedFileSystem)DFSTestUtil.getFileSystemAs(appenduser, (Configuration)conf);
            Path dir = new Path(root, this.getClass().getSimpleName());
            Path foo = new Path(dir, "foo.dat");
            FSDataOutputStream out2 = null;
            int offset = 0;
            try {
                out2 = fs.create(foo);
                len = 10 + AppendTestUtil.nextInt(100);
                out2.write(this.fileContents, offset, len);
                offset += len;
            }
            finally {
                IOUtils.closeStream((Closeable)out2);
            }
            fs.setPermission(dir, new FsPermission(64));
            fs.setPermission(foo, new FsPermission(128));
            out2 = null;
            try {
                out2 = fs.append(foo, EnumSet.of(CreateFlag.APPEND, CreateFlag.NEW_BLOCK), 4096, null);
                len = 10 + AppendTestUtil.nextInt(100);
                out2.write(this.fileContents, offset, len);
                offset += len;
            }
            finally {
                IOUtils.closeStream((Closeable)out2);
            }
            fs.setPermission(foo, new FsPermission(383));
            fs.setPermission(dir, new FsPermission(511));
            out2 = null;
            try {
                out2 = fs.append(foo, EnumSet.of(CreateFlag.APPEND, CreateFlag.NEW_BLOCK), 4096, null);
                Assert.fail((String)"Expected to have AccessControlException");
            }
            catch (AccessControlException ace) {
                System.out.println("Good: got " + (Object)((Object)ace));
                ace.printStackTrace(System.out);
            }
            finally {
                IOUtils.closeStream((Closeable)out2);
            }
        }
        finally {
            fs.close();
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testComplexAppend(boolean appendToNewBlock) throws IOException {
        this.fileContents = AppendTestUtil.initBuffer(10241);
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setInt("dfs.namenode.heartbeat.recheck-interval", 2000);
        conf.setInt("dfs.heartbeat.interval", 2);
        conf.setInt("dfs.namenode.reconstruction.pending.timeout-sec", 2);
        conf.setInt("dfs.client.socket-timeout", 30000);
        conf.setInt("dfs.datanode.socket.write.timeout", 30000);
        conf.setInt("dfs.datanode.handler.count", 50);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(6).build();
        cluster.waitActive();
        DistributedFileSystem fs = cluster.getFileSystem();
        try {
            int i;
            for (i = 0; i < 50; ++i) {
                int replication = AppendTestUtil.nextInt(4) + 1;
                Path testFile = new Path("/" + i + ".dat");
                FSDataOutputStream stm = AppendTestUtil.createFile((FileSystem)fs, testFile, replication);
                stm.close();
                this.testFiles.add(testFile);
            }
            this.workload = new Workload[10];
            for (i = 0; i < 10; ++i) {
                this.workload[i] = new Workload(cluster, i, appendToNewBlock);
                this.workload[i].start();
            }
            for (i = 0; i < 10; ++i) {
                try {
                    System.out.println("Waiting for thread " + i + " to complete...");
                    this.workload[i].join();
                    System.out.println("Waiting for thread " + i + " complete.");
                    continue;
                }
                catch (InterruptedException e) {
                    --i;
                }
            }
        }
        finally {
            fs.close();
            cluster.shutdown();
        }
        Assert.assertTrue((String)"testComplexAppend Worker encountered exceptions.", (boolean)globalStatus);
    }

    @Test
    public void testComplexAppend() throws IOException {
        this.testComplexAppend(false);
    }

    @Test
    public void testComplexAppend2() throws IOException {
        this.testComplexAppend(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAppendLessThanChecksumChunk() throws Exception {
        byte[] buf = new byte[1024];
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)new HdfsConfiguration()).numDataNodes(1).build();
        cluster.waitActive();
        try (DistributedFileSystem fs = cluster.getFileSystem();){
            int len1 = 200;
            int len2 = 300;
            Path p = new Path("/foo");
            FSDataOutputStream out = fs.create(p);
            out.write(buf, 0, 200);
            out.close();
            out = fs.append(p);
            out.write(buf, 0, 300);
            out.hflush();
            FSDataInputStream in = fs.open(p);
            int length = in.read(0L, buf, 0, 500);
            Assert.assertTrue((length > 0 ? 1 : 0) != 0);
            in.close();
            out.close();
        }
        finally {
            cluster.shutdown();
        }
    }

    class Workload
    extends Thread {
        private final int id;
        private final MiniDFSCluster cluster;
        private final boolean appendToNewBlock;

        Workload(MiniDFSCluster cluster, int threadIndex, boolean append2) {
            this.id = threadIndex;
            this.cluster = cluster;
            this.appendToNewBlock = append2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            System.out.println("Workload " + this.id + " starting... ");
            for (int i = 0; i < 20; ++i) {
                Path testfile;
                ArrayList<Path> arrayList = TestFileAppend2.this.testFiles;
                synchronized (arrayList) {
                    if (TestFileAppend2.this.testFiles.size() == 0) {
                        System.out.println("Completed write to almost all files.");
                        return;
                    }
                    int index = AppendTestUtil.nextInt(TestFileAppend2.this.testFiles.size());
                    testfile = TestFileAppend2.this.testFiles.remove(index);
                }
                long len = 0L;
                int sizeToAppend = 0;
                try {
                    DistributedFileSystem fs = this.cluster.getFileSystem();
                    len = fs.getFileStatus(testfile).getLen();
                    if (len >= 10241L) {
                        System.out.println("File " + testfile + " is full.");
                        continue;
                    }
                    int left = (int)(10241L - len) / 3;
                    if (left <= 0) {
                        left = 1;
                    }
                    sizeToAppend = AppendTestUtil.nextInt(left);
                    System.out.println("Workload thread " + this.id + " appending " + sizeToAppend + " bytes  to file " + testfile + " of size " + len);
                    FSDataOutputStream stm = this.appendToNewBlock ? fs.append(testfile, EnumSet.of(CreateFlag.APPEND, CreateFlag.NEW_BLOCK), 4096, null) : fs.append(testfile);
                    stm.write(TestFileAppend2.this.fileContents, (int)len, sizeToAppend);
                    stm.close();
                    while (fs.getFileStatus(testfile).getLen() != len + (long)sizeToAppend) {
                        try {
                            System.out.println("Workload thread " + this.id + " file " + testfile + " size " + fs.getFileStatus(testfile).getLen() + " expected size " + (len + (long)sizeToAppend) + " waiting for namenode metadata update.");
                            Thread.sleep(5000L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    Assert.assertTrue((String)("File " + testfile + " size is " + fs.getFileStatus(testfile).getLen() + " but expected " + (len + (long)sizeToAppend)), (fs.getFileStatus(testfile).getLen() == len + (long)sizeToAppend ? 1 : 0) != 0);
                    AppendTestUtil.checkFullFile((FileSystem)fs, testfile, (int)(len + (long)sizeToAppend), TestFileAppend2.this.fileContents, "Read 2");
                }
                catch (Throwable e) {
                    globalStatus = false;
                    if (e.toString() != null) {
                        System.out.println("Workload exception " + this.id + " testfile " + testfile + " " + e);
                        e.printStackTrace();
                    }
                    Assert.assertTrue((String)("Workload exception " + this.id + " testfile " + testfile + " expected size " + (len + (long)sizeToAppend)), (boolean)false);
                }
                ArrayList<Path> arrayList2 = TestFileAppend2.this.testFiles;
                synchronized (arrayList2) {
                    TestFileAppend2.this.testFiles.add(testfile);
                    continue;
                }
            }
        }
    }
}

