/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.security.token.block;

import com.google.protobuf.BlockingService;
import com.google.protobuf.RpcController;
import com.google.protobuf.ServiceException;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.GregorianCalendar;
import java.util.Set;
import javax.net.SocketFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DFSUtilClient;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.ClientDatanodeProtocol;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.protocol.proto.ClientDatanodeProtocolProtos;
import org.apache.hadoop.hdfs.protocol.proto.HdfsProtos;
import org.apache.hadoop.hdfs.protocolPB.ClientDatanodeProtocolPB;
import org.apache.hadoop.hdfs.protocolPB.PBHelperClient;
import org.apache.hadoop.hdfs.security.token.block.BlockPoolTokenSecretManager;
import org.apache.hadoop.hdfs.security.token.block.BlockTokenIdentifier;
import org.apache.hadoop.hdfs.security.token.block.BlockTokenSecretManager;
import org.apache.hadoop.hdfs.security.token.block.ExportedBlockKeys;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.TestWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.ipc.Client;
import org.apache.hadoop.ipc.ProtobufRpcEngine;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.SaslInputStream;
import org.apache.hadoop.security.SaslRpcClient;
import org.apache.hadoop.security.SaslRpcServer;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.util.Time;
import org.apache.log4j.Level;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestBlockToken {
    public static final Logger LOG = LoggerFactory.getLogger(TestBlockToken.class);
    private static final String ADDRESS = "0.0.0.0";
    static final File FD_DIR;
    final long blockKeyUpdateInterval = 600000L;
    final long blockTokenLifetime = 120000L;
    final ExtendedBlock block1 = new ExtendedBlock("0", 0L);
    final ExtendedBlock block2 = new ExtendedBlock("10", 10L);
    final ExtendedBlock block3 = new ExtendedBlock("-10", -108L);

    @Before
    public void disableKerberos() {
        Configuration conf = new Configuration();
        conf.set("hadoop.security.authentication", "simple");
        UserGroupInformation.setConfiguration((Configuration)conf);
    }

    private BlockTokenIdentifier generateTokenId(BlockTokenSecretManager sm, ExtendedBlock block, EnumSet<BlockTokenIdentifier.AccessMode> accessModes, StorageType[] storageTypes, String[] storageIds) throws IOException {
        Token token = sm.generateToken(block, accessModes, storageTypes, storageIds);
        BlockTokenIdentifier id = sm.createIdentifier();
        id.readFields((DataInput)new DataInputStream(new ByteArrayInputStream(token.getIdentifier())));
        return id;
    }

    private void testWritable(boolean enableProtobuf) throws Exception {
        TestWritable.testWritable((Writable)new BlockTokenIdentifier());
        BlockTokenSecretManager sm = new BlockTokenSecretManager(600000L, 120000L, 0, 1, "fake-pool", null, enableProtobuf);
        TestWritable.testWritable((Writable)this.generateTokenId(sm, this.block3, EnumSet.noneOf(BlockTokenIdentifier.AccessMode.class), new StorageType[]{StorageType.DEFAULT}, null));
        TestWritable.testWritable((Writable)this.generateTokenId(sm, this.block3, EnumSet.of(BlockTokenIdentifier.AccessMode.WRITE), new StorageType[]{StorageType.DEFAULT}, null));
        TestWritable.testWritable((Writable)this.generateTokenId(sm, this.block3, EnumSet.allOf(BlockTokenIdentifier.AccessMode.class), new StorageType[]{StorageType.DEFAULT}, null));
        TestWritable.testWritable((Writable)this.generateTokenId(sm, this.block1, EnumSet.allOf(BlockTokenIdentifier.AccessMode.class), new StorageType[]{StorageType.DEFAULT}, null));
        TestWritable.testWritable((Writable)this.generateTokenId(sm, this.block2, EnumSet.of(BlockTokenIdentifier.AccessMode.WRITE), new StorageType[]{StorageType.DEFAULT}, null));
        TestWritable.testWritable((Writable)this.generateTokenId(sm, this.block3, EnumSet.noneOf(BlockTokenIdentifier.AccessMode.class), new StorageType[]{StorageType.DEFAULT}, null));
        TestWritable.testWritable((Writable)this.generateTokenId(sm, this.block3, EnumSet.noneOf(BlockTokenIdentifier.AccessMode.class), null, null));
        TestWritable.testWritable((Writable)this.generateTokenId(sm, this.block3, EnumSet.noneOf(BlockTokenIdentifier.AccessMode.class), StorageType.EMPTY_ARRAY, null));
    }

    @Test
    public void testWritableLegacy() throws Exception {
        this.testWritable(false);
    }

    @Test
    public void testWritableProtobuf() throws Exception {
        this.testWritable(true);
    }

    private static void checkAccess(BlockTokenSecretManager m, Token<BlockTokenIdentifier> t, ExtendedBlock blk, BlockTokenIdentifier.AccessMode mode, StorageType[] storageTypes, String[] storageIds) throws IOException {
        if (storageIds == null) {
            m.checkAccess((BlockTokenIdentifier)t.decodeIdentifier(), null, blk, mode, storageTypes);
        }
        m.checkAccess(t, null, blk, mode, storageTypes, storageIds);
    }

    private void tokenGenerationAndVerification(BlockTokenSecretManager master, BlockTokenSecretManager slave, StorageType[] storageTypes, String[] storageIds) throws Exception {
        for (BlockTokenIdentifier.AccessMode mode : BlockTokenIdentifier.AccessMode.values()) {
            Token token1 = master.generateToken(this.block1, EnumSet.of(mode), storageTypes, storageIds);
            TestBlockToken.checkAccess(master, (Token<BlockTokenIdentifier>)token1, this.block1, mode, storageTypes, storageIds);
            TestBlockToken.checkAccess(slave, (Token<BlockTokenIdentifier>)token1, this.block1, mode, storageTypes, storageIds);
            Token token2 = slave.generateToken(this.block2, EnumSet.of(mode), storageTypes, storageIds);
            TestBlockToken.checkAccess(master, (Token<BlockTokenIdentifier>)token2, this.block2, mode, storageTypes, storageIds);
            TestBlockToken.checkAccess(slave, (Token<BlockTokenIdentifier>)token2, this.block2, mode, storageTypes, storageIds);
        }
        Token mtoken = master.generateToken(this.block3, EnumSet.allOf(BlockTokenIdentifier.AccessMode.class), storageTypes, storageIds);
        for (BlockTokenIdentifier.AccessMode mode : BlockTokenIdentifier.AccessMode.values()) {
            TestBlockToken.checkAccess(master, (Token<BlockTokenIdentifier>)mtoken, this.block3, mode, storageTypes, storageIds);
            TestBlockToken.checkAccess(slave, (Token<BlockTokenIdentifier>)mtoken, this.block3, mode, storageTypes, storageIds);
        }
    }

    private void testBlockTokenSecretManager(boolean enableProtobuf) throws Exception {
        BlockTokenSecretManager masterHandler = new BlockTokenSecretManager(600000L, 120000L, 0, 1, "fake-pool", null, enableProtobuf);
        BlockTokenSecretManager slaveHandler = new BlockTokenSecretManager(600000L, 120000L, "fake-pool", null, enableProtobuf);
        ExportedBlockKeys keys = masterHandler.exportKeys();
        slaveHandler.addKeys(keys);
        this.tokenGenerationAndVerification(masterHandler, slaveHandler, new StorageType[]{StorageType.DEFAULT}, null);
        this.tokenGenerationAndVerification(masterHandler, slaveHandler, null, null);
        masterHandler.updateKeys();
        this.tokenGenerationAndVerification(masterHandler, slaveHandler, new StorageType[]{StorageType.DEFAULT}, null);
        this.tokenGenerationAndVerification(masterHandler, slaveHandler, null, null);
        keys = masterHandler.exportKeys();
        slaveHandler.addKeys(keys);
        this.tokenGenerationAndVerification(masterHandler, slaveHandler, new StorageType[]{StorageType.DEFAULT}, null);
        this.tokenGenerationAndVerification(masterHandler, slaveHandler, null, null);
    }

    @Test
    public void testBlockTokenSecretManagerLegacy() throws Exception {
        this.testBlockTokenSecretManager(false);
    }

    @Test
    public void testBlockTokenSecretManagerProtobuf() throws Exception {
        this.testBlockTokenSecretManager(true);
    }

    private static Server createMockDatanode(BlockTokenSecretManager sm, Token<BlockTokenIdentifier> token, Configuration conf) throws IOException, ServiceException {
        ClientDatanodeProtocolPB mockDN = (ClientDatanodeProtocolPB)Mockito.mock(ClientDatanodeProtocolPB.class);
        BlockTokenIdentifier id = sm.createIdentifier();
        id.readFields((DataInput)new DataInputStream(new ByteArrayInputStream(token.getIdentifier())));
        ((ClientDatanodeProtocolPB)Mockito.doAnswer((Answer)new GetLengthAnswer(sm, id)).when((Object)mockDN)).getReplicaVisibleLength((RpcController)Matchers.any(RpcController.class), (ClientDatanodeProtocolProtos.GetReplicaVisibleLengthRequestProto)Matchers.any(ClientDatanodeProtocolProtos.GetReplicaVisibleLengthRequestProto.class));
        RPC.setProtocolEngine((Configuration)conf, ClientDatanodeProtocolPB.class, ProtobufRpcEngine.class);
        BlockingService service = ClientDatanodeProtocolProtos.ClientDatanodeProtocolService.newReflectiveBlockingService((ClientDatanodeProtocolProtos.ClientDatanodeProtocolService.BlockingInterface)mockDN);
        return new RPC.Builder(conf).setProtocol(ClientDatanodeProtocolPB.class).setInstance((Object)service).setBindAddress(ADDRESS).setPort(0).setNumHandlers(5).setVerbose(true).setSecretManager((SecretManager)sm).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testBlockTokenRpc(boolean enableProtobuf) throws Exception {
        Configuration conf = new Configuration();
        conf.set("hadoop.security.authentication", "kerberos");
        UserGroupInformation.setConfiguration((Configuration)conf);
        BlockTokenSecretManager sm = new BlockTokenSecretManager(600000L, 120000L, 0, 1, "fake-pool", null, enableProtobuf);
        Token token = sm.generateToken(this.block3, EnumSet.allOf(BlockTokenIdentifier.AccessMode.class), new StorageType[]{StorageType.DEFAULT}, new String[0]);
        Server server = TestBlockToken.createMockDatanode(sm, (Token<BlockTokenIdentifier>)token, conf);
        server.start();
        InetSocketAddress addr = NetUtils.getConnectAddress((Server)server);
        UserGroupInformation ticket = UserGroupInformation.createRemoteUser((String)this.block3.toString());
        ticket.addToken(token);
        ClientDatanodeProtocol proxy = null;
        try {
            proxy = DFSUtilClient.createClientDatanodeProtocolProxy((InetSocketAddress)addr, (UserGroupInformation)ticket, (Configuration)conf, (SocketFactory)NetUtils.getDefaultSocketFactory((Configuration)conf));
            Assert.assertEquals((long)this.block3.getBlockId(), (long)proxy.getReplicaVisibleLength(this.block3));
        }
        finally {
            server.stop();
            if (proxy != null) {
                RPC.stopProxy((Object)proxy);
            }
        }
    }

    @Test
    public void testBlockTokenRpcLegacy() throws Exception {
        this.testBlockTokenRpc(false);
    }

    @Test
    public void testBlockTokenRpcProtobuf() throws Exception {
        this.testBlockTokenRpc(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testBlockTokenRpcLeak(boolean enableProtobuf) throws Exception {
        Configuration conf = new Configuration();
        conf.set("hadoop.security.authentication", "kerberos");
        UserGroupInformation.setConfiguration((Configuration)conf);
        Assume.assumeTrue((boolean)FD_DIR.exists());
        BlockTokenSecretManager sm = new BlockTokenSecretManager(600000L, 120000L, 0, 1, "fake-pool", null, enableProtobuf);
        Token token = sm.generateToken(this.block3, EnumSet.allOf(BlockTokenIdentifier.AccessMode.class), new StorageType[]{StorageType.DEFAULT}, new String[0]);
        Server server = TestBlockToken.createMockDatanode(sm, (Token<BlockTokenIdentifier>)token, conf);
        server.start();
        InetSocketAddress addr = NetUtils.getConnectAddress((Server)server);
        DatanodeID fakeDnId = DFSTestUtil.getLocalDatanodeID(addr.getPort());
        ExtendedBlock b = new ExtendedBlock("fake-pool", new Block(12345L));
        LocatedBlock fakeBlock = new LocatedBlock(b, new DatanodeInfo[0]);
        fakeBlock.setBlockToken(token);
        ClientDatanodeProtocol proxyToNoWhere = (ClientDatanodeProtocol)RPC.getProxy(ClientDatanodeProtocol.class, (long)9L, (InetSocketAddress)new InetSocketAddress("1.1.1.1", 1), (UserGroupInformation)UserGroupInformation.createRemoteUser((String)"junk"), (Configuration)conf, (SocketFactory)NetUtils.getDefaultSocketFactory((Configuration)conf));
        ClientDatanodeProtocol proxy = null;
        int fdsAtStart = TestBlockToken.countOpenFileDescriptors();
        try {
            long endTime = Time.now() + 3000L;
            while (Time.now() < endTime) {
                proxy = DFSUtilClient.createClientDatanodeProtocolProxy((DatanodeID)fakeDnId, (Configuration)conf, (int)1000, (boolean)false, (LocatedBlock)fakeBlock);
                Assert.assertEquals((long)this.block3.getBlockId(), (long)proxy.getReplicaVisibleLength(this.block3));
                if (proxy != null) {
                    RPC.stopProxy((Object)proxy);
                }
                LOG.info("Num open fds:" + TestBlockToken.countOpenFileDescriptors());
            }
            int fdsAtEnd = TestBlockToken.countOpenFileDescriptors();
            if (fdsAtEnd - fdsAtStart > 50) {
                Assert.fail((String)("Leaked " + (fdsAtEnd - fdsAtStart) + " fds!"));
            }
        }
        finally {
            server.stop();
        }
        RPC.stopProxy((Object)proxyToNoWhere);
    }

    @Test
    public void testBlockTokenRpcLeakLegacy() throws Exception {
        this.testBlockTokenRpcLeak(false);
    }

    @Test
    public void testBlockTokenRpcLeakProtobuf() throws Exception {
        this.testBlockTokenRpcLeak(true);
    }

    private static int countOpenFileDescriptors() {
        return FD_DIR.list().length;
    }

    private void testBlockPoolTokenSecretManager(boolean enableProtobuf) throws Exception {
        BlockPoolTokenSecretManager bpMgr = new BlockPoolTokenSecretManager();
        for (int i = 0; i < 10; ++i) {
            String bpid = Integer.toString(i);
            BlockTokenSecretManager masterHandler = new BlockTokenSecretManager(600000L, 120000L, 0, 1, "fake-pool", null, enableProtobuf);
            BlockTokenSecretManager slaveHandler = new BlockTokenSecretManager(600000L, 120000L, "fake-pool", null, enableProtobuf);
            bpMgr.addBlockPool(bpid, slaveHandler);
            ExportedBlockKeys keys = masterHandler.exportKeys();
            bpMgr.addKeys(bpid, keys);
            String[] storageIds = new String[]{"DS-9001"};
            this.tokenGenerationAndVerification(masterHandler, bpMgr.get(bpid), new StorageType[]{StorageType.DEFAULT}, storageIds);
            this.tokenGenerationAndVerification(masterHandler, bpMgr.get(bpid), null, null);
            masterHandler.updateKeys();
            this.tokenGenerationAndVerification(masterHandler, bpMgr.get(bpid), new StorageType[]{StorageType.DEFAULT}, storageIds);
            this.tokenGenerationAndVerification(masterHandler, bpMgr.get(bpid), null, null);
            keys = masterHandler.exportKeys();
            bpMgr.addKeys(bpid, keys);
            this.tokenGenerationAndVerification(masterHandler, bpMgr.get(bpid), new StorageType[]{StorageType.DEFAULT}, new String[]{"DS-9001"});
            this.tokenGenerationAndVerification(masterHandler, bpMgr.get(bpid), null, null);
        }
    }

    @Test
    public void testBlockPoolTokenSecretManagerLegacy() throws Exception {
        this.testBlockPoolTokenSecretManager(false);
    }

    @Test
    public void testBlockPoolTokenSecretManagerProtobuf() throws Exception {
        this.testBlockPoolTokenSecretManager(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testBlockTokenInLastLocatedBlock(boolean enableProtobuf) throws IOException, InterruptedException {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setBoolean("dfs.block.access.token.enable", true);
        conf.setInt("dfs.blocksize", 512);
        conf.setBoolean("dfs.block.access.token.protobuf.enable", enableProtobuf);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).build();
        cluster.waitActive();
        try {
            DistributedFileSystem fs = cluster.getFileSystem();
            String fileName = "/testBlockTokenInLastLocatedBlock";
            Path filePath = new Path(fileName);
            FSDataOutputStream out = fs.create(filePath, (short)1);
            out.write(new byte[1000]);
            out.flush();
            LocatedBlocks locatedBlocks = cluster.getNameNodeRpc().getBlockLocations(fileName, 0L, 1000L);
            while (locatedBlocks.getLastLocatedBlock() == null) {
                Thread.sleep(100L);
                locatedBlocks = cluster.getNameNodeRpc().getBlockLocations(fileName, 0L, 1000L);
            }
            Token token = locatedBlocks.getLastLocatedBlock().getBlockToken();
            Assert.assertEquals((Object)BlockTokenIdentifier.KIND_NAME, (Object)token.getKind());
            out.close();
        }
        finally {
            cluster.shutdown();
        }
    }

    @Test
    public void testBlockTokenInLastLocatedBlockLegacy() throws IOException, InterruptedException {
        this.testBlockTokenInLastLocatedBlock(false);
    }

    @Test
    public void testBlockTokenInLastLocatedBlockProtobuf() throws IOException, InterruptedException {
        this.testBlockTokenInLastLocatedBlock(true);
    }

    @Test
    public void testLegacyBlockTokenBytesIsLegacy() throws IOException {
        boolean useProto = false;
        BlockTokenSecretManager sm = new BlockTokenSecretManager(600000L, 120000L, 0, 1, "fake-pool", null, false);
        Token token = sm.generateToken(this.block1, EnumSet.noneOf(BlockTokenIdentifier.AccessMode.class), new StorageType[]{StorageType.DEFAULT}, new String[0]);
        byte[] tokenBytes = token.getIdentifier();
        BlockTokenIdentifier legacyToken = new BlockTokenIdentifier();
        BlockTokenIdentifier protobufToken = new BlockTokenIdentifier();
        BlockTokenIdentifier readToken = new BlockTokenIdentifier();
        DataInputBuffer dib = new DataInputBuffer();
        dib.reset(tokenBytes, tokenBytes.length);
        legacyToken.readFieldsLegacy((DataInput)dib);
        boolean invalidProtobufMessage = false;
        try {
            dib.reset(tokenBytes, tokenBytes.length);
            protobufToken.readFieldsProtobuf((DataInput)dib);
        }
        catch (IOException e) {
            invalidProtobufMessage = true;
        }
        Assert.assertTrue((boolean)invalidProtobufMessage);
        dib.reset(tokenBytes, tokenBytes.length);
        readToken.readFields((DataInput)dib);
        Assert.assertEquals((Object)legacyToken, (Object)readToken);
        Assert.assertNotEquals((Object)protobufToken, (Object)readToken);
    }

    @Test
    public void testEmptyLegacyBlockTokenBytesIsLegacy() throws IOException {
        BlockTokenIdentifier emptyIdent = new BlockTokenIdentifier();
        DataOutputBuffer dob = new DataOutputBuffer(4096);
        DataInputBuffer dib = new DataInputBuffer();
        emptyIdent.writeLegacy((DataOutput)dob);
        byte[] emptyIdentBytes = Arrays.copyOf(dob.getData(), dob.getLength());
        BlockTokenIdentifier legacyToken = new BlockTokenIdentifier();
        BlockTokenIdentifier protobufToken = new BlockTokenIdentifier();
        BlockTokenIdentifier readToken = new BlockTokenIdentifier();
        dib.reset(emptyIdentBytes, emptyIdentBytes.length);
        legacyToken.readFieldsLegacy((DataInput)dib);
        boolean invalidProtobufMessage = false;
        try {
            dib.reset(emptyIdentBytes, emptyIdentBytes.length);
            protobufToken.readFieldsProtobuf((DataInput)dib);
        }
        catch (IOException e) {
            invalidProtobufMessage = true;
        }
        Assert.assertTrue((boolean)invalidProtobufMessage);
        dib.reset(emptyIdentBytes, emptyIdentBytes.length);
        readToken.readFields((DataInput)dib);
    }

    @Test
    public void testProtobufBlockTokenBytesIsProtobuf() throws IOException {
        boolean useProto = true;
        BlockTokenSecretManager sm = new BlockTokenSecretManager(600000L, 120000L, 0, 1, "fake-pool", null, true);
        Token token = sm.generateToken(this.block1, EnumSet.noneOf(BlockTokenIdentifier.AccessMode.class), StorageType.EMPTY_ARRAY, new String[0]);
        byte[] tokenBytes = token.getIdentifier();
        BlockTokenIdentifier legacyToken = new BlockTokenIdentifier();
        BlockTokenIdentifier protobufToken = new BlockTokenIdentifier();
        BlockTokenIdentifier readToken = new BlockTokenIdentifier();
        DataInputBuffer dib = new DataInputBuffer();
        boolean invalidLegacyMessage = false;
        try {
            dib.reset(tokenBytes, tokenBytes.length);
            legacyToken.readFieldsLegacy((DataInput)dib);
        }
        catch (IOException | NegativeArraySizeException e) {
            invalidLegacyMessage = true;
        }
        Assert.assertTrue((boolean)invalidLegacyMessage);
        dib.reset(tokenBytes, tokenBytes.length);
        protobufToken.readFieldsProtobuf((DataInput)dib);
        dib.reset(tokenBytes, tokenBytes.length);
        readToken.readFields((DataInput)dib);
        Assert.assertNotEquals((Object)legacyToken, (Object)readToken);
        Assert.assertEquals((Object)protobufToken, (Object)readToken);
    }

    private void testCraftedProtobufBlockTokenIdentifier(BlockTokenIdentifier identifier, boolean expectIOE, boolean expectRTE) throws IOException {
        DataOutputBuffer dob = new DataOutputBuffer(4096);
        DataInputBuffer dib = new DataInputBuffer();
        identifier.writeProtobuf((DataOutput)dob);
        byte[] identBytes = Arrays.copyOf(dob.getData(), dob.getLength());
        BlockTokenIdentifier legacyToken = new BlockTokenIdentifier();
        BlockTokenIdentifier protobufToken = new BlockTokenIdentifier();
        BlockTokenIdentifier readToken = new BlockTokenIdentifier();
        boolean invalidLegacyMessage = false;
        try {
            dib.reset(identBytes, identBytes.length);
            legacyToken.readFieldsLegacy((DataInput)dib);
        }
        catch (IOException e) {
            if (!expectIOE) {
                Assert.fail((String)"Received IOException but it was not expected.");
            }
            invalidLegacyMessage = true;
        }
        catch (RuntimeException e) {
            if (!expectRTE) {
                Assert.fail((String)"Received RuntimeException but it was not expected.");
            }
            invalidLegacyMessage = true;
        }
        Assert.assertTrue((boolean)invalidLegacyMessage);
        dib.reset(identBytes, identBytes.length);
        protobufToken.readFieldsProtobuf((DataInput)dib);
        dib.reset(identBytes, identBytes.length);
        readToken.readFieldsProtobuf((DataInput)dib);
        Assert.assertEquals((Object)protobufToken, (Object)readToken);
        Assert.assertEquals((Object)identifier, (Object)readToken);
    }

    @Test
    public void testEmptyProtobufBlockTokenBytesIsProtobuf() throws IOException {
        BlockTokenIdentifier identifier = new BlockTokenIdentifier();
        this.testCraftedProtobufBlockTokenIdentifier(identifier, true, false);
    }

    @Test
    public void testCraftedProtobufBlockTokenBytesIsProtobuf() throws IOException {
        BlockTokenIdentifier identifier = new BlockTokenIdentifier("user", "blockpool", 123L, EnumSet.allOf(BlockTokenIdentifier.AccessMode.class), new StorageType[]{StorageType.DISK, StorageType.ARCHIVE}, new String[]{"fake-storage-id"}, true);
        GregorianCalendar cal = new GregorianCalendar();
        cal.set(2017, 1, 9, 0, 12, 35);
        long datetime = cal.getTimeInMillis();
        datetime = datetime / 1000L * 1000L;
        identifier.setExpiryDate(datetime += 71L);
        this.testCraftedProtobufBlockTokenIdentifier(identifier, false, true);
        identifier.setExpiryDate(++datetime);
        this.testCraftedProtobufBlockTokenIdentifier(identifier, true, false);
    }

    private BlockTokenIdentifier writeAndReadBlockToken(BlockTokenIdentifier identifier) throws IOException {
        DataOutputBuffer dob = new DataOutputBuffer(4096);
        DataInputBuffer dib = new DataInputBuffer();
        identifier.write((DataOutput)dob);
        byte[] identBytes = Arrays.copyOf(dob.getData(), dob.getLength());
        BlockTokenIdentifier readToken = new BlockTokenIdentifier();
        dib.reset(identBytes, identBytes.length);
        readToken.readFields((DataInput)dib);
        Assert.assertEquals((Object)identifier, (Object)readToken);
        return readToken;
    }

    @Test
    public void testEmptyBlockTokenSerialization() throws IOException {
        BlockTokenIdentifier ident = new BlockTokenIdentifier();
        BlockTokenIdentifier ret = this.writeAndReadBlockToken(ident);
        Assert.assertEquals((long)ret.getExpiryDate(), (long)0L);
        Assert.assertEquals((long)ret.getKeyId(), (long)0L);
        Assert.assertEquals((Object)ret.getUserId(), null);
        Assert.assertEquals((Object)ret.getBlockPoolId(), null);
        Assert.assertEquals((long)ret.getBlockId(), (long)0L);
        Assert.assertEquals((Object)ret.getAccessModes(), EnumSet.noneOf(BlockTokenIdentifier.AccessMode.class));
        Assert.assertArrayEquals((Object[])ret.getStorageTypes(), (Object[])StorageType.EMPTY_ARRAY);
    }

    private void testBlockTokenSerialization(boolean useProto) throws IOException {
        EnumSet<BlockTokenIdentifier.AccessMode> accessModes = EnumSet.allOf(BlockTokenIdentifier.AccessMode.class);
        Object[] storageTypes = new StorageType[]{StorageType.RAM_DISK, StorageType.SSD, StorageType.DISK, StorageType.ARCHIVE};
        BlockTokenIdentifier ident = new BlockTokenIdentifier("user", "bpool", 123L, accessModes, (StorageType[])storageTypes, new String[]{"fake-storage-id"}, useProto);
        ident.setExpiryDate(1487080345L);
        BlockTokenIdentifier ret = this.writeAndReadBlockToken(ident);
        Assert.assertEquals((long)ret.getExpiryDate(), (long)1487080345L);
        Assert.assertEquals((long)ret.getKeyId(), (long)0L);
        Assert.assertEquals((Object)ret.getUserId(), (Object)"user");
        Assert.assertEquals((Object)ret.getBlockPoolId(), (Object)"bpool");
        Assert.assertEquals((long)ret.getBlockId(), (long)123L);
        Assert.assertEquals((Object)ret.getAccessModes(), EnumSet.allOf(BlockTokenIdentifier.AccessMode.class));
        Assert.assertArrayEquals((Object[])ret.getStorageTypes(), (Object[])storageTypes);
        Assert.assertArrayEquals((Object[])ret.getStorageIds(), (Object[])new String[]{"fake-storage-id"});
    }

    @Test
    public void testBlockTokenSerialization() throws IOException {
        this.testBlockTokenSerialization(false);
        this.testBlockTokenSerialization(true);
    }

    private void testBadStorageIDCheckAccess(boolean enableProtobuf) throws IOException {
        BlockTokenSecretManager sm = new BlockTokenSecretManager(600000L, 120000L, 0, 1, "fake-pool", null, enableProtobuf);
        StorageType[] storageTypes = new StorageType[]{StorageType.DISK};
        String[] storageIds = new String[]{"fake-storage-id"};
        String[] badStorageIds = new String[]{"BAD-STORAGE-ID"};
        String[] emptyStorageIds = new String[]{};
        BlockTokenIdentifier.AccessMode mode = BlockTokenIdentifier.AccessMode.READ;
        BlockTokenIdentifier id = this.generateTokenId(sm, this.block3, EnumSet.of(mode), storageTypes, storageIds);
        sm.checkAccess(id, null, this.block3, mode, storageTypes, storageIds);
        try {
            sm.checkAccess(id, null, this.block3, mode, storageTypes, badStorageIds);
            Assert.fail((String)"Expected strict BlockTokenSecretManager to fail");
        }
        catch (SecretManager.InvalidToken invalidToken) {
            // empty catch block
        }
        sm.checkAccess(id, null, this.block3, mode, storageTypes, emptyStorageIds);
        sm.checkAccess(id, null, this.block3, mode, storageTypes, null);
        sm.checkAccess(id, null, this.block3, mode, storageTypes);
    }

    @Test
    public void testBadStorageIDCheckAccess() throws IOException {
        this.testBadStorageIDCheckAccess(false);
        this.testBadStorageIDCheckAccess(true);
    }

    static {
        GenericTestUtils.setLogLevel((Logger)Client.LOG, (Level)Level.ALL);
        GenericTestUtils.setLogLevel((Logger)Server.LOG, (Level)Level.ALL);
        GenericTestUtils.setLogLevel((Logger)SaslRpcClient.LOG, (Level)Level.ALL);
        GenericTestUtils.setLogLevel((Logger)SaslRpcServer.LOG, (Level)Level.ALL);
        GenericTestUtils.setLogLevel((Logger)SaslInputStream.LOG, (Level)Level.ALL);
        FD_DIR = new File("/proc/self/fd/");
    }

    private static class GetLengthAnswer
    implements Answer<ClientDatanodeProtocolProtos.GetReplicaVisibleLengthResponseProto> {
        final BlockTokenSecretManager sm;
        final BlockTokenIdentifier ident;

        public GetLengthAnswer(BlockTokenSecretManager sm, BlockTokenIdentifier ident) {
            this.sm = sm;
            this.ident = ident;
        }

        public ClientDatanodeProtocolProtos.GetReplicaVisibleLengthResponseProto answer(InvocationOnMock invocation) throws IOException {
            Object[] args = invocation.getArguments();
            Assert.assertEquals((long)2L, (long)args.length);
            ClientDatanodeProtocolProtos.GetReplicaVisibleLengthRequestProto req = (ClientDatanodeProtocolProtos.GetReplicaVisibleLengthRequestProto)args[1];
            Set tokenIds = UserGroupInformation.getCurrentUser().getTokenIdentifiers();
            Assert.assertEquals((String)"Only one BlockTokenIdentifier expected", (long)1L, (long)tokenIds.size());
            long result = 0L;
            for (TokenIdentifier tokenId : tokenIds) {
                BlockTokenIdentifier id = (BlockTokenIdentifier)tokenId;
                LOG.info("Got: " + id.toString());
                Assert.assertTrue((String)"Received BlockTokenIdentifier is wrong", (boolean)this.ident.equals((Object)id));
                this.sm.checkAccess(id, null, PBHelperClient.convert((HdfsProtos.ExtendedBlockProto)req.getBlock()), BlockTokenIdentifier.AccessMode.WRITE, new StorageType[]{StorageType.DEFAULT}, null);
                result = id.getBlockId();
            }
            return ClientDatanodeProtocolProtos.GetReplicaVisibleLengthResponseProto.newBuilder().setLength(result).build();
        }
    }
}

