/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode.fsdataset.impl;

import java.io.IOException;
import java.util.concurrent.TimeoutException;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsDatasetTestUtil;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.LazyPersistTestCase;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.Test;

public class TestLazyPersistReplicaRecovery
extends LazyPersistTestCase {
    @Test
    public void testDnRestartWithSavedReplicas() throws IOException, InterruptedException, TimeoutException {
        this.getClusterBuilder().build();
        String METHOD_NAME = GenericTestUtils.getMethodName();
        Path path1 = new Path("/" + METHOD_NAME + ".01.dat");
        this.makeTestFile(path1, 0x500000L, true);
        this.ensureFileReplicasOnStorageType(path1, StorageType.RAM_DISK);
        Thread.sleep(3000L);
        this.ensureFileReplicasOnStorageType(path1, StorageType.RAM_DISK);
        LOG.info("Restarting the DataNode");
        this.cluster.restartDataNode(0, true);
        this.cluster.waitActive();
        this.triggerBlockReport();
        this.ensureFileReplicasOnStorageType(path1, StorageType.DEFAULT);
    }

    @Test
    public void testDnRestartWithUnsavedReplicas() throws IOException, InterruptedException, TimeoutException {
        this.getClusterBuilder().build();
        FsDatasetTestUtil.stopLazyWriter(this.cluster.getDataNodes().get(0));
        String METHOD_NAME = GenericTestUtils.getMethodName();
        Path path1 = new Path("/" + METHOD_NAME + ".01.dat");
        this.makeTestFile(path1, 0x500000L, true);
        this.ensureFileReplicasOnStorageType(path1, StorageType.RAM_DISK);
        LOG.info("Restarting the DataNode");
        this.cluster.restartDataNode(0, true);
        this.cluster.waitActive();
        this.ensureFileReplicasOnStorageType(path1, StorageType.RAM_DISK);
    }
}

