/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.viewfs;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.EnumSet;
import javax.security.auth.login.LoginException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileChecksum;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileSystemTestHelper;
import org.apache.hadoop.fs.FsConstants;
import org.apache.hadoop.fs.FsShell;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.contract.ContractTestUtils;
import org.apache.hadoop.fs.viewfs.ConfigUtil;
import org.apache.hadoop.fs.viewfs.NflyFSystem;
import org.apache.hadoop.fs.viewfs.ViewFileSystem;
import org.apache.hadoop.fs.viewfs.ViewFileSystemBaseTest;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.MiniDFSNNTopology;
import org.apache.hadoop.hdfs.client.CreateEncryptionZoneFlag;
import org.apache.hadoop.hdfs.client.HdfsAdmin;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestViewFileSystemHdfs
extends ViewFileSystemBaseTest {
    private static final Logger LOG = LoggerFactory.getLogger(TestViewFileSystemHdfs.class);
    private static MiniDFSCluster cluster;
    private static Path defaultWorkingDirectory;
    private static Path defaultWorkingDirectory2;
    private static final Configuration CONF;
    private static FileSystem fHdfs;
    private static FileSystem fHdfs2;
    private FileSystem fsTarget2;
    Path targetTestRoot2;

    protected FileSystemTestHelper createFileSystemHelper() {
        return new FileSystemTestHelper("/tmp/TestViewFileSystemHdfs");
    }

    @BeforeClass
    public static void clusterSetupAtBegining() throws IOException, LoginException, URISyntaxException {
        FileSystemTestHelper fsHelper = new FileSystemTestHelper();
        String testRoot = fsHelper.getTestRootDir();
        CONF.set("hadoop.security.key.provider.path", "jceks://file" + new Path(new File(testRoot).getAbsoluteFile().toString(), "test.jks").toUri());
        CONF.setBoolean("dfs.namenode.delegation.token.always-use", true);
        CONF.setInt("dfs.namenode.list.encryption.zones.num.responses", 2);
        SupportsBlocks = true;
        CONF.setBoolean("dfs.namenode.delegation.token.always-use", true);
        cluster = new MiniDFSCluster.Builder(CONF).nnTopology(MiniDFSNNTopology.simpleFederatedTopology(2)).numDataNodes(2).build();
        cluster.waitClusterUp();
        fHdfs = cluster.getFileSystem(0);
        fHdfs2 = cluster.getFileSystem(1);
        fHdfs.getConf().set("fs.defaultFS", FsConstants.VIEWFS_URI.toString());
        fHdfs2.getConf().set("fs.defaultFS", FsConstants.VIEWFS_URI.toString());
        defaultWorkingDirectory = fHdfs.makeQualified(new Path("/user/" + UserGroupInformation.getCurrentUser().getShortUserName()));
        defaultWorkingDirectory2 = fHdfs2.makeQualified(new Path("/user/" + UserGroupInformation.getCurrentUser().getShortUserName()));
        fHdfs.mkdirs(defaultWorkingDirectory);
        fHdfs2.mkdirs(defaultWorkingDirectory2);
    }

    @AfterClass
    public static void ClusterShutdownAtEnd() throws Exception {
        if (cluster != null) {
            cluster.shutdown();
        }
    }

    @Before
    public void setUp() throws Exception {
        this.fsTarget = fHdfs;
        this.fsTarget2 = fHdfs2;
        this.targetTestRoot2 = new FileSystemTestHelper().getAbsoluteTestRootPath(this.fsTarget2);
        super.setUp();
    }

    @After
    public void tearDown() throws Exception {
        super.tearDown();
    }

    void setupMountPoints() {
        super.setupMountPoints();
        ConfigUtil.addLink((Configuration)this.conf, (String)"/mountOnNn2", (URI)new Path(this.targetTestRoot2, "mountOnNn2").toUri());
    }

    int getExpectedDirPaths() {
        return 8;
    }

    int getExpectedMountPoints() {
        return 9;
    }

    int getExpectedDelegationTokenCount() {
        return 2;
    }

    int getExpectedDelegationTokenCountWithCredentials() {
        return 2;
    }

    @Test
    public void testTrashRootsAfterEncryptionZoneDeletion() throws Exception {
        Path zone = new Path("/EZ");
        this.fsTarget.mkdirs(zone);
        Path zone1 = new Path("/EZ/zone1");
        this.fsTarget.mkdirs(zone1);
        DFSTestUtil.createKey("test_key", cluster, CONF);
        HdfsAdmin hdfsAdmin = new HdfsAdmin(cluster.getURI(0), CONF);
        EnumSet<CreateEncryptionZoneFlag> provisionTrash = EnumSet.of(CreateEncryptionZoneFlag.PROVISION_TRASH);
        hdfsAdmin.createEncryptionZone(zone1, "test_key", provisionTrash);
        Path encFile = new Path(zone1, "encFile");
        DFSTestUtil.createFile(this.fsTarget, encFile, 10240L, (short)1, 65261L);
        Configuration clientConf = new Configuration(CONF);
        clientConf.setLong("fs.trash.interval", 1L);
        clientConf.set("fs.default.name", this.fsTarget.getUri().toString());
        FsShell shell = new FsShell(clientConf);
        DFSTestUtil.verifyDelete(shell, this.fsTarget, encFile, true);
        Assert.assertTrue((String)"ViewFileSystem trash roots should include EZ file trash", (this.fsView.getTrashRoots(true).size() == 1 ? 1 : 0) != 0);
        DFSTestUtil.verifyDelete(shell, this.fsTarget, zone, true);
        Assert.assertTrue((String)"ViewFileSystem trash roots should include EZ zone trash", (this.fsView.getTrashRoots(true).size() == 2 ? 1 : 0) != 0);
    }

    @Test
    public void testDf() throws Exception {
        Configuration newConf = new Configuration(this.conf);
        DFSTestUtil.FsShellRun("-df", 0, "Use%" + System.lineSeparator(), newConf);
        newConf.set("fs.default.name", "viewfs:///");
        DFSTestUtil.FsShellRun("-df /user", 0, "Mounted on", newConf);
        DFSTestUtil.FsShellRun("-df viewfs:///user", 0, "/user", newConf);
        DFSTestUtil.FsShellRun("-df /user3", 1, "/user3", newConf);
        DFSTestUtil.FsShellRun("-df /user2/abc", 1, "No such file or directory", newConf);
        DFSTestUtil.FsShellRun("-df /user2/", 0, "/user2", newConf);
        DFSTestUtil.FsShellRun("-df /internalDir", 0, "/internalDir", newConf);
        DFSTestUtil.FsShellRun("-df /", 0, null, newConf);
        DFSTestUtil.FsShellRun("-df", 0, null, newConf);
    }

    @Test
    public void testFileChecksum() throws IOException {
        ViewFileSystem viewFs = (ViewFileSystem)this.fsView;
        Path mountDataRootPath = new Path("/data");
        String fsTargetFileName = "debug.log";
        Path fsTargetFilePath = new Path(this.targetTestRoot, "data/debug.log");
        Path mountDataFilePath = new Path(mountDataRootPath, fsTargetFileName);
        FileSystemTestHelper.createFile((FileSystem)this.fsTarget, (Path)fsTargetFilePath);
        FileStatus fileStatus = viewFs.getFileStatus(mountDataFilePath);
        long fileLength = fileStatus.getLen();
        FileChecksum fileChecksumViaViewFs = viewFs.getFileChecksum(mountDataFilePath);
        FileChecksum fileChecksumViaTargetFs = this.fsTarget.getFileChecksum(fsTargetFilePath);
        Assert.assertTrue((String)"File checksum not matching!", (boolean)fileChecksumViaViewFs.equals((Object)fileChecksumViaTargetFs));
        fileChecksumViaViewFs = viewFs.getFileChecksum(mountDataFilePath, fileLength / 2L);
        fileChecksumViaTargetFs = this.fsTarget.getFileChecksum(fsTargetFilePath, fileLength / 2L);
        Assert.assertTrue((String)"File checksum not matching!", (boolean)fileChecksumViaViewFs.equals((Object)fileChecksumViaTargetFs));
    }

    @Test
    public void testRenameAccorssFilesystem() throws IOException {
        Path mountDataRootPath = new Path("/data");
        Path fsTargetFilePath = new Path("/mountOnNn2");
        Path filePath = new Path(mountDataRootPath + "/ttest");
        Path hdfFilepath = new Path(fsTargetFilePath + "/ttest2");
        this.fsView.create(filePath);
        try {
            this.fsView.rename(filePath, hdfFilepath);
            ContractTestUtils.fail((String)"Should thrown IOE on Renames across filesytems");
        }
        catch (IOException e) {
            GenericTestUtils.assertExceptionContains((String)"Renames across Mount points not supported", (Throwable)e);
        }
    }

    @Test
    public void testNflyClosestRepair() throws Exception {
        this.testNflyRepair(NflyFSystem.NflyKey.repairOnRead);
    }

    @Test
    public void testNflyMostRecentRepair() throws Exception {
        this.testNflyRepair(NflyFSystem.NflyKey.readMostRecent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testNflyRepair(NflyFSystem.NflyKey repairKey) throws Exception {
        block17: {
            LOG.info("Starting testNflyWriteSimpleFailover");
            URI uri1 = this.targetTestRoot.toUri();
            URI uri2 = this.targetTestRoot2.toUri();
            URI[] testUris = new URI[]{new URI(uri1.getScheme(), uri1.getAuthority(), "/", null, null), new URI(uri2.getScheme(), uri2.getAuthority(), "/", null, null)};
            String clusterName = "mycluster";
            Configuration testConf = new Configuration(this.conf);
            testConf.set("fs.viewfs.mounttable.default.name.key", clusterName);
            testConf.setInt("ipc.client.connect.max.retries", 1);
            String testString = "Hello Nfly!";
            Path nflyRoot = new Path("/nflyroot");
            ConfigUtil.addLinkNfly((Configuration)testConf, (String)clusterName, (String)nflyRoot.toString(), (String)("minReplication=2," + repairKey + "=true"), (URI[])testUris);
            FileSystem nfly = FileSystem.get((URI)URI.create("viewfs:///"), (Configuration)testConf);
            nfly.setWorkingDirectory(new Path(nflyRoot + nfly.getWorkingDirectory().toUri().getPath()));
            Path testDir = new Path("testdir1/sub1/sub3");
            Path testDir_tmp = new Path("testdir1/sub1/sub3_temp");
            Assert.assertTrue((String)(testDir + ": Failed to create!"), (boolean)nfly.mkdirs(testDir));
            Assert.assertTrue((boolean)nfly.rename(testDir, testDir_tmp));
            Assert.assertTrue((boolean)nfly.rename(testDir_tmp, testDir));
            for (URI testUri : testUris) {
                FileSystem fs = FileSystem.get((URI)testUri, (Configuration)testConf);
                Assert.assertTrue((String)(testDir + " should exist!"), (boolean)fs.exists(testDir));
            }
            Path testFile = new Path("test.txt");
            try (FSDataOutputStream fsDos = nfly.create(testFile);){
                fsDos.writeUTF("Hello Nfly!");
            }
            for (URI testUri : testUris) {
                FileSystem fs = FileSystem.get((URI)testUri, (Configuration)testConf);
                try (FSDataInputStream fsdis = fs.open(testFile);){
                    Assert.assertEquals((String)"Wrong file content", (Object)"Hello Nfly!", (Object)fsdis.readUTF());
                }
            }
            for (int i = 0; i < cluster.getNumNameNodes(); ++i) {
                cluster.shutdownNameNode(i);
                FSDataInputStream fsDis = null;
                try {
                    fsDis = nfly.open(testFile);
                    Assert.assertEquals((String)"Wrong file content", (Object)"Hello Nfly!", (Object)fsDis.readUTF());
                }
                catch (Throwable throwable) {
                    IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{fsDis});
                    cluster.restartNameNode(i);
                    throw throwable;
                }
                IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{fsDis});
                cluster.restartNameNode(i);
            }
            FileSystem fs1 = FileSystem.get((URI)testUris[0], (Configuration)this.conf);
            Assert.assertTrue((boolean)fs1.delete(testFile, false));
            Assert.assertFalse((boolean)fs1.exists(testFile));
            FSDataInputStream fsDis = null;
            try {
                fsDis = nfly.open(testFile);
                Assert.assertEquals((String)"Wrong file content", (Object)"Hello Nfly!", (Object)fsDis.readUTF());
                Assert.assertTrue((boolean)fs1.exists(testFile));
            }
            catch (Throwable throwable) {
                IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{fsDis});
                throw throwable;
            }
            IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{fsDis});
            if (repairKey != NflyFSystem.NflyKey.readMostRecent) break block17;
            FileSystem fs2 = FileSystem.get((URI)testUris[0], (Configuration)this.conf);
            long expectedMtime = fs2.getFileStatus(testFile).getModificationTime();
            for (URI testUri : testUris) {
                FileSystem fs = FileSystem.get((URI)testUri, (Configuration)this.conf);
                fs.setTimes(testFile, 1L, 1L);
                Assert.assertEquals((String)(testUri + "Set mtime failed!"), (long)1L, (long)fs.getFileStatus(testFile).getModificationTime());
                Assert.assertEquals((String)"nfly file status wrong", (long)expectedMtime, (long)nfly.getFileStatus(testFile).getModificationTime());
                FSDataInputStream fsDis2 = null;
                try {
                    fsDis2 = nfly.open(testFile);
                    Assert.assertEquals((String)"Wrong file content", (Object)"Hello Nfly!", (Object)fsDis2.readUTF());
                    Assert.assertEquals((String)"Repair most recent failed!", (long)expectedMtime, (long)fs.getFileStatus(testFile).getModificationTime());
                }
                catch (Throwable throwable) {
                    IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{fsDis2});
                    throw throwable;
                }
                IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{fsDis2});
            }
        }
    }

    static {
        CONF = new Configuration();
    }
}

