/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import com.google.common.collect.Lists;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import org.apache.commons.text.TextStringBuilder;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.AdminStatesBaseTest;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.client.HdfsDataInputStream;
import org.apache.hadoop.hdfs.client.HdfsDataOutputStream;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManagerTestUtil;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeAdminManager;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeManager;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeStatistics;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.DataNodeTestUtils;
import org.apache.hadoop.hdfs.server.datanode.SimulatedFSDataset;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.NameNodeAdapter;
import org.apache.hadoop.hdfs.server.namenode.ha.HATestUtil;
import org.apache.hadoop.hdfs.tools.DFSAdmin;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.log4j.Level;
import org.eclipse.jetty.util.ajax.JSON;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestDecommission
extends AdminStatesBaseTest {
    public static final Logger LOG = LoggerFactory.getLogger(TestDecommission.class);

    private static String checkFile(FileSystem fileSys, Path name, int repl, String downnode, int numDatanodes) throws IOException {
        boolean isNodeDown = downnode != null;
        Assert.assertTrue((String)("Not HDFS:" + fileSys.getUri()), (boolean)(fileSys instanceof DistributedFileSystem));
        HdfsDataInputStream dis = (HdfsDataInputStream)fileSys.open(name);
        List dinfo = dis.getAllBlocks();
        for (LocatedBlock blk : dinfo) {
            int hasdown = 0;
            DatanodeInfo[] nodes = blk.getLocations();
            for (int j = 0; j < nodes.length; ++j) {
                if (isNodeDown && nodes[j].getXferAddr().equals(downnode)) {
                    ++hasdown;
                    if (!nodes[j].isDecommissioned()) {
                        return "For block " + blk.getBlock() + " replica on " + nodes[j] + " is given as downnode, but is not decommissioned";
                    }
                    if (j != nodes.length - 1) {
                        return "For block " + blk.getBlock() + " decommissioned node " + nodes[j] + " was not last node in list: " + (j + 1) + " of " + nodes.length;
                    }
                    LOG.info("Block " + blk.getBlock() + " replica on " + nodes[j] + " is decommissioned.");
                    continue;
                }
                if (!nodes[j].isDecommissioned()) continue;
                return "For block " + blk.getBlock() + " replica on " + nodes[j] + " is unexpectedly decommissioned";
            }
            LOG.info("Block " + blk.getBlock() + " has " + hasdown + " decommissioned replica.");
            if (Math.min(numDatanodes, repl + hasdown) == nodes.length) continue;
            return "Wrong number of replicas for block " + blk.getBlock() + ": " + nodes.length + ", expected " + Math.min(numDatanodes, repl + hasdown);
        }
        return null;
    }

    private void verifyStats(NameNode namenode, FSNamesystem fsn, DatanodeInfo info, DataNode node, boolean decommissioning) throws InterruptedException, IOException {
        for (int i = 0; i < 10; ++i) {
            long[] newStats = namenode.getRpcServer().getStats();
            Assert.assertEquals((long)newStats[0], (long)(decommissioning ? 0L : info.getCapacity()));
            Assert.assertEquals((long)newStats[1], (long)(decommissioning ? 0L : info.getDfsUsed()));
            Assert.assertEquals((long)newStats[2], (long)(decommissioning ? 0L : info.getRemaining()));
            Assert.assertEquals((long)fsn.getTotalLoad(), (long)info.getXceiverCount());
            DataNodeTestUtils.triggerHeartbeat(node);
        }
    }

    @Test(timeout=360000L)
    public void testDecommission() throws IOException {
        this.testDecommission(1, 6);
    }

    @Test(timeout=360000L)
    public void testDecommission2() throws IOException {
        LOG.info("Starting test testDecommission");
        int numNamenodes = 1;
        int numDatanodes = 4;
        this.getConf().setInt("dfs.replication", 3);
        this.startCluster(numNamenodes, numDatanodes);
        ArrayList namenodeDecomList = new ArrayList(numNamenodes);
        namenodeDecomList.add(0, new ArrayList(numDatanodes));
        Path file1 = new Path("testDecommission2.dat");
        int replicas = 4;
        ArrayList decommissionedNodes = (ArrayList)namenodeDecomList.get(0);
        DistributedFileSystem fileSys = this.getCluster().getFileSystem(0);
        FSNamesystem ns = this.getCluster().getNamesystem(0);
        TestDecommission.writeFile((FileSystem)fileSys, file1, replicas);
        int deadDecomissioned = ns.getNumDecomDeadDataNodes();
        int liveDecomissioned = ns.getNumDecomLiveDataNodes();
        DatanodeInfo decomNode = this.takeNodeOutofService(0, null, 0L, decommissionedNodes, DatanodeInfo.AdminStates.DECOMMISSIONED);
        decommissionedNodes.add(decomNode);
        Assert.assertEquals((long)deadDecomissioned, (long)ns.getNumDecomDeadDataNodes());
        Assert.assertEquals((long)(liveDecomissioned + 1), (long)ns.getNumDecomLiveDataNodes());
        DFSClient client = this.getDfsClient(0);
        Assert.assertEquals((String)"All datanodes must be alive", (long)numDatanodes, (long)client.datanodeReport(HdfsConstants.DatanodeReportType.LIVE).length);
        Assert.assertNull((Object)TestDecommission.checkFile((FileSystem)fileSys, file1, replicas, decomNode.getXferAddr(), numDatanodes));
        TestDecommission.cleanupFile((FileSystem)fileSys, file1);
        this.shutdownCluster();
        this.startCluster(1, 4);
    }

    @Test(timeout=360000L)
    public void testDecommissionFederation() throws IOException {
        this.testDecommission(2, 2);
    }

    @Test(timeout=360000L)
    public void testDecommissionOnStandby() throws Exception {
        this.getConf().setInt("dfs.ha.tail-edits.period", 1);
        this.getConf().setInt("dfs.namenode.heartbeat.recheck-interval", 30000);
        this.getConf().setInt("dfs.namenode.tolerate.heartbeat.multiplier", 2);
        long slowHeartbeatDNwaitTime = this.getConf().getLong("dfs.heartbeat.interval", 3L) * 1000L * (long)(this.getConf().getInt("dfs.namenode.tolerate.heartbeat.multiplier", 4) + 1);
        this.startSimpleHACluster(3);
        Path file1 = new Path("testDecommissionHA.dat");
        int replicas = 3;
        DistributedFileSystem activeFileSys = this.getCluster().getFileSystem(0);
        TestDecommission.writeFile((FileSystem)activeFileSys, file1, replicas);
        HATestUtil.waitForStandbyToCatchUp(this.getCluster().getNameNode(0), this.getCluster().getNameNode(1));
        this.getConf().setLong("dfs.heartbeat.interval", 30L);
        this.getCluster().startDataNodes(this.getConf(), 1, true, null, null, null);
        DataNode lastDN = this.getCluster().getDataNodes().get(3);
        lastDN.getDatanodeUuid();
        DataNode firstDN = this.getCluster().getDataNodes().get(0);
        DatanodeInfo decommissionedNodeFromANN = this.takeNodeOutofService(0, firstDN.getDatanodeUuid(), 0L, null, DatanodeInfo.AdminStates.DECOMMISSIONED);
        DatanodeInfo decomNodeFromSBN = this.takeNodeOutofService(1, firstDN.getDatanodeUuid(), 0L, null, DatanodeInfo.AdminStates.DECOMMISSIONED);
        Thread.sleep(slowHeartbeatDNwaitTime);
        this.putNodeInService(1, decomNodeFromSBN);
        MiniDFSCluster.DataNodeProperties lastDNprop = this.getCluster().stopDataNode(3);
        lastDNprop.conf.setLong("dfs.heartbeat.interval", 1L);
        this.getCluster().restartDataNode(lastDNprop);
        MiniDFSCluster.DataNodeProperties nextToLastDNprop = this.getCluster().stopDataNode(2);
        nextToLastDNprop.conf.setLong("dfs.heartbeat.interval", 30L);
        this.getCluster().restartDataNode(nextToLastDNprop);
        this.getCluster().waitActive();
        Thread.sleep(slowHeartbeatDNwaitTime);
        this.putNodeInService(0, decommissionedNodeFromANN);
        this.getCluster().triggerHeartbeats();
        HATestUtil.waitForDNDeletions(this.getCluster());
        this.getCluster().triggerDeletionReports();
        this.takeNodeOutofService(0, firstDN.getDatanodeUuid(), 0L, null, DatanodeInfo.AdminStates.DECOMMISSIONED);
        this.takeNodeOutofService(1, firstDN.getDatanodeUuid(), 0L, null, DatanodeInfo.AdminStates.DECOMMISSIONED);
    }

    private void testDecommission(int numNamenodes, int numDatanodes) throws IOException {
        LOG.info("Starting test testDecommission");
        this.startCluster(numNamenodes, numDatanodes);
        ArrayList namenodeDecomList = new ArrayList(numNamenodes);
        for (int i = 0; i < numNamenodes; ++i) {
            namenodeDecomList.add(i, new ArrayList(numDatanodes));
        }
        Path file1 = new Path("testDecommission.dat");
        for (int iteration = 0; iteration < numDatanodes - 1; ++iteration) {
            int replicas = numDatanodes - iteration - 1;
            for (int i = 0; i < numNamenodes; ++i) {
                ArrayList decommissionedNodes = (ArrayList)namenodeDecomList.get(i);
                DistributedFileSystem fileSys = this.getCluster().getFileSystem(i);
                FSNamesystem ns = this.getCluster().getNamesystem(i);
                TestDecommission.writeFile((FileSystem)fileSys, file1, replicas);
                int deadDecomissioned = ns.getNumDecomDeadDataNodes();
                int liveDecomissioned = ns.getNumDecomLiveDataNodes();
                DatanodeInfo decomNode = this.takeNodeOutofService(i, null, 0L, decommissionedNodes, DatanodeInfo.AdminStates.DECOMMISSIONED);
                decommissionedNodes.add(decomNode);
                Assert.assertEquals((long)deadDecomissioned, (long)ns.getNumDecomDeadDataNodes());
                Assert.assertEquals((long)(liveDecomissioned + 1), (long)ns.getNumDecomLiveDataNodes());
                DFSClient client = this.getDfsClient(i);
                Assert.assertEquals((String)"All datanodes must be alive", (long)numDatanodes, (long)client.datanodeReport(HdfsConstants.DatanodeReportType.LIVE).length);
                int tries = 0;
                while (tries++ < 20) {
                    try {
                        Thread.sleep(1000L);
                        if (TestDecommission.checkFile((FileSystem)fileSys, file1, replicas, decomNode.getXferAddr(), numDatanodes) != null) continue;
                        break;
                    }
                    catch (InterruptedException interruptedException) {
                    }
                }
                Assert.assertTrue((String)("Checked if block was replicated after decommission, tried " + tries + " times."), (tries < 20 ? 1 : 0) != 0);
                TestDecommission.cleanupFile((FileSystem)fileSys, file1);
            }
        }
        this.shutdownCluster();
        this.startCluster(numNamenodes, numDatanodes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=120000L)
    public void testRecommission() throws Exception {
        int numDatanodes = 6;
        try {
            LOG.info("Starting test testRecommission");
            this.startCluster(1, 6);
            Path file1 = new Path("testDecommission.dat");
            int replicas = 5;
            ArrayList decommissionedNodes = Lists.newArrayList();
            DistributedFileSystem fileSys = this.getCluster().getFileSystem();
            TestDecommission.writeFile((FileSystem)fileSys, file1, 5);
            BlockLocation loc = fileSys.getFileBlockLocations(file1, 0L, 1L)[0];
            Assert.assertEquals((String)"Unexpected number of replicas from getFileBlockLocations", (long)5L, (long)loc.getHosts().length);
            String toDecomHost = loc.getNames()[0];
            String toDecomUuid = null;
            for (DataNode d : this.getCluster().getDataNodes()) {
                if (!d.getDatanodeId().getXferAddr().equals(toDecomHost)) continue;
                toDecomUuid = d.getDatanodeId().getDatanodeUuid();
                break;
            }
            Assert.assertNotNull((String)"Could not find a dn with the block!", toDecomUuid);
            DatanodeInfo decomNode = this.takeNodeOutofService(0, toDecomUuid, 0L, decommissionedNodes, DatanodeInfo.AdminStates.DECOMMISSIONED);
            decommissionedNodes.add(decomNode);
            final BlockManager blockManager = this.getCluster().getNamesystem().getBlockManager();
            DatanodeManager datanodeManager = blockManager.getDatanodeManager();
            BlockManagerTestUtil.recheckDecommissionState(datanodeManager);
            DFSClient client = this.getDfsClient(0);
            Assert.assertEquals((String)"All datanodes must be alive", (long)6L, (long)client.datanodeReport(HdfsConstants.DatanodeReportType.LIVE).length);
            final ExtendedBlock b = DFSTestUtil.getFirstBlock((FileSystem)fileSys, file1);
            final String uuid = toDecomUuid;
            GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

                @Override
                public Boolean get() {
                    BlockInfo info = blockManager.getStoredBlock(b.getLocalBlock());
                    int count = 0;
                    StringBuilder sb = new StringBuilder("Replica locations: ");
                    for (int i = 0; i < info.numNodes(); ++i) {
                        DatanodeDescriptor dn = info.getDatanode(i);
                        sb.append(dn + ", ");
                        if (dn.getDatanodeUuid().equals(uuid)) continue;
                        ++count;
                    }
                    LOG.info(sb.toString());
                    LOG.info("Count: " + count);
                    return count == 5;
                }
            }, (long)500L, (long)30000L);
            this.putNodeInService(0, decomNode);
            BlockManagerTestUtil.recheckDecommissionState(datanodeManager);
            DFSTestUtil.waitForReplication(this.getCluster(), b, 1, 5, 0);
            TestDecommission.cleanupFile((FileSystem)fileSys, file1);
        }
        finally {
            this.shutdownCluster();
        }
    }

    @Test(timeout=360000L)
    public void testClusterStats() throws Exception {
        this.testClusterStats(1);
    }

    @Test(timeout=360000L)
    public void testClusterStatsFederation() throws Exception {
        this.testClusterStats(3);
    }

    public void testClusterStats(int numNameNodes) throws IOException, InterruptedException {
        LOG.info("Starting test testClusterStats");
        int numDatanodes = 1;
        this.startCluster(numNameNodes, numDatanodes);
        for (int i = 0; i < numNameNodes; ++i) {
            DistributedFileSystem fileSys = this.getCluster().getFileSystem(i);
            Path file = new Path("testClusterStats.dat");
            TestDecommission.writeFile((FileSystem)fileSys, file, 1);
            FSNamesystem fsn = this.getCluster().getNamesystem(i);
            NameNode namenode = this.getCluster().getNameNode(i);
            DatanodeInfo decomInfo = this.takeNodeOutofService(i, null, 0L, null, DatanodeInfo.AdminStates.DECOMMISSION_INPROGRESS);
            DataNode decomNode = this.getDataNode(decomInfo);
            this.verifyStats(namenode, fsn, decomInfo, decomNode, true);
            DatanodeDescriptor retInfo = NameNodeAdapter.getDatanode(fsn, (DatanodeID)decomInfo);
            this.putNodeInService(i, (DatanodeInfo)retInfo);
            DataNode retNode = this.getDataNode(decomInfo);
            this.verifyStats(namenode, fsn, (DatanodeInfo)retInfo, retNode, false);
        }
    }

    private DataNode getDataNode(DatanodeInfo decomInfo) {
        DataNode decomNode = null;
        for (DataNode dn : this.getCluster().getDataNodes()) {
            if (!decomInfo.equals((Object)dn.getDatanodeId())) continue;
            decomNode = dn;
            break;
        }
        Assert.assertNotNull((String)"Could not find decomNode in cluster!", decomNode);
        return decomNode;
    }

    @Test(timeout=360000L)
    public void testHostsFile() throws IOException, InterruptedException {
        this.testHostsFile(1);
    }

    @Test(timeout=360000L)
    public void testHostsFileFederation() throws IOException, InterruptedException {
        this.testHostsFile(3);
    }

    public void testHostsFile(int numNameNodes) throws IOException, InterruptedException {
        int numDatanodes = 1;
        this.startCluster(numNameNodes, numDatanodes, true, null, false);
        String bogusIp = "127.0.30.1";
        this.initIncludeHost("127.0.30.1");
        for (int j = 0; j < numNameNodes; ++j) {
            this.refreshNodes(j);
            DFSClient client = this.getDfsClient(j);
            DatanodeInfo[] info = client.datanodeReport(HdfsConstants.DatanodeReportType.LIVE);
            for (int i = 0; i < 5 && info.length != 0; ++i) {
                LOG.info("Waiting for datanode to be marked dead");
                Thread.sleep(1000L);
                info = client.datanodeReport(HdfsConstants.DatanodeReportType.LIVE);
            }
            Assert.assertEquals((String)"Number of live nodes should be 0", (long)0L, (long)info.length);
            info = client.datanodeReport(HdfsConstants.DatanodeReportType.DEAD);
            Assert.assertEquals((String)"There should be 1 dead node", (long)1L, (long)info.length);
            Assert.assertEquals((Object)"127.0.30.1", (Object)info[0].getHostName());
        }
    }

    @Test(timeout=120000L)
    public void testDecommissionWithOpenfile() throws IOException, InterruptedException {
        LOG.info("Starting test testDecommissionWithOpenfile");
        this.startCluster(1, 7);
        DistributedFileSystem fileSys = this.getCluster().getFileSystem(0);
        FSNamesystem ns = this.getCluster().getNamesystem(0);
        String openFile = "/testDecommissionWithOpenfile.dat";
        TestDecommission.writeFile((FileSystem)fileSys, new Path(openFile), 3);
        FSDataOutputStream fdos = fileSys.append(new Path(openFile));
        LocatedBlocks lbs = NameNodeAdapter.getBlockLocations(this.getCluster().getNameNode(0), openFile, 0L, 16384L);
        DatanodeInfo[] dnInfos4LastBlock = lbs.getLastLocatedBlock().getLocations();
        DatanodeInfo[] dnInfos4FirstBlock = lbs.get(0).getLocations();
        ArrayList<String> nodes = new ArrayList<String>();
        ArrayList<DatanodeDescriptor> dnInfos = new ArrayList<DatanodeDescriptor>();
        DatanodeManager dm = ns.getBlockManager().getDatanodeManager();
        DatanodeInfo[] datanodeInfoArray = dnInfos4FirstBlock;
        int n = datanodeInfoArray.length;
        for (int i = 0; i < n; ++i) {
            DatanodeInfo datanodeInfo;
            DatanodeInfo found = datanodeInfo = datanodeInfoArray[i];
            for (DatanodeInfo dif : dnInfos4LastBlock) {
                if (!datanodeInfo.equals((Object)dif)) continue;
                found = null;
            }
            if (found == null) continue;
            nodes.add(found.getXferAddr());
            dnInfos.add(dm.getDatanode((DatanodeID)found));
        }
        nodes.add(dnInfos4LastBlock[0].getXferAddr());
        dnInfos.add(dm.getDatanode((DatanodeID)dnInfos4LastBlock[0]));
        this.initExcludeHosts(nodes);
        this.refreshNodes(0);
        for (DatanodeInfo datanodeInfo : dnInfos) {
            this.waitNodeState(datanodeInfo, DatanodeInfo.AdminStates.DECOMMISSIONED);
        }
        fdos.close();
    }

    private static String scanIntoString(ByteArrayOutputStream baos) {
        TextStringBuilder sb = new TextStringBuilder();
        Scanner scanner = new Scanner(baos.toString());
        while (scanner.hasNextLine()) {
            sb.appendln(scanner.nextLine());
        }
        scanner.close();
        return sb.toString();
    }

    private boolean verifyOpenFilesListing(String message, HashSet<Path> closedFileSet, HashMap<Path, FSDataOutputStream> openFilesMap, ByteArrayOutputStream out, int expOpenFilesListSize) {
        String outStr = TestDecommission.scanIntoString(out);
        LOG.info(message + " - stdout: \n" + outStr);
        for (Path path : closedFileSet) {
            if (!outStr.contains(path.toString())) continue;
            return false;
        }
        HashSet<Path> openFilesNotListed = new HashSet<Path>();
        for (Path openFilePath : openFilesMap.keySet()) {
            if (outStr.contains(openFilePath.toString())) continue;
            openFilesNotListed.add(openFilePath);
        }
        int n = openFilesMap.size() - openFilesNotListed.size();
        if (n >= expOpenFilesListSize) {
            return true;
        }
        LOG.info("Open files that are not listed yet: " + openFilesNotListed);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifyOpenFilesBlockingDecommission(final HashSet<Path> closedFileSet, final HashMap<Path, FSDataOutputStream> openFilesMap, final int maxOpenFiles) throws Exception {
        PrintStream oldStreamOut = System.out;
        try {
            final ByteArrayOutputStream toolOut = new ByteArrayOutputStream();
            System.setOut(new PrintStream(toolOut));
            final DFSAdmin dfsAdmin = new DFSAdmin(this.getConf());
            GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

                @Override
                public Boolean get() {
                    try {
                        boolean result1 = false;
                        boolean result2 = false;
                        toolOut.reset();
                        Assert.assertEquals((long)0L, (long)ToolRunner.run((Tool)dfsAdmin, (String[])new String[]{"-listOpenFiles", "-blockingDecommission"}));
                        toolOut.flush();
                        result1 = TestDecommission.this.verifyOpenFilesListing("dfsadmin -listOpenFiles -blockingDecommission", closedFileSet, openFilesMap, toolOut, maxOpenFiles);
                        if (openFilesMap.size() > 0) {
                            String firstOpenFile = null;
                            HashMap newOpenFilesMap = new HashMap();
                            HashSet newClosedFileSet = new HashSet();
                            for (Map.Entry entry : openFilesMap.entrySet()) {
                                if (firstOpenFile == null) {
                                    newOpenFilesMap.put(entry.getKey(), entry.getValue());
                                    firstOpenFile = ((Path)entry.getKey()).toString();
                                    continue;
                                }
                                newClosedFileSet.add(entry.getKey());
                            }
                            toolOut.reset();
                            Assert.assertEquals((long)0L, (long)ToolRunner.run((Tool)dfsAdmin, (String[])new String[]{"-listOpenFiles", "-blockingDecommission", "-path", firstOpenFile}));
                            toolOut.flush();
                            result2 = TestDecommission.this.verifyOpenFilesListing("dfsadmin -listOpenFiles -blockingDecommission -path" + firstOpenFile, newClosedFileSet, newOpenFilesMap, toolOut, 1);
                        } else {
                            result2 = true;
                        }
                        return result1 && result2;
                    }
                    catch (Exception e) {
                        LOG.warn("Unexpected exception: " + e);
                        return false;
                    }
                }
            }, (long)1000L, (long)60000L);
        }
        finally {
            System.setOut(oldStreamOut);
        }
    }

    @Test(timeout=180000L)
    public void testDecommissionWithOpenfileReporting() throws Exception {
        LOG.info("Starting test testDecommissionWithOpenfileReporting");
        this.getConf().setInt("dfs.namenode.redundancy.interval.seconds", 1000);
        this.getConf().setLong("dfs.namenode.list.openfiles.num.responses", 1L);
        this.startSimpleCluster(1, 4);
        DistributedFileSystem fileSys = this.getCluster().getFileSystem(0);
        FSNamesystem ns = this.getCluster().getNamesystem(0);
        String[] closedFiles = new String[3];
        String[] openFiles = new String[3];
        HashSet<Path> closedFileSet = new HashSet<Path>();
        HashMap<Path, FSDataOutputStream> openFilesMap = new HashMap<Path, FSDataOutputStream>();
        for (int i = 0; i < 3; ++i) {
            closedFiles[i] = "/testDecommissionWithOpenfileReporting.closed." + i;
            openFiles[i] = "/testDecommissionWithOpenfileReporting.open." + i;
            TestDecommission.writeFile((FileSystem)fileSys, new Path(closedFiles[i]), 3, 10);
            closedFileSet.add(new Path(closedFiles[i]));
            TestDecommission.writeFile((FileSystem)fileSys, new Path(openFiles[i]), 3, 10);
            FSDataOutputStream fdos = fileSys.append(new Path(openFiles[i]));
            openFilesMap.put(new Path(openFiles[i]), fdos);
        }
        HashMap<DatanodeInfo, Integer> dnInfoMap = new HashMap<DatanodeInfo, Integer>();
        for (int i = 0; i < 3; ++i) {
            LocatedBlocks lbs = NameNodeAdapter.getBlockLocations(this.getCluster().getNameNode(0), openFiles[i], 0L, 81920L);
            for (DatanodeInfo dn : lbs.getLastLocatedBlock().getLocations()) {
                if (dnInfoMap.containsKey(dn)) {
                    dnInfoMap.put(dn, (Integer)dnInfoMap.get(dn) + 1);
                    continue;
                }
                dnInfoMap.put(dn, 1);
            }
        }
        DatanodeInfo dnToDecommission = null;
        int maxDnOccurance = 0;
        for (Map.Entry entry : dnInfoMap.entrySet()) {
            if ((Integer)entry.getValue() <= maxDnOccurance) continue;
            maxDnOccurance = (Integer)entry.getValue();
            dnToDecommission = (DatanodeInfo)entry.getKey();
        }
        LOG.info("XXX Dn to decommission: " + dnToDecommission + ", max: " + maxDnOccurance);
        DatanodeManager dm = ns.getBlockManager().getDatanodeManager();
        ArrayList<String> nodes = new ArrayList<String>();
        dnToDecommission = dm.getDatanode(dnToDecommission.getDatanodeUuid());
        nodes.add(dnToDecommission.getXferAddr());
        this.initExcludeHosts(nodes);
        this.refreshNodes(0);
        this.waitNodeState(dnToDecommission, DatanodeInfo.AdminStates.DECOMMISSION_INPROGRESS);
        this.verifyOpenFilesBlockingDecommission(closedFileSet, openFilesMap, maxDnOccurance);
        final AtomicBoolean stopRedundancyMonitor = new AtomicBoolean(false);
        Thread monitorThread = new Thread(new Runnable(){

            @Override
            public void run() {
                while (!stopRedundancyMonitor.get()) {
                    try {
                        BlockManagerTestUtil.checkRedundancy(TestDecommission.this.getCluster().getNamesystem().getBlockManager());
                        BlockManagerTestUtil.updateState(TestDecommission.this.getCluster().getNamesystem().getBlockManager());
                        Thread.sleep(1000L);
                    }
                    catch (Exception e) {
                        LOG.warn("Encountered exception during redundancy monitor: " + e);
                    }
                }
            }
        });
        monitorThread.start();
        this.waitNodeState(dnToDecommission, DatanodeInfo.AdminStates.DECOMMISSIONED);
        stopRedundancyMonitor.set(true);
        monitorThread.join();
        openFilesMap.clear();
        this.verifyOpenFilesBlockingDecommission(closedFileSet, openFilesMap, 0);
    }

    @Test(timeout=360000L)
    public void testDecommissionWithOpenFileAndBlockRecovery() throws IOException, InterruptedException {
        long writtenBytes;
        this.startCluster(1, 6);
        this.getCluster().waitActive();
        Path file = new Path("/testRecoveryDecommission");
        DistributedFileSystem dfs = this.getCluster().getFileSystem();
        FSDataOutputStream out = dfs.create(file, true, this.getConf().getInt("io.file.buffer.size", 4096), (short)3, 8192L);
        for (writtenBytes = 0L; writtenBytes < 16384L; writtenBytes += 8L) {
            out.writeLong(writtenBytes);
        }
        out.hsync();
        DatanodeInfo[] lastBlockLocations = NameNodeAdapter.getBlockLocations(this.getCluster().getNameNode(), "/testRecoveryDecommission", 0L, 16384L).getLastLocatedBlock().getLocations();
        ArrayList<String> toDecom = new ArrayList<String>();
        for (DatanodeInfo dnDecom : lastBlockLocations) {
            toDecom.add(dnDecom.getXferAddr());
        }
        this.initExcludeHosts(toDecom);
        this.refreshNodes(0);
        this.getCluster().setLeasePeriod(300L, 300L);
        Thread.sleep(2000L);
        for (DatanodeInfo dnDecom : lastBlockLocations) {
            DatanodeDescriptor datanode = NameNodeAdapter.getDatanode(this.getCluster().getNamesystem(), (DatanodeID)dnDecom);
            this.waitNodeState((DatanodeInfo)datanode, DatanodeInfo.AdminStates.DECOMMISSIONED);
        }
        Assert.assertEquals((long)dfs.getFileStatus(file).getLen(), (long)writtenBytes);
    }

    @Test(timeout=120000L)
    public void testCloseWhileDecommission() throws IOException, ExecutionException, InterruptedException {
        LOG.info("Starting test testCloseWhileDecommission");
        this.getConf().setInt("dfs.namenode.replication.min", 2);
        this.startCluster(1, 3);
        DistributedFileSystem fileSys = this.getCluster().getFileSystem(0);
        FSNamesystem ns = this.getCluster().getNamesystem(0);
        String openFile = "/testDecommissionWithOpenfile.dat";
        TestDecommission.writeFile((FileSystem)fileSys, new Path(openFile), 3);
        FSDataOutputStream fdos = fileSys.append(new Path(openFile));
        byte[] bytes = new byte[1];
        fdos.write(bytes);
        fdos.hsync();
        LocatedBlocks lbs = NameNodeAdapter.getBlockLocations(this.getCluster().getNameNode(0), openFile, 0L, 16384L);
        DatanodeInfo[] dnInfos4LastBlock = lbs.getLastLocatedBlock().getLocations();
        ArrayList<String> nodes = new ArrayList<String>();
        ArrayList<DatanodeDescriptor> dnInfos = new ArrayList<DatanodeDescriptor>();
        DatanodeManager dm = ns.getBlockManager().getDatanodeManager();
        nodes.add(dnInfos4LastBlock[0].getXferAddr());
        dnInfos.add(dm.getDatanode((DatanodeID)dnInfos4LastBlock[0]));
        nodes.add(dnInfos4LastBlock[1].getXferAddr());
        dnInfos.add(dm.getDatanode((DatanodeID)dnInfos4LastBlock[1]));
        this.initExcludeHosts(nodes);
        this.refreshNodes(0);
        fdos.close();
        BlockManagerTestUtil.recheckDecommissionState(dm);
        this.assertTrackedAndPending(dm.getDatanodeAdminManager(), 2, 0);
    }

    @Test(timeout=120000L)
    public void testAllocAndIBRWhileDecommission() throws IOException {
        LOG.info("Starting test testAllocAndIBRWhileDecommission");
        this.startCluster(1, 6);
        this.getCluster().waitActive();
        FSNamesystem ns = this.getCluster().getNamesystem(0);
        DatanodeManager dm = ns.getBlockManager().getDatanodeManager();
        Path file = new Path("/testAllocAndIBRWhileDecommission");
        DistributedFileSystem dfs = this.getCluster().getFileSystem();
        FSDataOutputStream out = dfs.create(file, true, this.getConf().getInt("io.file.buffer.size", 4096), (short)3, 8192L);
        long writtenBytes = 0L;
        while (writtenBytes + 8L < 8192L) {
            out.writeLong(writtenBytes);
            writtenBytes += 8L;
        }
        out.hsync();
        LocatedBlock firstLocatedBlock = NameNodeAdapter.getBlockLocations(this.getCluster().getNameNode(), "/testAllocAndIBRWhileDecommission", 0L, 16384L).getLastLocatedBlock();
        DatanodeInfo[] firstBlockLocations = firstLocatedBlock.getLocations();
        ArrayList<String> toDecom = new ArrayList<String>();
        ArrayList<DatanodeDescriptor> decomDNInfos = new ArrayList<DatanodeDescriptor>();
        for (DatanodeInfo datanodeInfo : firstBlockLocations) {
            toDecom.add(datanodeInfo.getXferAddr());
            decomDNInfos.add(dm.getDatanode((DatanodeID)datanodeInfo));
            DataNode dn = this.getDataNode(datanodeInfo);
            DataNodeTestUtils.triggerHeartbeat(dn);
            DataNodeTestUtils.pauseIBR(dn);
        }
        while (writtenBytes <= 8192L) {
            out.writeLong(writtenBytes);
            writtenBytes += 8L;
        }
        out.hsync();
        Assert.assertEquals((Object)HdfsServerConstants.BlockUCState.COMMITTED, (Object)((BlockInfo)firstLocatedBlock.getBlock().getLocalBlock()).getBlockUCState());
        this.initExcludeHosts(toDecom);
        this.refreshNodes(0);
        for (DatanodeInfo datanodeInfo : decomDNInfos) {
            this.waitNodeState(datanodeInfo, DatanodeInfo.AdminStates.DECOMMISSION_INPROGRESS);
            DataNodeTestUtils.resumeIBR(this.getDataNode(datanodeInfo));
        }
        for (DataNode dataNode : this.getCluster().getDataNodes()) {
            DataNodeTestUtils.triggerHeartbeat(dataNode);
        }
        Assert.assertEquals((Object)HdfsServerConstants.BlockUCState.COMPLETE, (Object)((BlockInfo)firstLocatedBlock.getBlock().getLocalBlock()).getBlockUCState());
        out.close();
        this.shutdownCluster();
    }

    @Test(timeout=360000L)
    public void testDecommissionWithNamenodeRestart() throws IOException, InterruptedException {
        LOG.info("Starting test testDecommissionWithNamenodeRestart");
        int numNamenodes = 1;
        int numDatanodes = 1;
        int replicas = 1;
        this.getConf().setLong("dfs.blockreport.intervalMsec", 21600000L);
        this.getConf().setLong("dfs.blockreport.initialDelay", 5L);
        this.startCluster(numNamenodes, numDatanodes);
        Path file1 = new Path("testDecommissionWithNamenodeRestart.dat");
        DistributedFileSystem fileSys = this.getCluster().getFileSystem();
        TestDecommission.writeFile((FileSystem)fileSys, file1, replicas);
        DFSClient client = this.getDfsClient(0);
        DatanodeInfo[] info = client.datanodeReport(HdfsConstants.DatanodeReportType.LIVE);
        DatanodeInfo excludedDatanodeID = info[0];
        String excludedDatanodeName = info[0].getXferAddr();
        this.initExcludeHost(excludedDatanodeName);
        this.getCluster().startDataNodes(this.getConf(), 1, true, null, null, null, null);
        Assert.assertEquals((String)"Number of datanodes should be 2 ", (long)2L, (long)this.getCluster().getDataNodes().size());
        this.getCluster().restartNameNode(new String[0]);
        DatanodeDescriptor datanodeInfo = NameNodeAdapter.getDatanode(this.getCluster().getNamesystem(), (DatanodeID)excludedDatanodeID);
        this.waitNodeState((DatanodeInfo)datanodeInfo, DatanodeInfo.AdminStates.DECOMMISSIONED);
        Assert.assertEquals((String)"All datanodes must be alive", (long)(++numDatanodes), (long)client.datanodeReport(HdfsConstants.DatanodeReportType.LIVE).length);
        Assert.assertTrue((String)"Checked if block was replicated after decommission.", (TestDecommission.checkFile((FileSystem)fileSys, file1, replicas, datanodeInfo.getXferAddr(), numDatanodes) == null ? 1 : 0) != 0);
        TestDecommission.cleanupFile((FileSystem)fileSys, file1);
        this.shutdownCluster();
        this.startCluster(numNamenodes, numDatanodes);
    }

    @Test(timeout=360000L)
    public void testDeadNodeCountAfterNamenodeRestart() throws Exception {
        LOG.info("Starting test testDeadNodeCountAfterNamenodeRestart");
        int numNamenodes = 1;
        int numDatanodes = 2;
        this.startCluster(numNamenodes, numDatanodes);
        DFSClient client = this.getDfsClient(0);
        DatanodeInfo[] info = client.datanodeReport(HdfsConstants.DatanodeReportType.LIVE);
        DatanodeInfo excludedDatanode = info[0];
        String excludedDatanodeName = info[0].getXferAddr();
        ArrayList<String> hosts = new ArrayList<String>(Arrays.asList(excludedDatanodeName, info[1].getXferAddr()));
        this.initIncludeHosts(hosts.toArray(new String[hosts.size()]));
        this.takeNodeOutofService(0, excludedDatanode.getDatanodeUuid(), 0L, null, DatanodeInfo.AdminStates.DECOMMISSIONED);
        this.getCluster().stopDataNode(excludedDatanodeName);
        DFSTestUtil.waitForDatanodeState(this.getCluster(), excludedDatanode.getDatanodeUuid(), false, 20000);
        this.getCluster().restartNameNode(new String[0]);
        Assert.assertEquals((String)"There should be one node alive", (long)1L, (long)client.datanodeReport(HdfsConstants.DatanodeReportType.LIVE).length);
        Assert.assertEquals((String)"There should be one node dead", (long)1L, (long)client.datanodeReport(HdfsConstants.DatanodeReportType.DEAD).length);
    }

    @Ignore
    @Test(timeout=360000L)
    public void testIncludeByRegistrationName() throws Exception {
        String registrationName = "127.0.0.100";
        String nonExistentDn = "127.0.0.10";
        this.getConf().set("dfs.datanode.hostname", "127.0.0.100");
        this.startCluster(1, 1, false, null, true);
        this.initIncludeHost("127.0.0.10");
        this.refreshNodes(0);
        LOG.info("Waiting for DN to be marked as dead.");
        final DFSClient client = this.getDfsClient(0);
        GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

            @Override
            public Boolean get() {
                BlockManagerTestUtil.checkHeartbeat(TestDecommission.this.getCluster().getNamesystem().getBlockManager());
                try {
                    DatanodeInfo[] info = client.datanodeReport(HdfsConstants.DatanodeReportType.DEAD);
                    return info.length == 1;
                }
                catch (IOException e) {
                    LOG.warn("Failed to check dead DNs", (Throwable)e);
                    return false;
                }
            }
        }, (long)500L, (long)5000L);
        int dnPort = this.getCluster().getDataNodes().get(0).getXferPort();
        this.initIncludeHost("127.0.0.100:" + dnPort);
        this.refreshNodes(0);
        this.getCluster().restartDataNode(0);
        this.getCluster().triggerHeartbeats();
        LOG.info("Waiting for DN to come back.");
        GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

            @Override
            public Boolean get() {
                BlockManagerTestUtil.checkHeartbeat(TestDecommission.this.getCluster().getNamesystem().getBlockManager());
                try {
                    DatanodeInfo[] info = client.datanodeReport(HdfsConstants.DatanodeReportType.LIVE);
                    if (info.length == 1) {
                        Assert.assertFalse((boolean)info[0].isDecommissioned());
                        Assert.assertFalse((boolean)info[0].isDecommissionInProgress());
                        Assert.assertEquals((Object)"127.0.0.100", (Object)info[0].getHostName());
                        return true;
                    }
                }
                catch (IOException e) {
                    LOG.warn("Failed to check dead DNs", (Throwable)e);
                }
                return false;
            }
        }, (long)500L, (long)5000L);
    }

    @Test(timeout=120000L)
    public void testBlocksPerInterval() throws Exception {
        org.apache.log4j.Logger.getLogger(DatanodeAdminManager.class).setLevel(Level.TRACE);
        this.getConf().setInt("dfs.namenode.decommission.blocks.per.interval", 3);
        this.getConf().setInt("dfs.namenode.decommission.interval", Integer.MAX_VALUE);
        this.startCluster(1, 3);
        DistributedFileSystem fs = this.getCluster().getFileSystem();
        DatanodeManager datanodeManager = this.getCluster().getNamesystem().getBlockManager().getDatanodeManager();
        DatanodeAdminManager decomManager = datanodeManager.getDatanodeAdminManager();
        DFSTestUtil.createFile((FileSystem)fs, new Path("/file1"), 64L, (short)3, 195894762L);
        this.doDecomCheck(datanodeManager, decomManager, 3);
        DFSTestUtil.createFile((FileSystem)fs, new Path("/file2"), 64L, (short)3, 195894762L);
        this.doDecomCheck(datanodeManager, decomManager, 2);
        DFSTestUtil.createFile((FileSystem)fs, new Path("/file3"), 64L, (short)3, 195894762L);
        this.doDecomCheck(datanodeManager, decomManager, 1);
        DFSTestUtil.createFile((FileSystem)fs, new Path("/file4"), 64L, (short)3, 195894762L);
        this.doDecomCheck(datanodeManager, decomManager, 1);
    }

    private void doDecomCheck(DatanodeManager datanodeManager, DatanodeAdminManager decomManager, int expectedNumCheckedNodes) throws IOException, ExecutionException, InterruptedException {
        ArrayList decommissionedNodes = Lists.newArrayList();
        for (DataNode d : this.getCluster().getDataNodes()) {
            DatanodeInfo dn = this.takeNodeOutofService(0, d.getDatanodeUuid(), 0L, decommissionedNodes, DatanodeInfo.AdminStates.DECOMMISSION_INPROGRESS);
            decommissionedNodes.add(dn);
        }
        BlockManagerTestUtil.recheckDecommissionState(datanodeManager);
        Assert.assertEquals((String)"Unexpected # of nodes checked", (long)expectedNumCheckedNodes, (long)decomManager.getNumNodesChecked());
        for (DatanodeInfo dn : decommissionedNodes) {
            this.putNodeInService(0, dn);
        }
    }

    @Test(timeout=120000L)
    public void testPendingNodeButDecommissioned() throws Exception {
        this.getConf().setInt("dfs.namenode.decommission.max.concurrent.tracked.nodes", 1);
        this.getConf().setInt("dfs.namenode.decommission.interval", Integer.MAX_VALUE);
        this.startCluster(1, 2);
        DatanodeManager datanodeManager = this.getCluster().getNamesystem().getBlockManager().getDatanodeManager();
        DatanodeAdminManager decomManager = datanodeManager.getDatanodeAdminManager();
        ArrayList decommissionedNodes = Lists.newArrayList();
        ArrayList<DataNode> dns = this.getCluster().getDataNodes();
        for (int i = 0; i < 2; ++i) {
            DataNode d = (DataNode)dns.get(i);
            DatanodeInfo dn = this.takeNodeOutofService(0, d.getDatanodeUuid(), 0L, decommissionedNodes, DatanodeInfo.AdminStates.DECOMMISSION_INPROGRESS);
            decommissionedNodes.add(dn);
        }
        Assert.assertEquals((long)2L, (long)decomManager.getNumPendingNodes());
        DatanodeDescriptor dn = datanodeManager.getDatanode(((DataNode)dns.get(0)).getDatanodeId());
        dn.setDecommissioned();
        try {
            BlockManagerTestUtil.recheckDecommissionState(datanodeManager);
            GenericTestUtils.waitFor(() -> decomManager.getNumTrackedNodes() == 0, (long)500L, (long)30000L);
            Assert.assertTrue((boolean)GenericTestUtils.anyThreadMatching((Pattern)Pattern.compile("DatanodeAdminMonitor-.*")));
        }
        catch (ExecutionException e) {
            GenericTestUtils.assertExceptionContains((String)"in an invalid state!", (Throwable)e);
            Assert.fail((String)"DatanodeAdminManager#monitor does not swallow exceptions.");
        }
    }

    @Test(timeout=120000L)
    public void testPendingNodes() throws Exception {
        int i;
        org.apache.log4j.Logger.getLogger(DatanodeAdminManager.class).setLevel(Level.TRACE);
        this.getConf().setInt("dfs.namenode.decommission.max.concurrent.tracked.nodes", 1);
        this.getConf().setInt("dfs.namenode.decommission.interval", Integer.MAX_VALUE);
        this.startCluster(1, 3);
        DistributedFileSystem fs = this.getCluster().getFileSystem();
        DatanodeManager datanodeManager = this.getCluster().getNamesystem().getBlockManager().getDatanodeManager();
        DatanodeAdminManager decomManager = datanodeManager.getDatanodeAdminManager();
        HdfsDataOutputStream open1 = (HdfsDataOutputStream)fs.create(new Path("/openFile1"), (short)3);
        open1.write(123);
        open1.hflush();
        for (DataNode d : this.getCluster().getDataNodes()) {
            DataNodeTestUtils.triggerBlockReport(d);
        }
        ArrayList decommissionedNodes = Lists.newArrayList();
        for (i = 0; i < 2; ++i) {
            DataNode d = this.getCluster().getDataNodes().get(i);
            DatanodeInfo dn = this.takeNodeOutofService(0, d.getDatanodeUuid(), 0L, decommissionedNodes, DatanodeInfo.AdminStates.DECOMMISSION_INPROGRESS);
            decommissionedNodes.add(dn);
        }
        for (i = 2; i >= 0; --i) {
            this.assertTrackedAndPending(decomManager, 0, i);
            BlockManagerTestUtil.recheckDecommissionState(datanodeManager);
        }
        open1.close();
        DataNode d = this.getCluster().getDataNodes().get(2);
        DatanodeInfo dn = this.takeNodeOutofService(0, d.getDatanodeUuid(), 0L, decommissionedNodes, DatanodeInfo.AdminStates.DECOMMISSION_INPROGRESS);
        decommissionedNodes.add(dn);
        BlockManagerTestUtil.recheckDecommissionState(datanodeManager);
        this.assertTrackedAndPending(decomManager, 1, 0);
    }

    private void assertTrackedAndPending(DatanodeAdminManager decomManager, int tracked, int pending) {
        Assert.assertEquals((String)"Unexpected number of tracked nodes", (long)tracked, (long)decomManager.getNumTrackedNodes());
        Assert.assertEquals((String)"Unexpected number of pending nodes", (long)pending, (long)decomManager.getNumPendingNodes());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCountOnDecommissionedNodeList() throws IOException {
        this.getConf().setInt("dfs.heartbeat.interval", 1);
        this.getConf().setInt("dfs.namenode.heartbeat.recheck-interval", 1);
        try {
            this.startCluster(1, 1);
            ArrayList namenodeDecomList = new ArrayList(1);
            namenodeDecomList.add(0, new ArrayList(1));
            ArrayList decommissionedNode = (ArrayList)namenodeDecomList.get(0);
            this.takeNodeOutofService(0, null, 0L, decommissionedNode, DatanodeInfo.AdminStates.DECOMMISSIONED);
            FSNamesystem ns = this.getCluster().getNamesystem(0);
            DatanodeManager datanodeManager = ns.getBlockManager().getDatanodeManager();
            ArrayList live = new ArrayList();
            datanodeManager.fetchDatanodes(live, null, false);
            Assert.assertTrue((1 == live.size() ? 1 : 0) != 0);
            datanodeManager.fetchDatanodes(live, null, true);
            Assert.assertTrue((0 == live.size() ? 1 : 0) != 0);
        }
        finally {
            this.shutdownCluster();
        }
    }

    @Test
    public void testNodeUsageAfterDecommissioned() throws IOException, InterruptedException {
        this.nodeUsageVerification(2, new long[]{26384L, 26384L}, DatanodeInfo.AdminStates.DECOMMISSIONED);
    }

    @Test
    public void testNodeUsageWhileDecommissioining() throws IOException, InterruptedException {
        this.nodeUsageVerification(1, new long[]{26384L}, DatanodeInfo.AdminStates.DECOMMISSION_INPROGRESS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void nodeUsageVerification(int numDatanodes, long[] nodesCapacity, DatanodeInfo.AdminStates decommissionState) throws IOException, InterruptedException {
        Map usage = null;
        DatanodeInfo decommissionedNodeInfo = null;
        String zeroNodeUsage = "0.00%";
        this.getConf().setInt("dfs.replication", 1);
        this.getConf().setInt("dfs.heartbeat.interval", 1);
        this.getConf().setInt("dfs.namenode.heartbeat.recheck-interval", 1);
        DistributedFileSystem fileSys = null;
        Path file1 = new Path("testNodeUsage.dat");
        try {
            SimulatedFSDataset.setFactory(this.getConf());
            this.startCluster(1, numDatanodes, false, nodesCapacity, false);
            ArrayList namenodeDecomList = new ArrayList(1);
            namenodeDecomList.add(0, new ArrayList(numDatanodes));
            if (decommissionState == DatanodeInfo.AdminStates.DECOMMISSIONED) {
                ArrayList decommissionedNode = (ArrayList)namenodeDecomList.get(0);
                decommissionedNodeInfo = this.takeNodeOutofService(0, null, 0L, decommissionedNode, decommissionState);
            }
            fileSys = this.getCluster().getFileSystem(0);
            FSNamesystem ns = this.getCluster().getNamesystem(0);
            TestDecommission.writeFile((FileSystem)fileSys, file1, 1);
            Thread.sleep(2000L);
            usage = (Map)JSON.parse((String)ns.getNodeUsage());
            String minUsageBeforeDecom = (String)((Map)usage.get("nodeUsage")).get("min");
            Assert.assertTrue((!minUsageBeforeDecom.equalsIgnoreCase(zeroNodeUsage) ? 1 : 0) != 0);
            if (decommissionState == DatanodeInfo.AdminStates.DECOMMISSION_INPROGRESS) {
                ArrayList decommissioningNodes = (ArrayList)namenodeDecomList.get(0);
                decommissionedNodeInfo = this.takeNodeOutofService(0, null, 0L, decommissioningNodes, decommissionState);
                usage = (Map)JSON.parse((String)ns.getNodeUsage());
                Assert.assertTrue((boolean)((String)((Map)usage.get("nodeUsage")).get("min")).equalsIgnoreCase(zeroNodeUsage));
            }
            this.putNodeInService(0, decommissionedNodeInfo);
            usage = (Map)JSON.parse((String)ns.getNodeUsage());
            String nodeusageAfterRecommi = decommissionState == DatanodeInfo.AdminStates.DECOMMISSION_INPROGRESS ? minUsageBeforeDecom : zeroNodeUsage;
            Assert.assertTrue((boolean)((String)((Map)usage.get("nodeUsage")).get("min")).equalsIgnoreCase(nodeusageAfterRecommi));
        }
        catch (Throwable throwable) {
            TestDecommission.cleanupFile(fileSys, file1);
            throw throwable;
        }
        TestDecommission.cleanupFile((FileSystem)fileSys, file1);
    }

    @Test
    public void testUsedCapacity() throws Exception {
        int numNamenodes = 1;
        int numDatanodes = 2;
        this.startCluster(numNamenodes, numDatanodes);
        FSNamesystem ns = this.getCluster().getNamesystem(0);
        BlockManager blockManager = ns.getBlockManager();
        DatanodeStatistics datanodeStatistics = blockManager.getDatanodeManager().getDatanodeStatistics();
        long initialUsedCapacity = datanodeStatistics.getCapacityUsed();
        long initialTotalCapacity = datanodeStatistics.getCapacityTotal();
        long initialBlockPoolUsed = datanodeStatistics.getBlockPoolUsed();
        ArrayList namenodeDecomList = new ArrayList(numNamenodes);
        namenodeDecomList.add(0, new ArrayList(numDatanodes));
        ArrayList decommissionedNodes = (ArrayList)namenodeDecomList.get(0);
        DatanodeInfo decomNode = this.takeNodeOutofService(0, null, 0L, decommissionedNodes, DatanodeInfo.AdminStates.DECOMMISSIONED);
        decommissionedNodes.add(decomNode);
        long newUsedCapacity = datanodeStatistics.getCapacityUsed();
        long newTotalCapacity = datanodeStatistics.getCapacityTotal();
        long newBlockPoolUsed = datanodeStatistics.getBlockPoolUsed();
        Assert.assertTrue((String)"DfsUsedCapacity should not be the same after a node has been decommissioned!", (initialUsedCapacity != newUsedCapacity ? 1 : 0) != 0);
        Assert.assertTrue((String)"TotalCapacity should not be the same after a node has been decommissioned!", (initialTotalCapacity != newTotalCapacity ? 1 : 0) != 0);
        Assert.assertTrue((String)"BlockPoolUsed should not be the same after a node has been decommissioned!", (initialBlockPoolUsed != newBlockPoolUsed ? 1 : 0) != 0);
    }

    @Test(timeout=360000L)
    public void testMultipleNodesDecommission() throws Exception {
        this.startCluster(1, 5);
        Path file = new Path("/testMultipleNodesDecommission.dat");
        DistributedFileSystem fileSys = this.getCluster().getFileSystem(0);
        FSNamesystem ns = this.getCluster().getNamesystem(0);
        int repl = 3;
        TestDecommission.writeFile((FileSystem)fileSys, file, repl, 1);
        List<DatanodeInfo> decomDataNodes = this.takeNodeOutofService(0, Lists.newArrayList((Object[])new String[]{this.getCluster().getDataNodes().get(0).getDatanodeUuid(), this.getCluster().getDataNodes().get(1).getDatanodeUuid()}), Long.MAX_VALUE, null, null, DatanodeInfo.AdminStates.DECOMMISSIONED);
        GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>((FileSystem)fileSys, file, repl, decomDataNodes){
            final /* synthetic */ FileSystem val$fileSys;
            final /* synthetic */ Path val$file;
            final /* synthetic */ int val$repl;
            final /* synthetic */ List val$decomDataNodes;
            {
                this.val$fileSys = fileSystem;
                this.val$file = path;
                this.val$repl = n;
                this.val$decomDataNodes = list;
            }

            @Override
            public Boolean get() {
                try {
                    String errMsg = TestDecommission.checkFile(this.val$fileSys, this.val$file, this.val$repl, ((DatanodeInfo)this.val$decomDataNodes.get(0)).getXferAddr(), 5);
                    if (errMsg != null) {
                        LOG.warn("Check file: " + errMsg);
                    }
                    return true;
                }
                catch (IOException e) {
                    LOG.warn("Check file: " + e);
                    return false;
                }
            }
        }, (long)500L, (long)30000L);
        for (DatanodeInfo datanodeInfo : decomDataNodes) {
            this.putNodeInService(0, datanodeInfo);
        }
        TestDecommission.cleanupFile((FileSystem)fileSys, file);
    }
}

