/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.tools;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.SystemErasureCodingPolicies;
import org.apache.hadoop.hdfs.tools.ECAdmin;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestECAdmin {
    public static final Logger LOG = LoggerFactory.getLogger(TestECAdmin.class);
    private Configuration conf = new Configuration();
    private MiniDFSCluster cluster;
    private ECAdmin admin = new ECAdmin(this.conf);
    private final ByteArrayOutputStream out = new ByteArrayOutputStream();
    private final ByteArrayOutputStream err = new ByteArrayOutputStream();
    private static final PrintStream OLD_OUT = System.out;
    private static final PrintStream OLD_ERR = System.err;
    @Rule
    public Timeout globalTimeout = new Timeout(300000);

    @Before
    public void setup() throws Exception {
        System.setOut(new PrintStream(this.out));
        System.setErr(new PrintStream(this.err));
    }

    @After
    public void tearDown() throws Exception {
        try {
            System.out.flush();
            System.err.flush();
            this.resetOutputs();
        }
        finally {
            System.setOut(OLD_OUT);
            System.setErr(OLD_ERR);
        }
        if (this.cluster != null) {
            this.cluster.shutdown();
            this.cluster = null;
        }
    }

    @Test
    public void testRS63MinDN() throws Exception {
        this.cluster = DFSTestUtil.setupCluster(this.conf, 6, 3, 0);
        String[] args = new String[]{"-verifyClusterSetup"};
        int ret = this.admin.run(args);
        LOG.info("Command stdout: {}", (Object)this.out.toString());
        LOG.info("Command stderr: {}", (Object)this.err.toString());
        Assert.assertEquals((String)"Return value of the command is not successful", (long)2L, (long)ret);
        Assert.assertTrue((String)"Result of cluster topology verify should be logged correctly", (boolean)this.out.toString().contains("less than the minimum required number of DataNodes"));
        Assert.assertTrue((String)"Error output should be empty", (boolean)this.err.toString().isEmpty());
    }

    @Test
    public void testRS104MinRacks() throws Exception {
        this.cluster = DFSTestUtil.setupCluster(this.conf, 15, 3, 0);
        this.cluster.getFileSystem().enableErasureCodingPolicy(SystemErasureCodingPolicies.getByID((byte)5).getName());
        String[] args = new String[]{"-verifyClusterSetup"};
        int ret = this.admin.run(args);
        LOG.info("Command stdout: {}", (Object)this.out.toString());
        LOG.info("Command stderr: {}", (Object)this.err.toString());
        Assert.assertEquals((String)"Return value of the command is not successful", (long)2L, (long)ret);
        Assert.assertTrue((String)"Result of cluster topology verify should be logged correctly", (boolean)this.out.toString().contains("less than the minimum required number of racks"));
        Assert.assertTrue((String)"Error output should be empty", (boolean)this.err.toString().isEmpty());
    }

    @Test
    public void testXOR21MinRacks() throws Exception {
        this.cluster = DFSTestUtil.setupCluster(this.conf, 5, 2, 0);
        this.cluster.getFileSystem().disableErasureCodingPolicy(SystemErasureCodingPolicies.getByID((byte)1).getName());
        this.cluster.getFileSystem().enableErasureCodingPolicy(SystemErasureCodingPolicies.getByID((byte)4).getName());
        String[] args = new String[]{"-verifyClusterSetup"};
        int ret = this.admin.run(args);
        LOG.info("Command stdout: {}", (Object)this.out.toString());
        LOG.info("Command stderr: {}", (Object)this.err.toString());
        Assert.assertEquals((String)"Return value of the command is not successful", (long)2L, (long)ret);
        Assert.assertTrue((String)"Result of cluster topology verify should be logged correctly", (boolean)this.out.toString().contains("less than the minimum required number of racks"));
        Assert.assertTrue((String)"Error output should be empty", (boolean)this.err.toString().isEmpty());
    }

    @Test
    public void testRS32MinRacks() throws Exception {
        this.cluster = DFSTestUtil.setupCluster(this.conf, 5, 2, 0);
        this.cluster.getFileSystem().disableErasureCodingPolicy(SystemErasureCodingPolicies.getByID((byte)1).getName());
        this.cluster.getFileSystem().enableErasureCodingPolicy(SystemErasureCodingPolicies.getByID((byte)2).getName());
        String[] args = new String[]{"-verifyClusterSetup"};
        int ret = this.admin.run(args);
        LOG.info("Command stdout: {}", (Object)this.out.toString());
        LOG.info("Command stderr: {}", (Object)this.err.toString());
        Assert.assertEquals((String)"Return value of the command is not successful", (long)2L, (long)ret);
        Assert.assertTrue((String)"Result of cluster topology verify should be logged correctly", (boolean)this.out.toString().contains("less than the minimum required number of racks"));
        Assert.assertTrue((String)"Error output should be empty", (boolean)this.err.toString().isEmpty());
    }

    @Test
    public void testRS63Good() throws Exception {
        this.cluster = DFSTestUtil.setupCluster(this.conf, 9, 3, 0);
        String[] args = new String[]{"-verifyClusterSetup"};
        int ret = this.admin.run(args);
        LOG.info("Command stdout: {}", (Object)this.out.toString());
        LOG.info("Command stderr: {}", (Object)this.err.toString());
        Assert.assertEquals((String)"Return value of the command is successful", (long)0L, (long)ret);
        Assert.assertTrue((String)"Result of cluster topology verify should be logged correctly", (boolean)this.out.toString().contains("The cluster setup can support EC policies: RS-6-3-1024k"));
        Assert.assertTrue((String)"Error output should be empty", (boolean)this.err.toString().isEmpty());
    }

    @Test
    public void testNoECEnabled() throws Exception {
        this.cluster = DFSTestUtil.setupCluster(this.conf, 9, 3, 0);
        this.cluster.getFileSystem().disableErasureCodingPolicy(SystemErasureCodingPolicies.getByID((byte)1).getName());
        String[] args = new String[]{"-verifyClusterSetup"};
        int ret = this.admin.run(args);
        LOG.info("Command stdout: {}", (Object)this.out.toString());
        LOG.info("Command stderr: {}", (Object)this.err.toString());
        Assert.assertEquals((String)"Return value of the command is successful", (long)0L, (long)ret);
        Assert.assertTrue((String)"Result of cluster topology verify should be logged correctly", (boolean)this.out.toString().contains("No erasure coding policy is given"));
        Assert.assertTrue((String)"Error output should be empty", (boolean)this.err.toString().isEmpty());
    }

    @Test
    public void testUnsuccessfulEnablePolicyMessage() throws Exception {
        this.cluster = DFSTestUtil.setupCluster(this.conf, 5, 2, 0);
        this.cluster.getFileSystem().disableErasureCodingPolicy(SystemErasureCodingPolicies.getByID((byte)1).getName());
        String[] args = new String[]{"-enablePolicy", "-policy", "RS-3-2-1024k"};
        int ret = this.admin.run(args);
        LOG.info("Command stdout: {}", (Object)this.out.toString());
        LOG.info("Command stderr: {}", (Object)this.err.toString());
        Assert.assertEquals((String)"Return value of the command is successful", (long)0L, (long)ret);
        Assert.assertTrue((String)"Enabling policy should be logged", (boolean)this.out.toString().contains("Erasure coding policy RS-3-2-1024k is enabled"));
        Assert.assertTrue((String)"Warning about cluster topology should be printed", (boolean)this.err.toString().contains("Warning: The cluster setup does not support EC policy RS-3-2-1024k. Reason:"));
        Assert.assertTrue((String)"Warning about cluster topology should be printed", (boolean)this.err.toString().contains("less than the minimum required number of racks"));
    }

    @Test
    public void testSuccessfulEnablePolicyMessage() throws Exception {
        this.cluster = DFSTestUtil.setupCluster(this.conf, 5, 3, 0);
        this.cluster.getFileSystem().disableErasureCodingPolicy(SystemErasureCodingPolicies.getByID((byte)1).getName());
        String[] args = new String[]{"-enablePolicy", "-policy", "RS-3-2-1024k"};
        int ret = this.admin.run(args);
        LOG.info("Command stdout: {}", (Object)this.out.toString());
        LOG.info("Command stderr: {}", (Object)this.err.toString());
        Assert.assertEquals((String)"Return value of the command is successful", (long)0L, (long)ret);
        Assert.assertTrue((String)"Enabling policy should be logged", (boolean)this.out.toString().contains("Erasure coding policy RS-3-2-1024k is enabled"));
        Assert.assertFalse((String)"Warning about cluster topology should not be printed", (boolean)this.out.toString().contains("Warning: The cluster setup does not support"));
        Assert.assertTrue((String)"Error output should be empty", (boolean)this.err.toString().isEmpty());
    }

    @Test
    public void testEnableNonExistentPolicyMessage() throws Exception {
        this.cluster = DFSTestUtil.setupCluster(this.conf, 5, 3, 0);
        this.cluster.getFileSystem().disableErasureCodingPolicy(SystemErasureCodingPolicies.getByID((byte)1).getName());
        String[] args = new String[]{"-enablePolicy", "-policy", "NonExistentPolicy"};
        int ret = this.admin.run(args);
        LOG.info("Command stdout: {}", (Object)this.out.toString());
        LOG.info("Command stderr: {}", (Object)this.err.toString());
        Assert.assertEquals((String)"Return value of the command is unsuccessful", (long)2L, (long)ret);
        Assert.assertFalse((String)"Enabling policy should not be logged when it was unsuccessful", (boolean)this.out.toString().contains("is enabled"));
        Assert.assertTrue((String)"Error message should be printed", (boolean)this.err.toString().contains("RemoteException: The policy name NonExistentPolicy does not exist"));
    }

    @Test
    public void testVerifyClusterSetupWithGivenPolicies() throws Exception {
        this.cluster = DFSTestUtil.setupCluster(this.conf, 5, 2, 0);
        String[] args = new String[]{"-verifyClusterSetup", "-policy", "RS-3-2-1024k"};
        int ret = this.admin.run(args);
        LOG.info("Command stdout: {}", (Object)this.out.toString());
        LOG.info("Command stderr: {}", (Object)this.err.toString());
        Assert.assertEquals((String)"Return value of the command is not successful", (long)2L, (long)ret);
        Assert.assertTrue((String)"Result of cluster topology verify should be logged correctly", (boolean)this.out.toString().contains("less than the minimum required number of racks (3) for the erasure coding policies: RS-3-2-1024k"));
        Assert.assertTrue((String)"Error output should be empty", (boolean)this.err.toString().isEmpty());
        this.resetOutputs();
        args = new String[]{"-verifyClusterSetup", "-policy", "RS-10-4-1024k", "RS-3-2-1024k"};
        ret = this.admin.run(args);
        LOG.info("Command stdout: {}", (Object)this.out.toString());
        LOG.info("Command stderr: {}", (Object)this.err.toString());
        Assert.assertEquals((String)"Return value of the command is not successful", (long)2L, (long)ret);
        Assert.assertTrue((String)"Result of cluster topology verify should be logged correctly", (boolean)this.out.toString().contains("for the erasure coding policies: RS-10-4-1024k, RS-3-2-1024k"));
        Assert.assertTrue((String)"Error output should be empty", (boolean)this.err.toString().isEmpty());
        this.resetOutputs();
        args = new String[]{"-verifyClusterSetup", "-policy", "invalidPolicy"};
        ret = this.admin.run(args);
        LOG.info("Command stdout: {}", (Object)this.out.toString());
        LOG.info("Command stderr: {}", (Object)this.err.toString());
        Assert.assertEquals((String)"Return value of the command is not successful", (long)-1L, (long)ret);
        Assert.assertTrue((String)"Error message should be logged", (boolean)this.err.toString().contains("The given erasure coding policy invalidPolicy does not exist."));
        this.resetOutputs();
        args = new String[]{"-verifyClusterSetup", "-policy"};
        ret = this.admin.run(args);
        LOG.info("Command stdout: {}", (Object)this.out.toString());
        LOG.info("Command stderr: {}", (Object)this.err.toString());
        Assert.assertEquals((String)"Return value of the command is not successful", (long)-1L, (long)ret);
        Assert.assertTrue((String)"Error message should be logged", (boolean)this.err.toString().contains("NotEnoughArgumentsException: Not enough arguments: expected 1 but got 0"));
    }

    private void resetOutputs() {
        this.out.reset();
        this.err.reset();
    }
}

