/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.ha;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSUtilClient;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.MiniDFSNNTopology;
import org.apache.hadoop.hdfs.server.namenode.CheckpointSignature;
import org.apache.hadoop.hdfs.server.namenode.FSImageTestUtil;
import org.apache.hadoop.hdfs.server.namenode.NNStorage;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.NameNodeAdapter;
import org.apache.hadoop.hdfs.server.namenode.ha.BootstrapStandby;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestBootstrapStandby {
    private static final Logger LOG = LoggerFactory.getLogger(TestBootstrapStandby.class);
    private static final int maxNNCount = 3;
    private static final int STARTING_PORT = 20000;
    private MiniDFSCluster cluster;
    private NameNode nn0;

    @Before
    public void setupCluster() throws IOException {
        Configuration conf = new Configuration();
        MiniDFSNNTopology.NSConf nameservice = new MiniDFSNNTopology.NSConf("ns1");
        for (int i = 0; i < 3; ++i) {
            nameservice.addNN(new MiniDFSNNTopology.NNConf("nn" + i).setHttpPort(20000 + i + 1));
        }
        MiniDFSNNTopology topology = new MiniDFSNNTopology().addNameservice(nameservice);
        this.cluster = new MiniDFSCluster.Builder(conf).nnTopology(topology).numDataNodes(0).build();
        this.cluster.waitActive();
        this.nn0 = this.cluster.getNameNode(0);
        this.cluster.transitionToActive(0);
        for (int i = 1; i < 3; ++i) {
            this.cluster.shutdownNameNode(i);
        }
    }

    @After
    public void shutdownCluster() {
        if (this.cluster != null) {
            this.cluster.shutdown();
            this.cluster = null;
        }
    }

    @Test
    public void testSuccessfulBaseCase() throws Exception {
        this.removeStandbyNameDirs();
        for (int index = 1; index < 3; ++index) {
            try {
                this.cluster.restartNameNode(index);
                Assert.fail((String)"Did not throw");
            }
            catch (IOException ioe) {
                GenericTestUtils.assertExceptionContains((String)"storage directory does not exist or is not accessible", (Throwable)ioe);
            }
            int expectedCheckpointTxId = (int)NameNodeAdapter.getNamesystem(this.nn0).getFSImage().getMostRecentCheckpointTxId();
            int rc = BootstrapStandby.run((String[])new String[]{"-nonInteractive"}, (Configuration)this.cluster.getConfiguration(index));
            Assert.assertEquals((long)0L, (long)rc);
            FSImageTestUtil.assertNNHasCheckpoints(this.cluster, index, (List<Integer>)ImmutableList.of((Object)expectedCheckpointTxId));
        }
        this.restartNameNodesFromIndex(1);
    }

    @Test
    public void testDownloadingLaterCheckpoint() throws Exception {
        this.nn0.getRpcServer().rollEditLog();
        this.nn0.getRpcServer().rollEditLog();
        NameNodeAdapter.enterSafeMode(this.nn0, false);
        NameNodeAdapter.saveNamespace(this.nn0);
        NameNodeAdapter.leaveSafeMode(this.nn0);
        long expectedCheckpointTxId = NameNodeAdapter.getNamesystem(this.nn0).getFSImage().getMostRecentCheckpointTxId();
        Assert.assertEquals((long)6L, (long)expectedCheckpointTxId);
        this.cluster.getFileSystem(0).create(new Path("/test_txid"), (short)1).close();
        URI editsUri = this.cluster.getSharedEditsDir(0, 2);
        long seen_txid_shared = FSImageTestUtil.getStorageTxId(this.nn0, editsUri);
        for (int i = 1; i < 3; ++i) {
            Assert.assertEquals((long)0L, (long)this.forceBootstrap(i));
            LOG.info("Checking namenode: " + i);
            FSImageTestUtil.assertNNHasCheckpoints(this.cluster, i, (List<Integer>)ImmutableList.of((Object)((int)expectedCheckpointTxId)));
        }
        FSImageTestUtil.assertNNFilesMatch(this.cluster);
        Assert.assertEquals((long)seen_txid_shared, (long)FSImageTestUtil.getStorageTxId(this.nn0, editsUri));
        this.restartNameNodesFromIndex(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSharedEditsMissingLogs() throws Exception {
        this.removeStandbyNameDirs();
        CheckpointSignature sig = this.nn0.getRpcServer().rollEditLog();
        Assert.assertEquals((long)3L, (long)sig.getCurSegmentTxId());
        URI editsUri = this.cluster.getSharedEditsDir(0, 2);
        File editsDir = new File(editsUri);
        File currentDir = new File(editsDir, "current");
        File editsSegment = new File(currentDir, NNStorage.getFinalizedEditsFileName((long)1L, (long)2L));
        GenericTestUtils.assertExists((File)editsSegment);
        GenericTestUtils.assertExists((File)currentDir);
        Assert.assertTrue((boolean)editsSegment.delete());
        GenericTestUtils.LogCapturer logs = GenericTestUtils.LogCapturer.captureLogs((Logger)LoggerFactory.getLogger(BootstrapStandby.class));
        try {
            Assert.assertEquals((long)6L, (long)this.forceBootstrap(1));
        }
        finally {
            logs.stopCapturing();
        }
        Assert.assertTrue((boolean)logs.getOutput().contains("Unable to read transaction ids 1-3 from the configured shared"));
    }

    @Test
    public void testStandbyDirsAlreadyExist() throws Exception {
        int rc = BootstrapStandby.run((String[])new String[]{"-nonInteractive"}, (Configuration)this.cluster.getConfiguration(1));
        Assert.assertEquals((long)5L, (long)rc);
        Assert.assertEquals((long)0L, (long)this.forceBootstrap(1));
    }

    @Test(timeout=30000L)
    public void testOtherNodeNotActive() throws Exception {
        this.cluster.transitionToStandby(0);
        this.assertSuccessfulBootstrapFromIndex(1);
    }

    @Test(timeout=30000L)
    public void testRateThrottling() throws Exception {
        this.cluster.getConfiguration(0).setLong("dfs.image.transfer.bandwidthPerSec", 1L);
        this.cluster.restartNameNode(0);
        this.cluster.waitActive();
        this.nn0 = this.cluster.getNameNode(0);
        this.cluster.transitionToActive(0);
        boolean minXferRatePerMS = true;
        int imageXferBufferSize = DFSUtilClient.getIoFileBufferSize((Configuration)new Configuration());
        File imageFile = null;
        int dirIdx = 0;
        while (imageFile == null || imageFile.length() < (long)imageXferBufferSize) {
            for (int i = 0; i < 5; ++i) {
                this.cluster.getFileSystem(0).mkdirs(new Path("/foo" + dirIdx++));
            }
            this.nn0.getRpcServer().rollEditLog();
            NameNodeAdapter.enterSafeMode(this.nn0, false);
            NameNodeAdapter.saveNamespace(this.nn0);
            NameNodeAdapter.leaveSafeMode(this.nn0);
            imageFile = FSImageTestUtil.findLatestImageFile(FSImageTestUtil.getFSImage(this.nn0).getStorage().getStorageDir(0));
        }
        int timeOut = (int)(imageFile.length() / 1L) + 1;
        final AtomicBoolean bootStrapped = new AtomicBoolean(false);
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    TestBootstrapStandby.this.testSuccessfulBaseCase();
                    bootStrapped.set(true);
                }
                catch (Exception e) {
                    Assert.fail((String)e.getMessage());
                }
            }
        }).start();
        GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

            @Override
            public Boolean get() {
                return bootStrapped.get();
            }
        }, (long)50L, (long)timeOut);
        this.shutdownCluster();
        this.setupCluster();
        this.cluster.getConfiguration(0).setLong("dfs.image.transfer-bootstrap-standby.bandwidthPerSec", 1L);
        this.cluster.restartNameNode(0);
        this.cluster.waitActive();
        this.nn0 = this.cluster.getNameNode(0);
        this.cluster.transitionToActive(0);
        bootStrapped.set(false);
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    TestBootstrapStandby.this.testSuccessfulBaseCase();
                    bootStrapped.set(true);
                }
                catch (Exception e) {
                    LOG.info(e.getMessage());
                }
            }
        }).start();
        try {
            GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

                @Override
                public Boolean get() {
                    return bootStrapped.get();
                }
            }, (long)50L, (long)timeOut);
            Assert.fail((String)"Did not timeout");
        }
        catch (TimeoutException e) {
            LOG.info("Encountered expected timeout.");
        }
    }

    private void removeStandbyNameDirs() {
        for (int i = 1; i < 3; ++i) {
            for (URI u : this.cluster.getNameDirs(i)) {
                Assert.assertTrue((boolean)u.getScheme().equals("file"));
                File dir = new File(u.getPath());
                LOG.info("Removing standby dir " + dir);
                Assert.assertTrue((boolean)FileUtil.fullyDelete((File)dir));
            }
        }
    }

    private void restartNameNodesFromIndex(int start) throws IOException {
        for (int i = start; i < 3; ++i) {
            this.cluster.restartNameNode(i, false, new String[0]);
        }
        this.cluster.waitClusterUp();
        this.cluster.waitActive();
    }

    private int forceBootstrap(int i) throws Exception {
        return BootstrapStandby.run((String[])new String[]{"-force"}, (Configuration)this.cluster.getConfiguration(i));
    }

    private void assertSuccessfulBootstrapFromIndex(int start) throws Exception {
        for (int i = start; i < 3; ++i) {
            Assert.assertEquals((long)0L, (long)this.forceBootstrap(i));
        }
    }
}

