/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import com.google.common.base.Supplier;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.concurrent.TimeoutException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.tools.DFSAdmin;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestBalancerBandwidth {
    private static final Configuration conf = new Configuration();
    private static final int NUM_OF_DATANODES = 2;
    private static final int DEFAULT_BANDWIDTH = 0x100000;
    public static final Logger LOG = LoggerFactory.getLogger(TestBalancerBandwidth.class);
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private final ByteArrayOutputStream outContent = new ByteArrayOutputStream();
    private final PrintStream outStream = new PrintStream(this.outContent);

    @Test
    public void testBalancerBandwidth() throws Exception {
        conf.setLong("dfs.datanode.balance.bandwidthPerSec", 0x100000L);
        try (MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).numDataNodes(2).build();){
            cluster.waitActive();
            DistributedFileSystem fs = cluster.getFileSystem();
            ArrayList<DataNode> datanodes = cluster.getDataNodes();
            Assert.assertEquals((long)0x100000L, (long)datanodes.get(0).getBalancerBandwidth());
            Assert.assertEquals((long)0x100000L, (long)datanodes.get(1).getBalancerBandwidth());
            DFSAdmin admin = new DFSAdmin(conf);
            String dn1Address = datanodes.get((int)0).ipcServer.getListenerAddress().getHostName() + ":" + datanodes.get(0).getIpcPort();
            String dn2Address = datanodes.get((int)1).ipcServer.getListenerAddress().getHostName() + ":" + datanodes.get(1).getIpcPort();
            String[] args = new String[]{"-getBalancerBandwidth", dn1Address};
            this.runGetBalancerBandwidthCmd(admin, args, 0x100000L);
            args = new String[]{"-getBalancerBandwidth", dn2Address};
            this.runGetBalancerBandwidthCmd(admin, args, 0x100000L);
            long newBandwidth = 0xC00000L;
            fs.setBalancerBandwidth(newBandwidth);
            this.verifyBalancerBandwidth(datanodes, newBandwidth);
            args = new String[]{"-getBalancerBandwidth", dn1Address};
            this.runGetBalancerBandwidthCmd(admin, args, newBandwidth);
            args = new String[]{"-getBalancerBandwidth", dn2Address};
            this.runGetBalancerBandwidthCmd(admin, args, newBandwidth);
            fs.setBalancerBandwidth(0L);
            this.verifyBalancerBandwidth(datanodes, newBandwidth);
            args = new String[]{"-getBalancerBandwidth", dn1Address};
            this.runGetBalancerBandwidthCmd(admin, args, newBandwidth);
            args = new String[]{"-getBalancerBandwidth", dn2Address};
            this.runGetBalancerBandwidthCmd(admin, args, newBandwidth);
            Assert.assertEquals((long)0L, (long)ToolRunner.run((Tool)admin, (String[])new String[]{"-setBalancerBandwidth", "1t"}));
            Assert.assertEquals((long)-1L, (long)ToolRunner.run((Tool)admin, (String[])new String[]{"-setBalancerBandwidth", "1e"}));
        }
    }

    private void verifyBalancerBandwidth(final ArrayList<DataNode> datanodes, final long newBandwidth) throws TimeoutException, InterruptedException {
        GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

            public Boolean get() {
                return ((DataNode)datanodes.get(0)).getBalancerBandwidth() == newBandwidth && ((DataNode)datanodes.get(1)).getBalancerBandwidth() == newBandwidth;
            }
        }, (long)100L, (long)60000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runGetBalancerBandwidthCmd(DFSAdmin admin, String[] args, long expectedBandwidth) throws Exception {
        PrintStream initialStdOut = System.out;
        this.outContent.reset();
        try {
            System.setOut(this.outStream);
            int exitCode = admin.run(args);
            Assert.assertEquals((String)"DFSAdmin should return 0", (long)0L, (long)exitCode);
            String bandwidthOutMsg = "Balancer bandwidth is " + expectedBandwidth + " bytes per second.";
            String strOut = new String(this.outContent.toByteArray(), UTF8);
            Assert.assertTrue((String)"Wrong balancer bandwidth!", (boolean)strOut.contains(bandwidthOutMsg));
        }
        finally {
            System.setOut(initialStdOut);
        }
    }

    public static void main(String[] args) throws Exception {
        new TestBalancerBandwidth().testBalancerBandwidth();
    }
}

