/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.Closeable;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.StripedFileTestUtil;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.ErasureCodingPolicy;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.server.namenode.FSDirectory;
import org.apache.hadoop.hdfs.server.namenode.INodeDirectory;
import org.apache.hadoop.hdfs.server.namenode.INodeFile;
import org.apache.hadoop.io.IOUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.Timeout;

public class TestQuotaWithStripedBlocks {
    private int blockSize;
    private ErasureCodingPolicy ecPolicy;
    private int dataBlocks;
    private int parityBlocsk;
    private int groupSize;
    private int cellSize;
    private Path ecDir;
    private long diskQuota;
    private MiniDFSCluster cluster;
    private FSDirectory dir;
    private DistributedFileSystem dfs;
    @Rule
    public Timeout globalTimeout = new Timeout(300000);

    public ErasureCodingPolicy getEcPolicy() {
        return StripedFileTestUtil.getDefaultECPolicy();
    }

    @Before
    public void setUp() throws IOException {
        this.blockSize = 0x100000;
        this.ecPolicy = this.getEcPolicy();
        this.dataBlocks = this.ecPolicy.getNumDataUnits();
        this.parityBlocsk = this.ecPolicy.getNumParityUnits();
        this.groupSize = this.dataBlocks + this.parityBlocsk;
        this.cellSize = this.ecPolicy.getCellSize();
        this.ecDir = new Path("/ec");
        this.diskQuota = this.blockSize * (this.groupSize + 1);
        Configuration conf = new Configuration();
        conf.setLong("dfs.blocksize", (long)this.blockSize);
        this.cluster = new MiniDFSCluster.Builder(conf).numDataNodes(this.groupSize).build();
        this.cluster.waitActive();
        this.dir = this.cluster.getNamesystem().getFSDirectory();
        this.dfs = this.cluster.getFileSystem();
        this.dfs.enableErasureCodingPolicy(this.ecPolicy.getName());
        this.dfs.mkdirs(this.ecDir);
        this.dfs.getClient().setErasureCodingPolicy(this.ecDir.toString(), this.ecPolicy.getName());
        this.dfs.setQuota(this.ecDir, 0x7FFFFFFFFFFFFFFEL, this.diskQuota);
        this.dfs.setQuotaByStorageType(this.ecDir, StorageType.DISK, this.diskQuota);
        this.dfs.setStoragePolicy(this.ecDir, "HOT");
    }

    @After
    public void tearDown() {
        if (this.cluster != null) {
            this.cluster.shutdown();
            this.cluster = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUpdatingQuotaCount() throws Exception {
        Path file = new Path(this.ecDir, "file");
        FSDataOutputStream out = null;
        try {
            out = this.dfs.create(file, (short)1);
            INodeFile fileNode = this.dir.getINode4Write(file.toString()).asFile();
            ExtendedBlock previous = null;
            Block newBlock = DFSTestUtil.addBlockToFile(true, this.cluster.getDataNodes(), this.dfs, this.cluster.getNamesystem(), file.toString(), fileNode, this.dfs.getClient().getClientName(), previous, 1, 0);
            previous = new ExtendedBlock(this.cluster.getNamesystem().getBlockPoolId(), newBlock);
            INodeDirectory dirNode = this.dir.getINode4Write(this.ecDir.toString()).asDirectory();
            long spaceUsed = dirNode.getDirectoryWithQuotaFeature().getSpaceConsumed().getStorageSpace();
            long diskUsed = dirNode.getDirectoryWithQuotaFeature().getSpaceConsumed().getTypeSpaces().get((Enum)StorageType.DISK);
            Assert.assertEquals((long)(this.blockSize * this.groupSize), (long)spaceUsed);
            Assert.assertEquals((long)(this.blockSize * this.groupSize), (long)diskUsed);
            this.dfs.getClient().getNamenode().complete(file.toString(), this.dfs.getClient().getClientName(), previous, fileNode.getId());
            long actualSpaceUsed = dirNode.getDirectoryWithQuotaFeature().getSpaceConsumed().getStorageSpace();
            long actualDiskUsed = dirNode.getDirectoryWithQuotaFeature().getSpaceConsumed().getTypeSpaces().get((Enum)StorageType.DISK);
            Assert.assertEquals((long)(this.cellSize * this.groupSize), (long)actualSpaceUsed);
            Assert.assertEquals((long)(this.cellSize * this.groupSize), (long)actualDiskUsed);
        }
        catch (Throwable throwable) {
            IOUtils.cleanup(null, (Closeable[])new Closeable[]{out});
            throw throwable;
        }
        IOUtils.cleanup(null, (Closeable[])new Closeable[]{out});
    }
}

