/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.ha;

import com.google.common.base.Supplier;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.List;
import java.util.concurrent.TimeoutException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.MiniDFSNNTopology;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.datanode.DataNodeTestUtils;
import org.apache.hadoop.hdfs.server.namenode.ha.HATestUtil;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.Assert;
import org.junit.Test;

public class TestPendingCorruptDnMessages {
    private static final Path filePath = new Path("/foo.txt");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testChangedStorageId() throws IOException, URISyntaxException, InterruptedException, TimeoutException {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setInt("dfs.ha.tail-edits.period", 1);
        final MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).nnTopology(MiniDFSNNTopology.simpleHATopology()).build();
        try {
            cluster.transitionToActive(0);
            DistributedFileSystem fs = HATestUtil.configureFailoverFs(cluster, (Configuration)conf);
            FSDataOutputStream out = fs.create(filePath);
            out.write("foo bar baz".getBytes());
            out.close();
            HATestUtil.waitForStandbyToCatchUp(cluster.getNameNode(0), cluster.getNameNode(1));
            ExtendedBlock block = DFSTestUtil.getFirstBlock((FileSystem)fs, filePath);
            cluster.changeGenStampOfBlock(0, block, 900L);
            DataNodeTestUtils.runDirectoryScanner(cluster.getDataNodes().get(0));
            MiniDFSCluster.DataNodeProperties dnProps = cluster.stopDataNode(0);
            cluster.restartNameNode(1, false, new String[0]);
            Assert.assertTrue((boolean)cluster.restartDataNode(dnProps, true));
            GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

                public Boolean get() {
                    return cluster.getNamesystem(1).getBlockManager().getPendingDataNodeMessageCount() == 1;
                }
            }, (long)1000L, (long)30000L);
            final String oldStorageId = TestPendingCorruptDnMessages.getRegisteredDatanodeUid(cluster, 1);
            Assert.assertNotNull((Object)oldStorageId);
            Assert.assertTrue((boolean)TestPendingCorruptDnMessages.wipeAndRestartDn(cluster, 0));
            GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

                public Boolean get() {
                    String newStorageId = TestPendingCorruptDnMessages.getRegisteredDatanodeUid(cluster, 1);
                    return newStorageId != null && !newStorageId.equals(oldStorageId);
                }
            }, (long)1000L, (long)30000L);
            Assert.assertEquals((long)0L, (long)cluster.getNamesystem(1).getBlockManager().getPendingDataNodeMessageCount());
            cluster.transitionToStandby(0);
            cluster.transitionToActive(1);
        }
        finally {
            cluster.shutdown();
        }
    }

    private static String getRegisteredDatanodeUid(MiniDFSCluster cluster, int nnIndex) {
        List registeredDatanodes = cluster.getNamesystem(nnIndex).getBlockManager().getDatanodeManager().getDatanodeListForReport(HdfsConstants.DatanodeReportType.ALL);
        return registeredDatanodes.isEmpty() ? null : ((DatanodeDescriptor)registeredDatanodes.get(0)).getDatanodeUuid();
    }

    private static boolean wipeAndRestartDn(MiniDFSCluster cluster, int dnIndex) throws IOException {
        MiniDFSCluster.DataNodeProperties dnProps = cluster.stopDataNode(dnIndex);
        cluster.formatDataNodeDirs();
        return cluster.restartDataNode(dnProps, true);
    }
}

